/*
 * Decompiled with CFR 0.152.
 */
package org.pytorch.serve.util.codec;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public final class CodecUtils {
    public static final int END = -1;
    public static final int BUFFER_UNDER_RUN = -3;
    public static final long TIMEOUT_IN_MILLIS = 100L;

    private CodecUtils() {
    }

    public static int readLength(ByteBuf byteBuf, int maxLength) {
        int size = byteBuf.readableBytes();
        if (size < 4) {
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException("Did not receive enough data.");
        }
        int len = byteBuf.readInt();
        if (len > maxLength) {
            throw new TooLongFrameException("Message size exceed limit: " + len + "\nConsider increasing the 'max_response_size' in 'config.properties' to fix.");
        }
        if (len > byteBuf.readableBytes()) {
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException("Did not receive enough data.");
        }
        return len;
    }

    public static String readString(ByteBuf byteBuf, int len) {
        return new String(CodecUtils.read(byteBuf, len), StandardCharsets.UTF_8);
    }

    public static byte[] read(ByteBuf in, int len) {
        if (len < 0) {
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException("Did not receive enough data.");
        }
        byte[] buf = new byte[len];
        in.readBytes(buf);
        return buf;
    }

    public static Map<String, String> readMap(ByteBuf in, int len) {
        HashMap<String, String> ret = new HashMap<String, String>();
        while (len > 0) {
            int l = CodecUtils.readLength(in, 6500000);
            String key = CodecUtils.readString(in, l);
            l = CodecUtils.readLength(in, 6500000);
            String val = CodecUtils.readString(in, l);
            ret.put(key, val);
            --len;
        }
        return ret;
    }
}

