/*
 * Decompiled with CFR 0.152.
 */
package org.pytorch.serve.util.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import java.util.ArrayList;
import java.util.List;
import org.pytorch.serve.util.codec.CodecUtils;
import org.pytorch.serve.util.messages.ModelWorkerResponse;
import org.pytorch.serve.util.messages.Predictions;

public class ModelResponseDecoder
extends ByteToMessageDecoder {
    private final int maxBufferSize;

    public ModelResponseDecoder(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        int size = in.readableBytes();
        if (size < 9) {
            return;
        }
        in.markReaderIndex();
        boolean completed = false;
        try {
            ModelWorkerResponse resp = new ModelWorkerResponse();
            resp.setCode(in.readInt());
            int len = CodecUtils.readLength(in, this.maxBufferSize);
            if (len == -3) {
                return;
            }
            resp.setMessage(CodecUtils.readString(in, len));
            ArrayList<Predictions> predictions = new ArrayList<Predictions>();
            while ((len = CodecUtils.readLength(in, this.maxBufferSize)) != -1) {
                if (len == -3) {
                    return;
                }
                Predictions prediction = new Predictions();
                prediction.setRequestId(CodecUtils.readString(in, len));
                len = CodecUtils.readLength(in, this.maxBufferSize);
                if (len == -3) {
                    return;
                }
                prediction.setContentType(CodecUtils.readString(in, len));
                if (in.readableBytes() < 4) {
                    return;
                }
                int httpStatusCode = in.readInt();
                prediction.setStatusCode(httpStatusCode);
                len = CodecUtils.readLength(in, this.maxBufferSize);
                if (len == -3) {
                    return;
                }
                prediction.setReasonPhrase(CodecUtils.readString(in, len));
                len = CodecUtils.readLength(in, this.maxBufferSize);
                if (len == -3) {
                    return;
                }
                prediction.setHeaders(CodecUtils.readMap(in, len));
                len = CodecUtils.readLength(in, this.maxBufferSize);
                if (len == -3) {
                    return;
                }
                prediction.setResp(CodecUtils.read(in, len));
                predictions.add(prediction);
            }
            resp.setPredictions(predictions);
            out.add(resp);
            completed = true;
        }
        catch (HttpPostRequestDecoder.NotEnoughDataDecoderException notEnoughDataDecoderException) {
        }
        finally {
            if (!completed) {
                in.resetReaderIndex();
            }
        }
    }
}

