/*
 * Decompiled with CFR 0.152.
 */
package org.pytorch.serve.util.logging;

import java.nio.charset.Charset;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.message.Message;
import org.pytorch.serve.metrics.Metric;
import org.pytorch.serve.util.JsonUtils;

@Plugin(name="JSONPatternLayout", category="Core", elementType="layout", printObject=true)
public class JSONPatternLayout
extends AbstractStringLayout {
    public JSONPatternLayout() {
        super((Charset)null, (byte[])null, (byte[])null);
    }

    @PluginFactory
    public static JSONPatternLayout createLayout() {
        return new JSONPatternLayout();
    }

    @Override
    public String toSerializable(LogEvent event) {
        Object[] parameters;
        Message eventMessage = event.getMessage();
        if (eventMessage == null || eventMessage.getParameters() == null) {
            return null;
        }
        for (Object obj : parameters = eventMessage.getParameters()) {
            if (!(obj instanceof Metric)) continue;
            Metric metric = (Metric)obj;
            return JsonUtils.GSON_PRETTY.toJson(metric) + "\n";
        }
        return eventMessage.toString() + '\n';
    }
}

