/*
 * Decompiled with CFR 0.152.
 */
package org.pytorch.serve.util.logging;

import java.nio.charset.Charset;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.message.Message;
import org.pytorch.serve.metrics.Dimension;
import org.pytorch.serve.metrics.Metric;

@Plugin(name="QLogLayout", category="Core", elementType="layout", printObject=true)
public class QLogLayout
extends AbstractStringLayout {
    public QLogLayout() {
        super((Charset)null, (byte[])null, (byte[])null);
    }

    @PluginFactory
    public static QLogLayout createLayout() {
        return new QLogLayout();
    }

    @Override
    public String toSerializable(LogEvent event) {
        Message eventMessage = event.getMessage();
        if (eventMessage == null || eventMessage.getParameters() == null) {
            return null;
        }
        String programName = QLogLayout.getStringOrDefault(System.getenv("MXNETMODELSERVER_PROGRAM"), "MXNetModelServer");
        String domain = QLogLayout.getStringOrDefault(System.getenv("DOMAIN"), "Unknown");
        long currentTimeInSec = System.currentTimeMillis() / 1000L;
        Object[] parameters = eventMessage.getParameters();
        StringBuilder stringBuilder = new StringBuilder();
        for (Object obj : parameters) {
            if (!(obj instanceof Metric)) continue;
            Metric metric = (Metric)obj;
            String marketPlace = System.getenv("REALM");
            stringBuilder.append("HostName=").append(metric.getHostName());
            if (metric.getRequestId() != null && !metric.getRequestId().isEmpty()) {
                stringBuilder.append("\nRequestId=").append(metric.getRequestId());
            }
            if (marketPlace != null && !marketPlace.isEmpty()) {
                stringBuilder.append("\nMarketplace=").append(programName).append(':').append(domain).append(':').append(marketPlace);
            }
            stringBuilder.append("\nStartTime=").append(QLogLayout.getStringOrDefault(metric.getTimestamp(), Long.toString(currentTimeInSec)));
            stringBuilder.append("\nProgram=").append(programName).append("\nMetrics=").append(metric.getMetricName()).append('=').append(metric.getValue()).append(' ').append(metric.getUnit());
            for (Dimension dimension : metric.getDimensions()) {
                stringBuilder.append(' ').append(dimension.getName()).append('|').append(dimension.getValue()).append(' ');
            }
            stringBuilder.append("\nEOE\n");
        }
        return stringBuilder.toString();
    }

    private static String getStringOrDefault(String val, String defVal) {
        if (val == null || val.isEmpty()) {
            return defVal;
        }
        return val;
    }
}

