/*
 * Decompiled with CFR 0.152.
 */
package org.pytorch.serve.util.messages;

import org.pytorch.serve.util.ConfigManager;
import org.pytorch.serve.util.messages.BaseModelRequest;
import org.pytorch.serve.util.messages.WorkerCommands;
import org.pytorch.serve.wlm.Model;

public class ModelLoadModelRequest
extends BaseModelRequest {
    private String modelPath;
    private String handler;
    private String envelope;
    private int batchSize;
    private int gpuId;
    private boolean limitMaxImagePixels;

    public ModelLoadModelRequest(Model model, int gpuId) {
        super(WorkerCommands.LOAD, model.getModelName());
        this.gpuId = gpuId;
        this.modelPath = model.getModelDir().getAbsolutePath();
        this.handler = model.getModelArchive().getManifest().getModel().getHandler();
        this.envelope = model.getModelArchive().getManifest().getModel().getEnvelope();
        this.batchSize = model.getBatchSize();
        this.limitMaxImagePixels = ConfigManager.getInstance().isLimitMaxImagePixels();
    }

    public String getModelPath() {
        return this.modelPath;
    }

    public String getHandler() {
        return this.handler;
    }

    public String getEnvelope() {
        return this.envelope;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getGpuId() {
        return this.gpuId;
    }

    public boolean isLimitMaxImagePixels() {
        return this.limitMaxImagePixels;
    }
}

