/*
 * Decompiled with CFR 0.152.
 */
package org.pytorch.serve.util.messages;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pytorch.serve.util.messages.InputParameter;

public class RequestInput {
    public static final String TS_STREAM_NEXT = "ts_stream_next";
    public static final String TS_REQUEST_SEQUENCE_ID = "ts_request_sequence_id";
    private String requestId;
    private String sequenceId;
    private Map<String, String> headers;
    private List<InputParameter> parameters;
    private long clientExpireTS;
    private boolean cached;

    public RequestInput(String requestId) {
        this.requestId = requestId;
        this.headers = new HashMap<String, String>();
        this.parameters = new ArrayList<InputParameter>();
        this.clientExpireTS = Long.MAX_VALUE;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void updateHeaders(String key, String val) {
        this.headers.put(key, val);
    }

    public List<InputParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<InputParameter> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(InputParameter modelInput) {
        this.parameters.add(modelInput);
    }

    public String getStringParameter(String key) {
        for (InputParameter param : this.parameters) {
            if (!key.equals(param.getName())) continue;
            return new String(param.getValue(), StandardCharsets.UTF_8);
        }
        return null;
    }

    public long getClientExpireTS() {
        return this.clientExpireTS;
    }

    public void setClientExpireTS(long clientTimeoutInMills) {
        if (clientTimeoutInMills > 0L) {
            this.clientExpireTS = System.currentTimeMillis() + clientTimeoutInMills;
        }
    }

    public String getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(String sequenceId) {
        this.sequenceId = sequenceId;
    }

    public boolean isCachedInBackend() {
        return this.cached;
    }

    public void setCachedInBackend(boolean cached) {
        this.cached = cached;
    }
}

