/*
 * Decompiled with CFR 0.152.
 */
package org.pytorch.serve.wlm;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.pytorch.serve.job.Job;
import org.pytorch.serve.util.messages.BaseModelRequest;
import org.pytorch.serve.util.messages.ModelInferenceRequest;
import org.pytorch.serve.util.messages.ModelLoadModelRequest;
import org.pytorch.serve.util.messages.ModelWorkerResponse;
import org.pytorch.serve.util.messages.Predictions;
import org.pytorch.serve.util.messages.RequestInput;
import org.pytorch.serve.util.messages.WorkerCommands;
import org.pytorch.serve.wlm.Model;
import org.pytorch.serve.wlm.WorkerState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchAggregator {
    private static final Logger logger = LoggerFactory.getLogger(BatchAggregator.class);
    protected Model model;
    protected Map<String, Job> jobs;

    public BatchAggregator() {
    }

    public BatchAggregator(Model model) {
        this.model = model;
        this.jobs = new LinkedHashMap<String, Job>();
    }

    public BaseModelRequest getRequest(String threadName, WorkerState state) throws InterruptedException, ExecutionException {
        this.cleanJobs();
        ModelInferenceRequest req = new ModelInferenceRequest(this.model.getModelName());
        this.pollBatch(threadName, state);
        if (this.model.isUseJobTicket() && this.jobs.isEmpty()) {
            this.model.decNumJobTickets();
            return req;
        }
        for (Job j : this.jobs.values()) {
            if (j.isControlCmd()) {
                if (this.jobs.size() > 1) {
                    throw new IllegalStateException("Received more than 1 control command. Control messages should be processed/retrieved one at a time.");
                }
                RequestInput input = j.getPayload();
                int gpuId = -1;
                String gpu = input.getStringParameter("gpu");
                if (gpu != null) {
                    gpuId = Integer.parseInt(gpu);
                }
                return new ModelLoadModelRequest(this.model, gpuId);
            }
            if (j.getCmd() == WorkerCommands.STREAMPREDICT || j.getCmd() == WorkerCommands.STREAMPREDICT2) {
                req.setCommand(j.getCmd());
            }
            j.setScheduled();
            req.addRequest(j.getPayload());
        }
        return req;
    }

    public boolean sendResponse(ModelWorkerResponse message) {
        boolean jobDone = true;
        if (message.getCode() == 200) {
            if (this.jobs.isEmpty()) {
                return true;
            }
            for (Predictions prediction : message.getPredictions()) {
                String streamNext;
                String jobId = prediction.getRequestId();
                Job job = this.jobs.get(jobId);
                if (job == null) {
                    throw new IllegalStateException("Unexpected job in sendResponse() with 200 status code: " + jobId);
                }
                if (jobDone && "true".equals(streamNext = prediction.getHeaders().get("ts_stream_next"))) {
                    jobDone = false;
                }
                if (job.getPayload().getClientExpireTS() > System.currentTimeMillis()) {
                    job.response(prediction.getResp(), prediction.getContentType(), prediction.getStatusCode(), prediction.getReasonPhrase(), prediction.getHeaders());
                    continue;
                }
                logger.warn("Drop response for inference request {} due to client timeout", (Object)job.getPayload().getRequestId());
            }
        } else {
            for (Map.Entry<String, Job> j : this.jobs.entrySet()) {
                if (j.getValue() == null) {
                    throw new IllegalStateException("Unexpected job in sendResponse() with non 200 status code: " + j.getKey());
                }
                Job job = j.getValue();
                if (job.getPayload().getClientExpireTS() > System.currentTimeMillis()) {
                    job.sendError(message.getCode(), message.getMessage());
                    continue;
                }
                logger.warn("Drop error response for inference request {} due to client timeout", (Object)job.getPayload().getRequestId());
            }
        }
        if (jobDone) {
            this.cleanJobs();
        }
        return jobDone;
    }

    public void sendError(BaseModelRequest message, String error, int status) {
        if (message instanceof ModelLoadModelRequest) {
            logger.warn("Load model failed: {}, error: {}", (Object)message.getModelName(), (Object)error);
            return;
        }
        if (message != null) {
            ModelInferenceRequest msg = (ModelInferenceRequest)message;
            for (RequestInput req : msg.getRequestBatch()) {
                String requestId = req.getRequestId();
                Job job = this.jobs.remove(requestId);
                if (job == null) {
                    logger.error("Unexpected job in sendError(): " + requestId);
                    continue;
                }
                job.sendError(status, error);
            }
            if (!this.jobs.isEmpty()) {
                this.cleanJobs();
                logger.error("Not all jobs got an error response.");
            }
        } else {
            for (Map.Entry<String, Job> j : this.jobs.entrySet()) {
                String jobsId = j.getValue().getJobId();
                Job job = this.jobs.get(jobsId);
                if (job.isControlCmd()) {
                    job.sendError(status, error);
                    continue;
                }
                this.handleErrorJob(job);
            }
        }
        this.cleanJobs();
    }

    public void cleanJobs() {
        if (this.jobs != null) {
            this.jobs.clear();
        }
    }

    public void handleErrorJob(Job job) {
        this.model.addFirst(job);
    }

    public void pollBatch(String threadName, WorkerState state) throws InterruptedException, ExecutionException {
        this.model.pollBatch(threadName, state == WorkerState.WORKER_MODEL_LOADED ? 0L : Long.MAX_VALUE, this.jobs);
    }
}

