/*
 * Decompiled with CFR 0.152.
 */
package org.pytorch.serve.wlm;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.pytorch.serve.archive.model.ModelVersionNotFoundException;
import org.pytorch.serve.http.ConflictStatusException;
import org.pytorch.serve.http.InvalidModelVersionException;
import org.pytorch.serve.wlm.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModelVersionedRefs {
    private static final Logger logger = LoggerFactory.getLogger(ModelVersionedRefs.class);
    private ConcurrentHashMap<String, Model> modelsVersionMap = new ConcurrentHashMap();
    private String defaultVersion;

    public void addVersionModel(Model model, String versionId) throws ModelVersionNotFoundException, ConflictStatusException {
        logger.debug("Adding new version {} for model {}", (Object)versionId, (Object)model.getModelName());
        if (versionId == null) {
            throw new InvalidModelVersionException("Model version not found. ");
        }
        if (this.modelsVersionMap.putIfAbsent(versionId, model) != null) {
            throw new ConflictStatusException("Model version " + versionId + " is already registered for model " + model.getModelName());
        }
        if (this.defaultVersion == null) {
            this.setDefaultVersion(versionId);
        }
    }

    public String getDefaultVersion() {
        return this.defaultVersion;
    }

    public void setDefaultVersion(String versionId) throws ModelVersionNotFoundException {
        Model model = this.modelsVersionMap.get(versionId);
        if (model == null) {
            throw new ModelVersionNotFoundException("Model version " + versionId + " does not exist for model " + this.getDefaultModel().getModelName());
        }
        logger.debug("Setting default version to {} for model {}", (Object)versionId, (Object)model.getModelName());
        this.defaultVersion = versionId;
    }

    public Model removeVersionModel(String versionId) throws InvalidModelVersionException, ModelVersionNotFoundException {
        if (versionId == null) {
            versionId = this.getDefaultVersion();
        }
        if (this.defaultVersion.equals(versionId) && this.modelsVersionMap.size() > 1) {
            throw new InvalidModelVersionException(String.format("Can't remove default version: %s", versionId));
        }
        Model model = this.modelsVersionMap.remove(versionId);
        if (model == null) {
            throw new ModelVersionNotFoundException(String.format("Model version: %s not found", versionId));
        }
        logger.debug("Removed model: {} version: {}", (Object)model.getModelName(), (Object)versionId);
        return model;
    }

    public Model getVersionModel(String versionId) {
        Model model = null;
        model = versionId != null ? this.modelsVersionMap.get(versionId) : this.getDefaultModel();
        return model;
    }

    public Model getDefaultModel() {
        return this.modelsVersionMap.get(this.defaultVersion);
    }

    public Model forAllVersions() {
        return null;
    }

    public Set<Map.Entry<String, Model>> getAllVersions() {
        return this.modelsVersionMap.entrySet();
    }
}

