/*
 * Decompiled with CFR 0.152.
 */
package org.pytorch.serve.wlm;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.pytorch.serve.wlm.WorkerState;

public class WorkerStateListener {
    private CompletableFuture<Integer> future;
    private AtomicInteger count;

    public WorkerStateListener(CompletableFuture<Integer> future, int count) {
        this.future = future;
        this.count = new AtomicInteger(count);
    }

    public void notifyChangeState(String modelName, WorkerState state, Integer status) {
        if (state == WorkerState.WORKER_MODEL_LOADED && this.count.decrementAndGet() == 0) {
            this.future.complete(status);
        }
        if (state == WorkerState.WORKER_ERROR || state == WorkerState.WORKER_STOPPED) {
            this.future.complete(status);
        }
    }
}

