/*
 * Decompiled with CFR 0.152.
 */
package org.pytorch.serve.wlm;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.LambdaMetafactory;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.pytorch.serve.job.RestJob;
import org.pytorch.serve.metrics.IMetric;
import org.pytorch.serve.metrics.MetricCache;
import org.pytorch.serve.util.ConfigManager;
import org.pytorch.serve.util.Connector;
import org.pytorch.serve.util.codec.ModelRequestEncoder;
import org.pytorch.serve.util.codec.ModelResponseDecoder;
import org.pytorch.serve.util.messages.BaseModelRequest;
import org.pytorch.serve.util.messages.InputParameter;
import org.pytorch.serve.util.messages.ModelWorkerResponse;
import org.pytorch.serve.util.messages.RequestInput;
import org.pytorch.serve.util.messages.WorkerCommands;
import org.pytorch.serve.wlm.BatchAggregator;
import org.pytorch.serve.wlm.Model;
import org.pytorch.serve.wlm.ModelManager;
import org.pytorch.serve.wlm.SequenceBatchAggregator;
import org.pytorch.serve.wlm.WorkerInitializationException;
import org.pytorch.serve.wlm.WorkerLifeCycle;
import org.pytorch.serve.wlm.WorkerState;
import org.pytorch.serve.wlm.WorkerStateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(WorkerThread.class);
    private static final Logger loggerTelemetryMetrics = LoggerFactory.getLogger("TELEMETRY_METRICS");
    private static final int[] BACK_OFF = new int[]{0, 1, 1, 2, 3, 5, 8, 13, 21, 34, 55, 89, 144, 233, 377, 610, 987, 1597};
    private static final long WORKER_TIMEOUT = 2L;
    private static final ModelRequestEncoder ENCODER = new ModelRequestEncoder(ConfigManager.getInstance().getPreferDirectBuffer());
    private final IMetric workerThreadTimeMetric;
    private final IMetric workerLoadTimeMetric;
    private final List<String> workerThreadTimeMetricDimensionValues;
    private final List<String> workerLoadTimeMetricDimensionValues;
    private ConfigManager configManager;
    private EventLoopGroup backendEventGroup;
    private int port;
    private Model model;
    private ArrayList<Channel> backendChannel = new ArrayList();
    private AtomicBoolean running = new AtomicBoolean(true);
    private int backoffIdx;
    private BatchAggregator aggregator;
    private WorkerStateListener listener;
    private ArrayBlockingQueue<ModelWorkerResponse> replies;
    private int gpuId;
    private long memory;
    private long startTime;
    private AtomicReference<Thread> currentThread = new AtomicReference();
    private String workerId;
    private WorkerState state;
    private WorkerLifeCycle lifeCycle;
    private int responseTimeout;
    private long recoveryStartTS;
    private BaseModelRequest req = null;

    public WorkerThread(ConfigManager configManager, EventLoopGroup backendEventGroup, int port, int gpuId, Model model, BatchAggregator aggregator, WorkerStateListener listener) {
        this.workerId = String.valueOf(port);
        this.configManager = configManager;
        this.backendEventGroup = backendEventGroup;
        this.port = port;
        this.model = model;
        this.aggregator = aggregator;
        this.gpuId = gpuId;
        this.listener = listener;
        this.startTime = System.currentTimeMillis();
        this.lifeCycle = new WorkerLifeCycle(configManager, model);
        this.replies = new ArrayBlockingQueue(model.getParallelLevel() > 0 ? model.getParallelLevel() : 1);
        this.workerThreadTimeMetric = MetricCache.getInstance().getMetricFrontend("WorkerThreadTime");
        this.workerLoadTimeMetric = MetricCache.getInstance().getMetricFrontend("WorkerLoadTime");
        this.workerThreadTimeMetricDimensionValues = Arrays.asList("Host", ConfigManager.getInstance().getHostName());
        this.workerLoadTimeMetricDimensionValues = Arrays.asList(this.getWorkerName(), "Host", ConfigManager.getInstance().getHostName());
    }

    public WorkerState getState() {
        return this.state;
    }

    public String getGpuUsage() {
        StringBuffer gpuUsage = new StringBuffer();
        if (this.gpuId >= 0) {
            try {
                String line;
                ProcessBuilder pb = new ProcessBuilder("nvidia-smi", "-i", String.valueOf(this.gpuId), "--query-gpu=utilization.gpu,utilization.memory,memory.used", "--format=csv");
                Process process = pb.start();
                process.waitFor();
                int exitCode = process.exitValue();
                if (exitCode != 0) {
                    gpuUsage.append("failed to obtained gpu usage");
                    InputStream error = process.getErrorStream();
                    for (int i = 0; i < error.available(); ++i) {
                        logger.error("" + error.read());
                    }
                    return gpuUsage.toString();
                }
                InputStream stdout = process.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(stdout, StandardCharsets.UTF_8));
                String[] headers = new String[3];
                Boolean firstLine = true;
                while ((line = reader.readLine()) != null) {
                    if (firstLine.booleanValue()) {
                        headers = line.split(",");
                        firstLine = false;
                        continue;
                    }
                    String[] values = line.split(",");
                    StringBuffer sb = new StringBuffer("gpuId::" + this.gpuId + " ");
                    for (int i = 0; i < headers.length; ++i) {
                        sb.append(headers[i] + "::" + values[i].strip());
                    }
                    gpuUsage.append(sb.toString());
                }
            }
            catch (Exception e) {
                gpuUsage.append("failed to obtained gpu usage");
                logger.error("Exception Raised : " + e.toString());
            }
        } else {
            gpuUsage.append("N/A");
        }
        return gpuUsage.toString();
    }

    public WorkerLifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.responseTimeout = this.model.getResponseTimeout();
        thread = Thread.currentThread();
        thread.setName(this.getWorkerName());
        this.currentThread.set(thread);
        this.req = null;
        status = 500;
        try {
            this.connect();
lbl9:
            // 4 sources

            while (true) {
                if (!this.isRunning()) ** GOTO lbl106
                this.req = this.aggregator.getRequest(this.workerId, this.state);
                workerCmd = this.req.getCommand();
                wtStartTime = System.currentTimeMillis();
                repeats = this.getRepeats(workerCmd);
                WorkerThread.logger.debug("Flushing req.cmd {} repeats {} to backend at: {}", new Object[]{workerCmd, repeats, wtStartTime});
                futureRequests = new ArrayList<CompletableFuture<Void>>(repeats);
                i = 0;
                while (this.backendChannel.size() > 0 && i < repeats) {
                    idx = i++;
                    futureRequests.add(CompletableFuture.runAsync((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$run$0(int ), ()V)((WorkerThread)this, (int)idx)));
                }
                futureRequests.stream().map((Function<CompletableFuture, Void>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, join(), (Ljava/util/concurrent/CompletableFuture;)Ljava/lang/Void;)());
                reply = null;
                jobDone = false;
                totalDuration = 0L;
                WorkerThread.logger.info("Looping backend response at: {}", (Object)System.currentTimeMillis());
                ** GOTO lbl61
                break;
            }
        }
        catch (InterruptedException e) {
            WorkerThread.logger.debug("System state is : " + (Object)this.state);
            if (this.state == WorkerState.WORKER_SCALED_DOWN || this.state == WorkerState.WORKER_STOPPED) {
                WorkerThread.logger.debug("Shutting down the thread .. Scaling down.");
            } else {
                WorkerThread.logger.debug("Backend worker monitoring thread interrupted or backend worker process died., responseTimeout:" + this.responseTimeout + "sec", e);
            }
            ** GOTO lbl123
            catch (WorkerInitializationException e) {
                WorkerThread.logger.error("Backend worker error", e);
                ** GOTO lbl140
                catch (OutOfMemoryError oom) {
                    WorkerThread.logger.error("Out of memory error when creating workers", oom);
                    status = 413;
                    if (ConfigManager.getInstance().isTelemetryEnabled()) {
                        WorkerThread.loggerTelemetryMetrics.info("ModelServerError.Count:1|#TorchServe:{},{}:-1", (Object)ConfigManager.getInstance().getVersion(), (Object)oom.getClass().getCanonicalName());
                    }
                    ** GOTO lbl157
                    catch (IllegalStateException e) {
                        WorkerThread.logger.error("IllegalStateException error", e);
                        ** GOTO lbl174
                        catch (Throwable t) {
                            try {
                                WorkerThread.logger.warn("Backend worker thread exception.", t);
                                if (ConfigManager.getInstance().isTelemetryEnabled()) {
                                    WorkerThread.loggerTelemetryMetrics.info("ModelServerError.Count:1|#TorchServe:{},{}:-1", (Object)ConfigManager.getInstance().getVersion(), (Object)t.getClass().getCanonicalName());
                                }
                                ** GOTO lbl191
                            }
                            catch (Throwable var17_34) {
                                block53: {
                                    break block53;
lbl61:
                                    // 1 sources

                                    do {
                                        begin = System.currentTimeMillis();
                                        for (i = 0; i < repeats; ++i) {
                                            reply = this.replies.poll(this.responseTimeout, TimeUnit.SECONDS);
                                            if (this.req.getCommand() != WorkerCommands.LOAD) break;
                                        }
                                        duration = System.currentTimeMillis() - begin;
                                        if (reply != null) {
                                            jobDone = this.aggregator.sendResponse(reply);
                                        } else if (this.req.getCommand() != WorkerCommands.DESCRIBE) {
                                            val = this.model.incrFailedInfReqs();
                                            WorkerThread.logger.error("Number or consecutive unsuccessful inference {}", (Object)val);
                                            throw new WorkerInitializationException("Backend worker did not respond in given time");
                                        }
                                        totalDuration += duration;
                                    } while (!jobDone);
                                    WorkerThread.logger.info("Backend response time: {}", (Object)totalDuration);
                                    switch (2.$SwitchMap$org$pytorch$serve$util$messages$WorkerCommands[this.req.getCommand().ordinal()]) {
                                        case 1: {
                                            this.model.resetFailedInfReqs();
                                            break;
                                        }
                                        case 2: {
                                            this.model.resetFailedInfReqs();
                                            break;
                                        }
                                        case 3: {
                                            if (reply.getCode() == 200) {
                                                this.setState(WorkerState.WORKER_MODEL_LOADED, 200);
                                                this.backoffIdx = 0;
                                                break;
                                            }
                                            this.setState(WorkerState.WORKER_ERROR, reply.getCode());
                                            status = reply.getCode();
                                            break;
                                        }
                                        case 4: {
                                            if (reply != null) break;
                                            this.aggregator.sendError(this.req, "Failed to get customized model matadata.", 500);
                                            break;
                                        }
                                    }
                                    this.req = null;
                                    workerThreadTime = System.currentTimeMillis() - wtStartTime - totalDuration;
                                    if (this.workerThreadTimeMetric == null) ** GOTO lbl9
                                    try {
                                        this.workerThreadTimeMetric.addOrUpdate(this.workerThreadTimeMetricDimensionValues, workerThreadTime);
                                    }
                                    catch (Exception e) {
                                        WorkerThread.logger.error("Failed to update frontend metric WorkerThreadTime: ", e);
                                    }
                                    ** continue;
lbl106:
                                    // 2 sources

                                    for (i = 0; this.backendChannel.size() > 0 && i < (this.model.getParallelLevel() > 0 ? this.model.getParallelLevel() : 1); ++i) {
                                        this.backendChannel.get(i).disconnect();
                                    }
                                    this.backendChannel.clear();
                                    this.currentThread.set(null);
                                    exitValue = this.lifeCycle.getExitValue();
                                    if (exitValue != null && exitValue == 137) {
                                        status = 413;
                                    }
                                    if (this.req != null) {
                                        this.aggregator.sendError(this.req, "Worker died.", status);
                                    }
                                    this.aggregator.cleanJobs();
                                    this.setState(WorkerState.WORKER_STOPPED, status);
                                    this.lifeCycle.exit();
                                    if (this.isHealthy() == false) return;
                                    this.retry();
                                    return;
lbl123:
                                    // 3 sources

                                    for (i = 0; this.backendChannel.size() > 0 && i < (this.model.getParallelLevel() > 0 ? this.model.getParallelLevel() : 1); ++i) {
                                        this.backendChannel.get(i).disconnect();
                                    }
                                    this.backendChannel.clear();
                                    this.currentThread.set(null);
                                    exitValue = this.lifeCycle.getExitValue();
                                    if (exitValue != null && exitValue == 137) {
                                        status = 413;
                                    }
                                    if (this.req != null) {
                                        this.aggregator.sendError(this.req, "Worker died.", status);
                                    }
                                    this.aggregator.cleanJobs();
                                    this.setState(WorkerState.WORKER_STOPPED, status);
                                    this.lifeCycle.exit();
                                    if (this.isHealthy() == false) return;
                                    this.retry();
                                    return;
lbl140:
                                    // 2 sources

                                    for (i = 0; this.backendChannel.size() > 0 && i < (this.model.getParallelLevel() > 0 ? this.model.getParallelLevel() : 1); ++i) {
                                        this.backendChannel.get(i).disconnect();
                                    }
                                    this.backendChannel.clear();
                                    this.currentThread.set(null);
                                    exitValue = this.lifeCycle.getExitValue();
                                    if (exitValue != null && exitValue == 137) {
                                        status = 413;
                                    }
                                    if (this.req != null) {
                                        this.aggregator.sendError(this.req, "Worker died.", status);
                                    }
                                    this.aggregator.cleanJobs();
                                    this.setState(WorkerState.WORKER_STOPPED, status);
                                    this.lifeCycle.exit();
                                    if (this.isHealthy() == false) return;
                                    this.retry();
                                    return;
lbl157:
                                    // 2 sources

                                    for (i = 0; this.backendChannel.size() > 0 && i < (this.model.getParallelLevel() > 0 ? this.model.getParallelLevel() : 1); ++i) {
                                        this.backendChannel.get(i).disconnect();
                                    }
                                    this.backendChannel.clear();
                                    this.currentThread.set(null);
                                    exitValue = this.lifeCycle.getExitValue();
                                    if (exitValue != null && exitValue == 137) {
                                        status = 413;
                                    }
                                    if (this.req != null) {
                                        this.aggregator.sendError(this.req, "Worker died.", status);
                                    }
                                    this.aggregator.cleanJobs();
                                    this.setState(WorkerState.WORKER_STOPPED, status);
                                    this.lifeCycle.exit();
                                    if (this.isHealthy() == false) return;
                                    this.retry();
                                    return;
lbl174:
                                    // 2 sources

                                    for (i = 0; this.backendChannel.size() > 0 && i < (this.model.getParallelLevel() > 0 ? this.model.getParallelLevel() : 1); ++i) {
                                        this.backendChannel.get(i).disconnect();
                                    }
                                    this.backendChannel.clear();
                                    this.currentThread.set(null);
                                    exitValue = this.lifeCycle.getExitValue();
                                    if (exitValue != null && exitValue == 137) {
                                        status = 413;
                                    }
                                    if (this.req != null) {
                                        this.aggregator.sendError(this.req, "Worker died.", status);
                                    }
                                    this.aggregator.cleanJobs();
                                    this.setState(WorkerState.WORKER_STOPPED, status);
                                    this.lifeCycle.exit();
                                    if (this.isHealthy() == false) return;
                                    this.retry();
                                    return;
lbl191:
                                    // 2 sources

                                    for (i = 0; this.backendChannel.size() > 0 && i < (this.model.getParallelLevel() > 0 ? this.model.getParallelLevel() : 1); ++i) {
                                        this.backendChannel.get(i).disconnect();
                                    }
                                    this.backendChannel.clear();
                                    this.currentThread.set(null);
                                    exitValue = this.lifeCycle.getExitValue();
                                    if (exitValue != null && exitValue == 137) {
                                        status = 413;
                                    }
                                    if (this.req != null) {
                                        this.aggregator.sendError(this.req, "Worker died.", status);
                                    }
                                    this.aggregator.cleanJobs();
                                    this.setState(WorkerState.WORKER_STOPPED, status);
                                    this.lifeCycle.exit();
                                    if (this.isHealthy() == false) return;
                                    this.retry();
                                    return;
                                }
                                for (i = 0; this.backendChannel.size() > 0 && i < (this.model.getParallelLevel() > 0 ? this.model.getParallelLevel() : 1); ++i) {
                                    this.backendChannel.get(i).disconnect();
                                }
                                this.backendChannel.clear();
                                this.currentThread.set(null);
                                exitValue = this.lifeCycle.getExitValue();
                                if (exitValue != null && exitValue == 137) {
                                    status = 413;
                                }
                                if (this.req != null) {
                                    this.aggregator.sendError(this.req, "Worker died.", status);
                                }
                                this.aggregator.cleanJobs();
                                this.setState(WorkerState.WORKER_STOPPED, status);
                                this.lifeCycle.exit();
                                if (this.isHealthy() == false) throw var17_34;
                                this.retry();
                                throw var17_34;
                            }
                        }
                    }
                }
            }
        }
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public long getMemory() {
        return this.memory;
    }

    public void setMemory(long memory) {
        this.memory = memory;
    }

    private void connect() throws WorkerInitializationException, InterruptedException {
        if (!this.configManager.isDebug()) {
            this.lifeCycle.startWorker(this.port, this.getDeviceIds());
        }
        String modelName = this.model.getModelName();
        String modelVersion = this.model.getVersion();
        this.setState(WorkerState.WORKER_STARTED, 200);
        int parallelLevel = this.model.getParallelLevel() > 0 ? this.model.getParallelLevel() : 1;
        CountDownLatch latch = new CountDownLatch(parallelLevel);
        final int responseBufferSize = this.configManager.getMaxResponseSize();
        try {
            for (int i = 0; i < parallelLevel; ++i) {
                Connector connector = new Connector(this.port + i);
                Bootstrap b = new Bootstrap();
                ((Bootstrap)((Bootstrap)b.group(this.backendEventGroup)).channel(connector.getClientChannel())).handler(new ChannelInitializer<Channel>(){

                    @Override
                    public void initChannel(Channel ch) {
                        ChannelPipeline p = ch.pipeline();
                        p.addLast(ENCODER);
                        p.addLast(new ModelResponseDecoder(responseBufferSize));
                        p.addLast(new WorkerHandler());
                    }
                });
                SocketAddress address = connector.getSocketAddress();
                logger.info("Connecting to: {}", (Object)address);
                this.backendChannel.add(b.connect(address).sync().channel());
                this.backendChannel.get(i).closeFuture().addListener(future -> {
                    latch.countDown();
                    logger.info("{} Worker disconnected. {}", (Object)this.getWorkerId(), (Object)this.state);
                    Thread thread = this.currentThread.getAndSet(null);
                    if (thread != null) {
                        thread.interrupt();
                    }
                });
                this.backendChannel.get(i).newSucceededFuture().addListener(future -> {
                    if (latch.getCount() == 1L) {
                        RequestInput input = new RequestInput(UUID.randomUUID().toString());
                        if (this.gpuId >= 0) {
                            input.addParameter(new InputParameter("gpu", String.valueOf(this.gpuId)));
                        }
                        RestJob job = new RestJob(null, modelName, modelVersion, WorkerCommands.LOAD, input);
                        this.model.addJob(this.workerId, job);
                    }
                    latch.countDown();
                });
            }
            if (!latch.await(2L, TimeUnit.MINUTES)) {
                throw new WorkerInitializationException("Worker failed to initialize within 2 mins");
            }
            this.running.set(true);
        }
        catch (Throwable t) {
            if (t instanceof IOException) {
                throw new WorkerInitializationException("Failed to connect to worker.", t);
            }
            throw t;
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public int getGpuId() {
        return this.gpuId;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getPid() {
        return this.lifeCycle.getPid();
    }

    public void shutdown() {
        this.running.set(false);
        this.setState(WorkerState.WORKER_SCALED_DOWN, 200);
        for (int i = 0; this.backendChannel.size() > 0 && i < (this.model.getParallelLevel() > 0 ? this.model.getParallelLevel() : 1); ++i) {
            if (this.backendChannel.get(i) == null) continue;
            this.backendChannel.get(i).close();
        }
        this.backendChannel.clear();
        this.lifeCycle.terminateIOStreams();
        Thread thread = this.currentThread.getAndSet(null);
        if (thread != null) {
            thread.interrupt();
            this.aggregator.sendError(null, "Worker scaled down.", 500);
            this.model.removeJobQueue(this.workerId);
        }
        if (this.aggregator instanceof SequenceBatchAggregator) {
            ((SequenceBatchAggregator)this.aggregator).shutdownExecutors();
            ((SequenceBatchAggregator)this.aggregator).stopEventDispatcher();
        }
    }

    private String getWorkerName() {
        String modelName = this.model.getModelVersionName().getVersionedModelName();
        return "W-" + this.port + '-' + modelName;
    }

    public void setState(WorkerState newState, int status) {
        this.listener.notifyChangeState(this.model.getModelVersionName().getVersionedModelName(), newState, status);
        logger.debug("{} State change {} -> {}", new Object[]{this.getWorkerName(), this.state, newState});
        long currentTS = System.currentTimeMillis();
        long timeTaken = currentTS - this.startTime;
        if (this.state != WorkerState.WORKER_SCALED_DOWN) {
            this.state = newState;
        }
        if (this.state == WorkerState.WORKER_MODEL_LOADED) {
            if (this.workerLoadTimeMetric != null) {
                try {
                    this.workerLoadTimeMetric.addOrUpdate(this.workerLoadTimeMetricDimensionValues, timeTaken);
                }
                catch (Exception e) {
                    logger.error("Failed to update frontend metric WorkerLoadTime: ", e);
                }
            }
            if (this.recoveryStartTS > 0L) {
                logger.info("Auto recovery succeeded, reset recoveryStartTS");
                this.recoveryStartTS = 0L;
            }
        } else if (this.state == WorkerState.WORKER_STOPPED) {
            if (this.recoveryStartTS == 0L) {
                this.recoveryStartTS = currentTS;
                logger.info("Auto recovery start timestamp: {}", (Object)this.recoveryStartTS);
            } else {
                logger.warn("Auto recovery failed again");
            }
        }
    }

    public void retry() {
        if (this.state == WorkerState.WORKER_SCALED_DOWN) {
            logger.debug("Worker terminated due to scale-down call.");
            return;
        }
        ModelManager manager = ModelManager.getInstance();
        if (this.backoffIdx < BACK_OFF.length - 1) {
            ++this.backoffIdx;
        }
        if (this.aggregator instanceof SequenceBatchAggregator) {
            ((SequenceBatchAggregator)this.aggregator).startEventDispatcher();
        }
        manager.getScheduler().schedule(() -> manager.submitTask(this), (long)BACK_OFF[this.backoffIdx], TimeUnit.SECONDS);
        logger.info("Retry worker: {} in {} seconds.", (Object)this.workerId, (Object)BACK_OFF[this.backoffIdx]);
    }

    private String getDeviceIds() {
        if (this.gpuId == -1 || this.model.getParallelLevel() == 0) {
            return null;
        }
        if (this.model.isHasCfgDeviceIds()) {
            return this.model.getDeviceIds().subList(this.gpuId, this.gpuId + this.model.getParallelLevel()).stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        ArrayList<Integer> deviceIds = new ArrayList<Integer>(this.model.getParallelLevel());
        for (int i = this.gpuId; i < this.gpuId + this.model.getParallelLevel(); ++i) {
            deviceIds.add(i);
        }
        return deviceIds.stream().map(String::valueOf).collect(Collectors.joining(","));
    }

    public boolean isHealthy() {
        return this.recoveryStartTS == 0L || System.currentTimeMillis() - this.recoveryStartTS < this.model.getMaxRetryTimeoutInMill();
    }

    private boolean isTensorParallelRequest(WorkerCommands workerCmd) {
        switch (workerCmd) {
            case PREDICT: 
            case STREAMPREDICT: 
            case STREAMPREDICT2: {
                return this.model.hasTensorParallel();
            }
        }
        return false;
    }

    private boolean isLoadRequest(WorkerCommands workerCmd) {
        return workerCmd == WorkerCommands.LOAD;
    }

    private int getRepeats(WorkerCommands workerCmd) {
        if (this.isLoadRequest(workerCmd) || this.isTensorParallelRequest(workerCmd)) {
            return Math.max(1, this.model.getParallelLevel());
        }
        return 1;
    }

    private /* synthetic */ void lambda$run$0(int idx) {
        try {
            this.backendChannel.get(idx).writeAndFlush(this.req).sync();
        }
        catch (InterruptedException e) {
            logger.error("Failed to send request to backend", e);
        }
    }

    @ChannelHandler.Sharable
    private class WorkerHandler
    extends SimpleChannelInboundHandler<ModelWorkerResponse> {
        private WorkerHandler() {
        }

        @Override
        public void channelRead0(ChannelHandlerContext ctx, ModelWorkerResponse msg) {
            try {
                WorkerThread.this.replies.offer(msg, WorkerThread.this.responseTimeout, TimeUnit.SECONDS);
            }
            catch (InterruptedException | NullPointerException e) {
                logger.error("Failed to offer reply, responseTimeout:" + WorkerThread.this.responseTimeout + "sec", e);
                throw new IllegalStateException("Reply queue is full.");
            }
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            logger.error("Unknown exception", cause);
            if (cause instanceof OutOfMemoryError) {
                ModelWorkerResponse msg = new ModelWorkerResponse();
                msg.setCode(413);
                msg.setMessage(cause.getMessage());
                if (!WorkerThread.this.replies.offer(msg)) {
                    throw new IllegalStateException("Reply queue is full.");
                }
            }
            ctx.close();
        }
    }
}

