import sys
from PyQt6 import QtWidgets,QtGui,QtCore
import io
import numpy as np
from print_info_window import print_info


if sys.version_info[0] == 3:
    from urllib.request import urlopen
elif sys.version_info[0] == 2:
    from urllib2 import urlopen

import ssl
ssl._create_default_https_context = ssl._create_unverified_context

#font = QtGui.QFont()
#font.setPointSize(8)
#font.setBold(False)


class RVBank_window(QtWidgets.QDialog):


    def __init__(self, parent=None):
        super(RVBank_window, self).__init__(parent=parent)
        vLayout = QtWidgets.QVBoxLayout(self)
        hLayout = QtWidgets.QHBoxLayout()


        self.info_dialog = print_info(self)


        self.lineEdit = QtWidgets.QLineEdit(self)
        hLayout.addWidget(self.lineEdit)

#        self.filter = QtWidgets.QPushButton("Search", self)
#        hLayout.addWidget(self.filter)
#        self.filter.clicked.connect(self.filterClicked)
        self.lineEdit.textChanged.connect(self.filterClicked)

        self.radio_group=QtWidgets.QButtonGroup(hLayout) # Number group
        self.button1  = QtWidgets.QRadioButton('HARPS RVBank', self)
        self.button2  = QtWidgets.QRadioButton('HIRES NZP', self)
        self.button1.setChecked(True)
#        self.button2.setEnabled(False)
#        self.button3  = QtWidgets.QRadioButton('symbol "t1"', self)

        self.radio_group.addButton(self.button1)
        self.radio_group.addButton(self.button2)

        hLayout.addWidget(self.button1)
        hLayout.addWidget(self.button2)

        self.radio_group.buttonClicked.connect(self.init_model)


        self.readme_button = QtWidgets.QPushButton('READ ME', self)
        hLayout.addWidget(self.readme_button)

        self.readme_button.clicked.connect(self.info)

        #self.radio_group.buttonClicked.connect(self.final_output)
        #self.button2.toggled.connect(self.final_output)
########  Targets ##############
        self.list = QtWidgets.QListView(self)
        vLayout.addLayout(hLayout)
        vLayout.addWidget(self.list)
        self.model = QtGui.QStandardItemModel(self.list)


########  Options ##############

        self.list_opt = QtWidgets.QListView(self)
        vLayout.addWidget(self.list_opt)
        self.model_opt = QtGui.QStandardItemModel(self.list_opt)

        self.setGeometry(2,2, 555, 525) 
        
        
        self.list.clicked.connect(self.on_clicked)
        self.list_opt.clicked.connect(self.on_clicked_opt)

        #self.list.setSelectionRectVisible(True)
        #print(self.list.isSelectionRectVisible())

        #url = "http://www2.mpia.de/homes/trifonov/Ver_02/%s_RVs/%s_HARPS_RVBank_ver02.dat"%(targets_HARPS[0],targets_HARPS[0])
        url = "https://exo-restart.com/wp-content/uploads/Stellar_parameters/Ver_02/%s_RVs/%s_HARPS_RVBank_ver02.dat"%(targets_HARPS[0],targets_HARPS[0])        
        
        self.path = url
        self.data_index  = 1
        self.row_opt = 0
        self.row = 0
        self.type_data = "HARPS"
        
        self.try_connection(url)
        if self.url_success == False:
            return

        try:
            self.x_data = np.genfromtxt(io.BytesIO(self.resp),usecols=[0])
            self.y_data = np.genfromtxt(io.BytesIO(self.resp),usecols=[1])
            self.e_y_data = np.genfromtxt(io.BytesIO(self.resp),usecols=[2])

        except:
            print("Something is wrong.... No connection to the HARPS RVBank!!!")
            self.url_success = False            

        self.init_model()


    def try_connection(self,url):

        try:
            self.resp = urlopen(url).read() 
            self.url_success = True
            return
        except:
            print("No internet connection, or no connection to the HARPS RVBank!!!")
            self.url_success = False

 
    def init_model(self):


        self.model.clear()
        self.model_opt.clear()

        if self.button1.isChecked():
            targets    = targets_HARPS
            data_files = data_files_HARPS
            data_files_ind = data_files_ind_HARPS
        elif self.button2.isChecked():
            targets    = targets_HIRES
            data_files = data_files_HIRES
            data_files_ind = data_files_ind_HIRES

        for code in targets:
            item = QtGui.QStandardItem(code)
            item.setCheckable(False)
            item.setEditable(False)
            self.model.appendRow(item)
        self.list.setModel(self.model)

        for code in data_files:
            item = QtGui.QStandardItem(code)
            item.setCheckable(False)
            item.setEditable(False)

            self.model_opt.appendRow(item)
        self.list_opt.setModel(self.model_opt)

        self.filterClicked()



#####################################
#        self.list.selectionModel().currentChanged.connect(self.on_row_changed)
#
#    def on_row_changed(self, current, previous):
#        self._INDEX = current.row()
#        print('Row %d selected' % current.row())
#####################################



    def filterClicked(self):

        filter_text = str(self.lineEdit.text()).lower()
        valid_row = []
        for row in range(self.model.rowCount()):
            if filter_text in str(self.model.item(row).text()).lower():
                self.list.setRowHidden(row, False)
                valid_row.append(row)
            else:
                self.list.setRowHidden(row, True)

        try:
            ix = self.model.index(valid_row[0], 0)
        except:
            ix = self.model.index(0, 0)   
         
        sm = self.list.selectionModel()
        sm.select(ix, QtCore.QItemSelectionModel.Select)
        
#        index = self.model.indexFromItem(self.model.item(valid_row[-1]))
 
        #self.on_clicked(ix)
        self.row = ix.row()
        self.final_output()

    def on_clicked(self, index):

        self.row = index.row()
        self.final_output()

    def on_clicked_opt(self, index):
        self.row_opt = index.row()
        self.final_output()
        
    def final_output(self):
        
        row =self.row
        row_opt = self.row_opt
        
        #print(row,row_opt)
        
        
        if self.button1.isChecked():

            self.type_data = "HARPS" 
            self.data_index = data_files_ind_HARPS[row_opt]
            self.data_name = data_files_HARPS[row_opt]
            

            #url = "http://www2.mpia.de/homes/trifonov/Ver_02/%s_RVs/%s_HARPS_RVBank_ver02.dat"%(targets_HARPS[row],targets_HARPS[row])
            url = "https://exo-restart.com/wp-content/uploads/Stellar_parameters/Ver_02/%s_RVs/%s_HARPS_RVBank_ver02.dat"%(targets_HARPS[row],targets_HARPS[row])            
           # resp = urlopen(url).read() 
 
            self.try_connection(url)
            if self.url_success == False:
                return
            
            self.x_data = np.atleast_1d(np.genfromtxt(io.BytesIO(self.resp),usecols=[3]))
            
            if self.data_index <22+3 or self.data_index==53:
                self.y_data = np.atleast_1d(np.genfromtxt(io.BytesIO(self.resp),usecols=[self.data_index]))
                self.e_y_data = np.atleast_1d(np.genfromtxt(io.BytesIO(self.resp),usecols=[self.data_index+1]))
            elif self.data_index == 22+3 or self.data_index == 24+3:
                self.y_data = np.atleast_1d(np.genfromtxt(io.BytesIO(self.resp),usecols=[self.data_index])* 1000.0)
                self.e_y_data = np.atleast_1d(np.array([1.0]*len(self.y_data)))
            else:
                self.y_data = np.atleast_1d(np.genfromtxt(io.BytesIO(self.resp),usecols=[self.data_index]))
                self.e_y_data = np.atleast_1d(np.array([np.mean(self.y_data)*0.01]*len(self.y_data)))
                
            #print(self.data_index)
           # print(self.y_data)
           # print(self.e_y_data)
 
            self.path = url
            self.target_name = targets_HARPS[row]


        elif self.button2.isChecked():

            self.type_data = "HIRES"
            
            if row_opt > 3:
                row_opt = 0
            
            self.data_index = data_files_ind_HIRES[row_opt]
            self.data_name = data_files_HIRES[row_opt]
            
            #print(self.data_index,self.data_name)

            url = "http://www2.mpia.de/homes/trifonov/HIRES/%s_RVs/%s.dat"%(targets_HIRES[row],targets_HIRES[row])
            #resp = urlopen(url).read() 
            
            self.try_connection(url)
            if self.url_success == False:
                return
            
            self.x_data = np.genfromtxt(io.BytesIO(self.resp),usecols=[0])
            if self.data_index <5:
                self.y_data = np.genfromtxt(io.BytesIO(self.resp),usecols=[self.data_index])
                self.e_y_data = np.genfromtxt(io.BytesIO(self.resp),usecols=[self.data_index+1])
            elif self.data_index >= 5:
                self.y_data = np.genfromtxt(io.BytesIO(self.resp),usecols=[self.data_index])
                self.e_y_data = np.array([0.001]*len(self.y_data))

            self.path = url
            self.target_name = targets_HIRES[row]



    def info(self):
        
       # self.info_dialog.setGeometry(300, 300, 150, 150)
        self.info_dialog.setFixedSize(550, 700)

        self.info_dialog.setWindowTitle('RVBank info')
 
    
        text = ''
        self.info_dialog.text.setText(text) 
        
        text = """
<br>A few things you need to know about the RVBank data:
<br>
<br>
<br>The data are retrieved via an internet connection from the RVBank web pages: 
<br>* <a href='http://www.mpia.de/homes/trifonov/HARPS_RVBank.html'>HARPS RVBank</a>, and
<br>* <a href='http://www.mpia.de/homes/trifonov/HIRES_RVBank.html'>HIRES RVBank</a>
<br>
<br>Therefore, you need an internet connection for browsing the RVBank data.
"""
        self.info_dialog.text.append(text)


        text = """
<br>
<br>
If you made the use of the HARPS data for your paper, please cite:
<br>* <a href='https://ui.adsabs.harvard.edu/abs/2020arXiv200105942T/abstract'> Trifonov et al. (2020)</a>
<br>(also, please check for relevant references in the paper).
<br>
<br>If you made the use of the original HIRES data, please cite:
<br>* <a href='https://ui.adsabs.harvard.edu/abs/2017AJ....153..208B/abstract'> Butler et al. (2017)</a>
<br>
<br>If you made the use of the NZP corrected HIRES data, please cite:
<br>* <a href='https://ui.adsabs.harvard.edu/abs/2019MNRAS.484L...8T/abstract'> Tal-Or et al. (2019)</a>
together with  <a href='https://ui.adsabs.harvard.edu/abs/2017AJ....153..208B/abstract'> Butler et al. (2017)</a>  
<br>
<br>
<br>
<br> Remember! 
<br> 
<br> * HARPS-DRS activity data such as FWHM, Contrast, and Bisector-span, originally do not have error bars! Thus, the Exo-Striker adopts "sigma=1 m/s" for CCF and FWHM data, and "sigma=0.01" for the Contrast data. 
<br> 
<br> * HIRES s- and h-index data originally do not have error bars! Thus, the Exo-Striker adopts "sigma"=0.001.
<br> 
<br> * Some HIRES h-index data appear as -1.0. This means that for the given epoch the h-index data was not possible to be computed.
"""

 
        self.info_dialog.text.append(text)

    
        self.info_dialog.text.setReadOnly(True)
        #self.dialog.setWindowIcon (QtGui.QIcon('logo.png'))
        self.info_dialog.show()










data_files_HARPS = ["RVs SERVAL + NZP correction",
              "RVs DRS + NZP correction",
              "RVs SERVAL",
              "RVs DRS",
              "CRX","dLW","Halpha","NaD1","NaD2","FWHM_DRS","CONTRAST_DRS","Bisector","RHKp"]

#data_files_ind_HARPS = [1,3,5,7,11,13,15,17,19,22,23,24]
data_files_ind_HARPS = [4,6,8,10,14,16,18,20,22,25,26,27,53]

targets_HARPS = ['BD+012494', 'BD+01316', 'BD+034525', 'BD+053805', 'BD+053818', 'BD+053820', 'BD+053829', 'BD+053833', 'BD+053835', 'BD+053839', 'BD+053840', 'BD+053858', 'BD+053868', 'BD+053882', 'BD+053906', 'BD+062168', 'BD+062932A', 'BD+063796', 'BD+072351', 'BD+072474', 'BD+081767', 'BD+084055', 'BD+084056', 'BD+10125', 'BD+101799', 'BD+101802', 'BD+11359', 'BD+144559', 'BD+171832', 'BD+17601B', 'BD+20594', 'BD+22353B', 'BD+22574', 'BD+23527', 'BD+25610', 'BD-011951', 'BD-013943', 'BD-02146', 'BD-022880', 'BD-043206', 'BD-043588', 'BD-053461', 'BD-053763', 'BD-055432', 'BD-061006', 'BD-073537', 'BD-07436B', 'BD-07436', 'BD-081175', 'BD-093064', 'BD-096003', 'BD-096325', 'BD-101177', 'BD-114672', 'BD-114934A', 'BD-114934B', 'BD-122361', 'BD-122371', 'BD-12588', 'BD-132130', 'BD-136424', 'BD-141137', 'BD-156276', 'BD-15705', 'BD-17751', 'BD-184244', 'BD-184532', 'BD-184705', 'BD-184710', 'BD-194086', 'BD-194173', 'BD-194341', 'BD-194582', 'BD-202976', 'BD-20761', 'BD-21521', 'BD-221092', 'BD-22167', 'BD-225866', 'CD-2312854', 'CD-234300', 'CD-236086', 'CD-236099', 'CD-2412030', 'CD-2412897', 'CD-2510553', 'CD-2514757', 'CD-2516399', 'CD-251737', 'CD-252180', 'CD-252913', 'CD-254246', 'CD-254253', 'CD-261407', 'CD-2616866B', 'CD-2616866', 'CD-281745', 'CD-287411', 'CD-287935', 'CD-3010313', 'CD-301812', 'CD-3019757', 'CD-306011', 'CD-306015', 'CD-3110766', 'CD-3114532', 'CD-3114549', 'CD-312415', 'CD-321952', 'CD-329927', 'CD-3315536', 'CD-332771', 'CD-337795B', 'CD-337795', 'CD-3415399', 'CD-341735', 'CD-34677', 'CD-348236', 'CD-348618', 'CD-3515858', 'CD-35983', 'CD-361818', 'CD-371123', 'CD-381059', 'CD-381467', 'CD-383745', 'CD-383754', 'CD-386968', 'CD-394725', 'CD-395833', 'CD-397570', 'CD-397945', 'CD-408434', 'CD-4113726', 'CD-415929', 'CD-4215773', 'CD-426963', 'CD-426976', 'CD-426977', 'CD-431395', 'CD-431451', 'CD-438016', 'CD-4414956', 'CD-4414956b', 'CD-44327', 'CD-445997', 'CD-452093', 'CD-452997', 'CD-461064', 'CD-461323', 'CD-461408', 'CD-471026', 'CD-487349', 'CD-4911399', 'CD-4911401', 'CD-4911402', 'CD-4911404', 'CD-4911405', 'CD-4911410', 'CD-4911413', 'CD-4911415', 'CD-50524', 'CD-50714', 'CD-52381', 'CD-52862B', 'CD-535815', 'CD-535820', 'CD-535829', 'CD-536474', 'CD-546002', 'CD-546003', 'CD-551709', 'CD-554911', 'CD-561068', 'CD-561433', 'CD-564581', 'CD-567708', 'CD-57105', 'CD-584411', 'CD-601144', 'CD-601348', 'CD-60370', 'CD-611276', 'CD-61970', 'CD-691055', 'CD-692101', 'CD-721700B', 'CD-73118', 'CD-74324', 'CD-74712', 'CD-75878', 'CD-7824', 'CD-8028', 'CD-8480', 'EPIC202843085', 'EPIC210558622', 'EPIC210744674', 'EPIC210968143', 'EPIC211359660', 'EPIC211647930', 'EPIC211730024', 'EPIC212428509', 'EPIC212460519', 'EPIC212469831', 'EPIC212572439', 'EPIC212585579', 'EPIC212627712', 'EPIC212645891', 'EPIC212658818', 'EPIC212735333', 'EPIC212757004', 'EPIC219388192', 'EPIC219409830', 'EPIC219503117', 'EPIC219661601', 'EPIC219722212', 'EPIC246193072', 'GJ1001', 'GJ1002', 'GJ1008', 'GJ1009', 'GJ100', 'GJ1012', 'GJ1018', 'GJ1020', 'GJ1021', 'GJ1022', 'GJ1031', 'GJ1032', 'GJ1036', 'GJ103', 'GJ1043', 'GJ1044', 'GJ1046', 'GJ1048', 'GJ1050', 'GJ1054', 'GJ1056', 'GJ1057', 'GJ105A', 'GJ105B', 'GJ1061', 'GJ1065', 'GJ1066', 'GJ1068', 'GJ1069', 'GJ1075', 'GJ1079', 'GJ1084', 'GJ1085', 'GJ1088', 'GJ1089', 'GJ108', 'GJ1094', 'GJ1099', 'GJ10', 'GJ1123', 'GJ1126', 'GJ1129', 'GJ1130', 'GJ1132', 'GJ1135', 'GJ1137', 'GJ1144', 'GJ1145', 'GJ1154', 'GJ115', 'GJ1161', 'GJ1164', 'GJ1177', 'GJ117', 'GJ118', 'GJ1190', 'GJ1191', 'GJ1207', 'GJ1214', 'GJ1217', 'GJ121', 'GJ1224', 'GJ1232', 'GJ1236', 'GJ1239', 'GJ1240', 'GJ1246', 'GJ1247', 'GJ1248', 'GJ1252', 'GJ1256', 'GJ1265', 'GJ1267', 'GJ126', 'GJ1279', 'GJ1280', 'GJ1282', 'GJ128', 'GJ12', 'GJ131', 'GJ132', 'GJ135', 'GJ136', 'GJ138', 'GJ140.1', 'GJ141.2', 'GJ143.1', 'GJ143', 'GJ146', 'GJ149', 'GJ150.0', 'GJ150.1', 'GJ154', 'GJ155', 'GJ156', 'GJ159', 'GJ162.2', 'GJ163', 'GJ166C', 'GJ166', 'GJ167.2', 'GJ169', 'GJ16', 'GJ170.1', 'GJ173', 'GJ177.1', 'GJ177', 'GJ178', 'GJ179', 'GJ17', 'GJ18.0', 'GJ180', 'GJ182', 'GJ183', 'GJ185', 'GJ186', 'GJ187', 'GJ188', 'GJ189.2', 'GJ191', 'GJ198', 'GJ19', 'GJ1', 'GJ2001', 'GJ2018', 'GJ201', 'GJ2030', 'GJ2033', 'GJ2036', 'GJ2037', 'GJ204.2', 'GJ2046', 'GJ2049', 'GJ204', 'GJ2051', 'GJ2056', 'GJ2058', 'GJ2059', 'GJ205', 'GJ2060', 'GJ2066', 'GJ206', 'GJ2079', 'GJ2085', 'GJ208', 'GJ2119', 'GJ2126', 'GJ2127', 'GJ2128', 'GJ2137', 'GJ213', 'GJ214', 'GJ218', 'GJ219.0', 'GJ221', 'GJ223.3', 'GJ224', 'GJ225.1', 'GJ225', 'GJ227', 'GJ230', 'GJ231.1', 'GJ233', 'GJ234', 'GJ236', 'GJ238', 'GJ239.1', 'GJ240', 'GJ243', 'GJ245.1', 'GJ250', 'GJ252', 'GJ253', 'GJ257', 'GJ260', 'GJ267', 'GJ268.2', 'GJ273', 'GJ275', 'GJ279', 'GJ280', 'GJ281', 'GJ284', 'GJ285', 'GJ288', 'GJ291.1', 'GJ293.1', 'GJ294A', 'GJ294B', 'GJ294', 'GJ298', 'GJ299', 'GJ29', 'GJ3005', 'GJ300', 'GJ3018', 'GJ3020', 'GJ3021', 'GJ3025', 'GJ3029', 'GJ302', 'GJ3038', 'GJ3049', 'GJ3053', 'GJ3054', 'GJ3071', 'GJ3072', 'GJ3075', 'GJ3082', 'GJ3084', 'GJ3090', 'GJ3091', 'GJ3098', 'GJ309', 'GJ31.3', 'GJ3102', 'GJ3110', 'GJ312', 'GJ3131', 'GJ3138', 'GJ3139', 'GJ313', 'GJ3141', 'GJ3148', 'GJ315.0', 'GJ3155', 'GJ3160', 'GJ3161', 'GJ317', 'GJ3187', 'GJ3189', 'GJ3193', 'GJ319', 'GJ31', 'GJ3200', 'GJ3202', 'GJ3203', 'GJ3205', 'GJ3207', 'GJ320', 'GJ321.3', 'GJ3212', 'GJ3218', 'GJ3219', 'GJ3221', 'GJ3222', 'GJ3230', 'GJ3244', 'GJ3253', 'GJ3255', 'GJ3256', 'GJ3258', 'GJ3260', 'GJ3263', 'GJ3269', 'GJ3279', 'GJ327', 'GJ3284', 'GJ3293', 'GJ3300', 'GJ3305', 'GJ3307', 'GJ330', 'GJ3313', 'GJ3314', 'GJ3317', 'GJ3321', 'GJ3323', 'GJ3325', 'GJ3328', 'GJ333.2', 'GJ3332', 'GJ333', 'GJ3340', 'GJ3341', 'GJ3344', 'GJ334', 'GJ3356', 'GJ3362', 'GJ3367', 'GJ3376', 'GJ3379', 'GJ337', 'GJ3389', 'GJ33', 'GJ3404', 'GJ3405', 'GJ341', 'GJ3436', 'GJ3446', 'GJ3449', 'GJ3455', 'GJ3470', 'GJ3473', 'GJ3492', 'GJ3493', 'GJ3494', 'GJ349', 'GJ3500', 'GJ3502', 'GJ3508', 'GJ3519', 'GJ3523', 'GJ3527', 'GJ352', 'GJ3530', 'GJ3535', 'GJ3543', 'GJ355.2', 'GJ3551', 'GJ3555', 'GJ355', 'GJ3563', 'GJ357', 'GJ358', 'GJ3591', 'GJ3598', 'GJ3603', 'GJ3615', 'GJ3618', 'GJ361', 'GJ3620', 'GJ3633', 'GJ3634', 'GJ364.0', 'GJ3643', 'GJ3644', 'GJ3648', 'GJ3663', 'GJ3671', 'GJ3677', 'GJ3679', 'GJ367', 'GJ3695', 'GJ369', 'GJ3700', 'GJ3701', 'GJ3707', 'GJ3708', 'GJ3727', 'GJ3737', 'GJ3746', 'GJ3752', 'GJ3759', 'GJ3769', 'GJ3778', 'GJ377', 'GJ378.2', 'GJ379.1', 'GJ3792', 'GJ3796', 'GJ3799', 'GJ3813', 'GJ3817', 'GJ3822', 'GJ3823', 'GJ3827', 'GJ382', 'GJ3830', 'GJ3835', 'GJ3838', 'GJ383', 'GJ386', 'GJ3871', 'GJ3874', 'GJ3885', 'GJ388', 'GJ3896', 'GJ3900', 'GJ3905', 'GJ390', 'GJ3912', 'GJ3915', 'GJ3916', 'GJ3918', 'GJ393', 'GJ3944', 'GJ3952', 'GJ3962', 'GJ3969', 'GJ3970', 'GJ398.1', 'GJ3987', 'GJ3996', 'GJ3998', 'GJ399', 'GJ3', 'GJ4001', 'GJ4004', 'GJ4005', 'GJ4008', 'GJ4014', 'GJ4016', 'GJ401', 'GJ402.1', 'GJ402', 'GJ4038', 'GJ404', 'GJ4052', 'GJ4056', 'GJ406', 'GJ4071', 'GJ4077', 'GJ4085', 'GJ4088', 'GJ4092', 'GJ40', 'GJ4100', 'GJ410', 'GJ412.3', 'GJ4129', 'GJ413.1', 'GJ4130', 'GJ4140', 'GJ4143', 'GJ4154', 'GJ4155', 'GJ416.1', 'GJ4160', 'GJ4187', 'GJ4195', 'GJ4197', 'GJ419', 'GJ42.0', 'GJ42.1', 'GJ4206', 'GJ4213', 'GJ421', 'GJ4220', 'GJ423.1', 'GJ4230', 'GJ4241', 'GJ4244', 'GJ4245', 'GJ4248', 'GJ4253', 'GJ425', 'GJ4262', 'GJ4265', 'GJ4270', 'GJ4273', 'GJ4274', 'GJ429.2', 'GJ4291', 'GJ4293', 'GJ429', 'GJ4303', 'GJ4306', 'GJ431', 'GJ4321', 'GJ4322', 'GJ432', 'GJ4331', 'GJ4332', 'GJ433', 'GJ4340', 'GJ4347', 'GJ4352', 'GJ4353', 'GJ435', 'GJ4362', 'GJ4364', 'GJ436', 'GJ4377', 'GJ4383', 'GJ438', 'GJ43', 'GJ442', 'GJ443', 'GJ446', 'GJ447', 'GJ448.0', 'GJ449', 'GJ452.1', 'GJ452', 'GJ45', 'GJ465', 'GJ468', 'GJ469', 'GJ472', 'GJ476', 'GJ477', 'GJ478', 'GJ479', 'GJ480', 'GJ488.2', 'GJ488', 'GJ493', 'GJ494', 'GJ496.1', 'GJ501.2', 'GJ503.3', 'GJ506.1', 'GJ506', 'GJ508.3', 'GJ50', 'GJ510', 'GJ511', 'GJ513', 'GJ514', 'GJ517', 'GJ52.1', 'GJ521.1', 'GJ522', 'GJ524.1', 'GJ526', 'GJ529', 'GJ530', 'GJ534', 'GJ536', 'GJ538.1', 'GJ54.1', 'GJ540.1', 'GJ541.1', 'GJ542', 'GJ544', 'GJ547', 'GJ550', 'GJ551', 'GJ552', 'GJ553', 'GJ557.0', 'GJ558.1', 'GJ559B', 'GJ55', 'GJ56.1', 'GJ56.3', 'GJ560', 'GJ563.2', 'GJ565', 'GJ569', 'GJ570.1', 'GJ570A', 'GJ570B', 'GJ571', 'GJ574', 'GJ579.2', 'GJ579.3', 'GJ57', 'GJ58.2', 'GJ581', 'GJ583', 'GJ587', 'GJ588', 'GJ58', 'GJ594', 'GJ598', 'GJ599', 'GJ603', 'GJ604', 'GJ606', 'GJ611.3', 'GJ613.0', 'GJ615', 'GJ616', 'GJ618.1', 'GJ618.4', 'GJ620.1', 'GJ620', 'GJ622', 'GJ624', 'GJ628', 'GJ629.1', 'GJ629.3', 'GJ62', 'GJ631', 'GJ634.1', 'GJ634', 'GJ637', 'GJ641', 'GJ643', 'GJ644', 'GJ645', 'GJ649', 'GJ65.2', 'GJ650', 'GJ653', 'GJ654', 'GJ656', 'GJ657', 'GJ660.1', 'GJ660', 'GJ664', 'GJ666', 'GJ667', 'GJ66', 'GJ670', 'GJ672.1', 'GJ674', 'GJ676', 'GJ680', 'GJ683', 'GJ686', 'GJ688', 'GJ691', 'GJ692', 'GJ693', 'GJ695.1', 'GJ696', 'GJ698.1', 'GJ699.2', 'GJ699', 'GJ701', 'GJ702', 'GJ707', 'GJ70', 'GJ710', 'GJ711', 'GJ715', 'GJ717', 'GJ722', 'GJ724.2', 'GJ724', 'GJ726', 'GJ727', 'GJ729', 'GJ730', 'GJ735', 'GJ739', 'GJ740', 'GJ744', 'GJ747.1', 'GJ747.3', 'GJ747.4', 'GJ752', 'GJ754', 'GJ755', 'GJ757', 'GJ762', 'GJ768.1', 'GJ770', 'GJ771', 'GJ776', 'GJ780', 'GJ781.1', 'GJ781.2', 'GJ782', 'GJ783', 'GJ784.1', 'GJ784', 'GJ785', 'GJ787', 'GJ788.1', 'GJ791', 'GJ792.1', 'GJ796', 'GJ797', 'GJ798', 'GJ79', 'GJ7', 'GJ800', 'GJ801', 'GJ803', 'GJ805', 'GJ808', 'GJ810', 'GJ811.1', 'GJ811', 'GJ812.1', 'GJ812', 'GJ817', 'GJ818', 'GJ821', 'GJ825.2', 'GJ825', 'GJ826.1', 'GJ827.1', 'GJ827', 'GJ83.1', 'GJ830', 'GJ831', 'GJ836.7', 'GJ838', 'GJ83', 'GJ84.1', 'GJ841A', 'GJ841', 'GJ842', 'GJ843', 'GJ845', 'GJ846', 'GJ848', 'GJ849.1', 'GJ849', 'GJ851.3', 'GJ853', 'GJ855.1', 'GJ855', 'GJ85', 'GJ862', 'GJ863', 'GJ864', 'GJ865', 'GJ867', 'GJ869', 'GJ86', 'GJ874', 'GJ875', 'GJ876', 'GJ877', 'GJ879', 'GJ87', 'GJ880', 'GJ881', 'GJ882', 'GJ884', 'GJ887', 'GJ889.1', 'GJ889', 'GJ890', 'GJ891', 'GJ894', 'GJ895.1', 'GJ9003', 'GJ9007', 'GJ9008', 'GJ900', 'GJ9010', 'GJ9012', 'GJ9015', 'GJ9018', 'GJ9024', 'GJ9027', 'GJ9029', 'GJ902', 'GJ9031', 'GJ9036', 'GJ9038', 'GJ904', 'GJ9055', 'GJ9056', 'GJ9061', 'GJ9067', 'GJ9075', 'GJ9079', 'GJ9080', 'GJ908', 'GJ909.1', 'GJ9094', 'GJ9101', 'GJ9103A', 'GJ9106', 'GJ9107', 'GJ9109', 'GJ9116', 'GJ9118', 'GJ911', 'GJ9121', 'GJ9122', 'GJ912', 'GJ9133', 'GJ9135', 'GJ9137', 'GJ9144', 'GJ9156', 'GJ9163', 'GJ9165', 'GJ9172', 'GJ9177', 'GJ9178', 'GJ9183', 'GJ9188', 'GJ9190', 'GJ9191', 'GJ9201', 'GJ9204', 'GJ9206', 'GJ9207', 'GJ9210', 'GJ9219', 'GJ9222', 'GJ9223', 'GJ9224', 'GJ9241', 'GJ9252', 'GJ9254', 'GJ9255', 'GJ9263', 'GJ9268', 'GJ9269', 'GJ9273', 'GJ9276', 'GJ9283', 'GJ9293', 'GJ9296', 'GJ9299', 'GJ9316', 'GJ9320', 'GJ9322', 'GJ9324', 'GJ9328', 'GJ9332', 'GJ9338', 'GJ9345', 'GJ9356', 'GJ9367', 'GJ9381', 'GJ9384', 'GJ9391', 'GJ9395', 'GJ9396', 'GJ9398', 'GJ9411', 'GJ9415', 'GJ9423', 'GJ9429', 'GJ9441', 'GJ9445', 'GJ9467', 'GJ9472', 'GJ9473', 'GJ9476', 'GJ9479', 'GJ9481', 'GJ9482', 'GJ9498', 'GJ9507', 'GJ9524', 'GJ9525', 'GJ9527', 'GJ9536', 'GJ9547', 'GJ9563', 'GJ9565', 'GJ9583', 'GJ9590', 'GJ9592', 'GJ95', 'GJ9625', 'GJ9626', 'GJ9630', 'GJ9646', 'GJ9655', 'GJ9659', 'GJ9661', 'GJ9663', 'GJ9673', 'GJ9700', 'GJ9714', 'GJ9732', 'GJ9733', 'GJ9740', 'GJ9757', 'GJ9762', 'GJ9765', 'GJ9771', 'GJ9774', 'GJ9787', 'GJ9789', 'GJ9790', 'GJ9797', 'GJ97', 'GJ9801', 'GJ9803', 'GJ9824', 'GJ9827', 'GJ9828', 'GJ9829', 'GJ9833', 'GJ9835', 'GJ9836', 'GJ9845', 'GJ9847', 'HATS-17', 'HATS-31', 'HATS-6', 'HATS-72', 'HATS398-020', 'HATS398-021', 'HATS411-024', 'HATS411-035', 'HATS411-062', 'HATS412-016', 'HATS499-001', 'HATS511-001', 'HATS524-001', 'HATS535-001', 'HATS537-009', 'HATS538-002', 'HATS544-001', 'HATS545-001', 'HATS545-003', 'HATS546-004', 'HATS547-004', 'HATS549-008', 'HATS551-012', 'HATS551-017', 'HATS554-024', 'HATS554-051', 'HATS554-059', 'HATS555-001', 'HATS555-012', 'HATS556-001', 'HATS556-002', 'HATS557-026', 'HATS557-030', 'HATS557-037', 'HATS557-039', 'HATS557-049', 'HATS557-050', 'HATS559-013', 'HATS560-001', 'HATS560-012', 'HATS560-018', 'HATS560-021', 'HATS561-002', 'HATS561-007', 'HATS563-014', 'HATS565-001', 'HATS565-004', 'HATS565-005', 'HATS566-006', 'HATS567-001', 'HATS585-008', 'HATS586-003', 'HATS587-008', 'HATS598-010', 'HATS598-013', 'HATS600-004', 'HATS600-019', 'HATS600-027', 'HATS601-056', 'HATS601-059', 'HATS601-061', 'HATS602-002', 'HATS602-003', 'HATS602-035', 'HATS602-040', 'HATS602-067', 'HATS602-072', 'HATS602-123', 'HATS602-124', 'HATS602-154', 'HATS606-001', 'HATS606-010', 'HATS606-017', 'HATS606-033', 'HATS610-007', 'HATS610-008', 'HATS610-016', 'HATS625-003', 'HATS625-020', 'HATS625-025', 'HATS625-040', 'HATS631-001', 'HATS647-005', 'HATS697-007', 'HATS697-025', 'HATS697-027', 'HATS698-015', 'HATS698-017', 'HATS698-018', 'HATS698-021', 'HATS698-024', 'HATS698-041', 'HATS699-039', 'HATS699-049', 'HATS699-050', 'HATS700-002', 'HATS700-003', 'HATS700-026', 'HATS700-032', 'HATS701-005', 'HATS701-008', 'HATS701-018', 'HATS701-019', 'HATS701-023', 'HATS709-003', 'HATS710-001', 'HATS736-002', 'HATS737-002', 'HATS745-004', 'HATS745-006', 'HATS745-015', 'HATS745-021', 'HATS746-009', 'HATS747-008', 'HATS747-013', 'HATS747-031', 'HATS755-007', 'HATS756-008', 'HATS762-007', 'HATS762-014', 'HATS772-018', 'HATS772-088', 'HATS772-095', 'HATS772-106', 'HATS772-121', 'HATS772-126', 'HATS772-142', 'HATS772-143', 'HATS772-150', 'HATS772-186', 'HATS777-003', 'HATS777-012', 'HATS778-004', 'HATS778-015', 'HATS778-018', 'HATS778-024', 'HATS803-003', 'HD100069', 'HD10008', 'HD1000', 'HD100282', 'HD100289', 'HD100334', 'HD100336', 'HD100363', 'HD100407', 'HD10042', 'HD100453B', 'HD100453', 'HD100508', 'HD100655', 'HD10069', 'HD100773', 'HD100777', 'HD100788', 'HD100880', 'HD10092', 'HD101021', 'HD101063', 'HD101065', 'HD101117', 'HD101197', 'HD101285', 'HD101321', 'HD101339', 'HD101348', 'HD101367', 'HD101412', 'HD10142', 'HD101579', 'HD101612', 'HD101615', 'HD101644', 'HD101650', 'HD10166', 'HD101695', 'HD101724', 'HD10180', 'HD101886', 'HD10188', 'HD101896', 'HD101900', 'HD101917', 'HD101930', 'HD101940', 'HD102117', 'HD102124', 'HD102136', 'HD102188', 'HD102195', 'HD102196', 'HD102200', 'HD10226', 'HD102272', 'HD102300', 'HD102346', 'HD102350', 'HD102361', 'HD102458', 'HD102584', 'HD10261', 'HD10269', 'HD10278', 'HD102843', 'HD103197', 'HD103234', 'HD10337', 'HD103462', 'HD103482', 'HD10353', 'HD103578', 'HD103589', 'HD103720', 'HD103743', 'HD103746', 'HD103774', 'HD103789', 'HD10380', 'HD103836', 'HD103847', 'HD103891', 'HD103914', 'HD103929', 'HD103949', 'HD104006', 'HD104067', 'HD1040', 'HD104181', 'HD104237', 'HD104263', 'HD104555', 'HD10472', 'HD104730', 'HD104760', 'HD104800', 'HD104819', 'HD104856', 'HD104982', 'HD105004', 'HD105066', 'HD105509', 'HD105575', 'HD105613', 'HD105665', 'HD105690', 'HD105707', 'HD105779', 'HD105837', 'HD105850', 'HD105874', 'HD105938', 'HD105994', 'HD105', 'HD10607', 'HD10615', 'HD106218', 'HD106275', 'HD106290', 'HD106315', 'HD106444', 'HD106473', 'HD10647', 'HD106589', 'HD106661', 'HD10678', 'HD106855', 'HD106906', 'HD106937', 'HD10700', 'HD107094', 'HD107148', 'HD107181', 'HD10720', 'HD107328', 'HD107383', 'HD107446', 'HD107572', 'HD10761', 'HD107815', 'HD107821', 'HD108063', 'HD108095', 'HD108147', 'HD108177', 'HD108202', 'HD108236', 'HD108309', 'HD10830', 'HD108341', 'HD108564', 'HD108570', 'HD10863', 'HD108701', 'HD108760', 'HD108767B', 'HD108767', 'HD108768', 'HD108851', 'HD108857', 'HD108904', 'HD108935', 'HD108953', 'HD10895', 'HD109098', 'HD109138', 'HD109145', 'HD109271', 'HD109310', 'HD109368', 'HD109379', 'HD109408', 'HD109409', 'HD109423', 'HD109536', 'HD109573', 'HD10957', 'HD109684', 'HD109723', 'HD109787', 'HD109799', 'HD109832', 'HD109833', 'HD109988', 'HD110014', 'HD110020', 'HD110058', 'HD110113', 'HD11025', 'HD110291', 'HD110411', 'HD110537', 'HD110546', 'HD110557', 'HD110619', 'HD110621', 'HD110634', 'HD110646', 'HD110666', 'HD110668', 'HD110697', 'HD11072', 'HD110829', 'HD111028', 'HD111038', 'HD111102', 'HD111133', 'HD111232', 'HD111261B', 'HD111295', 'HD111315', 'HD111333', 'HD111473', 'HD111487', 'HD111505', 'HD111519', 'HD111520', 'HD111564', 'HD111588', 'HD111676', 'HD11168', 'HD111777', 'HD111814', 'HD111884', 'HD111915', 'HD11195', 'HD111998', 'HD112100', 'HD112109', 'HD112183', 'HD112269', 'HD11226', 'HD112283', 'HD11231', 'HD112410', 'HD112540', 'HD11262', 'HD112646', 'HD11271', 'HD11274', 'HD112776', 'HD112810', 'HD112934', 'HD113083', 'HD113101', 'HD113226', 'HD11327', 'HD11332', 'HD113449', 'HD113466', 'HD113513', 'HD113524', 'HD113538', 'HD113556', 'HD113569', 'HD113679', 'HD113766', 'HD113901', 'HD113904', 'HD11397', 'HD113998', 'HD114076', 'HD114082', 'HD114319', 'HD114330', 'HD114386', 'HD114470', 'HD114529', 'HD114543', 'HD114561', 'HD114613', 'HD114642', 'HD114729', 'HD114747', 'HD114853', 'HD115031', 'HD11505', 'HD115116', 'HD11511', 'HD115128', 'HD115169', 'HD115226', 'HD115231', 'HD115319', 'HD115341', 'HD115361', 'HD115439', 'HD115440', 'HD115466', 'HD115478', 'HD115496', 'HD115499', 'HD115577', 'HD115585', 'HD11563A', 'HD115659', 'HD115674', 'HD115773', 'HD115820', 'HD11584', 'HD115902', 'HD116087', 'HD11608', 'HD116114', 'HD116160', 'HD11616', 'HD116235', 'HD116244', 'HD116255', 'HD116259', 'HD116284', 'HD116410', 'HD116434', 'HD116458', 'HD116568', 'HD11667', 'HD11683', 'HD116883', 'HD116914', 'HD116941', 'HD11695', 'HD116963', 'HD117105', 'HD117126', 'HD117190', 'HD1171', 'HD117207', 'HD117214', 'HD117359', 'HD11753', 'HD117618', 'HD117865', 'HD117938', 'HD118022', 'HD118072', 'HD118318', 'HD118379', 'HD118466', 'HD118551', 'HD118563', 'HD118598', 'HD118679', 'HD118878', 'HD119027', 'HD119028', 'HD119173', 'HD119288', 'HD119291', 'HD119329', 'HD11938', 'HD119503', 'HD119511', 'HD119537', 'HD119629', 'HD119638', 'HD11964', 'HD119661', 'HD119718', 'HD119772', 'HD119773', 'HD11977', 'HD119782', 'HD119802', 'HD119810', 'HD119949', 'HD119971', 'HD120129', 'HD120250', 'HD120272', 'HD120323', 'HD120326', 'HD120344', 'HD120359', 'HD120362', 'HD12039', 'HD120447', 'HD120491', 'HD12055', 'HD120609', 'HD120635', 'HD120734', 'HD120961', 'HD121004', 'HD121056', 'HD121156', 'HD121176', 'HD121189', 'HD121416', 'HD121504', 'HD121688', 'HD1217', 'HD121804', 'HD121815', 'HD121918', 'HD122173', 'HD122194', 'HD122259', 'HD122308', 'HD122430', 'HD122474', 'HD122476', 'HD122563', 'HD122603', 'HD122640', 'HD12264', 'HD12265', 'HD12270', 'HD122970', 'HD123265', 'HD123319', 'HD12345', 'HD123517', 'HD123615', 'HD123619', 'HD123651', 'HD123732', 'HD123767', 'HD123798', 'HD123836', 'HD12387', 'HD123999', 'HD124244', 'HD12431', 'HD12438', 'HD124469', 'HD124523', 'HD124718', 'HD124729', 'HD12477', 'HD124785', 'HD12484', 'HD124882', 'HD124900', 'HD124931', 'HD125104', 'HD12515', 'HD12524', 'HD125271', 'HD125283', 'HD125337', 'HD125490', 'HD125504', 'HD125522', 'HD125560', 'HD125595', 'HD125612A', 'HD125612B', 'HD125612', 'HD125823', 'HD12583', 'HD125881', 'HD125912', 'HD126035', 'HD126135', 'HD12617', 'HD126238', 'HD126248', 'HD126488', 'HD126515', 'HD126535', 'HD126583', 'HD126661', 'HD126793', 'HD126803', 'HD126829', 'HD126838', 'HD126859', 'HD126999', 'HD127124', 'HD127168', 'HD127423', 'HD12783', 'HD12806', 'HD128113', 'HD128207', 'HD128232', 'HD128340', 'HD128356', 'HD128429', 'HD128431', 'HD128571', 'HD128575', 'HD128582', 'HD128674', 'HD128760', 'HD128833C', 'HD128833', 'HD129078', 'HD129191', 'HD129229', 'HD12932', 'HD129422', 'HD129456', 'HD129590', 'HD129642', 'HD129685', 'HD129704', 'HD129750', 'HD129814', 'HD129829', 'HD129893', 'HD129899', 'HD129926', 'HD129956', 'HD13004', 'HD130109', 'HD13021B', 'HD13021', 'HD130259', 'HD130260', 'HD130287', 'HD130322', 'HD13060', 'HD130650', 'HD130694', 'HD130930', 'HD130952', 'HD130989', 'HD131109', 'HD131183', 'HD131218', 'HD131399', 'HD13147', 'HD131565', 'HD131588', 'HD131653', 'HD131664', 'HD131835', 'HD13183', 'HD132052', 'HD13217', 'HD132238', 'HD132307', 'HD132411', 'HD13252', 'HD132569', 'HD13263', 'HD132648', 'HD132905', 'HD132944', 'HD133112', 'HD133131A', 'HD133131B', 'HD133147', 'HD133469', 'HD13350', 'HD133574', 'HD13357', 'HD133600', 'HD133631', 'HD133633', 'HD133670', 'HD133803', 'HD133813', 'HD133884', 'HD134060', 'HD134088', 'HD134113', 'HD134214', 'HD13423', 'HD134305', 'HD134330', 'HD134353', 'HD134481', 'HD134505', 'HD134606', 'HD134627', 'HD134664', 'HD13468', 'HD134702', 'HD134888', 'HD134928', 'HD134929', 'HD134987', 'HD135104', 'HD13513A', 'HD13513', 'HD1352', 'HD135344', 'HD135382', 'HD135454', 'HD135468', 'HD135559', 'HD135592', 'HD135625', 'HD135758', 'HD135778', 'HD13578', 'HD135953', 'HD136014', 'HD136123', 'HD136246', 'HD136352', 'HD136407', 'HD136482', 'HD1365', 'HD1367', 'HD136894', 'HD136924', 'HD13692', 'HD137010', 'HD137015', 'HD137053', 'HD137057', 'HD13724', 'HD137320', 'HD137388', 'HD13747', 'HD137496', 'HD137518', 'HD13754', 'HD137787', 'HD13789', 'HD137909', 'HD138009B', 'HD13808', 'HD138403', 'HD13846', 'HD138549', 'HD138573', 'HD138716', 'HD13871', 'HD138763', 'HD138799', 'HD138914', 'HD138965', 'HD13904', 'HD139084', 'HD139129', 'HD139189', 'HD139271', 'HD13940', 'HD139461', 'HD139521', 'HD139536', 'HD139590', 'HD139710', 'HD139763', 'HD1397', 'HD139879', 'HD139883', 'HD13997', 'HD139980', 'HD14000', 'HD140129', 'HD140283', 'HD140637', 'HD140785', 'HD1407', 'HD140861', 'HD141011', 'HD141024', 'HD141128', 'HD14119', 'HD14127', 'HD141344', 'HD141513', 'HD141514', 'HD141597', 'HD141598', 'HD141624', 'HD141637', 'HD141851', 'HD141937', 'HD141943', 'HD141969', 'HD142070', 'HD142072', 'HD142113', 'HD142139', 'HD142331', 'HD142446', 'HD142527', 'HD142560', 'HD142629', 'HD142630', 'HD142666', 'HD142879', 'HD142883', 'HD142921', 'HD142A', 'HD142', 'HD143114', 'HD143295', 'HD143309', 'HD143336', 'HD143361', 'HD143436', 'HD143487', 'HD143538', 'HD143546', 'HD143567', 'HD143615', 'HD143638', 'HD143675', 'HD14374', 'HD143754', 'HD143790', 'HD143811', 'HD144006', 'HD144059', 'HD144342', 'HD144377', 'HD144411', 'HD144497', 'HD14452', 'HD144550', 'HD144570', 'HD144585', 'HD144587', 'HD144589', 'HD144608', 'HD144846', 'HD144848', 'HD144880', 'HD144897', 'HD144899', 'HD14499', 'HD145005', 'HD145132', 'HD145148', 'HD145263', 'HD145344', 'HD145377', 'HD145415', 'HD145467', 'HD145468', 'HD145560', 'HD145598', 'HD145666', 'HD145689', 'HD145718', 'HD145788', 'HD145927', 'HD145936', 'HD145972', 'HD145997', 'HD146181', 'HD1461', 'HD146296', 'HD146389', 'HD146464', 'HD146514', 'HD14651', 'HD146546', 'HD146610', 'HD146624', 'HD146690', 'HD1466', 'HD146897', 'HD14691', 'HD14703', 'HD147048', 'HD147135', 'HD147147', 'HD147195', 'HD147220', 'HD147386', 'HD14744', 'HD14745', 'HD14747', 'HD147512', 'HD147513', 'HD147518', 'HD147555', 'HD147642', 'HD147644', 'HD147670', 'HD147722', 'HD147723', 'HD147787', 'HD147873', 'HD147894', 'HD147922', 'HD147935', 'HD148055', 'HD148076', 'HD148153', 'HD148156', 'HD148211', 'HD14830', 'HD148319', 'HD14832', 'HD148427B', 'HD148427', 'HD14851', 'HD148577', 'HD14868', 'HD148816', 'HD148890', 'HD148998', 'HD149143', 'HD149189', 'HD149200', 'HD149277', 'HD149396', 'HD149438', 'HD14943', 'HD149458', 'HD149481', 'HD149499', 'HD149686', 'HD149711', 'HD149724', 'HD149747', 'HD149782', 'HD149790', 'HD1497', 'HD149933', 'HD149946', 'HD150024', 'HD150139', 'HD150177', 'HD150193', 'HD150248', 'HD150343', 'HD150437', 'HD150562', 'HD150589', 'HD150633', 'HD150798', 'HD150936', 'HD15115', 'HD151249', 'HD151282', 'HD151376', 'HD151504', 'HD151665', 'HD151692', 'HD151721', 'HD151772', 'HD151850', 'HD151933', 'HD152079', 'HD15220', 'HD1522', 'HD152334', 'HD152433', 'HD15248', 'HD152533', 'HD152555', 'HD15279', 'HD152980', 'HD153053', 'HD153226', 'HD153232', 'HD153234', 'HD153276', 'HD153363', 'HD15337', 'HD153419', 'HD153851', 'HD15394', 'HD153950', 'HD154088', 'HD154160', 'HD154195', 'HD154221', 'HD154387', 'HD154619', 'HD154672', 'HD15468', 'HD154708', 'HD154801', 'HD154857', 'HD154962', 'HD15507', 'HD155245', 'HD155712', 'HD155717', 'HD155806', 'HD155915', 'HD155968', 'HD156079', 'HD156098', 'HD156111', 'HD15612', 'HD156411', 'HD156423', 'HD156517', 'HD156846', 'HD156854', 'HD156878', 'HD156991', 'HD157040', 'HD157060', 'HD157172', 'HD157244', 'HD157338', 'HD157347', 'HD157527', 'HD157668', 'HD15767', 'HD157751', 'HD15779', 'HD157830', 'HD157950', 'HD157999', 'HD15799', 'HD158148', 'HD158352', 'HD158408', 'HD158469', 'HD158809', 'HD158864', 'HD15906', 'HD159170', 'HD159173', 'HD159194', 'HD159246', 'HD159376', 'HD15942', 'HD159868', 'HD160013', 'HD160089', 'HD16008', 'HD16031', 'HD160613', 'HD160617', 'HD160635', 'HD160720', 'HD160836', 'HD160839', 'HD161098', 'HD16120', 'HD161256', 'HD161265', 'HD16141', 'HD161459', 'HD161555', 'HD161566', 'HD161592', 'HD161660', 'HD161698', 'HD161814', 'HD161852', 'HD161868', 'HD161935', 'HD16193', 'HD162020', 'HD162049', 'HD1620', 'HD162236', 'HD162396', 'HD16241', 'HD16252', 'HD162598', 'HD162757', 'HD162763', 'HD16280', 'HD16297', 'HD163102', 'HD163145', 'HD163254', 'HD163441', 'HD163652', 'HD163675', 'HD16382', 'HD163891', 'HD163963', 'HD16400', 'HD16417', 'HD164233', 'HD164249A', 'HD164257', 'HD16427', 'HD164500', 'HD164509', 'HD164595', 'HD164948', 'HD165131', 'HD165135', 'HD165155', 'HD165204', 'HD16522', 'HD165235', 'HD16536', 'HD165474', 'HD16548', 'HD16555', 'HD165760', 'HD165843', 'HD165920', 'HD166063', 'HD16646', 'HD166473', 'HD166599', 'HD1666', 'HD166724', 'HD166745', 'HD167060', 'HD167096', 'HD16714', 'HD167291', 'HD167300', 'HD167359', 'HD167468', 'HD167554', 'HD16765', 'HD167677', 'HD167858', 'HD16815', 'HD168403', 'HD168432', 'HD168525', 'HD1686', 'HD168746', 'HD168769', 'HD16885', 'HD168863', 'HD168870', 'HD168871', 'HD168960', 'HD168988', 'HD16905', 'HD1690', 'HD169123', 'HD169142', 'HD169178', 'HD169370', 'HD169392A', 'HD169690', 'HD169744', 'HD16975', 'HD169822', 'HD169830', 'HD169836', 'HD170031', 'HD170053', 'HD170174', 'HD170200', 'HD170231', 'HD17025', 'HD170270', 'HD170292', 'HD17039', 'HD170514', 'HD170580', 'HD170699', 'HD170706', 'HD170808', 'HD170958', 'HD171028', 'HD171219', 'HD171238', 'HD171488', 'HD171545', 'HD171587', 'HD171658', 'HD171759', 'HD171834', 'HD171942', 'HD172046', 'HD172103', 'HD172211', 'HD172513', 'HD172555', 'HD172568', 'HD172643', 'HD173282', 'HD173427', 'HD173540', 'HD17374', 'HD173787', 'HD1737', 'HD173819', 'HD17383', 'HD173885', 'HD174153', 'HD174295', 'HD17439', 'HD174429', 'HD174512', 'HD174545', 'HD175100', 'HD175128', 'HD175179', 'HD175219', 'HD175224B', 'HD17548', 'HD175541', 'HD175607', 'HD175639', 'HD175775', 'HD175989', 'HD175990', 'HD17599', 'HD176157', 'HD17617', 'HD176269', 'HD176303', 'HD176354', 'HD176386', 'HD176387', 'HD176535', 'HD176638', 'HD176704', 'HD176864', 'HD176982', 'HD176983', 'HD176986', 'HD177033', 'HD177122', 'HD177178', 'HD177409', 'HD177444', 'HD177474', 'HD177565', 'HD177730', 'HD177756', 'HD177758', 'HD177805', 'HD177847', 'HD177873', 'HD17793', 'HD178085', 'HD17824', 'HD178340', 'HD178479', 'HD178484', 'HD17848', 'HD178787', 'HD178880', 'HD178904', 'HD17906B', 'HD179079', 'HD179210', 'HD179211', 'HD17926', 'HD179346', 'HD179376', 'HD179433', 'HD179799', 'HD179949', 'HD18001', 'HD180134', 'HD180263', 'HD180409', 'HD180474', 'HD180750', 'HD180815', 'HD180839', 'HD18083', 'HD180928', 'HD181012', 'HD181197', 'HD181234', 'HD181249', 'HD181296', 'HD181327', 'HD181387', 'HD181428', 'HD181433', 'HD181517', 'HD181544', 'HD181558', 'HD181720', 'HD181907', 'HD18202', 'HD182556', 'HD182797', 'HD182817', 'HD182893', 'HD18293', 'HD183173', 'HD183216', 'HD18322', 'HD183263', 'HD18330', 'HD18331', 'HD183414', 'HD183579', 'HD183826', 'HD18386', 'HD183877', 'HD183993', 'HD18404', 'HD184317', 'HD184588', 'HD184711', 'HD184768', 'HD185256', 'HD185257', 'HD185283', 'HD185615', 'HD185679', 'HD185967', 'HD18599', 'HD186061', 'HD186194', 'HD186265', 'HD186272', 'HD186302', 'HD18632', 'HD186704', 'HD186803', 'HD186843', 'HD18692', 'HD18702', 'HD187082', 'HD187085', 'HD18708', 'HD187151', 'HD18719', 'HD187273', 'HD18742', 'HD187532', 'HD18754', 'HD187657', 'HD187669', 'HD187760', 'HD18777', 'HD18784', 'HD187861', 'HD1878', 'HD188042', 'HD188091', 'HD18809', 'HD188114', 'HD188228', 'HD18822', 'HD188298', 'HD188321', 'HD188345', 'HD18838', 'HD188394', 'HD188622', 'HD188748', 'HD188815', 'HD18884', 'HD18885', 'HD18894', 'HD189004', 'HD189005', 'HD189242', 'HD18955', 'HD189625', 'HD189627', 'HD189631', 'HD189739', 'HD189760', 'HD18986', 'HD189987', 'HD190056', 'HD190125', 'HD190204', 'HD190290', 'HD190451', 'HD190524', 'HD190590', 'HD190594', 'HD190608', 'HD190613', 'HD190622', 'HD190647', 'HD190751', 'HD190954', 'HD190984', 'HD1909', 'HD191033', 'HD191067', 'HD19107', 'HD191122', 'HD191584', 'HD191662', 'HD191756', 'HD191760B', 'HD191760', 'HD191797', 'HD191847', 'HD191902', 'HD192031', 'HD192117', 'HD192263', 'HD19230', 'HD192343', 'HD192344', 'HD192425', 'HD192509', 'HD192511', 'HD192836', 'HD192865', 'HD192882', 'HD193193', 'HD193334', 'HD193406', 'HD193547', 'HD193690', 'HD193721', 'HD193756', 'HD193826', 'HD193844', 'HD193901', 'HD193995', 'HD194158', 'HD19423', 'HD194274', 'HD194330', 'HD194490', 'HD19463', 'HD194717', 'HD194794', 'HD19493', 'HD194973', 'HD195019', 'HD195034', 'HD195044', 'HD195145', 'HD19518', 'HD195200', 'HD195302', 'HD195330', 'HD19545', 'HD195633', 'HD195961', 'HD196050', 'HD196067', 'HD196068', 'HD196286', 'HD196293', 'HD196378', 'HD196384', 'HD196385', 'HD196390', 'HD196397', 'HD19641', 'HD196470', 'HD19668', 'HD196724', 'HD196755', 'HD196800', 'HD196892', 'HD196982', 'HD197027', 'HD197051', 'HD197083', 'HD19717', 'HD197197', 'HD197210', 'HD197286', 'HD197300', 'HD197305', 'HD19733', 'HD1973', 'HD197481', 'HD197482', 'HD197536', 'HD197557', 'HD197563', 'HD197623', 'HD19773', 'HD197746', 'HD197777', 'HD197818', 'HD197823', 'HD19787', 'HD197890', 'HD197921', 'HD197952', 'HD1979', 'HD198075', 'HD198227', 'HD198232', 'HD19827', 'HD198390', 'HD198431', 'HD198477', 'HD19859', 'HD198748', 'HD198918', 'HD199086', 'HD19916', 'HD19918', 'HD199190', 'HD199254', 'HD199289', 'HD199604', 'HD199665', 'HD199796', 'HD199847', 'HD199868', 'HD199933', 'HD199960', 'HD20003', 'HD200078', 'HD200083', 'HD20010', 'HD200143', 'HD200297', 'HD200349', 'HD20037', 'HD200505', 'HD200538', 'HD200565', 'HD200633', 'HD200761', 'HD200763', 'HD200852', 'HD200869', 'HD200962', 'HD200989', 'HD201161', 'HD201169', 'HD201219', 'HD201247A', 'HD201247B', 'HD201381', 'HD201422', 'HD20143', 'HD201484', 'HD201496', 'HD2014', 'HD201547', 'HD201601A', 'HD201757', 'HD201796A', 'HD201796B', 'HD201852', 'HD201985', 'HD202206', 'HD202389', 'HD202448', 'HD202605', 'HD202746', 'HD202772', 'HD20278', 'HD202819', 'HD202871', 'HD202876', 'HD202917', 'HD202982', 'HD203050', 'HD203335', 'HD203384', 'HD203387', 'HD203413', 'HD203432', 'HD203473', 'HD203621', 'HD203771', 'HD203897', 'HD203932', 'HD204287', 'HD20430', 'HD204313', 'HD204381', 'HD204385', 'HD20439', 'HD204554', 'HD20492', 'HD204941', 'HD204943', 'HD204961', 'HD205289', 'HD205294', 'HD205366', 'HD205471', 'HD205478', 'HD205536', 'HD205591', 'HD20559B', 'HD205674', 'HD205739', 'HD205929', 'HD206116', 'HD206131', 'HD206163', 'HD206172', 'HD20618', 'HD206428', 'HD206429', 'HD206561', 'HD206630', 'HD206642', 'HD206658', 'HD206683', 'HD206837', 'HD206893', 'HD206998', 'HD207038', 'HD207190', 'HD2071', 'HD207496', 'HD207575', 'HD207583', 'HD207699', 'HD207700', 'HD20781', 'HD20782', 'HD207832', 'HD207869', 'HD207889', 'HD20794', 'HD207999', 'HD208000', 'HD208068', 'HD208215', 'HD208233', 'HD208272', 'HD208487', 'HD20852', 'HD208552', 'HD208573', 'HD208672', 'HD20868', 'HD208703', 'HD208704', 'HD208880', 'HD208897', 'HD20894', 'HD208', 'HD209262', 'HD209396', 'HD209449', 'HD209458', 'HD209507', 'HD209566', 'HD209625', 'HD209703', 'HD209779', 'HD209828', 'HD20', 'HD21011', 'HD210139', 'HD210272', 'HD210277', 'HD210320', 'HD210329', 'HD210410', 'HD210507', 'HD210573', 'HD210591', 'HD210614', 'HD210739', 'HD210752', 'HD210763', 'HD210797', 'HD210975', 'HD211087', 'HD211188', 'HD21120', 'HD211317', 'HD21132', 'HD211420', 'HD21145', 'HD21146', 'HD2114', 'HD211532', 'HD211534', 'HD211583', 'HD21161', 'HD211723', 'HD211847', 'HD211970', 'HD211976', 'HD212035', 'HD212036', 'HD21209A', 'HD21209B', 'HD21216', 'HD21220', 'HD212211', 'HD212231', 'HD212291', 'HD212301B', 'HD212307', 'HD21251', 'HD212563', 'HD212571', 'HD212580', 'HD212658', 'HD212708', 'HD212728', 'HD212729', 'HD212918', 'HD212943', 'HD212989', 'HD213240', 'HD213366', 'HD2133', 'HD213410', 'HD2134', 'HD213575', 'HD213637', 'HD213852', 'HD213885', 'HD214090', 'HD214094', 'HD21430', 'HD214383', 'HD214385', 'HD214484', 'HD214853', 'HD214867', 'HD214910', 'HD214953', 'HD214954', 'HD214998', 'HD21520', 'HD215257', 'HD215342', 'HD215355', 'HD215497', 'HD215625', 'HD215641', 'HD215722', 'HD215789', 'HD215864', 'HD215902', 'HD215906', 'HD216008', 'HD2160', 'HD216215', 'HD216435', 'HD216437', 'HD216530', 'HD216627', 'HD216640', 'HD216770', 'HD21693', 'HD217065', 'HD217221', 'HD217343', 'HD217395', 'HD217522', 'HD21759', 'HD217703', 'HD217738', 'HD217739', 'HD217786', 'HD217831', 'HD217897', 'HD217958', 'HD217987', 'HD218249', 'HD218340', 'HD218379', 'HD218396', 'HD218495', 'HD218497', 'HD218504', 'HD218544', 'HD218566', 'HD218614', 'HD218642', 'HD218693', 'HD218750', 'HD21882', 'HD218860', 'HD218885', 'HD218935', 'HD218960', 'HD218994', 'HD219011', 'HD219057', 'HD219077', 'HD219249', 'HD21938', 'HD219449', 'HD219495', 'HD219556', 'HD219666', 'HD219688', 'HD21977', 'HD219781', 'HD219784', 'HD219828', 'HD219869', 'HD220009', 'HD220096', 'HD220308', 'HD220367', 'HD220456', 'HD220476', 'HD22049', 'HD220507', 'HD22054', 'HD220572', 'HD220657', 'HD220689', 'HD220729', 'HD22072', 'HD220740', 'HD220894', 'HD220928', 'HD221146', 'HD221148', 'HD221287', 'HD221416', 'HD221420', 'HD221503', 'HD221550', 'HD221575', 'HD221580', 'HD221609', 'HD221627', 'HD221638', 'HD221760', 'HD22177', 'HD221833', 'HD221950', 'HD221954', 'HD221974', 'HD222095', 'HD222120', 'HD222125', 'HD222259A', 'HD222259', 'HD22231', 'HD222422', 'HD222435', 'HD222480', 'HD22249', 'HD222582', 'HD222595', 'HD222603', 'HD222662', 'HD222669', 'HD222721', 'HD22282', 'HD222910', 'HD222995', 'HD223121', 'HD22315', 'HD223171', 'HD223238', 'HD223272', 'HD223282', 'HD223315', 'HD223340', 'HD223352', 'HD223641', 'HD223681', 'HD223781', 'HD223854', 'HD223889', 'HD22403', 'HD224047', 'HD224063', 'HD22409', 'HD224230', 'HD224286', 'HD224287', 'HD224347', 'HD224383', 'HD224392', 'HD224393', 'HD224432', 'HD224433', 'HD224474', 'HD224538', 'HD224578', 'HD224619', 'HD224638', 'HD224685', 'HD224693', 'HD224789', 'HD2247', 'HD224817', 'HD224828', 'HD224908', 'HD224945', 'HD224959', 'HD224974', 'HD225187', 'HD225194', 'HD225197', 'HD225200', 'HD225297', 'HD22610', 'HD22625', 'HD22663', 'HD22676', 'HD22680', 'HD22694', 'HD22713', 'HD22798', 'HD22897', 'HD22924', 'HD22977', 'HD230017', 'HD23007', 'HD23030', 'HD23079', 'HD23127', 'HD231630', 'HD231701', 'HD23207', 'HD23208', 'HD23290', 'HD23312', 'HD23314', 'HD23319', 'HD23356', 'HD23398', 'HD23456', 'HD23464', 'HD23472', 'HD23526', 'HD23719', 'HD23805', 'HD23901', 'HD23919', 'HD23940', 'HD23952', 'HD23', 'HD24015', 'HD24048', 'HD240534', 'HD240622', 'HD24062', 'HD240648', 'HD24070', 'HD24085', 'HD24098A', 'HD24112', 'HD24160', 'HD24194', 'HD24199', 'HD242780', 'HD24302', 'HD24331B', 'HD24331', 'HD24348', 'HD24357', 'HD244138', 'HD244516', 'HD24465', 'HD2454', 'HD24558', 'HD24633', 'HD24636', 'HD24706', 'HD24712', 'HD24745', 'HD24916', 'HD249474', 'HD24990A', 'HD25061', 'HD25068', 'HD250792', 'HD25102', 'HD25105', 'HD25120', 'HD25153', 'HD25171', 'HD25202', 'HD2529', 'HD25357', 'HD25490', 'HD25535A', 'HD25565', 'HD25570', 'HD25579', 'HD25587', 'HD25632', 'HD25673', 'HD2567', 'HD256', 'HD25704', 'HD25825', 'HD25874', 'HD25912', 'HD259954', 'HD259990', 'HD26015', 'HD26071', 'HD26090', 'HD26257', 'HD26297', 'HD26334', 'HD26345', 'HD2638', 'HD26397', 'HD26413', 'HD26430', 'HD26462', 'HD26464', 'HD26546', 'HD26591', 'HD26609', 'HD26729', 'HD26736', 'HD26737', 'HD26738', 'HD26749', 'HD26756', 'HD26767', 'HD26784', 'HD26864', 'HD26874', 'HD26887', 'HD26911', 'HD26913', 'HD26923', 'HD269434', 'HD26956', 'HD26965', 'HD26967', 'HD2696', 'HD26990', 'HD26995', 'HD26', 'HD27036', 'HD27063', 'HD27130', 'HD27250', 'HD272695', 'HD27282', 'HD27328', 'HD27370', 'HD27371', 'HD27372', 'HD27376', 'HD273832', 'HD27383', 'HD27397', 'HD27406', 'HD274255', 'HD27429', 'HD27442A', 'HD27466', 'HD27471', 'HD27476', 'HD27483', 'HD274873', 'HD27524', 'HD27534', 'HD27536', 'HD27561', 'HD27628', 'HD27631', 'HD27685', 'HD2768', 'HD27697', 'HD27731', 'HD27732', 'HD27771', 'HD27808', 'HD27819', 'HD27837', 'HD27848', 'HD27859', 'HD27867', 'HD27887', 'HD27894', 'HD27901', 'HD27935', 'HD27947', 'HD27989', 'HD27990', 'HD27991', 'HD28013', 'HD28028', 'HD28033', 'HD28068', 'HD28069', 'HD2808', 'HD28093', 'HD28099', 'HD28109', 'HD28185', 'HD28192', 'HD28205', 'HD28226', 'HD28237', 'HD28254A', 'HD28254', 'HD28258', 'HD28291', 'HD28294', 'HD282972', 'HD28305', 'HD28307', 'HD28313', 'HD28338', 'HD28344', 'HD2834', 'HD28355', 'HD283690', 'HD283704', 'HD283869', 'HD28406', 'HD284113', 'HD284163', 'HD28424', 'HD284253', 'HD284310', 'HD284514', 'HD284552', 'HD284574', 'HD28462', 'HD284653', 'HD28483', 'HD284842', 'HD284858', 'HD284908', 'HD284927', 'HD284930', 'HD285181', 'HD285252', 'HD285367', 'HD285465', 'HD28546', 'HD285482', 'HD285507', 'HD285571', 'HD285625', 'HD285663', 'HD28568', 'HD285690', 'HD285720', 'HD285749', 'HD285773', 'HD285816', 'HD285830', 'HD285837', 'HD285876', 'HD285931', 'HD28593', 'HD285968', 'HD285970', 'HD285977', 'HD28608', 'HD286123', 'HD286250', 'HD28635', 'HD286363', 'HD286513', 'HD286554', 'HD286589', 'HD286693', 'HD286734', 'HD286770', 'HD28677', 'HD286789', 'HD286798', 'HD286820', 'HD286850', 'HD286891', 'HD286898', 'HD286900', 'HD286929', 'HD286941', 'HD286996', 'HD28701', 'HD287148', 'HD287201', 'HD287234', 'HD287319', 'HD28736', 'HD28807', 'HD28821', 'HD288313', 'HD28911', 'HD28969', 'HD28991', 'HD28992', 'HD290038', 'HD290327', 'HD290498', 'HD29137', 'HD29139', 'HD29167', 'HD29169', 'HD291763', 'HD291802', 'HD29225', 'HD29239', 'HD29263', 'HD29291', 'HD29303', 'HD29310', 'HD29375', 'HD29376', 'HD29388', 'HD29391', 'HD29399', 'HD29428', 'HD29479', 'HD29488', 'HD29499', 'HD295605', 'HD295707', 'HD29621', 'HD296761', 'HD29737', 'HD297396', 'HD29751', 'HD29789', 'HD29836', 'HD298541', 'HD298542', 'HD29875', 'HD298936', 'HD299043', 'HD29980', 'HD29985', 'HD299896', 'HD3001', 'HD30053', 'HD30119', 'HD30157', 'HD30177', 'HD30185', 'HD30210', 'HD30219', 'HD30246', 'HD30264', 'HD30273', 'HD30278', 'HD30295', 'HD30306', 'HD304043', 'HD30447', 'HD304859', 'HD30485', 'HD304864', 'HD30505', 'HD30508', 'HD30589', 'HD306159', 'HD30669', 'HD306798', 'HD30703', 'HD30738', 'HD3074A', 'HD30787', 'HD307936', 'HD30809', 'HD30810', 'HD30814', 'HD308353', 'HD308357', 'HD30836', 'HD30858', 'HD309701', 'HD309731', 'HD30997', 'HD31026', 'HD31040', 'HD310803', 'HD31103', 'HD31128', 'HD31142', 'HD311505', 'HD31153', 'HD312256', 'HD31225', 'HD312343', 'HD31236', 'HD312417', 'HD3126', 'HD3131', 'HD31414', 'HD31520', 'HD31527', 'HD31527d', 'HD31532', 'HD31609', 'HD31613', 'HD31622', 'HD3167', 'HD31746', 'HD3177', 'HD318015', 'HD318107', 'HD31822', 'HD31845', 'HD31950', 'HD319896', 'HD319', 'HD320345', 'HD321021', 'HD32129', 'HD3220', 'HD3221', 'HD322658', 'HD322660', 'HD32297', 'HD3229', 'HD32324', 'HD32347', 'HD323631', 'HD323684', 'HD324492', 'HD32453', 'HD32462', 'HD32475', 'HD32482', 'HD32515', 'HD325367', 'HD3254', 'HD32564', 'HD326267', 'HD32646', 'HD32662', 'HD32724', 'HD327692', 'HD32793', 'HD32804', 'HD32887', 'HD32969', 'HD32977', 'HD329788', 'HD329868', 'HD329879', 'HD330075', 'HD33081', 'HD33095', 'HD33142', 'HD33252', 'HD33254', 'HD33285', 'HD33313', 'HD33328', 'HD33449', 'HD33473', 'HD33474', 'HD33512', 'HD33555', 'HD33563', 'HD336A', 'HD336B', 'HD336', 'HD3374', 'HD33822', 'HD33904', 'HD34172', 'HD34253', 'HD34266', 'HD34327', 'HD344361', 'HD34449', 'HD344', 'HD34538', 'HD34599', 'HD34642', 'HD34649', 'HD34688', 'HD34745', 'HD34751', 'HD347929', 'HD34816', 'HD3488', 'HD349147', 'HD34987', 'HD35041', 'HD35369', 'HD35411', 'HD35490', 'HD35532', 'HD3556', 'HD35650', 'HD3569', 'HD358155', 'HD35828', 'HD358328', 'HD35850', 'HD358564', 'HD35967', 'HD36051', 'HD36079', 'HD360', 'HD36108', 'HD36152', 'HD36179', 'HD36189', 'HD361', 'HD36215', 'HD36379', 'HD36473', 'HD36481', 'HD3650', 'HD36595', 'HD36597', 'HD36705C', 'HD36705', 'HD36707', 'HD36734', 'HD36846', 'HD36848', 'HD3684', 'HD36869', 'HD36874', 'HD36889', 'HD36958', 'HD3695', 'HD37147', 'HD37160', 'HD37226', 'HD37306', 'HD37351', 'HD37484', 'HD3750', 'HD37513', 'HD37537', 'HD37548', 'HD37561', 'HD37572', 'HD3758', 'HD37620', 'HD37811', 'HD37896', 'HD37962', 'HD37990', 'HD38014', 'HD38078', 'HD3808', 'HD38206', 'HD3821', 'HD38255', 'HD38265', 'HD38277', 'HD38283', 'HD38355', 'HD38382', 'HD38385', 'HD38459', 'HD38467', 'HD38510', 'HD38527', 'HD38529', 'HD38600', 'HD38677', 'HD38772', 'HD38779', 'HD38801', 'HD38823', 'HD38835', 'HD38858', 'HD38871', 'HD38973', 'HD39014', 'HD39091', 'HD3919', 'HD39425', 'HD39427', 'HD39474', 'HD39523', 'HD39640', 'HD3964', 'HD39681', 'HD3968', 'HD39736', 'HD39801', 'HD3980', 'HD39855', 'HD39891', 'HD39945', 'HD40176', 'HD4021', 'HD40293', 'HD40483', 'HD40503', 'HD40512', 'HD40657', 'HD40808', 'HD40907', 'HD41047', 'HD41071', 'HD41076', 'HD41087', 'HD4113', 'HD41172', 'HD41245', 'HD41248', 'HD41255', 'HD41278', 'HD41291', 'HD41323', 'HD41327', 'HD41511', 'HD41695', 'HD41742', 'HD4175', 'HD41761', 'HD41842', 'HD4208', 'HD4211', 'HD42269', 'HD42270', 'HD42354', 'HD42499', 'HD42505', 'HD42538', 'HD42545', 'HD42556', 'HD42581', 'HD42606', 'HD42618', 'HD42659', 'HD42683', 'HD42719', 'HD4271', 'HD42729', 'HD42731', 'HD42813', 'HD42936', 'HD4293', 'HD4308', 'HD4313', 'HD43180', 'HD43197', 'HD4354', 'HD43601', 'HD43629', 'HD43717', 'HD43785', 'HD43834B', 'HD43940', 'HD43947', 'HD43989', 'HD4398', 'HD44219', 'HD44364', 'HD44420', 'HD44447', 'HD44573', 'HD4457', 'HD44594', 'HD44627', 'HD44665', 'HD44748', 'HD44762', 'HD44804', 'HD44821', 'HD45021', 'HD45081', 'HD45133', 'HD45184', 'HD45270', 'HD45289', 'HD45346', 'HD45364', 'HD45398', 'HD45415', 'HD45506', 'HD45512', 'HD4552', 'HD45600', 'HD45610', 'HD45652', 'HD45665', 'HD45669', 'HD457', 'HD45943', 'HD45977', 'HD46089', 'HD46116', 'HD46190', 'HD46202', 'HD46273', 'HD46375A', 'HD46384', 'HD46415', 'HD46487', 'HD4649', 'HD46523', 'HD46568', 'HD46600', 'HD4677', 'HD47001', 'HD47088', 'HD47186', 'HD47282', 'HD47366', 'HD4737', 'HD47536', 'HD4762', 'HD4764', 'HD4785', 'HD47863', 'HD47910', 'HD48115', 'HD48152', 'HD48265', 'HD48381', 'HD4838', 'HD483', 'HD48611', 'HD4875', 'HD48904', 'HD49006', 'HD49035', 'HD49050', 'HD49091', 'HD49105', 'HD4915', 'HD49212', 'HD49334', 'HD49355', 'HD4944', 'HD49773', 'HD49779', 'HD49798', 'HD49855', 'HD49866', 'HD49877', 'HD49933A', 'HD49947', 'HD49983', 'HD50060', 'HD50062', 'HD50078', 'HD50169', 'HD50170', 'HD50304', 'HD50310', 'HD50337', 'HD50445', 'HD50499', 'HD50554', 'HD50590', 'HD50652', 'HD50778', 'HD50896', 'HD51062', 'HD51133', 'HD51266', 'HD51697', 'HD51754', 'HD51797', 'HD52077', 'HD52265', 'HD52298', 'HD52456', 'HD52479', 'HD52483', 'HD5248', 'HD52491', 'HD52516', 'HD52547', 'HD52603', 'HD52613', 'HD52758A', 'HD5278', 'HD52947', 'HD52973', 'HD53116', 'HD53157', 'HD5319', 'HD5349', 'HD53545', 'HD5388', 'HD53936', 'HD53952A', 'HD54038', 'HD5403', 'HD54046', 'HD54100', 'HD54131', 'HD54341', 'HD54351', 'HD54361', 'HD5444', 'HD54521', 'HD5470', 'HD54732', 'HD54810', 'HD55137', 'HD55279', 'HD55524', 'HD55693', 'HD5578', 'HD55958', 'HD56096', 'HD56160', 'HD56259', 'HD5630', 'HD56341', 'HD56351', 'HD56380', 'HD56413', 'HD5643', 'HD564', 'HD56537', 'HD56560', 'HD5659A', 'HD565', 'HD56618', 'HD56662', 'HD56957', 'HD57061', 'HD57150', 'HD57219', 'HD5722', 'HD57240', 'HD57334', 'HD57375', 'HD5737', 'HD57568', 'HD57758', 'HD5785', 'HD58461', 'HD58489', 'HD58676', 'HD58760', 'HD5891', 'HD58972', 'HD59088', 'HD59219', 'HD5938', 'HD59411', 'HD59435', 'HD59659', 'HD59688', 'HD59711A', 'HD59717', 'HD5975', 'HD5976', 'HD59894', 'HD60060', 'HD60162', 'HD60341', 'HD6037', 'HD60435', 'HD60513', 'HD60574', 'HD60584', 'HD60629', 'HD61005', 'HD61051', 'HD6107', 'HD61261', 'HD61273', 'HD61383', 'HD61447', 'HD61475', 'HD61772', 'HD61902', 'HD6192', 'HD61935', 'HD61986', 'HD6204', 'HD62128', 'HD6234', 'HD62364', 'HD62412', 'HD6245', 'HD62509', 'HD62571', 'HD62676', 'HD62679', 'HD62713', 'HD62816', 'HD62847', 'HD62849', 'HD62897', 'HD62902', 'HD62943', 'HD63008B', 'HD63008', 'HD631', 'HD63435', 'HD63436', 'HD63454', 'HD63487', 'HD6348', 'HD63563', 'HD63598', 'HD63608', 'HD63685', 'HD63697', 'HD63738', 'HD63754', 'HD63765', 'HD63786', 'HD63798', 'HD63847', 'HD63948', 'HD64152', 'HD64181', 'HD64225', 'HD6434', 'HD6440B', 'HD64440', 'HD64640', 'HD64815', 'HD6491', 'HD64921', 'HD6493', 'HD64942', 'HD64967', 'HD65114', 'HD6512', 'HD65216', 'HD6532', 'HD65562', 'HD6559', 'HD65638', 'HD65667', 'HD65695', 'HD6569', 'HD65949', 'HD65982', 'HD66030', 'HD66039', 'HD66040', 'HD66051', 'HD66168', 'HD66221', 'HD66255', 'HD66340', 'HD66428', 'HD66488', 'HD66552', 'HD66653', 'HD66664', 'HD66740', 'HD66838', 'HD67093', 'HD6718', 'HD67200', 'HD6735', 'HD67364', 'HD67578', 'HD6790', 'HD6793', 'HD67959', 'HD67977', 'HD67990', 'HD67', 'HD68089', 'HD68161', 'HD68168', 'HD68284', 'HD68287', 'HD68312', 'HD68346', 'HD6838', 'HD68402', 'HD68607', 'HD68694', 'HD68978', 'HD69013', 'HD69076', 'HD69142', 'HD69151', 'HD69247', 'HD69363', 'HD69565', 'HD69611', 'HD69655', 'HD69721', 'HD69789', 'HD69830', 'HD69965', 'HD70038', 'HD70075', 'HD70084', 'HD70509', 'HD70569', 'HD70642', 'HD7082', 'HD70889', 'HD70903', 'HD70937', 'HD70982', 'HD71043', 'HD71155', 'HD71196', 'HD7134', 'HD71374', 'HD71399', 'HD71479', 'HD71685', 'HD71722', 'HD71835', 'HD71863', 'HD71934', 'HD7193', 'HD71966', 'HD7199', 'HD72359', 'HD72374', 'HD72429', 'HD72579', 'HD7257', 'HD72650', 'HD72659', 'HD72660', 'HD72687', 'HD72688', 'HD7279', 'HD7280', 'HD72834', 'HD72892', 'HD72928', 'HD72968', 'HD73121', 'HD73143', 'HD73256', 'HD73262', 'HD73267', 'HD73316', 'HD73468', 'HD73502', 'HD73526', 'HD7355', 'HD73583', 'HD73598', 'HD73665', 'HD73710', 'HD7377', 'HD7382', 'HD73887', 'HD73898', 'HD7399', 'HD74000', 'HD74006', 'HD74014', 'HD74146', 'HD74455', 'HD7449', 'HD74521', 'HD74560', 'HD74591', 'HD74622', 'HD74698', 'HD74873', 'HD74874', 'HD74885', 'HD74957', 'HD7495', 'HD75049', 'HD750', 'HD75112', 'HD7515', 'HD75168', 'HD75171', 'HD75288', 'HD75289', 'HD75302', 'HD75328', 'HD75393', 'HD75413', 'HD75416', 'HD75445', 'HD75469', 'HD75505', 'HD75530', 'HD75605', 'HD75623', 'HD75732', 'HD75745', 'HD75747', 'HD75881', 'HD76188', 'HD76354', 'HD76440', 'HD76582', 'HD7661', 'HD76632', 'HD76700', 'HD7672', 'HD76735', 'HD76766', 'HD76849', 'HD76859', 'HD77058', 'HD77087', 'HD770', 'HD77110', 'HD77191', 'HD77278', 'HD77314', 'HD77338', 'HD77347', 'HD77447', 'HD77462', 'HD77464', 'HD77748', 'HD77825', 'HD78004', 'HD78050', 'HD78130', 'HD78286', 'HD78429', 'HD78534', 'HD78538', 'HD78558', 'HD78632', 'HD78647', 'HD78660', 'HD78668', 'HD78670', 'HD78747', 'HD78883', 'HD78893', 'HD78964', 'HD79091', 'HD79505', 'HD7950', 'HD79601', 'HD79698', 'HD79846', 'HD79917', 'HD80033', 'HD80258', 'HD80316', 'HD80372', 'HD8038', 'HD80447', 'HD80499', 'HD80883', 'HD80886', 'HD80906', 'HD80950', 'HD80951', 'HD81009', 'HD81032', 'HD81101', 'HD81136', 'HD81169', 'HD81212', 'HD81544', 'HD81639', 'HD81700', 'HD81767', 'HD81797', 'HD81918', 'HD81968', 'HD82074', 'HD82101', 'HD82114', 'HD82140', 'HD82165', 'HD82241', 'HD82347', 'HD82350', 'HD82446', 'HD82458', 'HD82514', 'HD82516', 'HD82554', 'HD82610', 'HD82668', 'HD82783', 'HD82895', 'HD8291', 'HD82943', 'HD83368', 'HD83373', 'HD83441', 'HD83443', 'HD83446', 'HD83509', 'HD83529', 'HD83548', 'HD83679', 'HD83683', 'HD83754', 'HD8394', 'HD83953', 'HD84041', 'HD8406', 'HD84075', 'HD84261', 'HD84273', 'HD84295', 'HD84305', 'HD8446', 'HD84608', 'HD84627', 'HD84664', 'HD84687', 'HD84810', 'HD84937', 'HD85119', 'HD8523', 'HD85249', 'HD85250', 'HD8535', 'HD85390', 'HD85444', 'HD85512', 'HD8558', 'HD85672', 'HD85725', 'HD85823', 'HD85859', 'HD8599', 'HD86006', 'HD86021', 'HD86065', 'HD86081', 'HD86087', 'HD86133', 'HD86140', 'HD86171', 'HD86181', 'HD86226', 'HD86247', 'HD8651', 'HD86551', 'HD86652', 'HD86868', 'HD86997', 'HD8705', 'HD87097', 'HD87109', 'HD87130', 'HD87320', 'HD8733', 'HD87479', 'HD87488', 'HD87521', 'HD87526', 'HD87566', 'HD87627', 'HD8763', 'HD87743B', 'HD87810', 'HD87833', 'HD87838', 'HD87896', 'HD88072', 'HD88084', 'HD88133', 'HD8828', 'HD8829', 'HD88323', 'HD88351', 'HD88399', 'HD88474', 'HD8859', 'HD88656', 'HD88836', 'HD88885', 'HD88955', 'HD88981', 'HD89027', 'HD89037', 'HD89124', 'HD8912', 'HD89147', 'HD8930', 'HD89326', 'HD89328', 'HD89345', 'HD89454', 'HD89569', 'HD89577', 'HD89668', 'HD89709', 'HD89749', 'HD89768', 'HD89839', 'HD8985', 'HD89920', 'HD89965', 'HD90028', 'HD90043', 'HD90081', 'HD90125', 'HD90132', 'HD90133', 'HD90156', 'HD90170', 'HD90177', 'HD90197', 'HD90422', 'HD90434', 'HD90494', 'HD90518', 'HD90520', 'HD9054', 'HD90569', 'HD9065', 'HD90702', 'HD90712', 'HD90722', 'HD90774', 'HD90795', 'HD90812', 'HD9081', 'HD90905', 'HD90926', 'HD90936', 'HD90957', 'HD90994', 'HD91121', 'HD91267', 'HD91316', 'HD91345', 'HD91375', 'HD91379', 'HD91386', 'HD91437', 'HD91585', 'HD91682', 'HD9174', 'HD91816', 'HD91988', 'HD92003', 'HD92139', 'HD9218', 'HD92214', 'HD92245', 'HD9246', 'HD92499', 'HD92536', 'HD92547', 'HD92588', 'HD92719', 'HD92788', 'HD9289', 'HD92987', 'HD9312', 'HD93153', 'HD93193', 'HD93257', 'HD93351', 'HD93372', 'HD93385', 'HD93396', 'HD93489', 'HD93491', 'HD93507', 'HD9362', 'HD93745', 'HD93773', 'HD93800', 'HD93813', 'HD93836', 'HD93849', 'HD93932', 'HD94012', 'HD94100', 'HD94126', 'HD94151', 'HD94270', 'HD94386', 'HD94660', 'HD94771', 'HD94838', 'HD94853', 'HD94910', 'HD94964', 'HD95086', 'HD95122', 'HD95136', 'HD95338', 'HD9536', 'HD95406', 'HD95456', 'HD95509', 'HD95521', 'HD95533', 'HD95542', 'HD95671', 'HD95673', 'HD9578', 'HD95799', 'HD95808', 'HD95860', 'HD95879', 'HD95922', 'HD96008', 'HD96064', 'HD9608', 'HD96116', 'HD96118', 'HD9611', 'HD96175', 'HD96273', 'HD96276', 'HD96290', 'HD96407', 'HD96423', 'HD96445', 'HD96494', 'HD96544', 'HD96557', 'HD96568', 'HD965', 'HD96673', 'HD96700', 'HD96723', 'HD9672', 'HD96789', 'HD967', 'HD96808', 'HD96819', 'HD96941', 'HD97037', 'HD97113', 'HD97244', 'HD97312', 'HD97320', 'HD97344', 'HD97401', 'HD9742', 'HD97443', 'HD97507', 'HD97605', 'HD97658', 'HD97783', 'HD9782', 'HD9796', 'HD97998', 'HD98031', 'HD98248', 'HD98280', 'HD98284', 'HD98356', 'HD98430', 'HD98457', 'HD984', 'HD98586', 'HD98621', 'HD98649', 'HD987', 'HD9895', 'HD99167', 'HD9920', 'HD99211', 'HD99322', 'HD99492', 'HD99563', 'HD99623', 'HD9986', 'HIP100869', 'HIP101844', 'HIP101846', 'HIP102025', 'HIP102042', 'HIP102301', 'HIP102329', 'HIP102495', 'HIP10258', 'HIP102964', 'HIP103019', 'HIP103039', 'HIP103150', 'HIP103586', 'HIP103867', 'HIP10395', 'HIP103972', 'HIP104083', 'HIP1044', 'HIP104644', 'HIP104856', 'HIP105368', 'HIP105506', 'HIP106568', 'HIP10689', 'HIP106931', 'HIP107133', 'HIP107345', 'HIP10741', 'HIP107772', 'HIP108020', 'HIP108065', 'HIP108095', 'HIP108216', 'HIP108340', 'HIP108576', 'HIP108930', 'HIP109012', 'HIP109149', 'HIP109368', 'HIP109421', 'HIP109638', 'HIP110258', 'HIP110443', 'HIP110655', 'HIP110692', 'HIP110714', 'HIP111162', 'HIP111978', 'HIP1119', 'HIP112414', 'HIP112703', 'HIP113030', 'HIP113244', 'HIP113596', 'HIP113602', 'HIP113605', 'HIP113850', 'HIP114044', 'HIP114427', 'HIP114954', 'HIP115126', 'HIP115332', 'HIP115344', 'HIP115381', 'HIP11572', 'HIP115861', 'HIP116003', 'HIP116110', 'HIP116317', 'HIP116374', 'HIP116492', 'HIP116939', 'HIP117219', 'HIP11739', 'HIP117865', 'HIP117883', 'HIP117911', 'HIP118040', 'HIP118180', 'HIP11890', 'HIP11989', 'HIP12065', 'HIP12147', 'HIP12961', 'HIP13044', 'HIP13345', 'HIP13600', 'HIP13685', 'HIP13801', 'HIP13806', 'HIP13977', 'HIP14101', 'HIP14313', 'HIP14475', 'HIP14593', 'HIP14792', 'HIP15300', 'HIP15360', 'HIP15368', 'HIP15532', 'HIP15563', 'HIP15587', 'HIP1608', 'HIP16094', 'HIP16377', 'HIP16445', 'HIP16529', 'HIP16536', 'HIP16548', 'HIP16639', 'HIP16896', 'HIP16908', 'HIP16979', 'HIP17044', 'HIP17125', 'HIP17128', 'HIP17157', 'HIP17316', 'HIP17346', 'HIP17365', 'HIP1745', 'HIP17535', 'HIP17605', 'HIP17695', 'HIP17766', 'HIP17956', 'HIP18096', 'HIP18117', 'HIP18544', 'HIP18719', 'HIP18918', 'HIP18946', 'HIP18955', 'HIP19082', 'HIP19410', 'HIP19441', 'HIP19449', 'HIP19684', 'HIP1993', 'HIP20232', 'HIP20240', 'HIP20267', 'HIP20444', 'HIP20605', 'HIP20699', 'HIP21539', 'HIP21934', 'HIP21991', 'HIP22059', 'HIP22424', 'HIP2247', 'HIP22921', 'HIP23309', 'HIP23312', 'HIP23344', 'HIP25578', 'HIP25612', 'HIP25654', 'HIP26013', 'HIP26369', 'HIP26542', 'HIP27134', 'HIP27397', 'HIP27928', 'HIP29788', 'HIP31293', 'HIP31592', 'HIP31609', 'HIP31639', 'HIP31862', 'HIP31878', 'HIP32127', 'HIP32393', 'HIP3249', 'HIP32812', 'HIP33392', 'HIP34285', 'HIP3428', 'HIP35246', 'HIP35305', 'HIP35366', 'HIP3588', 'HIP35937', 'HIP35965', 'HIP36319', 'HIP36338', 'HIP36985', 'HIP3718', 'HIP37217', 'HIP38594', 'HIP39470', 'HIP39611', 'HIP39726', 'HIP40038', 'HIP40459', 'HIP40679', 'HIP40774', 'HIP41113', 'HIP41277', 'HIP41659', 'HIP41662', 'HIP41795', 'HIP42227', 'HIP4266', 'HIP43310', 'HIP43313', 'HIP43363', 'HIP43418', 'HIP4394', 'HIP43973', 'HIP44124', 'HIP44376', 'HIP4468', 'HIP44785', 'HIP44899', 'HIP45301', 'HIP4569', 'HIP45801', 'HIP46634', 'HIP46655', 'HIP46933', 'HIP4699', 'HIP47', 'HIP48477', 'HIP48762', 'HIP48766', 'HIP4877', 'HIP48836', 'HIP48953', 'HIP49067', 'HIP49520', 'HIP50267', 'HIP51073', 'HIP5114', 'HIP51263', 'HIP51344', 'HIP51443', 'HIP51588', 'HIP5158', 'HIP5215', 'HIP52225', 'HIP523', 'HIP52776', 'HIP52954', 'HIP52997', 'HIP53321', 'HIP53383', 'HIP53559', 'HIP53639', 'HIP53691', 'HIP53911', 'HIP54365', 'HIP54373', 'HIP54446', 'HIP54469', 'HIP54597', 'HIP55014', 'HIP55787', 'HIP55789', 'HIP56489', 'HIP56838', 'HIP57688', 'HIP58234', 'HIP58285', 'HIP58289', 'HIP58348', 'HIP59109', 'HIP59341', 'HIP59925', 'HIP59926', 'HIP60718', 'HIP60747', 'HIP60910', 'HIP61406', 'HIP61505', 'HIP61872', 'HIP61976', 'HIP62445', 'HIP62452', 'HIP6276', 'HIP63157', 'HIP63719', 'HIP6431', 'HIP64428', 'HIP65924', 'HIP65956', 'HIP6639', 'HIP66541', 'HIP66678', 'HIP66918', 'HIP67126', 'HIP67164', 'HIP67285', 'HIP68900', 'HIP69224', 'HIP69570', 'HIP69929', 'HIP70317', 'HIP70475', 'HIP7058', 'HIP70681', 'HIP70975', 'HIP71253', 'HIP7228', 'HIP72378', 'HIP72461', 'HIP72779', 'HIP72801', 'HIP73194', 'HIP73427', 'HIP74190', 'HIP74229', 'HIP74261', 'HIP74778', 'HIP75387', 'HIP75426', 'HIP7588', 'HIP7626', 'HIP7646', 'HIP76550', 'HIP76599', 'HIP76668', 'HIP77157', 'HIP77637', 'HIP78242', 'HIP7829', 'HIP78317', 'HIP78345', 'HIP78395', 'HIP78408', 'HIP79431', 'HIP79578', 'HIP80018', 'HIP80083', 'HIP80399', 'HIP80683', 'HIP80817', 'HIP80889', 'HIP80910', 'HIP81018', 'HIP81084', 'HIP8119', 'HIP81385', 'HIP81465', 'HIP8220', 'HIP8224', 'HIP82283', 'HIP82323', 'HIP82357', 'HIP8361', 'HIP84277', 'HIP8438', 'HIP84405', 'HIP85252', 'HIP85360', 'HIP86214', 'HIP86509', 'HIP8691', 'HIP87062', 'HIP87607', 'HIP88064', 'HIP88316', 'HIP88371', 'HIP89285', 'HIP89892', 'HIP90246', 'HIP90261', 'HIP90466', 'HIP91437', 'HIP91862', 'HIP92444', 'HIP92451', 'HIP92592', 'HIP92656', 'HIP93102', 'HIP93287', 'HIP93745', 'HIP9398', 'HIP94227', 'HIP948', 'HIP95903', 'HIP9603', 'HIP96101', 'HIP96240', 'HIP96689', 'HIP9786', 'HIP98105', 'HIP98106', 'HIP98226', 'HIP98470', 'HIP98764', 'HIP99273', 'HIP99332', 'K2-122', 'K2-129', 'K2-132', 'K2-138', 'K2-139', 'K2-140', 'K2-141', 'K2-161', 'K2-165', 'K2-231', 'K2-240', 'K2-261', 'K2-266', 'K2-27', 'K2-287', 'K2-314', 'K2-32', 'K2-55', 'K2-89', 'K2-99', 'TOI-1062', 'TOI-1130', 'TOI-125', 'TOI-1338', 'TOI-209', 'TOI-216', 'TOI-2202', 'TOI-220', 'TOI-2427', 'TOI-269', 'TOI-355', 'TOI-421', 'TOI-431', 'TOI-499', 'TOI-500', 'TOI-570', 'TOI-674', 'TOI-696', 'TOI-700', 'TOI-776', 'TOI-793', 'TOI-823', 'TOI-849', 'TOI-851', 'TOI-905', 'TOI-908', 'TOI125', 'TOI1338', 'TOI145', 'TOI175', 'TOI178', 'TOI193', 'TOI199', 'TOI216', 'TOI269', 'TOI500', 'TOI674', 'TYC1041-563-1', 'TYC11-1042-1', 'TYC111-1915-1', 'TYC1215-974-1', 'TYC1257-132-1', 'TYC1333-449-1', 'TYC1363-1583-1', 'TYC1392-886-1', 'TYC1396-393-1', 'TYC1405-1421-1', 'TYC143-114-1', 'TYC1472-1436-2', 'TYC15-882-1', 'TYC1800-2170-1', 'TYC183-755-1', 'TYC1866-2486-1', 'TYC1866-2564-1', 'TYC19-1157-1', 'TYC1968-371-1', 'TYC2-1155-1', 'TYC20-893-1', 'TYC211-706-1', 'TYC22-1354-1', 'TYC246-1159-1', 'TYC266-718-1', 'TYC281-736-1', 'TYC281-875-1', 'TYC30-116-1', 'TYC304-865-1', 'TYC306-206-1', 'TYC339-329-1', 'TYC45-1252-1', 'TYC459-1288-1', 'TYC4674-364-1', 'TYC4681-662-1', 'TYC4682-800-1', 'TYC4757-1588-2', 'TYC4813-492-1', 'TYC4851-299-1', 'TYC4858-1263-1', 'TYC4858-671-1', 'TYC4873-651-1', 'TYC4874-1474-1', 'TYC4890-625-1', 'TYC4916-897-1', 'TYC4927-1063-1', 'TYC4930-128-1', 'TYC4940-797-1', 'TYC4943-1016-1', 'TYC4946-386-1', 'TYC4947-834-1', 'TYC4948-327-1', 'TYC4951-933-1', 'TYC4954-218-1', 'TYC4956-633-1', 'TYC50-821-1', 'TYC5115-372-1', 'TYC5126-2775-1', 'TYC5138-1707-1', 'TYC514-1233-1', 'TYC5204-993-1', 'TYC5228-989-1', 'TYC5239-1149-1', 'TYC524-2528-1', 'TYC5288-103-1', 'TYC5290-462-1', 'TYC5315-221-1', 'TYC534-2183-1', 'TYC5416-2188-1', 'TYC5434-3430-1', 'TYC5460-236-1', 'TYC552-1060-1', 'TYC5588-987-1', 'TYC5600-377-1', 'TYC5605-1010-1', 'TYC5605-898-1', 'TYC562-421-1', 'TYC5829-1047-1', 'TYC5839-876-1', 'TYC5855-1291-1', 'TYC5871-218-1', 'TYC5876-110-1', 'TYC5876-817-1', 'TYC5881-551-1', 'TYC5889-271-1', 'TYC5889-717-1', 'TYC5940-155-1', 'TYC595-579-1', 'TYC5965-749-1', 'TYC6005-322-1', 'TYC6006-1522-1', 'TYC6010-4683-1', 'TYC6019-1286-1', 'TYC6051-445-1', 'TYC6110-1007-1', 'TYC6121-11-1', 'TYC6125-36-2', 'TYC6170-95-1', 'TYC6190-775-1', 'TYC6193-663-1', 'TYC6206-1374-1', 'TYC6224-870-1', 'TYC6240-759-1', 'TYC6244-604-1', 'TYC6245-297-1', 'TYC6247-420-1', 'TYC6252-455-1', 'TYC6283-1022-1', 'TYC6296-1176-1', 'TYC6296-1341-1', 'TYC6296-1556-1', 'TYC6296-1801-1', 'TYC6296-181-1', 'TYC6296-1857-1', 'TYC6296-303-1', 'TYC6296-478-1', 'TYC6296-483-1', 'TYC6296-654-1', 'TYC6300-257-1', 'TYC6300-98-1', 'TYC6306-1822-1', 'TYC6360-482-1', 'TYC6398-132-1', 'TYC6410-576-1', 'TYC6430-1245-1', 'TYC6456-340-1', 'TYC6468-912-1', 'TYC6470-828-1', 'TYC6484-222-1', 'TYC6484-426-1', 'TYC6504-948-1', 'TYC6511-2186-1', 'TYC6514-1296-1', 'TYC6520-198-1', 'TYC6531-466-1', 'TYC6570-1482-1', 'TYC6570-1766-1', 'TYC6574-3692-1', 'TYC6604-547-1', 'TYC6609-79-1', 'TYC6609-880-1', 'TYC6615-509-1', 'TYC6622-794-1', 'TYC6623-123-1', 'TYC6627-950-1', 'TYC6628-586-1', 'TYC6637-975-1', 'TYC6638-952-1', 'TYC6646-1539-1', 'TYC6647-516-1', 'TYC6716-330-1', 'TYC6761-865-1', 'TYC6764-1356-1', 'TYC6768-1482-1', 'TYC6772-1485-1', 'TYC6780-1523-1', 'TYC6784-837-1', 'TYC6792-670-1', 'TYC6822-2535-1', 'TYC6871-1581-1', 'TYC6874-632-1', 'TYC6887-2075-1', 'TYC6901-2187-1', 'TYC6914-1673-1', 'TYC6960-252-1', 'TYC6988-35-1', 'TYC6988-542-1', 'TYC7022-871-1', 'TYC7041-214-1', 'TYC7047-1324-1', 'TYC7063-637-1', 'TYC7063-698-1', 'TYC7064-737-1', 'TYC7087-2536-1', 'TYC7102-426-1', 'TYC7103-1714-1', 'TYC7104-505-1', 'TYC7115-3021-1', 'TYC7118-2550-1', 'TYC7150-787-1', 'TYC7167-584-1', 'TYC7193-571-1', 'TYC72-1041-1', 'TYC7243-1498-1', 'TYC7262-30-1', 'TYC7282-1298-1', 'TYC7284-224-1', 'TYC7289-493-1', 'TYC7310-1928-1', 'TYC7442-558-1', 'TYC7462-318-1', 'TYC7501-987-1', 'TYC7517-248-1', 'TYC7521-99-1', 'TYC7525-245-1', 'TYC7528-890-1', 'TYC7530-365-1', 'TYC7533-1169-1', 'TYC7550-294-1', 'TYC7588-318-1', 'TYC7632-2311-1', 'TYC7644-2302-1', 'TYC7646-3253-1', 'TYC7646-3290-1', 'TYC7716-1898-1', 'TYC7730-223-1', 'TYC7748-1800-1', 'TYC7748-269-1', 'TYC7752-648-1', 'TYC7763-1020-1', 'TYC7832-1167-1', 'TYC7838-962-2', 'TYC7931-842-1', 'TYC7966-866-1', 'TYC797-248-1', 'TYC7971-207-1', 'TYC7971-310-1', 'TYC7992-310-1', 'TYC8011-1257-1', 'TYC8015-1020-1', 'TYC8015-1177-1', 'TYC8029-1177-1', 'TYC8059-979-1', 'TYC8084-545-1', 'TYC8096-1049-1', 'TYC813-243-1', 'TYC8192-4033-2', 'TYC8224-859-1', 'TYC8229-1623-1', 'TYC8229-2228-1', 'TYC8232-963-1', 'TYC8233-2595-1', 'TYC8233-68-1', 'TYC8252-1071-1', 'TYC8253-306-1', 'TYC8254-1170-1', 'TYC8320-1799-1', 'TYC8320-1904-1', 'TYC8320-960-1', 'TYC836-308-1', 'TYC8378-64-1', 'TYC8444-1168-1', 'TYC8448-76-1', 'TYC8459-487-1', 'TYC8502-1226-1', 'TYC852-1050-1', 'TYC8522-455-1', 'TYC8527-329-1', 'TYC8533-950-1', 'TYC8545-158-1', 'TYC8547-1509-1', 'TYC8602-1360-1', 'TYC8620-1809-1', 'TYC8621-1103-1', 'TYC8633-394-1', 'TYC8647-2057-1', 'TYC8660-1583-1', 'TYC8677-71-1', 'TYC8681-611-1', 'TYC8684-1786-1', 'TYC8687-842-1', 'TYC8688-1180-1', 'TYC8756-2358-1', 'TYC8770-239-1', 'TYC8778-850-1', 'TYC8829-3-1', 'TYC8865-1478-1', 'TYC8870-372-1', 'TYC8907-1291-1', 'TYC8954-1014-1', 'TYC8963-1212-1', 'TYC8963-1429-1', 'TYC8963-1543-1', 'TYC9010-2258-1', 'TYC9034-968-1', 'TYC9055-1987-1', 'TYC9057-870-1', 'TYC9063-510-1', 'TYC9076-1070-1', 'TYC9086-1210-1', 'TYC9111-1423-1', 'TYC9114-1267-1', 'TYC9126-1532-1', 'TYC9129-1092-1', 'TYC9159-378-1', 'TYC9159-80-1', 'TYC9173-77-1', 'TYC9177-541-1', 'TYC9194-705-1', 'TYC9238-485-1', 'TYC9325-163-1', 'TYC9361-870-1', 'TYC9379-1149-1', 'TYC9499-136-1', 'TYC964-1432-1', 'TYC964-160-1', 'TYC964-1658-1', 'WASP-101', 'WASP-105', 'WASP-107', 'WASP-120', 'WASP-121', 'WASP-127', 'WASP-129', 'WASP-130', 'WASP-132', 'WASP-156', 'WASP-157', 'WASP-15', 'WASP-16', 'WASP-17', 'WASP-181', 'WASP-182', 'WASP-190', 'WASP-19', 'WASP-20', 'WASP-22', 'WASP-25', 'WASP-2A', 'WASP-30', 'WASP-31', 'WASP-34', 'WASP-35', 'WASP-36', 'WASP-40', 'WASP-41', 'WASP-42', 'WASP-43', 'WASP-44', 'WASP-45', 'WASP-46', 'WASP-4', 'WASP-52', 'WASP-54', 'WASP-55', 'WASP-61', 'WASP-62', 'WASP-6', 'WASP-76', 'WASP-77A', 'WASP-80', 'WASP-89', 'WASP-8', 'WASP-91', 'WASP-98', 'WASP-99']

data_files_HIRES = ["RVs HIRES + NZP correction",
              "RVs HIRES (original)",
              "s-index","h-index"]

data_files_ind_HIRES = [1,3,5,6]

targets_HIRES = ['0429-01631-1', '0438-00260-1', '0748-01711-1', 'BD+423146', 'BD-103166', 'G097-054', 'G161-29', 'G192-13', 'G195-59', 'G205-028', 'G207-019', 'G244-047', 'G60-06', 'GJ3470', 'GL105B', 'GL107B', 'GL109', 'GL1245B', 'GL2066', 'GL226', 'GL239', 'GL250B', 'GL26', 'GL273', 'GL317', 'GL357', 'GL382', 'GL388', 'GL393', 'GL397', 'GL4063', 'GL406', 'GL408', 'GL412A', 'GL433', 'GL445', 'GL450', 'GL47', 'GL486', 'GL48', 'GL49', 'GL514', 'GL528B', 'GL569A', 'GL625', 'GL667C', 'GL686', 'GL687', 'GL694', 'GL699', 'GL745A', 'GL745B', 'GL793', 'GL803', 'GL806', 'GL83.1', 'GL876', 'GL87', 'GL905', 'GL908', 'GMAUR', 'HD10002', 'HD10008', 'HD10013', 'HD10015', 'HD100180', 'HD100337', 'HD100623', 'HD101206', 'HD101259', 'HD101348', 'HD10145', 'HD101472', 'HD101501', 'HD101675', 'HD101847', 'HD101904', 'HD101959', 'HD102071', 'HD102158', 'HD102195', 'HD102361', 'HD102365', 'HD102444', 'HD102956', 'HD103047', 'HD103095', 'HD103417', 'HD103432', 'HD103459', 'HD103616', 'HD103813', 'HD103828', 'HD103829', 'HD103847', 'HD103890', 'HD103932', 'HD104017', 'HD104067', 'HD104263', 'HD104304', 'HD10436', 'HD104389', 'HD10442', 'HD104437', 'HD104556', 'HD104588', 'HD10476', 'HD104800', 'HD104860', 'HD105113', 'HD105279', 'HD105304', 'HD105618', 'HD105631', 'HD105811', 'HD105', 'HD106088', 'HD106116', 'HD106156', 'HD106279', 'HD106314', 'HD106421', 'HD106949', 'HD10697', 'HD10700', 'HD107087', 'HD107146', 'HD107148', 'HD107211', 'HD10780', 'HD10790', 'HD108189', 'HD108351', 'HD108863', 'HD108874', 'HD108942', 'HD109011', 'HD109159', 'HD109218', 'HD109331', 'HD109358', 'HD109409', 'HD109542', 'HD109718', 'HD109749', 'HD109929', 'HD10995', 'HD110044', 'HD11020', 'HD110315', 'HD110463', 'HD110537', 'HD110743', 'HD110897', 'HD111031', 'HD111153', 'HD11131', 'HD111395', 'HD111431', 'HD111484A', 'HD111484B', 'HD111515', 'HD111563', 'HD111631', 'HD111814', 'HD112019', 'HD112115', 'HD112208', 'HD112257', 'HD112337', 'HD112415', 'HD11271', 'HD112914', 'HD112973', 'HD112988', 'HD113194', 'HD113414', 'HD113490', 'HD113595', 'HD11373', 'HD113983', 'HD114161', 'HD114174', 'HD114375', 'HD11437', 'HD114613', 'HD114659', 'HD114729', 'HD114783', 'HD114946', 'HD11506', 'HD115404A', 'HD115589', 'HD115617', 'HD116029', 'HD116258', 'HD116321', 'HD116442', 'HD116443', 'HD116956', 'HD117122', 'HD117176', 'HD117207', 'HD117434', 'HD117497', 'HD117623', 'HD117936', 'HD11850', 'HD118670', 'HD118744', 'HD118914', 'HD119058', 'HD11964A', 'HD119802', 'HD119850', 'HD120066', 'HD120219', 'HD12039', 'HD120467', 'HD120476A', 'HD12051', 'HD120528', 'HD1205', 'HD120636', 'HD121320', 'HD121550', 'HD121579', 'HD122064', 'HD122120', 'HD122253', 'HD122255', 'HD122303', 'HD12235', 'HD122517', 'HD122652', 'HD122973', 'HD123239', 'HD123265', 'HD1234-00069-1', 'HD12380', 'HD123812', 'HD124102', 'HD124106', 'HD124257A', 'HD124257B', 'HD124292', 'HD124641', 'HD124642', 'HD12484', 'HD125184', 'HD125455', 'HD125607', 'HD125612', 'HD126053', 'HD126203', 'HD126583', 'HD126614', 'HD12661', 'HD126631', 'HD126831', 'HD126990', 'HD126991', 'HD127334', 'HD127374', 'HD127506', 'HD127741', 'HD128095', 'HD128165', 'HD128311', 'HD128428', 'HD12846', 'HD128642', 'HD129010', 'HD12911', 'HD129191', 'HD129333', 'HD1293', 'HD129471', 'HD12974', 'HD129814', 'HD130004', 'HD130048', 'HD130087', 'HD130307', 'HD130322', 'HD13043', 'HD130666', 'HD130672', 'HD130871', 'HD130992', 'HD131117', 'HD131183', 'HD131496', 'HD131509', 'HD132133', 'HD132142', 'HD132173', 'HD132307', 'HD132505', 'HD1326B', 'HD1326', 'HD133125', 'HD133233', 'HD133295', 'HD13345', 'HD13357', 'HD13361', 'HD13382', 'HD134319', 'HD134353', 'HD134439', 'HD134440', 'HD13483', 'HD134987', 'HD13507', 'HD135101A', 'HD1352-01149-1', 'HD135446', 'HD135599', 'HD13579', 'HD13584', 'HD135872', 'HD13612B', 'HD136159', 'HD136274', 'HD136352', 'HD136418', 'HD136442', 'HD136513', 'HD136618', 'HD136713', 'HD136834', 'HD136925', 'HD137368', 'HD13747', 'HD137631', 'HD13773', 'HD137778', 'HD138004', 'HD13836', 'HD138549', 'HD138600', 'HD13871', 'HD138776', 'HD1388', 'HD13931', 'HD139323', 'HD139457', 'HD139477', 'HD139813', 'HD139879', 'HD139907', 'HD13997', 'HD140025', 'HD140538A', 'HD140721', 'HD140913', 'HD141004', 'HD141085', 'HD141272', 'HD141399', 'HD141937', 'HD142091', 'HD14214', 'HD142229', 'HD14223', 'HD142245', 'HD142267', 'HD142626', 'HD142943', 'HD143006', 'HD143174', 'HD143291', 'HD143332', 'HD143761', 'HD14412', 'HD144287', 'HD144363', 'HD144579', 'HD144585', 'HD144872', 'HD144988', 'HD1449', 'HD14519', 'HD145229', 'HD145331', 'HD145428', 'HD145675', 'HD145809', 'HD145934', 'HD145958A', 'HD145958B', 'HD146050', 'HD1461', 'HD146233', 'HD146278', 'HD146362B', 'HD14651', 'HD14655', 'HD146775', 'HD147062', 'HD147231', 'HD147379A', 'HD147379B', 'HD147506', 'HD147750', 'HD147752', 'HD147776', 'HD147887', 'HD148164', 'HD148284', 'HD148319', 'HD148428', 'HD148467', 'HD14855', 'HD149026', 'HD149143', 'HD149661', 'HD149724', 'HD149750', 'HD149760', 'HD1497', 'HD149806', 'HD150122', 'HD1502', 'HD150331', 'HD150433', 'HD150437', 'HD150554', 'HD150698', 'HD150706', 'HD150936', 'HD151288', 'HD151329', 'HD151504', 'HD151522', 'HD151541', 'HD151852', 'HD151877', 'HD151995', 'HD152125', 'HD152391', 'HD152555', 'HD152581', 'HD152733', 'HD152792', 'HD152878', 'HD15335', 'HD153378', 'HD153458', 'HD153525', 'HD153557', 'HD15367', 'HD154088', 'HD154144', 'HD154325', 'HD154345', 'HD154363', 'HD154656', 'HD154697', 'HD154994', 'HD155358', 'HD155415', 'HD155456', 'HD155712', 'HD155817', 'HD155968', 'HD156026', 'HD156079', 'HD156146', 'HD156279', 'HD156342', 'HD156365', 'HD156549', 'HD156668', 'HD156826', 'HD156846', 'HD156985', 'HD157172', 'HD157214', 'HD157299', 'HD157338', 'HD157347', 'HD157881', 'HD158038', 'HD158173', 'HD158449', 'HD158614', 'HD158633', 'HD159062', 'HD159063', 'HD159222', 'HD159868', 'HD1605', 'HD160693', 'HD161198', 'HD161284', 'HD16141', 'HD161424', 'HD161479', 'HD16160', 'HD16175', 'HD161797', 'HD161848', 'HD161897', 'HD162231', 'HD162232', 'HD16275', 'HD16287', 'HD16297', 'HD163153', 'HD163489', 'HD163589', 'HD163607', 'HD16397', 'HD16417', 'HD164330', 'HD164507', 'HD164509', 'HD164595', 'HD164651', 'HD164922', 'HD165109', 'HD165173', 'HD165222', 'HD165341A', 'HD165401', 'HD16559', 'HD165672', 'HD16623', 'HD166620', 'HD1666', 'HD166', 'HD16702', 'HD167215', 'HD167216', 'HD167389', 'HD16760', 'HD167665', 'HD168009', 'HD168443', 'HD168603', 'HD168746', 'HD169830', 'HD169889', 'HD170174', 'HD17037', 'HD170469', 'HD170493', 'HD170512', 'HD170657', 'HD171067', 'HD171238', 'HD17152', 'HD17156', 'HD171665', 'HD17190', 'HD171918', 'HD171999', 'HD172051', 'HD17230', 'HD172310', 'HD172513', 'HD17354', 'HD173701', 'HD173739', 'HD173740', 'HD173818', 'HD17382', 'HD174080', 'HD175425', 'HD175541', 'HD175742', 'HD176377', 'HD176414', 'HD17660', 'HD176733', 'HD176845', 'HD176982', 'HD177033', 'HD1770', 'HD177153', 'HD177274', 'HD177830', 'HD178251', 'HD178911B', 'HD179079', 'HD179306', 'HD179596', 'HD179949', 'HD179957', 'HD179958', 'HD180053', 'HD180161', 'HD180617', 'HD180684', 'HD181234', 'HD181253', 'HD18131', 'HD18143', 'HD182189', 'HD182407', 'HD182488', 'HD182572', 'HD182619', 'HD183162', 'HD183263', 'HD183298', 'HD1832', 'HD183473', 'HD183650', 'HD183658', 'HD183870', 'HD18436A', 'HD18436B', 'HD18445', 'HD185144', 'HD185269', 'HD185295', 'HD185414', 'HD185501', 'HD186104', 'HD18632', 'HD186408', 'HD186427', 'HD186932', 'HD18702', 'HD187123', 'HD187237', 'HD18747', 'HD187897', 'HD187923', 'HD187944', 'HD188015', 'HD18803', 'HD188268', 'HD188298', 'HD188311', 'HD188345', 'HD188376', 'HD188510', 'HD188512', 'HD18907', 'HD18916', 'HD189625', 'HD189627', 'HD189733', 'HD18975', 'HD18993', 'HD190007', 'HD190067', 'HD19019', 'HD190228', 'HD19034', 'HD190360', 'HD190404', 'HD190406', 'HD190412', 'HD190571', 'HD190594', 'HD190821', 'HD190931', 'HD191067', 'HD191089', 'HD191408', 'HD191785', 'HD192020', 'HD192263', 'HD192310', 'HD192343', 'HD192344', 'HD192699', 'HD19308', 'HD193202', 'HD193342', 'HD193690', 'HD19373', 'HD193795', 'HD193901', 'HD194080', 'HD194110', 'HD194541', 'HD19467', 'HD195019B', 'HD195019', 'HD19502', 'HD195034', 'HD19522', 'HD1955-00658-1', 'HD195564', 'HD195787', 'HD195987', 'HD196124', 'HD19617', 'HD19618', 'HD196201', 'HD19632', 'HD19638', 'HD19659', 'HD196676', 'HD19668', 'HD196761', 'HD196850', 'HD197076', 'HD197162', 'HD197623', 'HD19773', 'HD198387', 'HD198425', 'HD198483', 'HD198550', 'HD198599', 'HD198683', 'HD198802', 'HD199019', 'HD199100', 'HD199178', 'HD199255', 'HD199305', 'HD199381', 'HD199476', 'HD199580', 'HD199683', 'HD199960', 'HD200078', 'HD200156', 'HD200538', 'HD200565', 'HD200964', 'HD200968', 'HD201091', 'HD201092', 'HD201203', 'HD201219', 'HD201378', 'HD20155', 'HD201651', 'HD20165', 'HD201924', 'HD201989', 'HD202560', 'HD202575', 'HD2025', 'HD202696', 'HD202751', 'HD202917', 'HD203030', 'HD203471', 'HD203473', 'HD204277', 'HD20439', 'HD204587', 'HD204814', 'HD205163', 'HD205351', 'HD205353', 'HD205739', 'HD205855', 'HD205905', 'HD206116', 'HD20618', 'HD20619', 'HD206374', 'HD206387', 'HD206610', 'HD206658', 'HD20675', 'HD207077', 'HD207485', 'HD207583', 'HD207832', 'HD207839', 'HD207874', 'HD207897', 'HD207992', 'HD207994', 'HD208038', 'HD208202', 'HD208313', 'HD2085', 'HD208801', 'HD208880', 'HD208897', 'HD209203', 'HD209253', 'HD209290', 'HD209340', 'HD209393', 'HD209458', 'HD209599', 'HD209706', 'HD209875', 'HD210011', 'HD210144', 'HD21019A', 'HD210277', 'HD210302', 'HD210312', 'HD210320', 'HD210323', 'HD210373', 'HD210391', 'HD210392', 'HD210702', 'HD211038', 'HD211080', 'HD211681', 'HD211810', 'HD21197', 'HD212291', 'HD212315', 'HD212585', 'HD212733', 'HD212801', 'HD212924', 'HD213042', 'HD213066', 'HD21313', 'HD213329', 'HD21340', 'HD213472', 'HD213519', 'HD213628', 'HD21449', 'HD214683', 'HD214749', 'HD214823', 'HD215032', 'HD215152', 'HD215274', 'HD215500', 'HD215578', 'HD215625', 'HD215704', 'HD216175', 'HD216191', 'HD216259', 'HD216275', 'HD216520', 'HD216722', 'HD216772', 'HD216783', 'HD216803', 'HD216899', 'HD217004', 'HD217014', 'HD217107', 'HD217165', 'HD217357', 'HD21742', 'HD217523', 'HD217591', 'HD21774', 'HD217850', 'HD217877', 'HD217987', 'HD218133', 'HD218168', 'HD218209', 'HD218445', 'HD21847', 'HD218566', 'HD218868', 'HD218935', 'HD219134', 'HD219428', 'HD219538', 'HD219542', 'HD219623', 'HD219770', 'HD219781', 'HD219828', 'HD219834B', 'HD220221', 'HD220339', 'HD22049', 'HD220554', 'HD22072', 'HD220952', 'HD221149', 'HD221354', 'HD221356', 'HD221561', 'HD221822', 'HD221851', 'HD221974', 'HD222038', 'HD222089', 'HD222582', 'HD222697', 'HD22282', 'HD222986', 'HD223238', 'HD223315', 'HD223498', 'HD223691', 'HD223869', 'HD224032', 'HD224040', 'HD224383', 'HD224601', 'HD224619', 'HD224693', 'HD22484', 'HD224983', 'HD225118', 'HD225213', 'HD225261', 'HD22879', 'HD230409', 'HD230999', 'HD231157', 'HD231701', 'HD23249', 'HD232979', 'HD233153', 'HD2331', 'HD23356', 'HD233641', 'HD234314', 'HD23439', 'HD237903', 'HD238069', 'HD238433', 'HD23952', 'HD239960', 'HD24040', 'HD24213', 'HD24238', 'HD24341', 'HD24365', 'HD24451', 'HD24496', 'HD24505', 'HD245409', 'HD24727', 'HD24892', 'HD24916', 'HD249', 'HD25069', 'HD25311', 'HD25329', 'HD25457', 'HD2564', 'HD25665', 'HD25682', 'HD25825', 'HD2589', 'HD25998', 'HD26151', 'HD26161', 'HD26257', 'HD265866', 'HD26633', 'HD26736', 'HD26794', 'HD26965', 'HD26990', 'HD27282', 'HD27496', 'HD27530', 'HD27732', 'HD28005', 'HD28099', 'HD281540', 'HD2816', 'HD28185', 'HD28187', 'HD281934', 'HD28237', 'HD28343', 'HD28388', 'HD283', 'HD285968', 'HD28946', 'HD29419', 'HD29461', 'HD2946', 'HD29528', 'HD29818', 'HD29883', 'HD2992', 'HD30339', 'HD30495', 'HD30649', 'HD30708', 'HD30712', 'HD3074A', 'HD30882', 'HD31018', 'HD31253', 'HD31392', 'HD31412', 'HD3141', 'HD31423', 'HD31451', 'HD31560', 'HD31664', 'HD31675', 'HD31693', 'HD31966', 'HD32147', 'HD32483', 'HD32850', 'HD32923', 'HD32963', 'HD33021', 'HD33142', 'HD33283', 'HD33298', 'HD33334', 'HD33636', 'HD33793', 'HD33822', 'HD3388-01009-1', 'HD3404', 'HD3411-02491-1', 'HD34411', 'HD34445', 'HD34575', 'HD34721', 'HD34745', 'HD34887', 'HD34957', 'HD3545', 'HD355183', 'HD35627', 'HD35850', 'HD35974', 'HD36003', 'HD36130', 'HD36308', 'HD36395', 'HD3651', 'HD3684', 'HD36974', 'HD37006', 'HD37008', 'HD37124', 'HD37213', 'HD37216', 'HD37250', 'HD37394', 'HD37445', 'HD37484', 'HD37605', 'HD3765', 'HD377', 'HD3795', 'HD37962', 'HD37986', 'HD38207', 'HD38230', 'HD38392', 'HD38393', 'HD38467', 'HD38505', 'HD38529', 'HD38801', 'HD38858', 'HD38949', 'HD38A', 'HD38B', 'HD39094', 'HD39715', 'HD39828', 'HD39881', 'HD3995-01436-1', 'HD40397', 'HD40537', 'HD40647', 'HD4075', 'HD40979', 'HD4113', 'HD41484', 'HD41593', 'HD41700', 'HD4203', 'HD4208', 'HD42250', 'HD4256', 'HD42581', 'HD42618', 'HD4307', 'HD4313', 'HD43162', 'HD4356-01014-1', 'HD43691', 'HD43745', 'HD43947', 'HD44420', 'HD44663', 'HD44985', 'HD45067', 'HD45184', 'HD45210', 'HD45350', 'HD45588', 'HD45652', 'HD457', 'HD46090', 'HD46122', 'HD4614B', 'HD4614', 'HD4628', 'HD4635', 'HD46375', 'HD47157', 'HD47186', 'HD4741', 'HD4747', 'HD47562', 'HD47752', 'HD48122', 'HD48345', 'HD4835-00774-1', 'HD48682', 'HD48938', 'HD4915', 'HD49197', 'HD49674', 'HD5015', 'HD50275', 'HD50281', 'HD50499', 'HD50554', 'HD50639', 'HD50692', 'HD50806', 'HD51046', 'HD51219', 'HD51272', 'HD5133', 'HD51419', 'HD51866', 'HD52265', 'HD52456', 'HD52711', 'HD52919', 'HD5319', 'HD531A', 'HD531B', 'HD533', 'HD53532', 'HD53665', 'HD5372', 'HD5470', 'HD55575', 'HD55647', 'HD55696', 'HD56083', 'HD5608', 'HD56122', 'HD56274', 'HD56303', 'HD56957', 'HD57204', 'HD57813', 'HD58727', 'HD5873', 'HD58781', 'HD5946', 'HD60234', 'HD60491', 'HD60737', 'HD61005', 'HD6101', 'HD61606', 'HD61994', 'HD61995', 'HD62613', 'HD63754', 'HD64090', 'HD64324', 'HD64413', 'HD64730', 'HD6512', 'HD65277', 'HD65430', 'HD65486', 'HD65583', 'HD6558', 'HD66171', 'HD66428', 'HD66751', 'HD6697', 'HD6715', 'HD6734', 'HD67458', 'HD67767', 'HD68017', 'HD68165', 'HD68168', 'HD6872A', 'HD6872B', 'HD68978', 'HD68988', 'HD69076', 'HD691', 'HD6963', 'HD69809', 'HD69830', 'HD69960', 'HD70516', 'HD71334', 'HD71479', 'HD71881', 'HD72003', 'HD72429', 'HD72440', 'HD72490', 'HD72659', 'HD72673', 'HD72905', 'HD73226', 'HD73256', 'HD73534', 'HD73667', 'HD74156', 'HD74390', 'HD745', 'HD74669', 'HD7510', 'HD75393', 'HD75407', 'HD75732B', 'HD75732', 'HD75784', 'HD75898', 'HD76218', 'HD76445', 'HD76909', 'HD77172', 'HD7727', 'HD77818', 'HD78255', 'HD79210', 'HD79211', 'HD7924', 'HD79498', 'HD79555', 'HD80355', 'HD80367', 'HD8038', 'HD804', 'HD80606', 'HD80811', 'HD8250', 'HD82886', 'HD82943', 'HD83024', 'HD8328', 'HD83394', 'HD83443', 'HD834', 'HD8375', 'HD8389', 'HD84035', 'HD84117', 'HD84453', 'HD8446', 'HD8467', 'HD84737', 'HD85301', 'HD85440', 'HD85472', 'HD85512', 'HD8553', 'HD85689', 'HD85725', 'HD8574', 'HD8594', 'HD86081', 'HD8648', 'HD86728', 'HD87001', 'HD87230', 'HD87359', 'HD87424', 'HD8765', 'HD87669', 'HD87836', 'HD87883', 'HD88072', 'HD88133', 'HD88218', 'HD88230', 'HD8828', 'HD88371', 'HD88654', 'HD88656', 'HD88725', 'HD88986', 'HD8907', 'HD8912', 'HD89269', 'HD89391', 'HD8939', 'HD8956', 'HD89793', 'HD90043', 'HD90054', 'HD90125', 'HD90156', 'HD9070', 'HD90711', 'HD90722', 'HD90792', 'HD9081', 'HD90875', 'HD90905', 'HD9113', 'HD91204', 'HD91876', 'HD9218', 'HD92222A', 'HD92222B', 'HD92266', 'HD92719', 'HD92788', 'HD9280', 'HD92855', 'HD92945', 'HD9331', 'HD93396', 'HD93461', 'HD93745', 'HD93864', 'HD9407', 'HD94151', 'HD94178', 'HD9446', 'HD9472', 'HD94834', 'HD95088', 'HD95089', 'HD95128', 'HD95188', 'HD9518A', 'HD9540A', 'HD95526', 'HD95622', 'HD9562', 'HD95650', 'HD95735', 'HD95900', 'HD96167', 'HD96361', 'HD96529', 'HD96612', 'HD96683', 'HD96700', 'HD96937', 'HD97101B', 'HD97101', 'HD97343', 'HD97601', 'HD97658', 'HD97854', 'HD98219', 'HD98281', 'HD98553', 'HD98618', 'HD98630', 'HD98736', 'HD98744', 'HD99109', 'HD99491', 'HD99492', 'HD99706', 'HD9986', 'HD99934', 'HIP10072', 'HIP101262', 'HIP102870', 'HIP103039', 'HIP103256', 'HIP103269', 'HIP10337', 'HIP103650', 'HIP104092', 'HIP10416', 'HIP104432', 'HIP10449', 'HIP105341', 'HIP1055', 'HIP105904', 'HIP106924', 'HIP1078', 'HIP108056', 'HIP108940', 'HIP109388', 'HIP109555', 'HIP109980', 'HIP11000', 'HIP110245', 'HIP11048', 'HIP110655', 'HIP110750', 'HIP110774', 'HIP111854', 'HIP112460', 'HIP112496', 'HIP112918', 'HIP113026', 'HIP113207', 'HIP113409', 'HIP114156', 'HIP114411', 'HIP114914', 'HIP115004', 'HIP115332', 'HIP115562', 'HIP116215', 'HIP116838', 'HIP117197', 'HIP117492', 'HIP117559', 'HIP117886', 'HIP117946', 'HIP117972', 'HIP118261', 'HIP118310', 'HIP12493', 'HIP12709', 'HIP12929', 'HIP1294', 'HIP13258', 'HIP13342', 'HIP13375', 'HIP13398', 'HIP13460', 'HIP1368', 'HIP1386', 'HIP14113', 'HIP14729', 'HIP14810', 'HIP15095', 'HIP15312', 'HIP1532', 'HIP15366', 'HIP15563', 'HIP15673', 'HIP15904', 'HIP16134', 'HIP16404', 'HIP17346', 'HIP1734', 'HIP17496', 'HIP18774', 'HIP19165', 'HIP19981', 'HIP20218', 'HIP20359', 'HIP21276', 'HIP21556', 'HIP22288', 'HIP2247', 'HIP22627', 'HIP22762', 'HIP22907', 'HIP23512', 'HIP23516', 'HIP24121', 'HIP24284', 'HIP25220', 'HIP26196', 'HIP26857', 'HIP29052', 'HIP29067', 'HIP29548', 'HIP30112', 'HIP30979', 'HIP3125', 'HIP3143', 'HIP32769', 'HIP32892', 'HIP32919', 'HIP33241', 'HIP33955', 'HIP3418', 'HIP35093', 'HIP36338', 'HIP36551', 'HIP36635', 'HIP36834', 'HIP37217', 'HIP37766', 'HIP37798', 'HIP38939', 'HIP38969', 'HIP3998', 'HIP40375', 'HIP40910', 'HIP41130', 'HIP41443', 'HIP41689', 'HIP42220', 'HIP42491', 'HIP428', 'HIP43534', 'HIP4353', 'HIP4454', 'HIP45042', 'HIP45839', 'HIP46199', 'HIP46343', 'HIP46417', 'HIP46655', 'HIP46769', 'HIP47098', 'HIP47201', 'HIP47513', 'HIP47650', 'HIP48139', 'HIP48411', 'HIP4845', 'HIP48714', 'HIP48740', 'HIP48855', 'HIP49091', 'HIP49197', 'HIP5004', 'HIP50341', 'HIP50960', 'HIP51007', 'HIP51443', 'HIP5215', 'HIP5247', 'HIP52942A', 'HIP53020', 'HIP53327', 'HIP53541', 'HIP54459', 'HIP54498', 'HIP54532', 'HIP54651', 'HIP54810', 'HIP55360', 'HIP55507', 'HIP55915', 'HIP5643', 'HIP56630', 'HIP5663', 'HIP57050', 'HIP57058', 'HIP57087', 'HIP57274', 'HIP5741', 'HIP57450', 'HIP57493', 'HIP57548', 'HIP5938', 'HIP59406B', 'HIP59406', 'HIP59496', 'HIP59748', 'HIP60093', 'HIP60357', 'HIP60559', 'HIP60633', 'HIP61205', 'HIP61706', 'HIP62406', 'HIP6276', 'HIP62794', 'HIP62847', 'HIP63257', 'HIP6339', 'HIP6344', 'HIP63510', 'HIP63759', 'HIP63762', 'HIP63894', 'HIP64048', 'HIP64262', 'HIP65016', 'HIP66074', 'HIP66193', 'HIP66222', 'HIP66283', 'HIP66459', 'HIP66840', 'HIP67164', 'HIP67691', 'HIP67842', 'HIP70865', 'HIP70975', 'HIP71253', 'HIP71898', 'HIP73427', 'HIP74346', 'HIP74981', 'HIP74995', 'HIP75672', 'HIP77908', 'HIP78184', 'HIP7830', 'HIP78423', 'HIP78999', 'HIP79308', 'HIP79431', 'HIP79698', 'HIP80096', 'HIP80295', 'HIP8051', 'HIP8070', 'HIP80824', 'HIP83043', 'HIP8361', 'HIP83762', 'HIP84099', 'HIP84790', 'HIP85582', 'HIP85977', 'HIP86961', 'HIP87062', 'HIP87123', 'HIP87464', 'HIP87579', 'HIP87803', 'HIP89087', 'HIP89215', 'HIP90376', 'HIP91605', 'HIP91699', 'HIP92403', 'HIP92922', 'HIP93119', 'HIP93703', 'HIP93871', 'HIP94931', 'HIP96561', 'HIP97051', 'HIP9788', 'HIP98381', 'HIP99205', 'HIP99332', 'HIP99385', 'HTR125-001', 'HTR127-008', 'HTR133-004', 'HTR136-001', 'HTR145-001', 'HTR145-002', 'HTR152-001', 'HTR152-004', 'HTR153-004', 'HTR154-011', 'HTR155-001', 'HTR161-003', 'HTR161-009', 'HTR169-024', 'HTR170-004', 'HTR176-002', 'HTR182-001', 'HTR185-002', 'HTR188-002', 'HTR191-001', 'HTR194-006', 'HTR195-003', 'HTR196-004', 'HTR198-002', 'HTR204-007', 'HTR204-010', 'HTR204-011', 'HTR204-014', 'HTR205-024', 'HTR205-22', 'HTR205-23', 'HTR213-001', 'HTR239-001', 'HTR239-004', 'HTR248-002', 'LHS462', 'RXJ0348.9', 'RXJ0434.3', 'S101438B', 'S11844', 'S122446', 'S130811', 'S92823', 'T-CYG0-04140', 'T-LAC0-01033', 'T-LAC0-14888', 'T-ORI0-01816', 'T-ORI0-02163', 'T-PER2-04344', 'TRES1', 'TRES2', 'TRES3', 'TRES4', 'V383LAC', 'VULCAN8842', 'WASP-1', 'WASP14', 'WASP234318', 'XO-2']


 
