from typing import Optional
import enum
import errno
import os
import site
import sys
import numpy

class BaseError(RuntimeError):...

class TrimFailureError(BaseError):...

class GeographicError(BaseError):...

def get_default_root_dir() -> str: ...

def _append_xml(name: str) -> str: ...

class FGPropagate:
    def __bool__(self) -> bool: ...
    def get_Tl2b(self) -> numpy.ndarray: ...
    def get_Tec2b(self) -> numpy.ndarray: ...
    def get_uvw(self) -> numpy.ndarray: ...

class Attribute(enum.Enum):...

class FGPropertyNode:
    def __bool__(self) -> bool: ...
    def __str__(self) -> str: ...
    def __eq__(self, other: FGPropertyNode) -> bool: ...
    def get_name(self) -> str: ...
    def get_fully_qualified_name(self) -> str: ...
    def get_node(self, path: str, create: bool = False) -> Optional[SGPropertyNode]: ...
    def get_double_value(self) -> float: ...
    def set_double_value(self, value: float) -> bool: ...
    def get_attribute(self, attr: Attribute) -> bool: ...
    def set_attribute(self, attr: Attribute, state: bool) -> None: ...

class FGPropertyManager:
    def get_node(self, path: Optional[str] = None, create: bool = False) -> Optional[SGPropertyNode]: ...
    def hasNode(self, path: str) -> bool: ...

class FGGroundReactions:
    def __bool__(self) -> bool: ...
    def get_gear_unit(self, gear: int) -> FGLGear: ...
    def get_num_gear_units(self) -> int: ...

class FGLGear:
    def __bool__(self) -> bool: ...
    def get_steer_norm(self) -> float: ...
    def get_body_x_force(self) -> float: ...
    def get_body_y_force(self) -> float: ...
    def get_body_z_force(self) -> float: ...
    def get_location(self) -> numpy.ndarray: ...
    def get_acting_location(self) -> numpy.ndarray: ...

class FGAuxiliary:
    def __bool__(self) -> bool: ...
    def get_Tw2b(self) -> numpy.ndarray: ...
    def get_Tb2w(self) -> numpy.ndarray: ...

class FGAerodynamics:
    def __bool__(self) -> bool: ...
    def get_moments_MRC(self) -> numpy.ndarray: ...
    def get_forces(self) -> numpy.ndarray: ...

class FGAircraft:
    def __bool__(self) -> bool: ...
    def get_aircraft_name(self) -> str: ...
    def get_xyz_rp(self) -> numpy.ndarray: ...

class eTemperature(enum.Enum):...

class ePressure(enum.Enum):...

class FGAtmosphere:
    def __bool__(self) -> bool: ...
    def set_temperature(self, t: float, h: float, unit: eTemperature) -> None: ...
    def get_temperature(self, h: float) -> float: ...
    def set_pressure_SL(self, unit: ePressure, p: float) -> None: ...

class FGMassBalance:
    def __bool__(self) -> bool: ...
    def get_xyz_cg(self) -> numpy.ndarray: ...
    def get_J(self) -> numpy.ndarray: ...
    def get_Jinv(self) -> numpy.ndarray: ...

class FGJSBBase:
    @property
    def debug_lvl(self) -> None: ...
    @debug_lvl.setter
    def debug_lvl(self, dbglvl: int) -> None: ...
    def get_version(self) -> str: ...
    def disable_highlighting(self) -> None: ...

class FGPropulsion:
    def __bool__(self) -> bool: ...
    def init_running(self, n: int) -> None: ...
    def get_num_engines(self) -> int: ...
    def get_engine(self, idx: int) -> FGEngine: ...
    def get_steady_state(self) -> bool: ...

class FGEngine:
    def __bool__(self) -> bool: ...
    def init_running(self) -> int: ...

class FGLinearization:
    def __bool__(self) -> bool: ...
    def write_scicoslab(self, path: str) -> None: ...
    @property
    def x0(self) -> numpy.ndarray: ...
    @property
    def u0(self) -> numpy.ndarray: ...
    @property
    def y0(self) -> numpy.ndarray: ...
    @property
    def system_matrix(self) -> numpy.ndarray: ...
    @property
    def input_matrix(self) -> numpy.ndarray: ...
    @property
    def output_matrix(self) -> numpy.ndarray: ...
    @property
    def feedforward_matrix(self) -> numpy.ndarray: ...
    @property
    def state_space(self) -> tuple[numpy.ndarray]: ...
    @property
    def x_names(self) -> tuple[str]: ...
    @property
    def u_names(self) -> tuple[str]: ...
    @property
    def y_names(self) -> tuple[str]: ...
    @property
    def x_units(self) -> tuple[str]: ...
    @property
    def u_units(self) -> tuple[str]: ...
    @property
    def y_units(self) -> tuple[str]: ...

class FGFDMExec(FGJSBBase):
    def __repr__(self) -> str: ...
    def __getitem__(self, key: str) -> float: ...
    def __setitem__(self, key: str, value: float) -> None: ...
    def run(self) -> bool: ...
    def run_ic(self) -> bool: ...
    def load_model(self, model: str, add_model_to_path: bool = True) -> bool: ...
    def load_model_with_paths(self, model: str, aircraft_path: str, engine_path: str, systems_path: str, add_model_to_path: bool = True) -> bool: ...
    def load_script(self, script: str, delta_t: float = 0.0, initfile: str = "") -> bool: ...
    def load_planet(self, planet_path: str, useAircraftPath: bool) -> bool: ...
    def set_engine_path(self, path: str) -> bool: ...
    def set_aircraft_path(self, path: str) -> bool: ...
    def set_systems_path(self, path: str) -> bool: ...
    def set_output_path(self, path: str) -> bool: ...
    def set_root_dir(self, path: str) -> None: ...
    def get_engine_path(self) -> str: ...
    def get_aircraft_path(self) -> str: ...
    def get_systems_path(self) -> str: ...
    def get_output_path(self) -> str: ...
    def get_full_aircraft_path(self) -> str: ...
    def get_root_dir(self) -> str: ...
    def get_property_value(self, name: str) -> float: ...
    def set_property_value(self, name: str, value: float) -> None: ...
    def get_model_name(self) -> str: ...
    def set_output_directive(self, fname: str) -> bool: ...
    def set_logging_rate(self, rate: float) -> None: ...
    def set_output_filename(self, n: int, fname: str) -> bool: ...
    def get_output_filename(self, n: int) -> str: ...
    def do_trim(self, mode: int) -> None: ...
    def disable_output(self) -> None: ...
    def enable_output(self) -> None: ...
    def hold(self) -> None: ...
    def enable_increment_then_hold(self, time_steps: int) -> None: ...
    def check_incremental_hold(self) -> None: ...
    def resume(self) -> None: ...
    def holding(self) -> bool: ...
    def reset_to_initial_conditions(self, mode: int) -> None: ...
    def set_debug_level(self, level: int) -> None: ...
    def query_property_catalog(self, check: str) -> str: ...
    def get_property_catalog(self) -> list[str]: ...
    def print_property_catalog(self) -> None: ...
    def print_simulation_configuration(self) -> None: ...
    def set_trim_status(self, status: bool) -> None: ...
    def get_trim_status(self) -> bool: ...
    def get_propulsion_tank_report(self) -> str: ...
    def get_sim_time(self) -> float: ...
    def get_delta_t(self) -> float: ...
    def suspend_integration(self) -> None: ...
    def resume_integration(self) -> None: ...
    def integration_suspended(self) -> bool: ...
    def set_sim_time(self, time: float) -> bool: ...
    def set_dt(self, dt: float) -> None: ...
    def incr_time(self) -> float: ...
    def get_debug_level(self) -> int: ...
    def load_ic(self, rstfile: str, useAircraftPath: bool) -> bool: ...
    def get_propagate(self) -> FGPropagate: ...
    def get_property_manager(self) -> FGPropertyManager: ...
    def get_ground_reactions(self) -> FGGroundReactions: ...
    def get_auxiliary(self) -> FGAuxiliary: ...
    def get_aerodynamics(self) -> FGAerodynamics: ...
    def get_aircraft(self) -> FGAircraft: ...
    def get_mass_balance(self) -> FGMassBalance: ...
    def get_atmosphere(self) -> FGAtmosphere: ...
    def get_propulsion(self) -> FGPropulsion: ...
