"""Feature map for the kaggle competition 'costa rican household poverty'."""

from collections import OrderedDict

from ...data_types import FeatureType


def get_feature_map():
    return OrderedDict([
        ("v2a1", FeatureType.CONTINUOUS),
        ("hacdor", FeatureType.CATEGORICAL),
        ("rooms", FeatureType.CONTINUOUS),
        ("hacapo", FeatureType.CATEGORICAL),
        ("v14a", FeatureType.CATEGORICAL),
        ("refrig", FeatureType.CATEGORICAL),
        ("v18q", FeatureType.CATEGORICAL),
        ("v18q1", FeatureType.CONTINUOUS),
        ("r4h1", FeatureType.CONTINUOUS),
        ("r4h2", FeatureType.CONTINUOUS),
        ("r4h3", FeatureType.CONTINUOUS),
        ("r4m1", FeatureType.CONTINUOUS),
        ("r4m2", FeatureType.CONTINUOUS),
        ("r4m3", FeatureType.CONTINUOUS),
        ("r4t1", FeatureType.CONTINUOUS),
        ("r4t2", FeatureType.CONTINUOUS),
        ("r4t3", FeatureType.CONTINUOUS),
        ("tamhog", FeatureType.CONTINUOUS),
        ("tamviv", FeatureType.CONTINUOUS),
        ("escolari", FeatureType.CONTINUOUS),
        ("rez_esc", FeatureType.CONTINUOUS),
        ("hhsize", FeatureType.CONTINUOUS),
        ("paredblolad", FeatureType.CATEGORICAL),
        ("paredzocalo", FeatureType.CATEGORICAL),
        ("paredpreb", FeatureType.CATEGORICAL),
        ("pareddes", FeatureType.CATEGORICAL),
        ("paredmad", FeatureType.CATEGORICAL),
        ("paredzinc", FeatureType.CATEGORICAL),
        ("paredfibras", FeatureType.CATEGORICAL),
        ("paredother", FeatureType.CATEGORICAL),
        ("pisomoscer", FeatureType.CATEGORICAL),
        ("pisocemento", FeatureType.CATEGORICAL),
        ("pisoother", FeatureType.CATEGORICAL),
        ("pisonatur", FeatureType.CATEGORICAL),
        ("pisonotiene", FeatureType.CATEGORICAL),
        ("pisomadera", FeatureType.CATEGORICAL),
        ("techozinc", FeatureType.CATEGORICAL),
        ("techoentrepiso", FeatureType.CATEGORICAL),
        ("techocane", FeatureType.CATEGORICAL),
        ("techootro", FeatureType.CATEGORICAL),
        ("cielorazo", FeatureType.CATEGORICAL),
        ("abastaguadentro", FeatureType.CATEGORICAL),
        ("abastaguafuera", FeatureType.CATEGORICAL),
        ("abastaguano", FeatureType.CATEGORICAL),
        ("public", FeatureType.CATEGORICAL),
        ("planpri", FeatureType.CATEGORICAL),
        ("noelec", FeatureType.CATEGORICAL),
        ("coopele", FeatureType.CATEGORICAL),
        ("sanitario1", FeatureType.CATEGORICAL),
        ("sanitario2", FeatureType.CATEGORICAL),
        ("sanitario3", FeatureType.CATEGORICAL),
        ("sanitario5", FeatureType.CATEGORICAL),
        ("sanitario6", FeatureType.CATEGORICAL),
        ("energcocinar1", FeatureType.CATEGORICAL),
        ("energcocinar2", FeatureType.CATEGORICAL),
        ("energcocinar3", FeatureType.CATEGORICAL),
        ("energcocinar4", FeatureType.CATEGORICAL),
        ("elimbasu1", FeatureType.CATEGORICAL),
        ("elimbasu2", FeatureType.CATEGORICAL),
        ("elimbasu3", FeatureType.CATEGORICAL),
        ("elimbasu4", FeatureType.CATEGORICAL),
        ("elimbasu5", FeatureType.CATEGORICAL),
        ("elimbasu6", FeatureType.CATEGORICAL),
        ("epared1", FeatureType.CATEGORICAL),
        ("epared2", FeatureType.CATEGORICAL),
        ("epared3", FeatureType.CATEGORICAL),
        ("etecho1", FeatureType.CATEGORICAL),
        ("etecho2", FeatureType.CATEGORICAL),
        ("etecho3", FeatureType.CATEGORICAL),
        ("eviv1", FeatureType.CATEGORICAL),
        ("eviv2", FeatureType.CATEGORICAL),
        ("eviv3", FeatureType.CATEGORICAL),
        ("dis", FeatureType.CATEGORICAL),
        ("male", FeatureType.CATEGORICAL),
        ("female", FeatureType.CATEGORICAL),
        ("estadocivil1", FeatureType.CATEGORICAL),
        ("estadocivil2", FeatureType.CATEGORICAL),
        ("estadocivil3", FeatureType.CATEGORICAL),
        ("estadocivil4", FeatureType.CATEGORICAL),
        ("estadocivil5", FeatureType.CATEGORICAL),
        ("estadocivil6", FeatureType.CATEGORICAL),
        ("estadocivil7", FeatureType.CATEGORICAL),
        ("parentesco1", FeatureType.CATEGORICAL),
        ("parentesco2", FeatureType.CATEGORICAL),
        ("parentesco3", FeatureType.CATEGORICAL),
        ("parentesco4", FeatureType.CATEGORICAL),
        ("parentesco5", FeatureType.CATEGORICAL),
        ("parentesco6", FeatureType.CATEGORICAL),
        ("parentesco7", FeatureType.CATEGORICAL),
        ("parentesco8", FeatureType.CATEGORICAL),
        ("parentesco9", FeatureType.CATEGORICAL),
        ("parentesco10", FeatureType.CATEGORICAL),
        ("parentesco11", FeatureType.CATEGORICAL),
        ("parentesco12", FeatureType.CATEGORICAL),
        ("idhogar", FeatureType.CATEGORICAL),
        ("hogar_nin", FeatureType.CATEGORICAL),
        ("hogar_adul", FeatureType.CATEGORICAL),
        ("hogar_mayor", FeatureType.CATEGORICAL),
        ("hogar_total", FeatureType.CATEGORICAL),
        ("dependency", FeatureType.CONTINUOUS),
        ("edjefe", FeatureType.CONTINUOUS),
        ("edjefa", FeatureType.CONTINUOUS),
        ("meaneduc", FeatureType.CONTINUOUS),
        ("instlevel1", FeatureType.CATEGORICAL),
        ("instlevel2", FeatureType.CATEGORICAL),
        ("instlevel3", FeatureType.CATEGORICAL),
        ("instlevel4", FeatureType.CATEGORICAL),
        ("instlevel5", FeatureType.CATEGORICAL),
        ("instlevel6", FeatureType.CATEGORICAL),
        ("instlevel7", FeatureType.CATEGORICAL),
        ("instlevel8", FeatureType.CATEGORICAL),
        ("instlevel9", FeatureType.CATEGORICAL),
        ("bedrooms", FeatureType.CATEGORICAL),
        ("overcrowding", FeatureType.CATEGORICAL),
        ("tipovivi1", FeatureType.CATEGORICAL),
        ("tipovivi2", FeatureType.CATEGORICAL),
        ("tipovivi3", FeatureType.CATEGORICAL),
        ("tipovivi4", FeatureType.CATEGORICAL),
        ("tipovivi5", FeatureType.CATEGORICAL),
        ("computer", FeatureType.CATEGORICAL),
        ("television", FeatureType.CATEGORICAL),
        ("mobilephone", FeatureType.CATEGORICAL),
        ("qmobilephone", FeatureType.CONTINUOUS),
        ("lugar1", FeatureType.CATEGORICAL),
        ("lugar2", FeatureType.CATEGORICAL),
        ("lugar3", FeatureType.CATEGORICAL),
        ("lugar4", FeatureType.CATEGORICAL),
        ("lugar5", FeatureType.CATEGORICAL),
        ("lugar6", FeatureType.CATEGORICAL),
        ("area1", FeatureType.CATEGORICAL),
        ("area2", FeatureType.CATEGORICAL),
        ("age", FeatureType.CONTINUOUS),
        ("SQBescolari", FeatureType.CONTINUOUS),
        ("SQBage", FeatureType.CONTINUOUS),
        ("SQBhogar_total", FeatureType.CONTINUOUS),
        ("SQBedjefe", FeatureType.CONTINUOUS),
        ("SQBhogar_nin", FeatureType.CONTINUOUS),
        ("SQBovercrowding", FeatureType.CONTINUOUS),
        ("SQBdependency", FeatureType.CONTINUOUS),
        ("SQBmeaned", FeatureType.CONTINUOUS),
        ("agesq", FeatureType.CONTINUOUS),
    ])
