![builds](https://github.com/danforthcenter/plantcv/workflows/builds/badge.svg)
[![codecov](https://codecov.io/gh/danforthcenter/plantcv/branch/master/graph/badge.svg)](https://codecov.io/gh/danforthcenter/plantcv)
[![Documentation Status](http://readthedocs.org/projects/plantcv/badge/?version=latest)](http://plantcv.readthedocs.io/en/latest/?badge=latest)
[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/danforthcenter/plantcv-binder.git/master?filepath=index.ipynb)
[![Docker Pulls](https://img.shields.io/docker/pulls/danforthcenter/plantcv.svg)](https://hub.docker.com/r/danforthcenter/plantcv/)
[![GitHub release](https://img.shields.io/github/release/danforthcenter/plantcv.svg)](https://github.com/danforthcenter/plantcv/releases)
[![PyPI version](https://badge.fury.io/py/plantcv.svg)](https://badge.fury.io/py/plantcv)
![Conda](https://img.shields.io/conda/v/conda-forge/plantcv)
[![license](https://img.shields.io/github/license/danforthcenter/plantcv.svg)](https://github.com/danforthcenter/plantcv/blob/master/LICENSE)

# PlantCV: Plant phenotyping using computer vision

Please use, cite, and [contribute to](http://plantcv.readthedocs.io/en/latest/CONTRIBUTING/) PlantCV!
If you have questions, please submit them via the
[GitHub issues page](https://github.com/danforthcenter/plantcv/issues).
Follow us on twitter [@plantcv](https://twitter.com/plantcv).

***

## Introduction to PlantCV

PlantCV is an open-source image analysis software package targeted for plant phenotyping. PlantCV provides a common
programming and documentation interface to a collection of image analysis techniques that are integrated from a variety
of source packages and algorithms. PlantCV utilizes a modular architecture that enables flexibility in the design of
analysis workflows and rapid assimilation and integration of new methods. For more information about the project,
links to recorded presentations, and publications using PlantCV, please visit our homepage: 
<https://plantcv.danforthcenter.org/>.

### Quick Links

* [Documentation](http://plantcv.readthedocs.io/)
* [Interactive Documentation](https://mybinder.org/v2/gh/danforthcenter/plantcv-binder.git/master?filepath=index.ipynb)
* [Installation Instructions](https://plantcv.readthedocs.io/en/stable/installation/)
* [Updating/Changelog](https://plantcv.readthedocs.io/en/stable/updating/)
* [Public Image Datasets](http://plantcv.danforthcenter.org/pages/data.html)
* [Contribution Guide](https://plantcv.readthedocs.io/en/stable/CONTRIBUTING/)
* [Code of Conduct](https://plantcv.readthedocs.io/en/stable/CODE_OF_CONDUCT/)
* Downloads
  * [GitHub](https://github.com/danforthcenter/plantcv)
  * [PyPI](https://pypi.org/project/plantcv/)
  * [Conda-forge](https://anaconda.org/conda-forge/plantcv)
  * [Docker](https://hub.docker.com/r/danforthcenter/plantcv)
  * [Zenodo](https://doi.org/10.5281/zenodo.595522)

### Citing PlantCV

If you use PlantCV, please cite the [PlantCV publications](https://plantcv.danforthcenter.org/#plantcv-publications)
relevant to your work. To see how others have used PlantCV in their research, check out our list of 
[publications using PlantCV](https://plantcv.danforthcenter.org/#publications-using-plantcv).

***

## Issues with PlantCV

Please file any PlantCV suggestions/issues/bugs via our 
[GitHub issues page](https://github.com/danforthcenter/plantcv/issues). Please check to see if any related 
issues have already been filed.

***
