/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import opennlp.tools.chunker.Chunker;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSTagger;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.sentdetect.SentenceDetector;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.tokenize.TokenizerModel;
import org.cogroo.LanguageLoader;
import org.cogroo.exceptions.CogrooRuntimeException;

public class RuntimeLanguageLoader
implements LanguageLoader {
    public static final String SENT = "/Users/wcolen/Documents/wrks/___MODELS/pt-sent.model";
    public static final String TOK = "/Users/wcolen/Documents/wrks/___MODELS/pt-token.model";
    public static final String PROP = "model/pt-prop.model";
    public static final String EXP = "model/pt-exp.model";
    public static final String CON = "model/pt-con.model";
    public static final String POS = "model/pt-pos.model";
    public static final String CHK = "model/pt-chk.model";
    public static final String SP = "model/pt-sp.model";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SentenceDetector getSentenceDetector() {
        FileInputStream modelIn;
        try {
            modelIn = new FileInputStream(SENT);
        }
        catch (FileNotFoundException e) {
            Object[] args = new Object[]{SENT};
            throw new CogrooRuntimeException("MODEL_FILE_NOT_FOUND", args, e);
        }
        SentenceModel model = null;
        try {
            model = new SentenceModel(modelIn);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (modelIn != null) {
                try {
                    ((InputStream)modelIn).close();
                }
                catch (IOException iOException) {}
            }
        }
        return new SentenceDetectorME(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tokenizer getTokenizer() {
        FileInputStream modelIn;
        try {
            modelIn = new FileInputStream(TOK);
        }
        catch (FileNotFoundException e) {
            Object[] args = new Object[]{TOK};
            throw new CogrooRuntimeException("MODEL_FILE_NOT_FOUND", args, e);
        }
        TokenizerModel model = null;
        try {
            model = new TokenizerModel(modelIn);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (modelIn != null) {
                try {
                    ((InputStream)modelIn).close();
                }
                catch (IOException iOException) {}
            }
        }
        return new TokenizerME(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TokenNameFinder getProperNameFinder() {
        FileInputStream modelIn;
        try {
            modelIn = new FileInputStream(PROP);
        }
        catch (FileNotFoundException e) {
            Object[] args = new Object[]{PROP};
            throw new CogrooRuntimeException("MODEL_FILE_NOT_FOUND", args, e);
        }
        TokenNameFinderModel model = null;
        try {
            model = new TokenNameFinderModel(modelIn);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (modelIn != null) {
                try {
                    ((InputStream)modelIn).close();
                }
                catch (IOException iOException) {}
            }
        }
        return new NameFinderME(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TokenNameFinder getExpressionFinder() {
        FileInputStream modelIn;
        try {
            modelIn = new FileInputStream(EXP);
        }
        catch (FileNotFoundException e) {
            Object[] args = new Object[]{EXP};
            throw new CogrooRuntimeException("MODEL_FILE_NOT_FOUND", args, e);
        }
        TokenNameFinderModel model = null;
        try {
            model = new TokenNameFinderModel(modelIn);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (modelIn != null) {
                try {
                    ((InputStream)modelIn).close();
                }
                catch (IOException iOException) {}
            }
        }
        return new NameFinderME(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TokenNameFinder getContractionFinder() {
        FileInputStream modelIn;
        try {
            modelIn = new FileInputStream(CON);
        }
        catch (FileNotFoundException e) {
            Object[] args = new Object[]{CON};
            throw new CogrooRuntimeException("MODEL_FILE_NOT_FOUND", args, e);
        }
        TokenNameFinderModel model = null;
        try {
            model = new TokenNameFinderModel(modelIn);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (modelIn != null) {
                try {
                    ((InputStream)modelIn).close();
                }
                catch (IOException iOException) {}
            }
        }
        return new NameFinderME(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public POSTagger getPOSTagger() {
        FileInputStream modelIn;
        try {
            modelIn = new FileInputStream(POS);
        }
        catch (FileNotFoundException e) {
            Object[] args = new Object[]{POS};
            throw new CogrooRuntimeException("MODEL_FILE_NOT_FOUND", args, e);
        }
        POSModel model = null;
        try {
            model = new POSModel(modelIn);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (modelIn != null) {
                try {
                    ((InputStream)modelIn).close();
                }
                catch (IOException iOException) {}
            }
        }
        return new POSTaggerME(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Chunker getChunker() {
        FileInputStream modelIn;
        try {
            modelIn = new FileInputStream(CHK);
        }
        catch (FileNotFoundException e) {
            Object[] args = new Object[]{CHK};
            throw new CogrooRuntimeException("MODEL_FILE_NOT_FOUND", args, e);
        }
        ChunkerModel model = null;
        try {
            model = new ChunkerModel(modelIn);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (modelIn != null) {
                try {
                    ((InputStream)modelIn).close();
                }
                catch (IOException iOException) {}
            }
        }
        return new ChunkerME(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Chunker getShallowParser() {
        FileInputStream modelIn;
        try {
            modelIn = new FileInputStream(SP);
        }
        catch (FileNotFoundException e) {
            Object[] args = new Object[]{SP};
            throw new CogrooRuntimeException("MODEL_FILE_NOT_FOUND", args, e);
        }
        ChunkerModel model = null;
        try {
            model = new ChunkerModel(modelIn);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (modelIn != null) {
                try {
                    ((InputStream)modelIn).close();
                }
                catch (IOException iOException) {}
            }
        }
        return new ChunkerME(model);
    }
}

