/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.checker.rules.applier;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.cogroo.tools.checker.rules.applier.RulesAccess;
import org.cogroo.tools.checker.rules.exception.RulesException;
import org.cogroo.tools.checker.rules.model.ObjectFactory;
import org.cogroo.tools.checker.rules.model.Rule;
import org.cogroo.tools.checker.rules.model.Rules;
import org.cogroo.util.Closeables;
import org.xml.sax.SAXException;

public class RulesXmlAccess
implements RulesAccess {
    private static RulesXmlAccess instance;
    private URL schemaName;
    private Schema schema;
    private URL xmlFile;
    private String serializedRule;

    private RulesXmlAccess() {
    }

    private RulesXmlAccess(URL xmlFile, URL schemaFile) {
        this.xmlFile = xmlFile;
        this.schemaName = schemaFile;
        this.loadSchema();
    }

    private RulesXmlAccess(String serializedRule, URL schemaFile) {
        this.serializedRule = serializedRule;
        this.schemaName = schemaFile;
        this.loadSchema();
    }

    public static synchronized RulesAccess getInstance() {
        if (instance == null) {
            URL xml = RulesXmlAccess.class.getClassLoader().getResource("rules/rules.xml");
            URL xsd = RulesXmlAccess.class.getClassLoader().getResource("rules/schema/rules.xsd");
            instance = new RulesXmlAccess(xml, xsd);
        }
        return instance;
    }

    public static synchronized RulesAccess getInstance(String serializedRule) {
        URL xsd = RulesXmlAccess.class.getClassLoader().getResource("rules/schema/rules.xsd");
        return new RulesXmlAccess(serializedRule, xsd);
    }

    private void loadSchema() {
        if (this.schema == null) {
            InputStream in = null;
            try {
                in = this.schemaName.openStream();
                StreamSource ss = new StreamSource(in);
                SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                this.schema = sf.newSchema(ss);
            }
            catch (SAXException saxe) {
                this.schema = null;
                throw new RulesException("Could not read file " + this.schemaName, saxe);
            }
            catch (IOException e) {
                throw new RulesException("Could not open schema " + this.schemaName, e);
            }
            finally {
                Closeables.closeQuietly(in);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validate() {
        Validator validator = this.schema.newValidator();
        InputStream in = null;
        try {
            in = this.xmlFile != null ? this.xmlFile.openStream() : new ByteArrayInputStream(this.serializedRule.getBytes());
            validator.validate(new StreamSource(in));
        }
        catch (SAXException e) {
            try {
                throw new RulesException("Rules file does not conform to the schema", e);
                catch (IOException e2) {
                    if (this.xmlFile == null) throw new RulesException("Could not read serialized rule " + this.serializedRule, e2);
                    throw new RulesException("Could not read file " + this.xmlFile, e2);
                }
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(in);
                throw throwable;
            }
        }
        Closeables.closeQuietly(in);
    }

    public Rule getRule(int id) {
        Rule returnRule = null;
        for (Rule rule : this.getRules().getRule()) {
            if (rule.getId() != (long)id) continue;
            returnRule = rule;
            break;
        }
        return returnRule;
    }

    @Override
    public Rules getRules() {
        Rules rules = null;
        InputStream in = null;
        if (this.xmlFile != null) {
            try {
                in = this.xmlFile.openStream();
                rules = this.unmarshal(in);
            }
            catch (JAXBException e) {
                throw new RulesException("Invalid rules file: " + this.xmlFile, e);
            }
            catch (FileNotFoundException e) {
                throw new RulesException("Could not find rules file: " + this.xmlFile, e);
            }
            catch (IOException e) {
                throw new RulesException("Could not open  file: " + this.xmlFile, e);
            }
            finally {
                Closeables.closeQuietly(in);
            }
        }
        try {
            in = new ByteArrayInputStream(this.serializedRule.getBytes());
            rules = this.unmarshal(in);
        }
        catch (JAXBException e) {
            throw new RulesException("Invalid serialized rules: " + this.serializedRule, e);
        }
        finally {
            Closeables.closeQuietly(in);
        }
        return rules;
    }

    private Rules unmarshal(InputStream inputStream) throws JAXBException {
        String packageName = Rules.class.getPackage().getName();
        JAXBContext jc = JAXBContext.newInstance(packageName, ObjectFactory.class.getClassLoader());
        Unmarshaller u = jc.createUnmarshaller();
        this.loadSchema();
        u.setSchema(this.schema);
        return (Rules)u.unmarshal(inputStream);
    }

    @Override
    public void persist(Rules newRules) {
        throw new UnsupportedOperationException("Method not implemented: RulesXMLAccess.persist");
    }
}

