/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.checker.rules.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class RulesProperties {
    public static String rootFolder = System.getProperty("user.dir") + "/";
    public static final int NUMBER_OF_TREES = 3;
    public static final int GENERAL_TREE = 0;
    public static final int PHRASE_LOCAL_TREE = 1;
    public static final int SUBJECT_VERB_TREE = 2;
    private static final Properties PROPERTIES = new Properties();
    public static final boolean APPLY_LOCAL;
    public static final boolean APPLY_PHRASE_LOCAL;
    public static final boolean APPLY_SUBJECT_VERB;
    public static final String PACKAGE;
    private static String SCHEMA;
    private static boolean READ_FROM_SERIALIZED;
    public static final boolean REREAD_FROM_SERIALIZED;
    public static final String DATA_SOURCE;
    private static boolean REREAD_RULES;
    public static final String XML_FILE_ENCODING;
    private static String XML_FILE;
    public static final String[] CHECKERS;

    public static void setRootFolder(String value) {
        rootFolder = value + "/";
        RulesProperties.setRulesFile(RulesProperties.getStringPathWithRoot("xml.file"));
        RulesProperties.setSchemaFile(RulesProperties.getStringPathWithRoot("schema"));
    }

    private static String[] getCommaSeparatedString(String string) {
        String[] prop = RulesProperties.getString(string).split(",");
        return prop;
    }

    private static boolean getBoolean(String key) {
        return Boolean.parseBoolean(PROPERTIES.getProperty(key));
    }

    private static String getString(String key) {
        return PROPERTIES.getProperty(key);
    }

    private static String getStringPathWithRoot(String key) {
        return RulesProperties.prependWithRoot(RulesProperties.getString(key));
    }

    private static String prependWithRoot(String value) {
        if (rootFolder == null) {
            rootFolder = System.getProperty("user.dir") + "/";
        }
        return rootFolder + value;
    }

    private RulesProperties() {
    }

    public static void setRulesFile(String rulesFile) {
        XML_FILE = rulesFile;
    }

    public static void setSchemaFile(String schemaFile) {
        SCHEMA = schemaFile;
    }

    public static String getRulesFile() {
        return XML_FILE;
    }

    public static String getSchemaFile() {
        return SCHEMA;
    }

    public static String getSerializedTreesFile() {
        return RulesProperties.getRulesFile() + ".tree";
    }

    public static void setRereadRules(boolean rereadRules) {
        REREAD_RULES = rereadRules;
    }

    public static boolean isRereadRules() {
        return REREAD_RULES;
    }

    public static void setReadFromSerialized(boolean readFromSerialized) {
        READ_FROM_SERIALIZED = readFromSerialized;
    }

    public static boolean isReadFromSerialized() {
        return READ_FROM_SERIALIZED;
    }

    static {
        try {
            InputStream stream = RulesProperties.class.getResourceAsStream("/rules/properties/rules.properties");
            PROPERTIES.load(stream);
            stream.close();
        }
        catch (IOException e) {
            throw new RuntimeException("could not load rules.properties!", e);
        }
        APPLY_LOCAL = RulesProperties.getBoolean("apply.local");
        APPLY_PHRASE_LOCAL = RulesProperties.getBoolean("apply.phrase.local");
        APPLY_SUBJECT_VERB = RulesProperties.getBoolean("apply.subject.verb");
        PACKAGE = RulesProperties.getString("package");
        SCHEMA = RulesProperties.getString("schema");
        READ_FROM_SERIALIZED = RulesProperties.getBoolean("read.from.serialized");
        REREAD_FROM_SERIALIZED = RulesProperties.getBoolean("reread.from.serialized");
        DATA_SOURCE = RulesProperties.getString("data.source");
        REREAD_RULES = RulesProperties.getBoolean("reread.rules");
        XML_FILE_ENCODING = RulesProperties.getString("xml.file.encoding");
        XML_FILE = RulesProperties.getStringPathWithRoot("xml.file");
        CHECKERS = RulesProperties.getCommaSeparatedString("checkers");
    }
}

