/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.featurizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import opennlp.tools.util.SequenceValidator;
import org.cogroo.dictionary.FeatureDictionary;
import org.cogroo.tools.chunker2.TokenTag;

public class DefaultFeaturizerSequenceValidator
implements SequenceValidator<TokenTag> {
    private FeatureDictionary tagDict = null;
    private Set<String> poisonedTags;

    public DefaultFeaturizerSequenceValidator(FeatureDictionary tagDict, Set<String> poisonedTags) {
        this.tagDict = tagDict;
        this.poisonedTags = poisonedTags;
    }

    public boolean validSequence(int i, TokenTag[] sequence, String[] s, String outcome) {
        String word = sequence[i].getToken();
        String postag = sequence[i].getTag();
        if (this.tagDict == null) {
            return true;
        }
        if (postag == null) {
            System.err.println("NULL: " + Arrays.toString(sequence));
            System.err.println("NULL: " + Arrays.toString(s));
        }
        String[] tagsArr = this.expandedSearch(word, postag, true);
        List<String> tags = null;
        if (tagsArr != null) {
            tags = this.filterPoisoned(tagsArr);
        }
        boolean match = true;
        if (tags != null && (match = this.matches(outcome, tags)) && this.hasNoSubjOpt(tags) && postag.equals("v-fin") && outcome.endsWith("=SUBJ")) {
            boolean found = false;
            for (int j = i - 1; j >= 0; --j) {
                String lexeme = sequence[j].getToken().toLowerCase();
                if (!lexeme.equals("que")) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        return match;
    }

    private boolean hasNoSubjOpt(List<String> tags) {
        if (tags.size() > 1) {
            for (String tag : tags) {
                if (tag.endsWith("=SUBJ")) continue;
                return true;
            }
        }
        return false;
    }

    private String[] expandedSearch(String word, String postag, boolean recurse) {
        String[] tagsArr = this.tagDict.getFeatures(word, postag);
        if (tagsArr == null || tagsArr.length == 0) {
            tagsArr = this.tagDict.getFeatures(word.toLowerCase(), postag);
        }
        if ((tagsArr == null || tagsArr.length == 0) && recurse) {
            if (postag.equals("n-adj")) {
                tagsArr = this.expandedSearch(word, "adj", false);
                if (tagsArr == null || tagsArr.length == 0) {
                    tagsArr = this.expandedSearch(word, "n", false);
                }
            } else if (postag.equals("n")) {
                tagsArr = this.expandedSearch(word, "n-adj", false);
            } else if (postag.equals("adj")) {
                tagsArr = this.expandedSearch(word, "n-adj", false);
            } else if (word.length() > 1 && word.charAt(0) == '-') {
                tagsArr = this.expandedSearch(word.substring(1), postag, false);
            }
        }
        return tagsArr;
    }

    private List<String> filterPoisoned(String[] featureTag) {
        if (featureTag == null) {
            return null;
        }
        ArrayList<String> filtered = new ArrayList<String>();
        for (String tag : featureTag) {
            if (this.poisonedTags.contains(tag)) {
                System.err.println("found poisoned tag. Will ignore all! " + tag);
                return null;
            }
            filtered.add(tag);
        }
        if (filtered.size() == 0) {
            return null;
        }
        return Collections.unmodifiableList(filtered);
    }

    private boolean matches(String outcome, List<String> tags) {
        if (tags.contains(outcome)) {
            return true;
        }
        for (String t : tags) {
            if (!DefaultFeaturizerSequenceValidator.matches(outcome, t)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(String outcome, String tag) {
        if ("-".equals(tag) || "-".equals(outcome)) {
            return false;
        }
        HashSet<String> outcomeParts = new HashSet<String>(Arrays.asList(outcome.split("[=-]")));
        HashSet<String> tagParts = new HashSet<String>(Arrays.asList(tag.split("[=-]")));
        if (outcomeParts.size() != tagParts.size()) {
            return false;
        }
        ArrayList<String> remove = new ArrayList<String>();
        for (String t : tagParts) {
            if (!outcomeParts.contains(t)) continue;
            remove.add(t);
        }
        tagParts.removeAll(remove);
        if (tagParts.size() == 0) {
            return true;
        }
        if (!tag.contains("/")) {
            return false;
        }
        outcomeParts.removeAll(remove);
        HashSet<String> outcomeParts2 = new HashSet<String>();
        for (String o : outcomeParts) {
            outcomeParts2.addAll(Arrays.asList(o.split("/")));
        }
        remove.clear();
        block2: for (String t : tagParts) {
            for (String o : outcomeParts2) {
                if (!t.contains(o) || Character.isDigit(o.charAt(0))) continue;
                remove.add(t);
                remove.add(o);
                continue block2;
            }
        }
        tagParts.removeAll(remove);
        outcomeParts2.removeAll(remove);
        if (tagParts.size() == 0 && outcomeParts2.size() == 0) {
            return true;
        }
        if (tagParts.size() == 1 && outcomeParts2.size() >= 1) {
            for (String op : outcomeParts2) {
                String t = new ArrayList<String>(tagParts).get(0);
                if (!Character.isDigit(op.charAt(0)) || !Character.isDigit(t.charAt(0))) continue;
                boolean ok = true;
                for (int i = 0; i < op.length(); ++i) {
                    if (t.contains(Character.toString(op.charAt(i)))) continue;
                    ok = false;
                    break;
                }
                if (!ok) continue;
                return true;
            }
        }
        return false;
    }
}

