/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.analyzer;

import java.util.List;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.util.Span;
import org.apache.log4j.Logger;
import org.cogroo.ContractionUtility;
import org.cogroo.analyzer.Analyzer;
import org.cogroo.config.Analyzers;
import org.cogroo.text.Document;
import org.cogroo.text.Sentence;
import org.cogroo.text.Token;
import org.cogroo.text.impl.TokenImpl;
import org.cogroo.util.TextUtils;

public class ContractionFinder
implements Analyzer {
    private NameFinderME contractionFinder;
    protected static final Logger LOGGER = Logger.getLogger(ContractionFinder.class);

    public ContractionFinder(NameFinderME contractionFinder) {
        this.contractionFinder = contractionFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyze(Document document) {
        List<Sentence> sentences = document.getSentences();
        for (Sentence sentence : sentences) {
            Span[] contractionsSpan;
            NameFinderME nameFinderME = this.contractionFinder;
            synchronized (nameFinderME) {
                contractionsSpan = this.contractionFinder.find(TextUtils.tokensToString(sentence.getTokens()));
            }
            List<Token> newTokens = sentence.getTokens();
            for (int i = contractionsSpan.length - 1; i >= 0; --i) {
                int start = contractionsSpan[i].getStart();
                String lexeme = sentence.getTokens().get(start).getLexeme();
                String[] contractions = ContractionUtility.expand(lexeme);
                Token original = newTokens.remove(start);
                if (contractions != null) {
                    for (int j = contractions.length - 1; j >= 0; --j) {
                        TokenImpl token = new TokenImpl(original.getStart(), original.getEnd(), contractions[j]);
                        newTokens.add(start, token);
                        String caze = null;
                        caze = j == 0 ? "B" : (j == contractions.length - 1 ? "E" : "I");
                        token.addContext(Analyzers.CONTRACTION_FINDER, caze);
                    }
                    continue;
                }
                LOGGER.debug("Missing contraction: " + lexeme);
            }
            sentence.setTokens(newTokens);
        }
    }
}

