/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.analyzer;

import java.util.ArrayList;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.util.Span;
import org.cogroo.analyzer.Analyzer;
import org.cogroo.text.Document;
import org.cogroo.text.Sentence;
import org.cogroo.text.impl.SentenceImpl;

public class SentenceDetector
implements Analyzer {
    private SentenceDetectorME sentenceDetector;

    public SentenceDetector(SentenceDetectorME sentenceDetector) {
        this.sentenceDetector = sentenceDetector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyze(Document document) {
        Span[] spans;
        if (document.getText() == null) {
            throw new IllegalArgumentException("Document text is null.");
        }
        SentenceDetectorME sentenceDetectorME = this.sentenceDetector;
        synchronized (sentenceDetectorME) {
            spans = this.sentenceDetector.sentPosDetect(document.getText());
        }
        ArrayList<Sentence> sentences = new ArrayList<Sentence>(spans.length);
        for (int i = 0; i < spans.length; ++i) {
            SentenceImpl sentence = new SentenceImpl(spans[i].getStart(), spans[i].getEnd(), document);
            sentences.add(sentence);
        }
        document.setSentences(sentences);
    }
}

