/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.checker.rules.util;

import org.cogroo.tools.checker.rules.model.Composition;
import org.cogroo.tools.checker.rules.model.Element;
import org.cogroo.tools.checker.rules.model.Mask;
import org.cogroo.tools.checker.rules.model.PatternElement;
import org.cogroo.tools.checker.rules.model.TagMask;

public class EqualsUtils {
    public static boolean arePatternElementEquals(PatternElement p1, PatternElement p2) {
        Element e1 = p1.getElement();
        Element e2 = p2.getElement();
        Composition c1 = p1.getComposition();
        Composition c2 = p2.getComposition();
        if (e1 != null) {
            if (e2 != null) {
                return EqualsUtils.areElementEquals(e1, e2);
            }
            if (c2 != null) {
                return false;
            }
        }
        if (c1 != null) {
            if (c2 != null) {
                return EqualsUtils.areCompositionEquals(c1, c2);
            }
            if (e2 != null) {
                return false;
            }
        }
        return false;
    }

    public static boolean areCompositionEquals(Composition c1, Composition c2) {
        return false;
    }

    public static boolean areElementEquals(Element element1, Element element2) {
        for (Mask mask1 : element1.getMask()) {
            if (!EqualsUtils.areBooleanEquals(element1.isNegated(), element2.isNegated())) {
                return false;
            }
            for (Mask mask2 : element2.getMask()) {
                if (!EqualsUtils.areStringEquals(mask1.getLexemeMask(), mask2.getLexemeMask())) {
                    return false;
                }
                if (!EqualsUtils.areStringEquals(mask1.getPrimitiveMask(), mask2.getPrimitiveMask())) {
                    return false;
                }
                if (EqualsUtils.areTagMaskEquals(mask1.getTagMask(), mask2.getTagMask())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean areTagMaskEquals(TagMask tagMask1, TagMask tagMask2) {
        if (tagMask1 == null && tagMask2 != null || tagMask1 != null && tagMask2 == null) {
            return false;
        }
        if (tagMask1 != null && tagMask2 != null) {
            if (tagMask1.getCase() != tagMask2.getCase()) {
                return false;
            }
            if (tagMask1.getClazz() != tagMask2.getClazz()) {
                return false;
            }
            if (tagMask1.getGender() != tagMask2.getGender()) {
                return false;
            }
            if (tagMask1.getMood() != tagMask2.getMood()) {
                return false;
            }
            if (tagMask1.getNumber() != tagMask2.getNumber()) {
                return false;
            }
            if (tagMask1.getPerson() != tagMask2.getPerson()) {
                return false;
            }
            if (tagMask1.getPunctuation() != tagMask2.getPunctuation()) {
                return false;
            }
            if (tagMask1.getSyntacticFunction() != tagMask2.getSyntacticFunction()) {
                return false;
            }
            if (tagMask1.getTense() != tagMask2.getTense()) {
                return false;
            }
        }
        return true;
    }

    public static boolean areBooleanEquals(Boolean boolean1, Boolean boolean2) {
        if (boolean1 != null && !boolean1.equals(boolean2)) {
            return false;
        }
        return boolean2 == null || boolean2.equals(boolean1);
    }

    public static boolean areStringEquals(String string1, String string2) {
        if (string1 == null && string2 == null) {
            return false;
        }
        if (string1 != null && !string1.equals(string2)) {
            return false;
        }
        return string2 == null || string2.equals(string1);
    }
}

