/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.checker.rules.verbs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.cogroo.analyzer.InitializationException;
import org.cogroo.tools.checker.rules.verbs.Prep;
import org.cogroo.tools.checker.rules.verbs.VerbPlusPreps;

public class Verbs {
    private final Map<String, VerbPlusPreps> verbsMap = Collections.unmodifiableMap(this.parseConfiguration());
    private static final Pattern PREP_LINE = Pattern.compile("^\\w+:.*");

    public Map<String, VerbPlusPreps> parseConfiguration() {
        InputStream input = Verbs.class.getClassLoader().getResourceAsStream("rules/government/verbs.txt");
        HashMap<String, VerbPlusPreps> map = new HashMap<String, VerbPlusPreps>();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
            ArrayList<Prep> preps = null;
            String verb = null;
            while (reader.ready()) {
                String line = reader.readLine();
                if (line.length() <= 0 || line.charAt(0) == '%') continue;
                if (line.charAt(0) == '#') {
                    if (preps != null) {
                        map.put(verb, new VerbPlusPreps(preps));
                        verb = null;
                        preps = null;
                    }
                    preps = new ArrayList<Prep>();
                    verb = line.substring(1).trim();
                    continue;
                }
                if (!PREP_LINE.matcher(line).matches()) continue;
                Prep prep = new Prep();
                String[] words = line.split(":\\s?", 3);
                if (words != null) {
                    prep.setPreposition(words[0]);
                    if (words.length > 1) {
                        prep.setMeaning(words[1]);
                        if (words.length > 2) {
                            prep.setObjects(words[2]);
                        }
                    }
                }
                preps.add(prep);
            }
            return map;
        }
        catch (UnsupportedEncodingException e) {
            throw new InitializationException("Enconding problem while reading the verbs.txt file", e);
        }
        catch (IOException e) {
            throw new InitializationException("Could not read the verbs.txt file", e);
        }
    }

    public VerbPlusPreps getVerb(String verb) {
        return this.verbsMap.get(verb);
    }
}

