/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.sentdetect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import opennlp.tools.sentdetect.SDContextGenerator;
import opennlp.tools.util.StringUtil;

public class PortugueseSDContextGenerator
implements SDContextGenerator {
    protected StringBuffer buf;
    protected List<String> collectFeats;
    private Set<String> inducedAbbreviations;
    private char[] eosCharacters;

    public PortugueseSDContextGenerator(char[] eosCharacters) {
        this(Collections.emptySet(), eosCharacters);
    }

    public PortugueseSDContextGenerator(Set<String> inducedAbbreviations, char[] eosCharacters) {
        this.inducedAbbreviations = inducedAbbreviations;
        this.eosCharacters = eosCharacters;
        this.buf = new StringBuffer();
        this.collectFeats = new ArrayList<String>();
    }

    @Override
    public String[] getContext(CharSequence sb, int position) {
        String next;
        String suffix;
        int lastIndex = sb.length() - 1;
        if (position > 0 && StringUtil.isWhitespace(sb.charAt(position - 1))) {
            this.collectFeats.add("sp");
        }
        if (position < lastIndex && StringUtil.isWhitespace(sb.charAt(position + 1))) {
            this.collectFeats.add("sn");
        }
        this.collectFeats.add("eos=" + sb.charAt(position));
        int prefixStart = PortugueseSDContextGenerator.previousSpaceIndex(sb, position);
        int c = position;
        block0: while (--c > prefixStart) {
            int ecl = this.eosCharacters.length;
            for (int eci = 0; eci < ecl; ++eci) {
                if (sb.charAt(c) != this.eosCharacters[eci]) continue;
                prefixStart = c++;
                continue block0;
            }
        }
        String prefix = new StringBuffer(sb.subSequence(prefixStart, position)).toString().trim();
        int prevStart = PortugueseSDContextGenerator.previousSpaceIndex(sb, prefixStart);
        String previous = new StringBuffer(sb.subSequence(prevStart, prefixStart)).toString().trim();
        int suffixEnd = PortugueseSDContextGenerator.nextSpaceIndex(sb, position, lastIndex);
        c = position;
        block2: while (++c < suffixEnd) {
            int ecl = this.eosCharacters.length;
            for (int eci = 0; eci < ecl; ++eci) {
                if (sb.charAt(c) != this.eosCharacters[eci]) continue;
                suffixEnd = c--;
                continue block2;
            }
        }
        int nextEnd = PortugueseSDContextGenerator.nextSpaceIndex(sb, suffixEnd + 1, lastIndex + 1);
        if (position == lastIndex) {
            suffix = "";
            next = "";
        } else {
            suffix = new StringBuilder(sb.subSequence(position + 1, suffixEnd)).toString().trim();
            next = new StringBuilder(sb.subSequence(suffixEnd + 1, nextEnd)).toString().trim();
        }
        this.collectFeatures(prefix, suffix, previous, next, sb.charAt(position));
        int sentEnd = Math.max(position + 1, suffixEnd);
        this.collectFeats.addAll(this.getSentenceContext(sb.subSequence(prefixStart, sentEnd).toString(), position - prefixStart));
        String[] context = new String[this.collectFeats.size()];
        context = this.collectFeats.toArray(context);
        this.collectFeats.clear();
        return context;
    }

    protected void collectFeatures(String prefix, String suffix, String previous, String next, char eosChar) {
        this.buf.append("x=");
        this.buf.append(prefix);
        this.collectFeats.add(this.buf.toString());
        this.buf.setLength(0);
        if (!prefix.equals("")) {
            this.collectFeats.add(Integer.toString(prefix.length()));
            if (PortugueseSDContextGenerator.isFirstUpper(prefix)) {
                this.collectFeats.add("xcap");
            }
            if (this.inducedAbbreviations.contains(prefix + eosChar)) {
                this.collectFeats.add("xabbrev");
            }
            char c = prefix.charAt(0);
            if (prefix.length() == 1 && Character.isLetter(c) && Character.isUpperCase(c) && eosChar == '.') {
                this.collectFeats.add("xnabb");
            }
        }
        this.buf.append("v=");
        this.buf.append(previous);
        this.collectFeats.add(this.buf.toString());
        this.buf.setLength(0);
        if (!previous.equals("")) {
            if (PortugueseSDContextGenerator.isFirstUpper(previous)) {
                this.collectFeats.add("vcap");
            }
            if (this.inducedAbbreviations.contains(previous)) {
                this.collectFeats.add("vabbrev");
            }
        }
        this.buf.append("s=");
        this.buf.append(suffix);
        this.collectFeats.add(this.buf.toString());
        this.buf.setLength(0);
        if (!suffix.equals("")) {
            if (PortugueseSDContextGenerator.isFirstUpper(suffix)) {
                this.collectFeats.add("scap");
            }
            if (this.inducedAbbreviations.contains(suffix)) {
                this.collectFeats.add("sabbrev");
            }
        }
        this.buf.append("n=");
        this.buf.append(next);
        this.collectFeats.add(this.buf.toString());
        this.buf.setLength(0);
        if (!next.equals("")) {
            if (PortugueseSDContextGenerator.isFirstUpper(next)) {
                this.collectFeats.add("ncap");
            }
            if (this.inducedAbbreviations.contains(next)) {
                this.collectFeats.add("nabbrev");
            }
        }
    }

    private static final boolean isFirstUpper(String s) {
        return Character.isUpperCase(s.charAt(0));
    }

    private static final int previousSpaceIndex(CharSequence sb, int seek) {
        --seek;
        while (seek > 0 && !StringUtil.isWhitespace(sb.charAt(seek))) {
            --seek;
        }
        if (seek > 0 && StringUtil.isWhitespace(sb.charAt(seek))) {
            while (seek > 0 && StringUtil.isWhitespace(sb.charAt(seek - 1))) {
                --seek;
            }
            return seek;
        }
        return 0;
    }

    private static final int nextSpaceIndex(CharSequence sb, int seek, int lastIndex) {
        ++seek;
        while (seek < lastIndex) {
            char c = sb.charAt(seek);
            if (StringUtil.isWhitespace(c)) {
                while (sb.length() > seek + 1 && StringUtil.isWhitespace(sb.charAt(seek + 1))) {
                    ++seek;
                }
                return seek;
            }
            ++seek;
        }
        return lastIndex;
    }

    public List<String> getSentenceContext(String sentence, int index) {
        ArrayList<String> preds = new ArrayList<String>();
        if (index > 0) {
            this.addCharPreds("p1", sentence.charAt(index - 1), preds);
            if (index > 1) {
                this.addCharPreds("p2", sentence.charAt(index - 2), preds);
                preds.add("p21=" + sentence.charAt(index - 2) + sentence.charAt(index - 1));
            } else {
                preds.add("p2=bok");
            }
            preds.add("p1f1=" + sentence.charAt(index - 1) + sentence.charAt(index));
        } else {
            preds.add("p1=bok");
        }
        if (index + 1 < sentence.length()) {
            this.addCharPreds("f2", sentence.charAt(index + 1), preds);
            preds.add("f12=" + sentence.charAt(index) + sentence.charAt(index + 1));
        } else {
            preds.add("f2=bok");
        }
        if (sentence.charAt(0) == '&' && sentence.charAt(sentence.length() - 1) == ';') {
            preds.add("cc");
        }
        return preds;
    }

    private void addCharPreds(String key, char c, List<String> preds) {
        preds.add(key + "=" + c);
        if (Character.isLetter(c)) {
            preds.add(key + "_alpha");
            if (Character.isUpperCase(c)) {
                preds.add(key + "_caps");
            }
        } else if (Character.isDigit(c)) {
            preds.add(key + "_num");
        } else if (StringUtil.isWhitespace(c)) {
            preds.add(key + "_ws");
        } else if (c == '.' || c == '?' || c == '!') {
            preds.add(key + "_eos");
        } else if (c == ',' || c == ';' || c == ':') {
            preds.add(key + "_reos");
        } else if (c == '`' || c == '\"' || c == '\'') {
            preds.add(key + "_quote");
        } else if (c == '[' || c == '{' || c == '(') {
            preds.add(key + "_lp");
        } else if (c == ']' || c == '}' || c == ')') {
            preds.add(key + "_rp");
        }
    }
}

