/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApplicationInsightsWorkbookTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/application_insights_workbook_template#author ApplicationInsightsWorkbookTemplate#author}
    */
    readonly author?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/application_insights_workbook_template#id ApplicationInsightsWorkbookTemplate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/application_insights_workbook_template#localized ApplicationInsightsWorkbookTemplate#localized}
    */
    readonly localized?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/application_insights_workbook_template#location ApplicationInsightsWorkbookTemplate#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/application_insights_workbook_template#name ApplicationInsightsWorkbookTemplate#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/application_insights_workbook_template#priority ApplicationInsightsWorkbookTemplate#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/application_insights_workbook_template#resource_group_name ApplicationInsightsWorkbookTemplate#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/application_insights_workbook_template#tags ApplicationInsightsWorkbookTemplate#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/application_insights_workbook_template#template_data ApplicationInsightsWorkbookTemplate#template_data}
    */
    readonly templateData: string;
    /**
    * galleries block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/application_insights_workbook_template#galleries ApplicationInsightsWorkbookTemplate#galleries}
    */
    readonly galleries: ApplicationInsightsWorkbookTemplateGalleries[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/application_insights_workbook_template#timeouts ApplicationInsightsWorkbookTemplate#timeouts}
    */
    readonly timeouts?: ApplicationInsightsWorkbookTemplateTimeouts;
}
export interface ApplicationInsightsWorkbookTemplateGalleries {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/application_insights_workbook_template#category ApplicationInsightsWorkbookTemplate#category}
    */
    readonly category: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/application_insights_workbook_template#name ApplicationInsightsWorkbookTemplate#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/application_insights_workbook_template#order ApplicationInsightsWorkbookTemplate#order}
    */
    readonly order?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/application_insights_workbook_template#resource_type ApplicationInsightsWorkbookTemplate#resource_type}
    */
    readonly resourceType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/application_insights_workbook_template#type ApplicationInsightsWorkbookTemplate#type}
    */
    readonly type?: string;
}
export declare function applicationInsightsWorkbookTemplateGalleriesToTerraform(struct?: ApplicationInsightsWorkbookTemplateGalleries | cdktf.IResolvable): any;
export declare function applicationInsightsWorkbookTemplateGalleriesToHclTerraform(struct?: ApplicationInsightsWorkbookTemplateGalleries | cdktf.IResolvable): any;
export declare class ApplicationInsightsWorkbookTemplateGalleriesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationInsightsWorkbookTemplateGalleries | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationInsightsWorkbookTemplateGalleries | cdktf.IResolvable | undefined);
    private _category?;
    get category(): string;
    set category(value: string);
    get categoryInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _order?;
    get order(): number;
    set order(value: number);
    resetOrder(): void;
    get orderInput(): number | undefined;
    private _resourceType?;
    get resourceType(): string;
    set resourceType(value: string);
    resetResourceType(): void;
    get resourceTypeInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class ApplicationInsightsWorkbookTemplateGalleriesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationInsightsWorkbookTemplateGalleries[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationInsightsWorkbookTemplateGalleriesOutputReference;
}
export interface ApplicationInsightsWorkbookTemplateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/application_insights_workbook_template#create ApplicationInsightsWorkbookTemplate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/application_insights_workbook_template#delete ApplicationInsightsWorkbookTemplate#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/application_insights_workbook_template#read ApplicationInsightsWorkbookTemplate#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/application_insights_workbook_template#update ApplicationInsightsWorkbookTemplate#update}
    */
    readonly update?: string;
}
export declare function applicationInsightsWorkbookTemplateTimeoutsToTerraform(struct?: ApplicationInsightsWorkbookTemplateTimeouts | cdktf.IResolvable): any;
export declare function applicationInsightsWorkbookTemplateTimeoutsToHclTerraform(struct?: ApplicationInsightsWorkbookTemplateTimeouts | cdktf.IResolvable): any;
export declare class ApplicationInsightsWorkbookTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationInsightsWorkbookTemplateTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationInsightsWorkbookTemplateTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/application_insights_workbook_template azurerm_application_insights_workbook_template}
*/
export declare class ApplicationInsightsWorkbookTemplate extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_application_insights_workbook_template";
    /**
    * Generates CDKTF code for importing a ApplicationInsightsWorkbookTemplate resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ApplicationInsightsWorkbookTemplate to import
    * @param importFromId The id of the existing ApplicationInsightsWorkbookTemplate that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/application_insights_workbook_template#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ApplicationInsightsWorkbookTemplate to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/application_insights_workbook_template azurerm_application_insights_workbook_template} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApplicationInsightsWorkbookTemplateConfig
    */
    constructor(scope: Construct, id: string, config: ApplicationInsightsWorkbookTemplateConfig);
    private _author?;
    get author(): string;
    set author(value: string);
    resetAuthor(): void;
    get authorInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _localized?;
    get localized(): string;
    set localized(value: string);
    resetLocalized(): void;
    get localizedInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _templateData?;
    get templateData(): string;
    set templateData(value: string);
    get templateDataInput(): string | undefined;
    private _galleries;
    get galleries(): ApplicationInsightsWorkbookTemplateGalleriesList;
    putGalleries(value: ApplicationInsightsWorkbookTemplateGalleries[] | cdktf.IResolvable): void;
    get galleriesInput(): cdktf.IResolvable | ApplicationInsightsWorkbookTemplateGalleries[] | undefined;
    private _timeouts;
    get timeouts(): ApplicationInsightsWorkbookTemplateTimeoutsOutputReference;
    putTimeouts(value: ApplicationInsightsWorkbookTemplateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApplicationInsightsWorkbookTemplateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
