/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BastionHostConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/bastion_host#copy_paste_enabled BastionHost#copy_paste_enabled}
    */
    readonly copyPasteEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/bastion_host#file_copy_enabled BastionHost#file_copy_enabled}
    */
    readonly fileCopyEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/bastion_host#id BastionHost#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/bastion_host#ip_connect_enabled BastionHost#ip_connect_enabled}
    */
    readonly ipConnectEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/bastion_host#kerberos_enabled BastionHost#kerberos_enabled}
    */
    readonly kerberosEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/bastion_host#location BastionHost#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/bastion_host#name BastionHost#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/bastion_host#resource_group_name BastionHost#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/bastion_host#scale_units BastionHost#scale_units}
    */
    readonly scaleUnits?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/bastion_host#session_recording_enabled BastionHost#session_recording_enabled}
    */
    readonly sessionRecordingEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/bastion_host#shareable_link_enabled BastionHost#shareable_link_enabled}
    */
    readonly shareableLinkEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/bastion_host#sku BastionHost#sku}
    */
    readonly sku?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/bastion_host#tags BastionHost#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/bastion_host#tunneling_enabled BastionHost#tunneling_enabled}
    */
    readonly tunnelingEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/bastion_host#virtual_network_id BastionHost#virtual_network_id}
    */
    readonly virtualNetworkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/bastion_host#zones BastionHost#zones}
    */
    readonly zones?: string[];
    /**
    * ip_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/bastion_host#ip_configuration BastionHost#ip_configuration}
    */
    readonly ipConfiguration?: BastionHostIpConfiguration;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/bastion_host#timeouts BastionHost#timeouts}
    */
    readonly timeouts?: BastionHostTimeouts;
}
export interface BastionHostIpConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/bastion_host#name BastionHost#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/bastion_host#public_ip_address_id BastionHost#public_ip_address_id}
    */
    readonly publicIpAddressId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/bastion_host#subnet_id BastionHost#subnet_id}
    */
    readonly subnetId: string;
}
export declare function bastionHostIpConfigurationToTerraform(struct?: BastionHostIpConfigurationOutputReference | BastionHostIpConfiguration): any;
export declare function bastionHostIpConfigurationToHclTerraform(struct?: BastionHostIpConfigurationOutputReference | BastionHostIpConfiguration): any;
export declare class BastionHostIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BastionHostIpConfiguration | undefined;
    set internalValue(value: BastionHostIpConfiguration | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _publicIpAddressId?;
    get publicIpAddressId(): string;
    set publicIpAddressId(value: string);
    get publicIpAddressIdInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
}
export interface BastionHostTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/bastion_host#create BastionHost#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/bastion_host#delete BastionHost#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/bastion_host#read BastionHost#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/bastion_host#update BastionHost#update}
    */
    readonly update?: string;
}
export declare function bastionHostTimeoutsToTerraform(struct?: BastionHostTimeouts | cdktf.IResolvable): any;
export declare function bastionHostTimeoutsToHclTerraform(struct?: BastionHostTimeouts | cdktf.IResolvable): any;
export declare class BastionHostTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BastionHostTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: BastionHostTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/bastion_host azurerm_bastion_host}
*/
export declare class BastionHost extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_bastion_host";
    /**
    * Generates CDKTF code for importing a BastionHost resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the BastionHost to import
    * @param importFromId The id of the existing BastionHost that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/bastion_host#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the BastionHost to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/bastion_host azurerm_bastion_host} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BastionHostConfig
    */
    constructor(scope: Construct, id: string, config: BastionHostConfig);
    private _copyPasteEnabled?;
    get copyPasteEnabled(): boolean | cdktf.IResolvable;
    set copyPasteEnabled(value: boolean | cdktf.IResolvable);
    resetCopyPasteEnabled(): void;
    get copyPasteEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get dnsName(): string;
    private _fileCopyEnabled?;
    get fileCopyEnabled(): boolean | cdktf.IResolvable;
    set fileCopyEnabled(value: boolean | cdktf.IResolvable);
    resetFileCopyEnabled(): void;
    get fileCopyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipConnectEnabled?;
    get ipConnectEnabled(): boolean | cdktf.IResolvable;
    set ipConnectEnabled(value: boolean | cdktf.IResolvable);
    resetIpConnectEnabled(): void;
    get ipConnectEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _kerberosEnabled?;
    get kerberosEnabled(): boolean | cdktf.IResolvable;
    set kerberosEnabled(value: boolean | cdktf.IResolvable);
    resetKerberosEnabled(): void;
    get kerberosEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _scaleUnits?;
    get scaleUnits(): number;
    set scaleUnits(value: number);
    resetScaleUnits(): void;
    get scaleUnitsInput(): number | undefined;
    private _sessionRecordingEnabled?;
    get sessionRecordingEnabled(): boolean | cdktf.IResolvable;
    set sessionRecordingEnabled(value: boolean | cdktf.IResolvable);
    resetSessionRecordingEnabled(): void;
    get sessionRecordingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _shareableLinkEnabled?;
    get shareableLinkEnabled(): boolean | cdktf.IResolvable;
    set shareableLinkEnabled(value: boolean | cdktf.IResolvable);
    resetShareableLinkEnabled(): void;
    get shareableLinkEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    resetSku(): void;
    get skuInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tunnelingEnabled?;
    get tunnelingEnabled(): boolean | cdktf.IResolvable;
    set tunnelingEnabled(value: boolean | cdktf.IResolvable);
    resetTunnelingEnabled(): void;
    get tunnelingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    resetVirtualNetworkId(): void;
    get virtualNetworkIdInput(): string | undefined;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
    private _ipConfiguration;
    get ipConfiguration(): BastionHostIpConfigurationOutputReference;
    putIpConfiguration(value: BastionHostIpConfiguration): void;
    resetIpConfiguration(): void;
    get ipConfigurationInput(): BastionHostIpConfiguration | undefined;
    private _timeouts;
    get timeouts(): BastionHostTimeoutsOutputReference;
    putTimeouts(value: BastionHostTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | BastionHostTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
