/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BillingAccountCostManagementExportConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/billing_account_cost_management_export#active BillingAccountCostManagementExport#active}
    */
    readonly active?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/billing_account_cost_management_export#billing_account_id BillingAccountCostManagementExport#billing_account_id}
    */
    readonly billingAccountId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/billing_account_cost_management_export#file_format BillingAccountCostManagementExport#file_format}
    */
    readonly fileFormat?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/billing_account_cost_management_export#id BillingAccountCostManagementExport#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/billing_account_cost_management_export#name BillingAccountCostManagementExport#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/billing_account_cost_management_export#recurrence_period_end_date BillingAccountCostManagementExport#recurrence_period_end_date}
    */
    readonly recurrencePeriodEndDate: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/billing_account_cost_management_export#recurrence_period_start_date BillingAccountCostManagementExport#recurrence_period_start_date}
    */
    readonly recurrencePeriodStartDate: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/billing_account_cost_management_export#recurrence_type BillingAccountCostManagementExport#recurrence_type}
    */
    readonly recurrenceType: string;
    /**
    * export_data_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/billing_account_cost_management_export#export_data_options BillingAccountCostManagementExport#export_data_options}
    */
    readonly exportDataOptions: BillingAccountCostManagementExportExportDataOptions;
    /**
    * export_data_storage_location block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/billing_account_cost_management_export#export_data_storage_location BillingAccountCostManagementExport#export_data_storage_location}
    */
    readonly exportDataStorageLocation: BillingAccountCostManagementExportExportDataStorageLocation;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/billing_account_cost_management_export#timeouts BillingAccountCostManagementExport#timeouts}
    */
    readonly timeouts?: BillingAccountCostManagementExportTimeouts;
}
export interface BillingAccountCostManagementExportExportDataOptions {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/billing_account_cost_management_export#time_frame BillingAccountCostManagementExport#time_frame}
    */
    readonly timeFrame: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/billing_account_cost_management_export#type BillingAccountCostManagementExport#type}
    */
    readonly type: string;
}
export declare function billingAccountCostManagementExportExportDataOptionsToTerraform(struct?: BillingAccountCostManagementExportExportDataOptionsOutputReference | BillingAccountCostManagementExportExportDataOptions): any;
export declare function billingAccountCostManagementExportExportDataOptionsToHclTerraform(struct?: BillingAccountCostManagementExportExportDataOptionsOutputReference | BillingAccountCostManagementExportExportDataOptions): any;
export declare class BillingAccountCostManagementExportExportDataOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BillingAccountCostManagementExportExportDataOptions | undefined;
    set internalValue(value: BillingAccountCostManagementExportExportDataOptions | undefined);
    private _timeFrame?;
    get timeFrame(): string;
    set timeFrame(value: string);
    get timeFrameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface BillingAccountCostManagementExportExportDataStorageLocation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/billing_account_cost_management_export#container_id BillingAccountCostManagementExport#container_id}
    */
    readonly containerId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/billing_account_cost_management_export#root_folder_path BillingAccountCostManagementExport#root_folder_path}
    */
    readonly rootFolderPath: string;
}
export declare function billingAccountCostManagementExportExportDataStorageLocationToTerraform(struct?: BillingAccountCostManagementExportExportDataStorageLocationOutputReference | BillingAccountCostManagementExportExportDataStorageLocation): any;
export declare function billingAccountCostManagementExportExportDataStorageLocationToHclTerraform(struct?: BillingAccountCostManagementExportExportDataStorageLocationOutputReference | BillingAccountCostManagementExportExportDataStorageLocation): any;
export declare class BillingAccountCostManagementExportExportDataStorageLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BillingAccountCostManagementExportExportDataStorageLocation | undefined;
    set internalValue(value: BillingAccountCostManagementExportExportDataStorageLocation | undefined);
    private _containerId?;
    get containerId(): string;
    set containerId(value: string);
    get containerIdInput(): string | undefined;
    private _rootFolderPath?;
    get rootFolderPath(): string;
    set rootFolderPath(value: string);
    get rootFolderPathInput(): string | undefined;
}
export interface BillingAccountCostManagementExportTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/billing_account_cost_management_export#create BillingAccountCostManagementExport#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/billing_account_cost_management_export#delete BillingAccountCostManagementExport#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/billing_account_cost_management_export#read BillingAccountCostManagementExport#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/billing_account_cost_management_export#update BillingAccountCostManagementExport#update}
    */
    readonly update?: string;
}
export declare function billingAccountCostManagementExportTimeoutsToTerraform(struct?: BillingAccountCostManagementExportTimeouts | cdktf.IResolvable): any;
export declare function billingAccountCostManagementExportTimeoutsToHclTerraform(struct?: BillingAccountCostManagementExportTimeouts | cdktf.IResolvable): any;
export declare class BillingAccountCostManagementExportTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BillingAccountCostManagementExportTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: BillingAccountCostManagementExportTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/billing_account_cost_management_export azurerm_billing_account_cost_management_export}
*/
export declare class BillingAccountCostManagementExport extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_billing_account_cost_management_export";
    /**
    * Generates CDKTF code for importing a BillingAccountCostManagementExport resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the BillingAccountCostManagementExport to import
    * @param importFromId The id of the existing BillingAccountCostManagementExport that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/billing_account_cost_management_export#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the BillingAccountCostManagementExport to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/billing_account_cost_management_export azurerm_billing_account_cost_management_export} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BillingAccountCostManagementExportConfig
    */
    constructor(scope: Construct, id: string, config: BillingAccountCostManagementExportConfig);
    private _active?;
    get active(): boolean | cdktf.IResolvable;
    set active(value: boolean | cdktf.IResolvable);
    resetActive(): void;
    get activeInput(): boolean | cdktf.IResolvable | undefined;
    private _billingAccountId?;
    get billingAccountId(): string;
    set billingAccountId(value: string);
    get billingAccountIdInput(): string | undefined;
    private _fileFormat?;
    get fileFormat(): string;
    set fileFormat(value: string);
    resetFileFormat(): void;
    get fileFormatInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _recurrencePeriodEndDate?;
    get recurrencePeriodEndDate(): string;
    set recurrencePeriodEndDate(value: string);
    get recurrencePeriodEndDateInput(): string | undefined;
    private _recurrencePeriodStartDate?;
    get recurrencePeriodStartDate(): string;
    set recurrencePeriodStartDate(value: string);
    get recurrencePeriodStartDateInput(): string | undefined;
    private _recurrenceType?;
    get recurrenceType(): string;
    set recurrenceType(value: string);
    get recurrenceTypeInput(): string | undefined;
    private _exportDataOptions;
    get exportDataOptions(): BillingAccountCostManagementExportExportDataOptionsOutputReference;
    putExportDataOptions(value: BillingAccountCostManagementExportExportDataOptions): void;
    get exportDataOptionsInput(): BillingAccountCostManagementExportExportDataOptions | undefined;
    private _exportDataStorageLocation;
    get exportDataStorageLocation(): BillingAccountCostManagementExportExportDataStorageLocationOutputReference;
    putExportDataStorageLocation(value: BillingAccountCostManagementExportExportDataStorageLocation): void;
    get exportDataStorageLocationInput(): BillingAccountCostManagementExportExportDataStorageLocation | undefined;
    private _timeouts;
    get timeouts(): BillingAccountCostManagementExportTimeoutsOutputReference;
    putTimeouts(value: BillingAccountCostManagementExportTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | BillingAccountCostManagementExportTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
