/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#dns_name_label ContainerGroup#dns_name_label}
    */
    readonly dnsNameLabel?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#dns_name_label_reuse_policy ContainerGroup#dns_name_label_reuse_policy}
    */
    readonly dnsNameLabelReusePolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#exposed_port ContainerGroup#exposed_port}
    */
    readonly exposedPort?: ContainerGroupExposedPort[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#id ContainerGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#ip_address_type ContainerGroup#ip_address_type}
    */
    readonly ipAddressType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#key_vault_key_id ContainerGroup#key_vault_key_id}
    */
    readonly keyVaultKeyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#key_vault_user_assigned_identity_id ContainerGroup#key_vault_user_assigned_identity_id}
    */
    readonly keyVaultUserAssignedIdentityId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#location ContainerGroup#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#name ContainerGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#network_profile_id ContainerGroup#network_profile_id}
    */
    readonly networkProfileId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#os_type ContainerGroup#os_type}
    */
    readonly osType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#priority ContainerGroup#priority}
    */
    readonly priority?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#resource_group_name ContainerGroup#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#restart_policy ContainerGroup#restart_policy}
    */
    readonly restartPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#sku ContainerGroup#sku}
    */
    readonly sku?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#subnet_ids ContainerGroup#subnet_ids}
    */
    readonly subnetIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#tags ContainerGroup#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#zones ContainerGroup#zones}
    */
    readonly zones?: string[];
    /**
    * container block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#container ContainerGroup#container}
    */
    readonly container: ContainerGroupContainer[] | cdktf.IResolvable;
    /**
    * diagnostics block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#diagnostics ContainerGroup#diagnostics}
    */
    readonly diagnostics?: ContainerGroupDiagnostics;
    /**
    * dns_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#dns_config ContainerGroup#dns_config}
    */
    readonly dnsConfig?: ContainerGroupDnsConfig;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#identity ContainerGroup#identity}
    */
    readonly identity?: ContainerGroupIdentity;
    /**
    * image_registry_credential block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#image_registry_credential ContainerGroup#image_registry_credential}
    */
    readonly imageRegistryCredential?: ContainerGroupImageRegistryCredential[] | cdktf.IResolvable;
    /**
    * init_container block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#init_container ContainerGroup#init_container}
    */
    readonly initContainer?: ContainerGroupInitContainer[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#timeouts ContainerGroup#timeouts}
    */
    readonly timeouts?: ContainerGroupTimeouts;
}
export interface ContainerGroupExposedPort {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#port ContainerGroup#port}
    */
    readonly port?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#protocol ContainerGroup#protocol}
    */
    readonly protocol?: string;
}
export declare function containerGroupExposedPortToTerraform(struct?: ContainerGroupExposedPort | cdktf.IResolvable): any;
export declare function containerGroupExposedPortToHclTerraform(struct?: ContainerGroupExposedPort | cdktf.IResolvable): any;
export declare class ContainerGroupExposedPortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerGroupExposedPort | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerGroupExposedPort | cdktf.IResolvable | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
}
export declare class ContainerGroupExposedPortList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerGroupExposedPort[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerGroupExposedPortOutputReference;
}
export interface ContainerGroupContainerLivenessProbeHttpGet {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#http_headers ContainerGroup#http_headers}
    */
    readonly httpHeaders?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#path ContainerGroup#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#port ContainerGroup#port}
    */
    readonly port?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#scheme ContainerGroup#scheme}
    */
    readonly scheme?: string;
}
export declare function containerGroupContainerLivenessProbeHttpGetToTerraform(struct?: ContainerGroupContainerLivenessProbeHttpGet | cdktf.IResolvable): any;
export declare function containerGroupContainerLivenessProbeHttpGetToHclTerraform(struct?: ContainerGroupContainerLivenessProbeHttpGet | cdktf.IResolvable): any;
export declare class ContainerGroupContainerLivenessProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerGroupContainerLivenessProbeHttpGet | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerGroupContainerLivenessProbeHttpGet | cdktf.IResolvable | undefined);
    private _httpHeaders?;
    get httpHeaders(): {
        [key: string]: string;
    };
    set httpHeaders(value: {
        [key: string]: string;
    });
    resetHttpHeaders(): void;
    get httpHeadersInput(): {
        [key: string]: string;
    } | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
}
export declare class ContainerGroupContainerLivenessProbeHttpGetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerGroupContainerLivenessProbeHttpGet[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerGroupContainerLivenessProbeHttpGetOutputReference;
}
export interface ContainerGroupContainerLivenessProbe {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#exec ContainerGroup#exec}
    */
    readonly exec?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#failure_threshold ContainerGroup#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#initial_delay_seconds ContainerGroup#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#period_seconds ContainerGroup#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#success_threshold ContainerGroup#success_threshold}
    */
    readonly successThreshold?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#timeout_seconds ContainerGroup#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#http_get ContainerGroup#http_get}
    */
    readonly httpGet?: ContainerGroupContainerLivenessProbeHttpGet[] | cdktf.IResolvable;
}
export declare function containerGroupContainerLivenessProbeToTerraform(struct?: ContainerGroupContainerLivenessProbeOutputReference | ContainerGroupContainerLivenessProbe): any;
export declare function containerGroupContainerLivenessProbeToHclTerraform(struct?: ContainerGroupContainerLivenessProbeOutputReference | ContainerGroupContainerLivenessProbe): any;
export declare class ContainerGroupContainerLivenessProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerGroupContainerLivenessProbe | undefined;
    set internalValue(value: ContainerGroupContainerLivenessProbe | undefined);
    private _exec?;
    get exec(): string[];
    set exec(value: string[]);
    resetExec(): void;
    get execInput(): string[] | undefined;
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _successThreshold?;
    get successThreshold(): number;
    set successThreshold(value: number);
    resetSuccessThreshold(): void;
    get successThresholdInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _httpGet;
    get httpGet(): ContainerGroupContainerLivenessProbeHttpGetList;
    putHttpGet(value: ContainerGroupContainerLivenessProbeHttpGet[] | cdktf.IResolvable): void;
    resetHttpGet(): void;
    get httpGetInput(): cdktf.IResolvable | ContainerGroupContainerLivenessProbeHttpGet[] | undefined;
}
export interface ContainerGroupContainerPorts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#port ContainerGroup#port}
    */
    readonly port?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#protocol ContainerGroup#protocol}
    */
    readonly protocol?: string;
}
export declare function containerGroupContainerPortsToTerraform(struct?: ContainerGroupContainerPorts | cdktf.IResolvable): any;
export declare function containerGroupContainerPortsToHclTerraform(struct?: ContainerGroupContainerPorts | cdktf.IResolvable): any;
export declare class ContainerGroupContainerPortsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerGroupContainerPorts | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerGroupContainerPorts | cdktf.IResolvable | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
}
export declare class ContainerGroupContainerPortsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerGroupContainerPorts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerGroupContainerPortsOutputReference;
}
export interface ContainerGroupContainerReadinessProbeHttpGet {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#http_headers ContainerGroup#http_headers}
    */
    readonly httpHeaders?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#path ContainerGroup#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#port ContainerGroup#port}
    */
    readonly port?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#scheme ContainerGroup#scheme}
    */
    readonly scheme?: string;
}
export declare function containerGroupContainerReadinessProbeHttpGetToTerraform(struct?: ContainerGroupContainerReadinessProbeHttpGet | cdktf.IResolvable): any;
export declare function containerGroupContainerReadinessProbeHttpGetToHclTerraform(struct?: ContainerGroupContainerReadinessProbeHttpGet | cdktf.IResolvable): any;
export declare class ContainerGroupContainerReadinessProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerGroupContainerReadinessProbeHttpGet | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerGroupContainerReadinessProbeHttpGet | cdktf.IResolvable | undefined);
    private _httpHeaders?;
    get httpHeaders(): {
        [key: string]: string;
    };
    set httpHeaders(value: {
        [key: string]: string;
    });
    resetHttpHeaders(): void;
    get httpHeadersInput(): {
        [key: string]: string;
    } | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
}
export declare class ContainerGroupContainerReadinessProbeHttpGetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerGroupContainerReadinessProbeHttpGet[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerGroupContainerReadinessProbeHttpGetOutputReference;
}
export interface ContainerGroupContainerReadinessProbe {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#exec ContainerGroup#exec}
    */
    readonly exec?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#failure_threshold ContainerGroup#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#initial_delay_seconds ContainerGroup#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#period_seconds ContainerGroup#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#success_threshold ContainerGroup#success_threshold}
    */
    readonly successThreshold?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#timeout_seconds ContainerGroup#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#http_get ContainerGroup#http_get}
    */
    readonly httpGet?: ContainerGroupContainerReadinessProbeHttpGet[] | cdktf.IResolvable;
}
export declare function containerGroupContainerReadinessProbeToTerraform(struct?: ContainerGroupContainerReadinessProbeOutputReference | ContainerGroupContainerReadinessProbe): any;
export declare function containerGroupContainerReadinessProbeToHclTerraform(struct?: ContainerGroupContainerReadinessProbeOutputReference | ContainerGroupContainerReadinessProbe): any;
export declare class ContainerGroupContainerReadinessProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerGroupContainerReadinessProbe | undefined;
    set internalValue(value: ContainerGroupContainerReadinessProbe | undefined);
    private _exec?;
    get exec(): string[];
    set exec(value: string[]);
    resetExec(): void;
    get execInput(): string[] | undefined;
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _successThreshold?;
    get successThreshold(): number;
    set successThreshold(value: number);
    resetSuccessThreshold(): void;
    get successThresholdInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _httpGet;
    get httpGet(): ContainerGroupContainerReadinessProbeHttpGetList;
    putHttpGet(value: ContainerGroupContainerReadinessProbeHttpGet[] | cdktf.IResolvable): void;
    resetHttpGet(): void;
    get httpGetInput(): cdktf.IResolvable | ContainerGroupContainerReadinessProbeHttpGet[] | undefined;
}
export interface ContainerGroupContainerSecurity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#privilege_enabled ContainerGroup#privilege_enabled}
    */
    readonly privilegeEnabled: boolean | cdktf.IResolvable;
}
export declare function containerGroupContainerSecurityToTerraform(struct?: ContainerGroupContainerSecurity | cdktf.IResolvable): any;
export declare function containerGroupContainerSecurityToHclTerraform(struct?: ContainerGroupContainerSecurity | cdktf.IResolvable): any;
export declare class ContainerGroupContainerSecurityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerGroupContainerSecurity | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerGroupContainerSecurity | cdktf.IResolvable | undefined);
    private _privilegeEnabled?;
    get privilegeEnabled(): boolean | cdktf.IResolvable;
    set privilegeEnabled(value: boolean | cdktf.IResolvable);
    get privilegeEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ContainerGroupContainerSecurityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerGroupContainerSecurity[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerGroupContainerSecurityOutputReference;
}
export interface ContainerGroupContainerVolumeGitRepo {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#directory ContainerGroup#directory}
    */
    readonly directory?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#revision ContainerGroup#revision}
    */
    readonly revision?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#url ContainerGroup#url}
    */
    readonly url: string;
}
export declare function containerGroupContainerVolumeGitRepoToTerraform(struct?: ContainerGroupContainerVolumeGitRepoOutputReference | ContainerGroupContainerVolumeGitRepo): any;
export declare function containerGroupContainerVolumeGitRepoToHclTerraform(struct?: ContainerGroupContainerVolumeGitRepoOutputReference | ContainerGroupContainerVolumeGitRepo): any;
export declare class ContainerGroupContainerVolumeGitRepoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerGroupContainerVolumeGitRepo | undefined;
    set internalValue(value: ContainerGroupContainerVolumeGitRepo | undefined);
    private _directory?;
    get directory(): string;
    set directory(value: string);
    resetDirectory(): void;
    get directoryInput(): string | undefined;
    private _revision?;
    get revision(): string;
    set revision(value: string);
    resetRevision(): void;
    get revisionInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export interface ContainerGroupContainerVolume {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#empty_dir ContainerGroup#empty_dir}
    */
    readonly emptyDir?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#mount_path ContainerGroup#mount_path}
    */
    readonly mountPath: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#name ContainerGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#read_only ContainerGroup#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#secret ContainerGroup#secret}
    */
    readonly secret?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#share_name ContainerGroup#share_name}
    */
    readonly shareName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#storage_account_key ContainerGroup#storage_account_key}
    */
    readonly storageAccountKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#storage_account_name ContainerGroup#storage_account_name}
    */
    readonly storageAccountName?: string;
    /**
    * git_repo block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#git_repo ContainerGroup#git_repo}
    */
    readonly gitRepo?: ContainerGroupContainerVolumeGitRepo;
}
export declare function containerGroupContainerVolumeToTerraform(struct?: ContainerGroupContainerVolume | cdktf.IResolvable): any;
export declare function containerGroupContainerVolumeToHclTerraform(struct?: ContainerGroupContainerVolume | cdktf.IResolvable): any;
export declare class ContainerGroupContainerVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerGroupContainerVolume | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerGroupContainerVolume | cdktf.IResolvable | undefined);
    private _emptyDir?;
    get emptyDir(): boolean | cdktf.IResolvable;
    set emptyDir(value: boolean | cdktf.IResolvable);
    resetEmptyDir(): void;
    get emptyDirInput(): boolean | cdktf.IResolvable | undefined;
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    get mountPathInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _secret?;
    get secret(): {
        [key: string]: string;
    };
    set secret(value: {
        [key: string]: string;
    });
    resetSecret(): void;
    get secretInput(): {
        [key: string]: string;
    } | undefined;
    private _shareName?;
    get shareName(): string;
    set shareName(value: string);
    resetShareName(): void;
    get shareNameInput(): string | undefined;
    private _storageAccountKey?;
    get storageAccountKey(): string;
    set storageAccountKey(value: string);
    resetStorageAccountKey(): void;
    get storageAccountKeyInput(): string | undefined;
    private _storageAccountName?;
    get storageAccountName(): string;
    set storageAccountName(value: string);
    resetStorageAccountName(): void;
    get storageAccountNameInput(): string | undefined;
    private _gitRepo;
    get gitRepo(): ContainerGroupContainerVolumeGitRepoOutputReference;
    putGitRepo(value: ContainerGroupContainerVolumeGitRepo): void;
    resetGitRepo(): void;
    get gitRepoInput(): ContainerGroupContainerVolumeGitRepo | undefined;
}
export declare class ContainerGroupContainerVolumeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerGroupContainerVolume[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerGroupContainerVolumeOutputReference;
}
export interface ContainerGroupContainer {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#commands ContainerGroup#commands}
    */
    readonly commands?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#cpu ContainerGroup#cpu}
    */
    readonly cpu: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#cpu_limit ContainerGroup#cpu_limit}
    */
    readonly cpuLimit?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#environment_variables ContainerGroup#environment_variables}
    */
    readonly environmentVariables?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#image ContainerGroup#image}
    */
    readonly image: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#memory ContainerGroup#memory}
    */
    readonly memory: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#memory_limit ContainerGroup#memory_limit}
    */
    readonly memoryLimit?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#name ContainerGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#secure_environment_variables ContainerGroup#secure_environment_variables}
    */
    readonly secureEnvironmentVariables?: {
        [key: string]: string;
    };
    /**
    * liveness_probe block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#liveness_probe ContainerGroup#liveness_probe}
    */
    readonly livenessProbe?: ContainerGroupContainerLivenessProbe;
    /**
    * ports block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#ports ContainerGroup#ports}
    */
    readonly ports?: ContainerGroupContainerPorts[] | cdktf.IResolvable;
    /**
    * readiness_probe block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#readiness_probe ContainerGroup#readiness_probe}
    */
    readonly readinessProbe?: ContainerGroupContainerReadinessProbe;
    /**
    * security block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#security ContainerGroup#security}
    */
    readonly security?: ContainerGroupContainerSecurity[] | cdktf.IResolvable;
    /**
    * volume block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#volume ContainerGroup#volume}
    */
    readonly volume?: ContainerGroupContainerVolume[] | cdktf.IResolvable;
}
export declare function containerGroupContainerToTerraform(struct?: ContainerGroupContainer | cdktf.IResolvable): any;
export declare function containerGroupContainerToHclTerraform(struct?: ContainerGroupContainer | cdktf.IResolvable): any;
export declare class ContainerGroupContainerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerGroupContainer | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerGroupContainer | cdktf.IResolvable | undefined);
    private _commands?;
    get commands(): string[];
    set commands(value: string[]);
    resetCommands(): void;
    get commandsInput(): string[] | undefined;
    private _cpu?;
    get cpu(): number;
    set cpu(value: number);
    get cpuInput(): number | undefined;
    private _cpuLimit?;
    get cpuLimit(): number;
    set cpuLimit(value: number);
    resetCpuLimit(): void;
    get cpuLimitInput(): number | undefined;
    private _environmentVariables?;
    get environmentVariables(): {
        [key: string]: string;
    };
    set environmentVariables(value: {
        [key: string]: string;
    });
    resetEnvironmentVariables(): void;
    get environmentVariablesInput(): {
        [key: string]: string;
    } | undefined;
    private _image?;
    get image(): string;
    set image(value: string);
    get imageInput(): string | undefined;
    private _memory?;
    get memory(): number;
    set memory(value: number);
    get memoryInput(): number | undefined;
    private _memoryLimit?;
    get memoryLimit(): number;
    set memoryLimit(value: number);
    resetMemoryLimit(): void;
    get memoryLimitInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _secureEnvironmentVariables?;
    get secureEnvironmentVariables(): {
        [key: string]: string;
    };
    set secureEnvironmentVariables(value: {
        [key: string]: string;
    });
    resetSecureEnvironmentVariables(): void;
    get secureEnvironmentVariablesInput(): {
        [key: string]: string;
    } | undefined;
    private _livenessProbe;
    get livenessProbe(): ContainerGroupContainerLivenessProbeOutputReference;
    putLivenessProbe(value: ContainerGroupContainerLivenessProbe): void;
    resetLivenessProbe(): void;
    get livenessProbeInput(): ContainerGroupContainerLivenessProbe | undefined;
    private _ports;
    get ports(): ContainerGroupContainerPortsList;
    putPorts(value: ContainerGroupContainerPorts[] | cdktf.IResolvable): void;
    resetPorts(): void;
    get portsInput(): cdktf.IResolvable | ContainerGroupContainerPorts[] | undefined;
    private _readinessProbe;
    get readinessProbe(): ContainerGroupContainerReadinessProbeOutputReference;
    putReadinessProbe(value: ContainerGroupContainerReadinessProbe): void;
    resetReadinessProbe(): void;
    get readinessProbeInput(): ContainerGroupContainerReadinessProbe | undefined;
    private _security;
    get security(): ContainerGroupContainerSecurityList;
    putSecurity(value: ContainerGroupContainerSecurity[] | cdktf.IResolvable): void;
    resetSecurity(): void;
    get securityInput(): cdktf.IResolvable | ContainerGroupContainerSecurity[] | undefined;
    private _volume;
    get volume(): ContainerGroupContainerVolumeList;
    putVolume(value: ContainerGroupContainerVolume[] | cdktf.IResolvable): void;
    resetVolume(): void;
    get volumeInput(): cdktf.IResolvable | ContainerGroupContainerVolume[] | undefined;
}
export declare class ContainerGroupContainerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerGroupContainer[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerGroupContainerOutputReference;
}
export interface ContainerGroupDiagnosticsLogAnalytics {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#log_type ContainerGroup#log_type}
    */
    readonly logType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#metadata ContainerGroup#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#workspace_id ContainerGroup#workspace_id}
    */
    readonly workspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#workspace_key ContainerGroup#workspace_key}
    */
    readonly workspaceKey: string;
}
export declare function containerGroupDiagnosticsLogAnalyticsToTerraform(struct?: ContainerGroupDiagnosticsLogAnalyticsOutputReference | ContainerGroupDiagnosticsLogAnalytics): any;
export declare function containerGroupDiagnosticsLogAnalyticsToHclTerraform(struct?: ContainerGroupDiagnosticsLogAnalyticsOutputReference | ContainerGroupDiagnosticsLogAnalytics): any;
export declare class ContainerGroupDiagnosticsLogAnalyticsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerGroupDiagnosticsLogAnalytics | undefined;
    set internalValue(value: ContainerGroupDiagnosticsLogAnalytics | undefined);
    private _logType?;
    get logType(): string;
    set logType(value: string);
    resetLogType(): void;
    get logTypeInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _workspaceId?;
    get workspaceId(): string;
    set workspaceId(value: string);
    get workspaceIdInput(): string | undefined;
    private _workspaceKey?;
    get workspaceKey(): string;
    set workspaceKey(value: string);
    get workspaceKeyInput(): string | undefined;
}
export interface ContainerGroupDiagnostics {
    /**
    * log_analytics block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#log_analytics ContainerGroup#log_analytics}
    */
    readonly logAnalytics: ContainerGroupDiagnosticsLogAnalytics;
}
export declare function containerGroupDiagnosticsToTerraform(struct?: ContainerGroupDiagnosticsOutputReference | ContainerGroupDiagnostics): any;
export declare function containerGroupDiagnosticsToHclTerraform(struct?: ContainerGroupDiagnosticsOutputReference | ContainerGroupDiagnostics): any;
export declare class ContainerGroupDiagnosticsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerGroupDiagnostics | undefined;
    set internalValue(value: ContainerGroupDiagnostics | undefined);
    private _logAnalytics;
    get logAnalytics(): ContainerGroupDiagnosticsLogAnalyticsOutputReference;
    putLogAnalytics(value: ContainerGroupDiagnosticsLogAnalytics): void;
    get logAnalyticsInput(): ContainerGroupDiagnosticsLogAnalytics | undefined;
}
export interface ContainerGroupDnsConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#nameservers ContainerGroup#nameservers}
    */
    readonly nameservers: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#options ContainerGroup#options}
    */
    readonly options?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#search_domains ContainerGroup#search_domains}
    */
    readonly searchDomains?: string[];
}
export declare function containerGroupDnsConfigToTerraform(struct?: ContainerGroupDnsConfigOutputReference | ContainerGroupDnsConfig): any;
export declare function containerGroupDnsConfigToHclTerraform(struct?: ContainerGroupDnsConfigOutputReference | ContainerGroupDnsConfig): any;
export declare class ContainerGroupDnsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerGroupDnsConfig | undefined;
    set internalValue(value: ContainerGroupDnsConfig | undefined);
    private _nameservers?;
    get nameservers(): string[];
    set nameservers(value: string[]);
    get nameserversInput(): string[] | undefined;
    private _options?;
    get options(): string[];
    set options(value: string[]);
    resetOptions(): void;
    get optionsInput(): string[] | undefined;
    private _searchDomains?;
    get searchDomains(): string[];
    set searchDomains(value: string[]);
    resetSearchDomains(): void;
    get searchDomainsInput(): string[] | undefined;
}
export interface ContainerGroupIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#identity_ids ContainerGroup#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#type ContainerGroup#type}
    */
    readonly type: string;
}
export declare function containerGroupIdentityToTerraform(struct?: ContainerGroupIdentityOutputReference | ContainerGroupIdentity): any;
export declare function containerGroupIdentityToHclTerraform(struct?: ContainerGroupIdentityOutputReference | ContainerGroupIdentity): any;
export declare class ContainerGroupIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerGroupIdentity | undefined;
    set internalValue(value: ContainerGroupIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ContainerGroupImageRegistryCredential {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#password ContainerGroup#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#server ContainerGroup#server}
    */
    readonly server: string;
    /**
    * The User Assigned Identity to use for Container Registry access.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#user_assigned_identity_id ContainerGroup#user_assigned_identity_id}
    */
    readonly userAssignedIdentityId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#username ContainerGroup#username}
    */
    readonly username?: string;
}
export declare function containerGroupImageRegistryCredentialToTerraform(struct?: ContainerGroupImageRegistryCredential | cdktf.IResolvable): any;
export declare function containerGroupImageRegistryCredentialToHclTerraform(struct?: ContainerGroupImageRegistryCredential | cdktf.IResolvable): any;
export declare class ContainerGroupImageRegistryCredentialOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerGroupImageRegistryCredential | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerGroupImageRegistryCredential | cdktf.IResolvable | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
    private _userAssignedIdentityId?;
    get userAssignedIdentityId(): string;
    set userAssignedIdentityId(value: string);
    resetUserAssignedIdentityId(): void;
    get userAssignedIdentityIdInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
}
export declare class ContainerGroupImageRegistryCredentialList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerGroupImageRegistryCredential[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerGroupImageRegistryCredentialOutputReference;
}
export interface ContainerGroupInitContainerSecurity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#privilege_enabled ContainerGroup#privilege_enabled}
    */
    readonly privilegeEnabled: boolean | cdktf.IResolvable;
}
export declare function containerGroupInitContainerSecurityToTerraform(struct?: ContainerGroupInitContainerSecurity | cdktf.IResolvable): any;
export declare function containerGroupInitContainerSecurityToHclTerraform(struct?: ContainerGroupInitContainerSecurity | cdktf.IResolvable): any;
export declare class ContainerGroupInitContainerSecurityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerGroupInitContainerSecurity | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerGroupInitContainerSecurity | cdktf.IResolvable | undefined);
    private _privilegeEnabled?;
    get privilegeEnabled(): boolean | cdktf.IResolvable;
    set privilegeEnabled(value: boolean | cdktf.IResolvable);
    get privilegeEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ContainerGroupInitContainerSecurityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerGroupInitContainerSecurity[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerGroupInitContainerSecurityOutputReference;
}
export interface ContainerGroupInitContainerVolumeGitRepo {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#directory ContainerGroup#directory}
    */
    readonly directory?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#revision ContainerGroup#revision}
    */
    readonly revision?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#url ContainerGroup#url}
    */
    readonly url: string;
}
export declare function containerGroupInitContainerVolumeGitRepoToTerraform(struct?: ContainerGroupInitContainerVolumeGitRepoOutputReference | ContainerGroupInitContainerVolumeGitRepo): any;
export declare function containerGroupInitContainerVolumeGitRepoToHclTerraform(struct?: ContainerGroupInitContainerVolumeGitRepoOutputReference | ContainerGroupInitContainerVolumeGitRepo): any;
export declare class ContainerGroupInitContainerVolumeGitRepoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerGroupInitContainerVolumeGitRepo | undefined;
    set internalValue(value: ContainerGroupInitContainerVolumeGitRepo | undefined);
    private _directory?;
    get directory(): string;
    set directory(value: string);
    resetDirectory(): void;
    get directoryInput(): string | undefined;
    private _revision?;
    get revision(): string;
    set revision(value: string);
    resetRevision(): void;
    get revisionInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export interface ContainerGroupInitContainerVolume {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#empty_dir ContainerGroup#empty_dir}
    */
    readonly emptyDir?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#mount_path ContainerGroup#mount_path}
    */
    readonly mountPath: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#name ContainerGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#read_only ContainerGroup#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#secret ContainerGroup#secret}
    */
    readonly secret?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#share_name ContainerGroup#share_name}
    */
    readonly shareName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#storage_account_key ContainerGroup#storage_account_key}
    */
    readonly storageAccountKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#storage_account_name ContainerGroup#storage_account_name}
    */
    readonly storageAccountName?: string;
    /**
    * git_repo block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#git_repo ContainerGroup#git_repo}
    */
    readonly gitRepo?: ContainerGroupInitContainerVolumeGitRepo;
}
export declare function containerGroupInitContainerVolumeToTerraform(struct?: ContainerGroupInitContainerVolume | cdktf.IResolvable): any;
export declare function containerGroupInitContainerVolumeToHclTerraform(struct?: ContainerGroupInitContainerVolume | cdktf.IResolvable): any;
export declare class ContainerGroupInitContainerVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerGroupInitContainerVolume | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerGroupInitContainerVolume | cdktf.IResolvable | undefined);
    private _emptyDir?;
    get emptyDir(): boolean | cdktf.IResolvable;
    set emptyDir(value: boolean | cdktf.IResolvable);
    resetEmptyDir(): void;
    get emptyDirInput(): boolean | cdktf.IResolvable | undefined;
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    get mountPathInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _secret?;
    get secret(): {
        [key: string]: string;
    };
    set secret(value: {
        [key: string]: string;
    });
    resetSecret(): void;
    get secretInput(): {
        [key: string]: string;
    } | undefined;
    private _shareName?;
    get shareName(): string;
    set shareName(value: string);
    resetShareName(): void;
    get shareNameInput(): string | undefined;
    private _storageAccountKey?;
    get storageAccountKey(): string;
    set storageAccountKey(value: string);
    resetStorageAccountKey(): void;
    get storageAccountKeyInput(): string | undefined;
    private _storageAccountName?;
    get storageAccountName(): string;
    set storageAccountName(value: string);
    resetStorageAccountName(): void;
    get storageAccountNameInput(): string | undefined;
    private _gitRepo;
    get gitRepo(): ContainerGroupInitContainerVolumeGitRepoOutputReference;
    putGitRepo(value: ContainerGroupInitContainerVolumeGitRepo): void;
    resetGitRepo(): void;
    get gitRepoInput(): ContainerGroupInitContainerVolumeGitRepo | undefined;
}
export declare class ContainerGroupInitContainerVolumeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerGroupInitContainerVolume[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerGroupInitContainerVolumeOutputReference;
}
export interface ContainerGroupInitContainer {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#commands ContainerGroup#commands}
    */
    readonly commands?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#environment_variables ContainerGroup#environment_variables}
    */
    readonly environmentVariables?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#image ContainerGroup#image}
    */
    readonly image: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#name ContainerGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#secure_environment_variables ContainerGroup#secure_environment_variables}
    */
    readonly secureEnvironmentVariables?: {
        [key: string]: string;
    };
    /**
    * security block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#security ContainerGroup#security}
    */
    readonly security?: ContainerGroupInitContainerSecurity[] | cdktf.IResolvable;
    /**
    * volume block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#volume ContainerGroup#volume}
    */
    readonly volume?: ContainerGroupInitContainerVolume[] | cdktf.IResolvable;
}
export declare function containerGroupInitContainerToTerraform(struct?: ContainerGroupInitContainer | cdktf.IResolvable): any;
export declare function containerGroupInitContainerToHclTerraform(struct?: ContainerGroupInitContainer | cdktf.IResolvable): any;
export declare class ContainerGroupInitContainerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerGroupInitContainer | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerGroupInitContainer | cdktf.IResolvable | undefined);
    private _commands?;
    get commands(): string[];
    set commands(value: string[]);
    resetCommands(): void;
    get commandsInput(): string[] | undefined;
    private _environmentVariables?;
    get environmentVariables(): {
        [key: string]: string;
    };
    set environmentVariables(value: {
        [key: string]: string;
    });
    resetEnvironmentVariables(): void;
    get environmentVariablesInput(): {
        [key: string]: string;
    } | undefined;
    private _image?;
    get image(): string;
    set image(value: string);
    get imageInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _secureEnvironmentVariables?;
    get secureEnvironmentVariables(): {
        [key: string]: string;
    };
    set secureEnvironmentVariables(value: {
        [key: string]: string;
    });
    resetSecureEnvironmentVariables(): void;
    get secureEnvironmentVariablesInput(): {
        [key: string]: string;
    } | undefined;
    private _security;
    get security(): ContainerGroupInitContainerSecurityList;
    putSecurity(value: ContainerGroupInitContainerSecurity[] | cdktf.IResolvable): void;
    resetSecurity(): void;
    get securityInput(): cdktf.IResolvable | ContainerGroupInitContainerSecurity[] | undefined;
    private _volume;
    get volume(): ContainerGroupInitContainerVolumeList;
    putVolume(value: ContainerGroupInitContainerVolume[] | cdktf.IResolvable): void;
    resetVolume(): void;
    get volumeInput(): cdktf.IResolvable | ContainerGroupInitContainerVolume[] | undefined;
}
export declare class ContainerGroupInitContainerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerGroupInitContainer[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerGroupInitContainerOutputReference;
}
export interface ContainerGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#create ContainerGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#delete ContainerGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#read ContainerGroup#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#update ContainerGroup#update}
    */
    readonly update?: string;
}
export declare function containerGroupTimeoutsToTerraform(struct?: ContainerGroupTimeouts | cdktf.IResolvable): any;
export declare function containerGroupTimeoutsToHclTerraform(struct?: ContainerGroupTimeouts | cdktf.IResolvable): any;
export declare class ContainerGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerGroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group azurerm_container_group}
*/
export declare class ContainerGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_container_group";
    /**
    * Generates CDKTF code for importing a ContainerGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ContainerGroup to import
    * @param importFromId The id of the existing ContainerGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ContainerGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_group azurerm_container_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerGroupConfig
    */
    constructor(scope: Construct, id: string, config: ContainerGroupConfig);
    private _dnsNameLabel?;
    get dnsNameLabel(): string;
    set dnsNameLabel(value: string);
    resetDnsNameLabel(): void;
    get dnsNameLabelInput(): string | undefined;
    private _dnsNameLabelReusePolicy?;
    get dnsNameLabelReusePolicy(): string;
    set dnsNameLabelReusePolicy(value: string);
    resetDnsNameLabelReusePolicy(): void;
    get dnsNameLabelReusePolicyInput(): string | undefined;
    private _exposedPort;
    get exposedPort(): ContainerGroupExposedPortList;
    putExposedPort(value: ContainerGroupExposedPort[] | cdktf.IResolvable): void;
    resetExposedPort(): void;
    get exposedPortInput(): cdktf.IResolvable | ContainerGroupExposedPort[] | undefined;
    get fqdn(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get ipAddress(): string;
    private _ipAddressType?;
    get ipAddressType(): string;
    set ipAddressType(value: string);
    resetIpAddressType(): void;
    get ipAddressTypeInput(): string | undefined;
    private _keyVaultKeyId?;
    get keyVaultKeyId(): string;
    set keyVaultKeyId(value: string);
    resetKeyVaultKeyId(): void;
    get keyVaultKeyIdInput(): string | undefined;
    private _keyVaultUserAssignedIdentityId?;
    get keyVaultUserAssignedIdentityId(): string;
    set keyVaultUserAssignedIdentityId(value: string);
    resetKeyVaultUserAssignedIdentityId(): void;
    get keyVaultUserAssignedIdentityIdInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkProfileId?;
    get networkProfileId(): string;
    set networkProfileId(value: string);
    resetNetworkProfileId(): void;
    get networkProfileIdInput(): string | undefined;
    private _osType?;
    get osType(): string;
    set osType(value: string);
    get osTypeInput(): string | undefined;
    private _priority?;
    get priority(): string;
    set priority(value: string);
    resetPriority(): void;
    get priorityInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _restartPolicy?;
    get restartPolicy(): string;
    set restartPolicy(value: string);
    resetRestartPolicy(): void;
    get restartPolicyInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    resetSku(): void;
    get skuInput(): string | undefined;
    private _subnetIds?;
    get subnetIds(): string[];
    set subnetIds(value: string[]);
    resetSubnetIds(): void;
    get subnetIdsInput(): string[] | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
    private _container;
    get container(): ContainerGroupContainerList;
    putContainer(value: ContainerGroupContainer[] | cdktf.IResolvable): void;
    get containerInput(): cdktf.IResolvable | ContainerGroupContainer[] | undefined;
    private _diagnostics;
    get diagnostics(): ContainerGroupDiagnosticsOutputReference;
    putDiagnostics(value: ContainerGroupDiagnostics): void;
    resetDiagnostics(): void;
    get diagnosticsInput(): ContainerGroupDiagnostics | undefined;
    private _dnsConfig;
    get dnsConfig(): ContainerGroupDnsConfigOutputReference;
    putDnsConfig(value: ContainerGroupDnsConfig): void;
    resetDnsConfig(): void;
    get dnsConfigInput(): ContainerGroupDnsConfig | undefined;
    private _identity;
    get identity(): ContainerGroupIdentityOutputReference;
    putIdentity(value: ContainerGroupIdentity): void;
    resetIdentity(): void;
    get identityInput(): ContainerGroupIdentity | undefined;
    private _imageRegistryCredential;
    get imageRegistryCredential(): ContainerGroupImageRegistryCredentialList;
    putImageRegistryCredential(value: ContainerGroupImageRegistryCredential[] | cdktf.IResolvable): void;
    resetImageRegistryCredential(): void;
    get imageRegistryCredentialInput(): cdktf.IResolvable | ContainerGroupImageRegistryCredential[] | undefined;
    private _initContainer;
    get initContainer(): ContainerGroupInitContainerList;
    putInitContainer(value: ContainerGroupInitContainer[] | cdktf.IResolvable): void;
    resetInitContainer(): void;
    get initContainerInput(): cdktf.IResolvable | ContainerGroupInitContainer[] | undefined;
    private _timeouts;
    get timeouts(): ContainerGroupTimeoutsOutputReference;
    putTimeouts(value: ContainerGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ContainerGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
