/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerRegistryCacheRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_registry_cache_rule#container_registry_id ContainerRegistryCacheRule#container_registry_id}
    */
    readonly containerRegistryId: string;
    /**
    * The ARM resource ID of the credential store which is associated with the cache rule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_registry_cache_rule#credential_set_id ContainerRegistryCacheRule#credential_set_id}
    */
    readonly credentialSetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_registry_cache_rule#id ContainerRegistryCacheRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the cache rule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_registry_cache_rule#name ContainerRegistryCacheRule#name}
    */
    readonly name: string;
    /**
    * The full source repository path such as 'docker.io/library/ubuntu'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_registry_cache_rule#source_repo ContainerRegistryCacheRule#source_repo}
    */
    readonly sourceRepo: string;
    /**
    * The target repository namespace such as 'ubuntu'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_registry_cache_rule#target_repo ContainerRegistryCacheRule#target_repo}
    */
    readonly targetRepo: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_registry_cache_rule#timeouts ContainerRegistryCacheRule#timeouts}
    */
    readonly timeouts?: ContainerRegistryCacheRuleTimeouts;
}
export interface ContainerRegistryCacheRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_registry_cache_rule#create ContainerRegistryCacheRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_registry_cache_rule#delete ContainerRegistryCacheRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_registry_cache_rule#read ContainerRegistryCacheRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_registry_cache_rule#update ContainerRegistryCacheRule#update}
    */
    readonly update?: string;
}
export declare function containerRegistryCacheRuleTimeoutsToTerraform(struct?: ContainerRegistryCacheRuleTimeouts | cdktf.IResolvable): any;
export declare function containerRegistryCacheRuleTimeoutsToHclTerraform(struct?: ContainerRegistryCacheRuleTimeouts | cdktf.IResolvable): any;
export declare class ContainerRegistryCacheRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerRegistryCacheRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerRegistryCacheRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_registry_cache_rule azurerm_container_registry_cache_rule}
*/
export declare class ContainerRegistryCacheRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_container_registry_cache_rule";
    /**
    * Generates CDKTF code for importing a ContainerRegistryCacheRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ContainerRegistryCacheRule to import
    * @param importFromId The id of the existing ContainerRegistryCacheRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_registry_cache_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ContainerRegistryCacheRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/container_registry_cache_rule azurerm_container_registry_cache_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerRegistryCacheRuleConfig
    */
    constructor(scope: Construct, id: string, config: ContainerRegistryCacheRuleConfig);
    private _containerRegistryId?;
    get containerRegistryId(): string;
    set containerRegistryId(value: string);
    get containerRegistryIdInput(): string | undefined;
    private _credentialSetId?;
    get credentialSetId(): string;
    set credentialSetId(value: string);
    resetCredentialSetId(): void;
    get credentialSetIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sourceRepo?;
    get sourceRepo(): string;
    set sourceRepo(value: string);
    get sourceRepoInput(): string | undefined;
    private _targetRepo?;
    get targetRepo(): string;
    set targetRepo(value: string);
    get targetRepoInput(): string | undefined;
    private _timeouts;
    get timeouts(): ContainerRegistryCacheRuleTimeoutsOutputReference;
    putTimeouts(value: ContainerRegistryCacheRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ContainerRegistryCacheRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
