/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CosmosdbSqlRoleDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/cosmosdb_sql_role_definition#account_name CosmosdbSqlRoleDefinition#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/cosmosdb_sql_role_definition#assignable_scopes CosmosdbSqlRoleDefinition#assignable_scopes}
    */
    readonly assignableScopes: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/cosmosdb_sql_role_definition#id CosmosdbSqlRoleDefinition#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/cosmosdb_sql_role_definition#name CosmosdbSqlRoleDefinition#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/cosmosdb_sql_role_definition#resource_group_name CosmosdbSqlRoleDefinition#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/cosmosdb_sql_role_definition#role_definition_id CosmosdbSqlRoleDefinition#role_definition_id}
    */
    readonly roleDefinitionId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/cosmosdb_sql_role_definition#type CosmosdbSqlRoleDefinition#type}
    */
    readonly type?: string;
    /**
    * permissions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/cosmosdb_sql_role_definition#permissions CosmosdbSqlRoleDefinition#permissions}
    */
    readonly permissions: CosmosdbSqlRoleDefinitionPermissions[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/cosmosdb_sql_role_definition#timeouts CosmosdbSqlRoleDefinition#timeouts}
    */
    readonly timeouts?: CosmosdbSqlRoleDefinitionTimeouts;
}
export interface CosmosdbSqlRoleDefinitionPermissions {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/cosmosdb_sql_role_definition#data_actions CosmosdbSqlRoleDefinition#data_actions}
    */
    readonly dataActions: string[];
}
export declare function cosmosdbSqlRoleDefinitionPermissionsToTerraform(struct?: CosmosdbSqlRoleDefinitionPermissions | cdktf.IResolvable): any;
export declare function cosmosdbSqlRoleDefinitionPermissionsToHclTerraform(struct?: CosmosdbSqlRoleDefinitionPermissions | cdktf.IResolvable): any;
export declare class CosmosdbSqlRoleDefinitionPermissionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CosmosdbSqlRoleDefinitionPermissions | cdktf.IResolvable | undefined;
    set internalValue(value: CosmosdbSqlRoleDefinitionPermissions | cdktf.IResolvable | undefined);
    private _dataActions?;
    get dataActions(): string[];
    set dataActions(value: string[]);
    get dataActionsInput(): string[] | undefined;
}
export declare class CosmosdbSqlRoleDefinitionPermissionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CosmosdbSqlRoleDefinitionPermissions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CosmosdbSqlRoleDefinitionPermissionsOutputReference;
}
export interface CosmosdbSqlRoleDefinitionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/cosmosdb_sql_role_definition#create CosmosdbSqlRoleDefinition#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/cosmosdb_sql_role_definition#delete CosmosdbSqlRoleDefinition#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/cosmosdb_sql_role_definition#read CosmosdbSqlRoleDefinition#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/cosmosdb_sql_role_definition#update CosmosdbSqlRoleDefinition#update}
    */
    readonly update?: string;
}
export declare function cosmosdbSqlRoleDefinitionTimeoutsToTerraform(struct?: CosmosdbSqlRoleDefinitionTimeouts | cdktf.IResolvable): any;
export declare function cosmosdbSqlRoleDefinitionTimeoutsToHclTerraform(struct?: CosmosdbSqlRoleDefinitionTimeouts | cdktf.IResolvable): any;
export declare class CosmosdbSqlRoleDefinitionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CosmosdbSqlRoleDefinitionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CosmosdbSqlRoleDefinitionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/cosmosdb_sql_role_definition azurerm_cosmosdb_sql_role_definition}
*/
export declare class CosmosdbSqlRoleDefinition extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_cosmosdb_sql_role_definition";
    /**
    * Generates CDKTF code for importing a CosmosdbSqlRoleDefinition resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CosmosdbSqlRoleDefinition to import
    * @param importFromId The id of the existing CosmosdbSqlRoleDefinition that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/cosmosdb_sql_role_definition#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CosmosdbSqlRoleDefinition to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/cosmosdb_sql_role_definition azurerm_cosmosdb_sql_role_definition} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CosmosdbSqlRoleDefinitionConfig
    */
    constructor(scope: Construct, id: string, config: CosmosdbSqlRoleDefinitionConfig);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _assignableScopes?;
    get assignableScopes(): string[];
    set assignableScopes(value: string[]);
    get assignableScopesInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _roleDefinitionId?;
    get roleDefinitionId(): string;
    set roleDefinitionId(value: string);
    resetRoleDefinitionId(): void;
    get roleDefinitionIdInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _permissions;
    get permissions(): CosmosdbSqlRoleDefinitionPermissionsList;
    putPermissions(value: CosmosdbSqlRoleDefinitionPermissions[] | cdktf.IResolvable): void;
    get permissionsInput(): cdktf.IResolvable | CosmosdbSqlRoleDefinitionPermissions[] | undefined;
    private _timeouts;
    get timeouts(): CosmosdbSqlRoleDefinitionTimeoutsOutputReference;
    putTimeouts(value: CosmosdbSqlRoleDefinitionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CosmosdbSqlRoleDefinitionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
