/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermAppServiceEnvironmentV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/app_service_environment_v3#id DataAzurermAppServiceEnvironmentV3#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/app_service_environment_v3#name DataAzurermAppServiceEnvironmentV3#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/app_service_environment_v3#resource_group_name DataAzurermAppServiceEnvironmentV3#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/app_service_environment_v3#timeouts DataAzurermAppServiceEnvironmentV3#timeouts}
    */
    readonly timeouts?: DataAzurermAppServiceEnvironmentV3Timeouts;
}
export interface DataAzurermAppServiceEnvironmentV3ClusterSetting {
}
export declare function dataAzurermAppServiceEnvironmentV3ClusterSettingToTerraform(struct?: DataAzurermAppServiceEnvironmentV3ClusterSetting): any;
export declare function dataAzurermAppServiceEnvironmentV3ClusterSettingToHclTerraform(struct?: DataAzurermAppServiceEnvironmentV3ClusterSetting): any;
export declare class DataAzurermAppServiceEnvironmentV3ClusterSettingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAppServiceEnvironmentV3ClusterSetting | undefined;
    set internalValue(value: DataAzurermAppServiceEnvironmentV3ClusterSetting | undefined);
    get name(): string;
    get value(): string;
}
export declare class DataAzurermAppServiceEnvironmentV3ClusterSettingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAppServiceEnvironmentV3ClusterSettingOutputReference;
}
export interface DataAzurermAppServiceEnvironmentV3InboundNetworkDependencies {
}
export declare function dataAzurermAppServiceEnvironmentV3InboundNetworkDependenciesToTerraform(struct?: DataAzurermAppServiceEnvironmentV3InboundNetworkDependencies): any;
export declare function dataAzurermAppServiceEnvironmentV3InboundNetworkDependenciesToHclTerraform(struct?: DataAzurermAppServiceEnvironmentV3InboundNetworkDependencies): any;
export declare class DataAzurermAppServiceEnvironmentV3InboundNetworkDependenciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAppServiceEnvironmentV3InboundNetworkDependencies | undefined;
    set internalValue(value: DataAzurermAppServiceEnvironmentV3InboundNetworkDependencies | undefined);
    get description(): string;
    get ipAddresses(): string[];
    get ports(): string[];
}
export declare class DataAzurermAppServiceEnvironmentV3InboundNetworkDependenciesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAppServiceEnvironmentV3InboundNetworkDependenciesOutputReference;
}
export interface DataAzurermAppServiceEnvironmentV3Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/app_service_environment_v3#read DataAzurermAppServiceEnvironmentV3#read}
    */
    readonly read?: string;
}
export declare function dataAzurermAppServiceEnvironmentV3TimeoutsToTerraform(struct?: DataAzurermAppServiceEnvironmentV3Timeouts | cdktf.IResolvable): any;
export declare function dataAzurermAppServiceEnvironmentV3TimeoutsToHclTerraform(struct?: DataAzurermAppServiceEnvironmentV3Timeouts | cdktf.IResolvable): any;
export declare class DataAzurermAppServiceEnvironmentV3TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermAppServiceEnvironmentV3Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermAppServiceEnvironmentV3Timeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/app_service_environment_v3 azurerm_app_service_environment_v3}
*/
export declare class DataAzurermAppServiceEnvironmentV3 extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_app_service_environment_v3";
    /**
    * Generates CDKTF code for importing a DataAzurermAppServiceEnvironmentV3 resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermAppServiceEnvironmentV3 to import
    * @param importFromId The id of the existing DataAzurermAppServiceEnvironmentV3 that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/app_service_environment_v3#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermAppServiceEnvironmentV3 to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/app_service_environment_v3 azurerm_app_service_environment_v3} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermAppServiceEnvironmentV3Config
    */
    constructor(scope: Construct, id: string, config: DataAzurermAppServiceEnvironmentV3Config);
    get allowNewPrivateEndpointConnections(): cdktf.IResolvable;
    private _clusterSetting;
    get clusterSetting(): DataAzurermAppServiceEnvironmentV3ClusterSettingList;
    get dedicatedHostCount(): number;
    get dnsSuffix(): string;
    get externalInboundIpAddresses(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _inboundNetworkDependencies;
    get inboundNetworkDependencies(): DataAzurermAppServiceEnvironmentV3InboundNetworkDependenciesList;
    get internalInboundIpAddresses(): string[];
    get internalLoadBalancingMode(): string;
    get ipSslAddressCount(): number;
    get linuxOutboundIpAddresses(): string[];
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get pricingTier(): string;
    get remoteDebuggingEnabled(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get subnetId(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get windowsOutboundIpAddresses(): string[];
    get zoneRedundant(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermAppServiceEnvironmentV3TimeoutsOutputReference;
    putTimeouts(value: DataAzurermAppServiceEnvironmentV3Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermAppServiceEnvironmentV3Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
