/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermCommunicationServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/communication_service#id DataAzurermCommunicationService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/communication_service#name DataAzurermCommunicationService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/communication_service#resource_group_name DataAzurermCommunicationService#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/communication_service#timeouts DataAzurermCommunicationService#timeouts}
    */
    readonly timeouts?: DataAzurermCommunicationServiceTimeouts;
}
export interface DataAzurermCommunicationServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/communication_service#read DataAzurermCommunicationService#read}
    */
    readonly read?: string;
}
export declare function dataAzurermCommunicationServiceTimeoutsToTerraform(struct?: DataAzurermCommunicationServiceTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermCommunicationServiceTimeoutsToHclTerraform(struct?: DataAzurermCommunicationServiceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermCommunicationServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermCommunicationServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermCommunicationServiceTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/communication_service azurerm_communication_service}
*/
export declare class DataAzurermCommunicationService extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_communication_service";
    /**
    * Generates CDKTF code for importing a DataAzurermCommunicationService resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermCommunicationService to import
    * @param importFromId The id of the existing DataAzurermCommunicationService that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/communication_service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermCommunicationService to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/communication_service azurerm_communication_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermCommunicationServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermCommunicationServiceConfig);
    get dataLocation(): string;
    get hostname(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get primaryConnectionString(): string;
    get primaryKey(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryConnectionString(): string;
    get secondaryKey(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermCommunicationServiceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermCommunicationServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermCommunicationServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
