/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDedicatedHostConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/dedicated_host#dedicated_host_group_name DataAzurermDedicatedHost#dedicated_host_group_name}
    */
    readonly dedicatedHostGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/dedicated_host#id DataAzurermDedicatedHost#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/dedicated_host#name DataAzurermDedicatedHost#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/dedicated_host#resource_group_name DataAzurermDedicatedHost#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/dedicated_host#timeouts DataAzurermDedicatedHost#timeouts}
    */
    readonly timeouts?: DataAzurermDedicatedHostTimeouts;
}
export interface DataAzurermDedicatedHostTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/dedicated_host#read DataAzurermDedicatedHost#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDedicatedHostTimeoutsToTerraform(struct?: DataAzurermDedicatedHostTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermDedicatedHostTimeoutsToHclTerraform(struct?: DataAzurermDedicatedHostTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDedicatedHostTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDedicatedHostTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermDedicatedHostTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/dedicated_host azurerm_dedicated_host}
*/
export declare class DataAzurermDedicatedHost extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_dedicated_host";
    /**
    * Generates CDKTF code for importing a DataAzurermDedicatedHost resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermDedicatedHost to import
    * @param importFromId The id of the existing DataAzurermDedicatedHost that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/dedicated_host#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermDedicatedHost to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/dedicated_host azurerm_dedicated_host} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDedicatedHostConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDedicatedHostConfig);
    private _dedicatedHostGroupName?;
    get dedicatedHostGroupName(): string;
    set dedicatedHostGroupName(value: string);
    get dedicatedHostGroupNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermDedicatedHostTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDedicatedHostTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermDedicatedHostTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
