/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermElasticSanVolumeGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/elastic_san_volume_group#elastic_san_id DataAzurermElasticSanVolumeGroup#elastic_san_id}
    */
    readonly elasticSanId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/elastic_san_volume_group#id DataAzurermElasticSanVolumeGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/elastic_san_volume_group#name DataAzurermElasticSanVolumeGroup#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/elastic_san_volume_group#timeouts DataAzurermElasticSanVolumeGroup#timeouts}
    */
    readonly timeouts?: DataAzurermElasticSanVolumeGroupTimeouts;
}
export interface DataAzurermElasticSanVolumeGroupEncryption {
}
export declare function dataAzurermElasticSanVolumeGroupEncryptionToTerraform(struct?: DataAzurermElasticSanVolumeGroupEncryption): any;
export declare function dataAzurermElasticSanVolumeGroupEncryptionToHclTerraform(struct?: DataAzurermElasticSanVolumeGroupEncryption): any;
export declare class DataAzurermElasticSanVolumeGroupEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermElasticSanVolumeGroupEncryption | undefined;
    set internalValue(value: DataAzurermElasticSanVolumeGroupEncryption | undefined);
    get currentVersionedKeyExpirationTimestamp(): string;
    get currentVersionedKeyId(): string;
    get keyVaultKeyId(): string;
    get lastKeyRotationTimestamp(): string;
    get userAssignedIdentityId(): string;
}
export declare class DataAzurermElasticSanVolumeGroupEncryptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermElasticSanVolumeGroupEncryptionOutputReference;
}
export interface DataAzurermElasticSanVolumeGroupIdentity {
}
export declare function dataAzurermElasticSanVolumeGroupIdentityToTerraform(struct?: DataAzurermElasticSanVolumeGroupIdentity): any;
export declare function dataAzurermElasticSanVolumeGroupIdentityToHclTerraform(struct?: DataAzurermElasticSanVolumeGroupIdentity): any;
export declare class DataAzurermElasticSanVolumeGroupIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermElasticSanVolumeGroupIdentity | undefined;
    set internalValue(value: DataAzurermElasticSanVolumeGroupIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermElasticSanVolumeGroupIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermElasticSanVolumeGroupIdentityOutputReference;
}
export interface DataAzurermElasticSanVolumeGroupNetworkRule {
}
export declare function dataAzurermElasticSanVolumeGroupNetworkRuleToTerraform(struct?: DataAzurermElasticSanVolumeGroupNetworkRule): any;
export declare function dataAzurermElasticSanVolumeGroupNetworkRuleToHclTerraform(struct?: DataAzurermElasticSanVolumeGroupNetworkRule): any;
export declare class DataAzurermElasticSanVolumeGroupNetworkRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermElasticSanVolumeGroupNetworkRule | undefined;
    set internalValue(value: DataAzurermElasticSanVolumeGroupNetworkRule | undefined);
    get action(): string;
    get subnetId(): string;
}
export declare class DataAzurermElasticSanVolumeGroupNetworkRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermElasticSanVolumeGroupNetworkRuleOutputReference;
}
export interface DataAzurermElasticSanVolumeGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/elastic_san_volume_group#read DataAzurermElasticSanVolumeGroup#read}
    */
    readonly read?: string;
}
export declare function dataAzurermElasticSanVolumeGroupTimeoutsToTerraform(struct?: DataAzurermElasticSanVolumeGroupTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermElasticSanVolumeGroupTimeoutsToHclTerraform(struct?: DataAzurermElasticSanVolumeGroupTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermElasticSanVolumeGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermElasticSanVolumeGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermElasticSanVolumeGroupTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/elastic_san_volume_group azurerm_elastic_san_volume_group}
*/
export declare class DataAzurermElasticSanVolumeGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_elastic_san_volume_group";
    /**
    * Generates CDKTF code for importing a DataAzurermElasticSanVolumeGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermElasticSanVolumeGroup to import
    * @param importFromId The id of the existing DataAzurermElasticSanVolumeGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/elastic_san_volume_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermElasticSanVolumeGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/elastic_san_volume_group azurerm_elastic_san_volume_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermElasticSanVolumeGroupConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermElasticSanVolumeGroupConfig);
    private _elasticSanId?;
    get elasticSanId(): string;
    set elasticSanId(value: string);
    get elasticSanIdInput(): string | undefined;
    private _encryption;
    get encryption(): DataAzurermElasticSanVolumeGroupEncryptionList;
    get encryptionType(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermElasticSanVolumeGroupIdentityList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkRule;
    get networkRule(): DataAzurermElasticSanVolumeGroupNetworkRuleList;
    get protocolType(): string;
    private _timeouts;
    get timeouts(): DataAzurermElasticSanVolumeGroupTimeoutsOutputReference;
    putTimeouts(value: DataAzurermElasticSanVolumeGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermElasticSanVolumeGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
