/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermKeyVaultCertificatesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/key_vault_certificates#id DataAzurermKeyVaultCertificates#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/key_vault_certificates#include_pending DataAzurermKeyVaultCertificates#include_pending}
    */
    readonly includePending?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/key_vault_certificates#key_vault_id DataAzurermKeyVaultCertificates#key_vault_id}
    */
    readonly keyVaultId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/key_vault_certificates#timeouts DataAzurermKeyVaultCertificates#timeouts}
    */
    readonly timeouts?: DataAzurermKeyVaultCertificatesTimeouts;
}
export interface DataAzurermKeyVaultCertificatesCertificates {
}
export declare function dataAzurermKeyVaultCertificatesCertificatesToTerraform(struct?: DataAzurermKeyVaultCertificatesCertificates): any;
export declare function dataAzurermKeyVaultCertificatesCertificatesToHclTerraform(struct?: DataAzurermKeyVaultCertificatesCertificates): any;
export declare class DataAzurermKeyVaultCertificatesCertificatesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKeyVaultCertificatesCertificates | undefined;
    set internalValue(value: DataAzurermKeyVaultCertificatesCertificates | undefined);
    get enabled(): cdktf.IResolvable;
    get id(): string;
    get name(): string;
    private _tags;
    get tags(): cdktf.StringMap;
}
export declare class DataAzurermKeyVaultCertificatesCertificatesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKeyVaultCertificatesCertificatesOutputReference;
}
export interface DataAzurermKeyVaultCertificatesTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/key_vault_certificates#read DataAzurermKeyVaultCertificates#read}
    */
    readonly read?: string;
}
export declare function dataAzurermKeyVaultCertificatesTimeoutsToTerraform(struct?: DataAzurermKeyVaultCertificatesTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermKeyVaultCertificatesTimeoutsToHclTerraform(struct?: DataAzurermKeyVaultCertificatesTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermKeyVaultCertificatesTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermKeyVaultCertificatesTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermKeyVaultCertificatesTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/key_vault_certificates azurerm_key_vault_certificates}
*/
export declare class DataAzurermKeyVaultCertificates extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_key_vault_certificates";
    /**
    * Generates CDKTF code for importing a DataAzurermKeyVaultCertificates resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermKeyVaultCertificates to import
    * @param importFromId The id of the existing DataAzurermKeyVaultCertificates that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/key_vault_certificates#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermKeyVaultCertificates to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/key_vault_certificates azurerm_key_vault_certificates} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermKeyVaultCertificatesConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermKeyVaultCertificatesConfig);
    private _certificates;
    get certificates(): DataAzurermKeyVaultCertificatesCertificatesList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _includePending?;
    get includePending(): boolean | cdktf.IResolvable;
    set includePending(value: boolean | cdktf.IResolvable);
    resetIncludePending(): void;
    get includePendingInput(): boolean | cdktf.IResolvable | undefined;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
    get names(): string[];
    private _timeouts;
    get timeouts(): DataAzurermKeyVaultCertificatesTimeoutsOutputReference;
    putTimeouts(value: DataAzurermKeyVaultCertificatesTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermKeyVaultCertificatesTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
