/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermKubernetesClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/kubernetes_cluster#id DataAzurermKubernetesCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/kubernetes_cluster#name DataAzurermKubernetesCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/kubernetes_cluster#resource_group_name DataAzurermKubernetesCluster#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/kubernetes_cluster#timeouts DataAzurermKubernetesCluster#timeouts}
    */
    readonly timeouts?: DataAzurermKubernetesClusterTimeouts;
}
export interface DataAzurermKubernetesClusterAciConnectorLinux {
}
export declare function dataAzurermKubernetesClusterAciConnectorLinuxToTerraform(struct?: DataAzurermKubernetesClusterAciConnectorLinux): any;
export declare function dataAzurermKubernetesClusterAciConnectorLinuxToHclTerraform(struct?: DataAzurermKubernetesClusterAciConnectorLinux): any;
export declare class DataAzurermKubernetesClusterAciConnectorLinuxOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterAciConnectorLinux | undefined;
    set internalValue(value: DataAzurermKubernetesClusterAciConnectorLinux | undefined);
    get subnetName(): string;
}
export declare class DataAzurermKubernetesClusterAciConnectorLinuxList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterAciConnectorLinuxOutputReference;
}
export interface DataAzurermKubernetesClusterAgentPoolProfileUpgradeSettings {
}
export declare function dataAzurermKubernetesClusterAgentPoolProfileUpgradeSettingsToTerraform(struct?: DataAzurermKubernetesClusterAgentPoolProfileUpgradeSettings): any;
export declare function dataAzurermKubernetesClusterAgentPoolProfileUpgradeSettingsToHclTerraform(struct?: DataAzurermKubernetesClusterAgentPoolProfileUpgradeSettings): any;
export declare class DataAzurermKubernetesClusterAgentPoolProfileUpgradeSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterAgentPoolProfileUpgradeSettings | undefined;
    set internalValue(value: DataAzurermKubernetesClusterAgentPoolProfileUpgradeSettings | undefined);
    get drainTimeoutInMinutes(): number;
    get maxSurge(): string;
    get nodeSoakDurationInMinutes(): number;
}
export declare class DataAzurermKubernetesClusterAgentPoolProfileUpgradeSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterAgentPoolProfileUpgradeSettingsOutputReference;
}
export interface DataAzurermKubernetesClusterAgentPoolProfile {
}
export declare function dataAzurermKubernetesClusterAgentPoolProfileToTerraform(struct?: DataAzurermKubernetesClusterAgentPoolProfile): any;
export declare function dataAzurermKubernetesClusterAgentPoolProfileToHclTerraform(struct?: DataAzurermKubernetesClusterAgentPoolProfile): any;
export declare class DataAzurermKubernetesClusterAgentPoolProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterAgentPoolProfile | undefined;
    set internalValue(value: DataAzurermKubernetesClusterAgentPoolProfile | undefined);
    get autoScalingEnabled(): cdktf.IResolvable;
    get count(): number;
    get maxCount(): number;
    get maxPods(): number;
    get minCount(): number;
    get name(): string;
    private _nodeLabels;
    get nodeLabels(): cdktf.StringMap;
    get nodePublicIpEnabled(): cdktf.IResolvable;
    get nodePublicIpPrefixId(): string;
    get nodeTaints(): string[];
    get orchestratorVersion(): string;
    get osDiskSizeGb(): number;
    get osType(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get type(): string;
    private _upgradeSettings;
    get upgradeSettings(): DataAzurermKubernetesClusterAgentPoolProfileUpgradeSettingsList;
    get vmSize(): string;
    get vnetSubnetId(): string;
    get zones(): string[];
}
export declare class DataAzurermKubernetesClusterAgentPoolProfileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterAgentPoolProfileOutputReference;
}
export interface DataAzurermKubernetesClusterAzureActiveDirectoryRoleBasedAccessControl {
}
export declare function dataAzurermKubernetesClusterAzureActiveDirectoryRoleBasedAccessControlToTerraform(struct?: DataAzurermKubernetesClusterAzureActiveDirectoryRoleBasedAccessControl): any;
export declare function dataAzurermKubernetesClusterAzureActiveDirectoryRoleBasedAccessControlToHclTerraform(struct?: DataAzurermKubernetesClusterAzureActiveDirectoryRoleBasedAccessControl): any;
export declare class DataAzurermKubernetesClusterAzureActiveDirectoryRoleBasedAccessControlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterAzureActiveDirectoryRoleBasedAccessControl | undefined;
    set internalValue(value: DataAzurermKubernetesClusterAzureActiveDirectoryRoleBasedAccessControl | undefined);
    get adminGroupObjectIds(): string[];
    get azureRbacEnabled(): cdktf.IResolvable;
    get tenantId(): string;
}
export declare class DataAzurermKubernetesClusterAzureActiveDirectoryRoleBasedAccessControlList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterAzureActiveDirectoryRoleBasedAccessControlOutputReference;
}
export interface DataAzurermKubernetesClusterIdentity {
}
export declare function dataAzurermKubernetesClusterIdentityToTerraform(struct?: DataAzurermKubernetesClusterIdentity): any;
export declare function dataAzurermKubernetesClusterIdentityToHclTerraform(struct?: DataAzurermKubernetesClusterIdentity): any;
export declare class DataAzurermKubernetesClusterIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterIdentity | undefined;
    set internalValue(value: DataAzurermKubernetesClusterIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermKubernetesClusterIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterIdentityOutputReference;
}
export interface DataAzurermKubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentity {
}
export declare function dataAzurermKubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentityToTerraform(struct?: DataAzurermKubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentity): any;
export declare function dataAzurermKubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentityToHclTerraform(struct?: DataAzurermKubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentity): any;
export declare class DataAzurermKubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentity | undefined;
    set internalValue(value: DataAzurermKubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentity | undefined);
    get clientId(): string;
    get objectId(): string;
    get userAssignedIdentityId(): string;
}
export declare class DataAzurermKubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentityOutputReference;
}
export interface DataAzurermKubernetesClusterIngressApplicationGateway {
}
export declare function dataAzurermKubernetesClusterIngressApplicationGatewayToTerraform(struct?: DataAzurermKubernetesClusterIngressApplicationGateway): any;
export declare function dataAzurermKubernetesClusterIngressApplicationGatewayToHclTerraform(struct?: DataAzurermKubernetesClusterIngressApplicationGateway): any;
export declare class DataAzurermKubernetesClusterIngressApplicationGatewayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterIngressApplicationGateway | undefined;
    set internalValue(value: DataAzurermKubernetesClusterIngressApplicationGateway | undefined);
    get effectiveGatewayId(): string;
    get gatewayId(): string;
    get gatewayName(): string;
    private _ingressApplicationGatewayIdentity;
    get ingressApplicationGatewayIdentity(): DataAzurermKubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentityList;
    get subnetCidr(): string;
    get subnetId(): string;
}
export declare class DataAzurermKubernetesClusterIngressApplicationGatewayList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterIngressApplicationGatewayOutputReference;
}
export interface DataAzurermKubernetesClusterKeyManagementService {
}
export declare function dataAzurermKubernetesClusterKeyManagementServiceToTerraform(struct?: DataAzurermKubernetesClusterKeyManagementService): any;
export declare function dataAzurermKubernetesClusterKeyManagementServiceToHclTerraform(struct?: DataAzurermKubernetesClusterKeyManagementService): any;
export declare class DataAzurermKubernetesClusterKeyManagementServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterKeyManagementService | undefined;
    set internalValue(value: DataAzurermKubernetesClusterKeyManagementService | undefined);
    get keyVaultKeyId(): string;
    get keyVaultNetworkAccess(): string;
}
export declare class DataAzurermKubernetesClusterKeyManagementServiceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterKeyManagementServiceOutputReference;
}
export interface DataAzurermKubernetesClusterKeyVaultSecretsProviderSecretIdentity {
}
export declare function dataAzurermKubernetesClusterKeyVaultSecretsProviderSecretIdentityToTerraform(struct?: DataAzurermKubernetesClusterKeyVaultSecretsProviderSecretIdentity): any;
export declare function dataAzurermKubernetesClusterKeyVaultSecretsProviderSecretIdentityToHclTerraform(struct?: DataAzurermKubernetesClusterKeyVaultSecretsProviderSecretIdentity): any;
export declare class DataAzurermKubernetesClusterKeyVaultSecretsProviderSecretIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterKeyVaultSecretsProviderSecretIdentity | undefined;
    set internalValue(value: DataAzurermKubernetesClusterKeyVaultSecretsProviderSecretIdentity | undefined);
    get clientId(): string;
    get objectId(): string;
    get userAssignedIdentityId(): string;
}
export declare class DataAzurermKubernetesClusterKeyVaultSecretsProviderSecretIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterKeyVaultSecretsProviderSecretIdentityOutputReference;
}
export interface DataAzurermKubernetesClusterKeyVaultSecretsProvider {
}
export declare function dataAzurermKubernetesClusterKeyVaultSecretsProviderToTerraform(struct?: DataAzurermKubernetesClusterKeyVaultSecretsProvider): any;
export declare function dataAzurermKubernetesClusterKeyVaultSecretsProviderToHclTerraform(struct?: DataAzurermKubernetesClusterKeyVaultSecretsProvider): any;
export declare class DataAzurermKubernetesClusterKeyVaultSecretsProviderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterKeyVaultSecretsProvider | undefined;
    set internalValue(value: DataAzurermKubernetesClusterKeyVaultSecretsProvider | undefined);
    private _secretIdentity;
    get secretIdentity(): DataAzurermKubernetesClusterKeyVaultSecretsProviderSecretIdentityList;
    get secretRotationEnabled(): cdktf.IResolvable;
    get secretRotationInterval(): string;
}
export declare class DataAzurermKubernetesClusterKeyVaultSecretsProviderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterKeyVaultSecretsProviderOutputReference;
}
export interface DataAzurermKubernetesClusterKubeAdminConfig {
}
export declare function dataAzurermKubernetesClusterKubeAdminConfigToTerraform(struct?: DataAzurermKubernetesClusterKubeAdminConfig): any;
export declare function dataAzurermKubernetesClusterKubeAdminConfigToHclTerraform(struct?: DataAzurermKubernetesClusterKubeAdminConfig): any;
export declare class DataAzurermKubernetesClusterKubeAdminConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterKubeAdminConfig | undefined;
    set internalValue(value: DataAzurermKubernetesClusterKubeAdminConfig | undefined);
    get clientCertificate(): string;
    get clientKey(): string;
    get clusterCaCertificate(): string;
    get host(): string;
    get password(): string;
    get username(): string;
}
export declare class DataAzurermKubernetesClusterKubeAdminConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterKubeAdminConfigOutputReference;
}
export interface DataAzurermKubernetesClusterKubeConfig {
}
export declare function dataAzurermKubernetesClusterKubeConfigToTerraform(struct?: DataAzurermKubernetesClusterKubeConfig): any;
export declare function dataAzurermKubernetesClusterKubeConfigToHclTerraform(struct?: DataAzurermKubernetesClusterKubeConfig): any;
export declare class DataAzurermKubernetesClusterKubeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterKubeConfig | undefined;
    set internalValue(value: DataAzurermKubernetesClusterKubeConfig | undefined);
    get clientCertificate(): string;
    get clientKey(): string;
    get clusterCaCertificate(): string;
    get host(): string;
    get password(): string;
    get username(): string;
}
export declare class DataAzurermKubernetesClusterKubeConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterKubeConfigOutputReference;
}
export interface DataAzurermKubernetesClusterKubeletIdentity {
}
export declare function dataAzurermKubernetesClusterKubeletIdentityToTerraform(struct?: DataAzurermKubernetesClusterKubeletIdentity): any;
export declare function dataAzurermKubernetesClusterKubeletIdentityToHclTerraform(struct?: DataAzurermKubernetesClusterKubeletIdentity): any;
export declare class DataAzurermKubernetesClusterKubeletIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterKubeletIdentity | undefined;
    set internalValue(value: DataAzurermKubernetesClusterKubeletIdentity | undefined);
    get clientId(): string;
    get objectId(): string;
    get userAssignedIdentityId(): string;
}
export declare class DataAzurermKubernetesClusterKubeletIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterKubeletIdentityOutputReference;
}
export interface DataAzurermKubernetesClusterLinuxProfileSshKey {
}
export declare function dataAzurermKubernetesClusterLinuxProfileSshKeyToTerraform(struct?: DataAzurermKubernetesClusterLinuxProfileSshKey): any;
export declare function dataAzurermKubernetesClusterLinuxProfileSshKeyToHclTerraform(struct?: DataAzurermKubernetesClusterLinuxProfileSshKey): any;
export declare class DataAzurermKubernetesClusterLinuxProfileSshKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterLinuxProfileSshKey | undefined;
    set internalValue(value: DataAzurermKubernetesClusterLinuxProfileSshKey | undefined);
    get keyData(): string;
}
export declare class DataAzurermKubernetesClusterLinuxProfileSshKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterLinuxProfileSshKeyOutputReference;
}
export interface DataAzurermKubernetesClusterLinuxProfile {
}
export declare function dataAzurermKubernetesClusterLinuxProfileToTerraform(struct?: DataAzurermKubernetesClusterLinuxProfile): any;
export declare function dataAzurermKubernetesClusterLinuxProfileToHclTerraform(struct?: DataAzurermKubernetesClusterLinuxProfile): any;
export declare class DataAzurermKubernetesClusterLinuxProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterLinuxProfile | undefined;
    set internalValue(value: DataAzurermKubernetesClusterLinuxProfile | undefined);
    get adminUsername(): string;
    private _sshKey;
    get sshKey(): DataAzurermKubernetesClusterLinuxProfileSshKeyList;
}
export declare class DataAzurermKubernetesClusterLinuxProfileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterLinuxProfileOutputReference;
}
export interface DataAzurermKubernetesClusterMicrosoftDefender {
}
export declare function dataAzurermKubernetesClusterMicrosoftDefenderToTerraform(struct?: DataAzurermKubernetesClusterMicrosoftDefender): any;
export declare function dataAzurermKubernetesClusterMicrosoftDefenderToHclTerraform(struct?: DataAzurermKubernetesClusterMicrosoftDefender): any;
export declare class DataAzurermKubernetesClusterMicrosoftDefenderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterMicrosoftDefender | undefined;
    set internalValue(value: DataAzurermKubernetesClusterMicrosoftDefender | undefined);
    get logAnalyticsWorkspaceId(): string;
}
export declare class DataAzurermKubernetesClusterMicrosoftDefenderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterMicrosoftDefenderOutputReference;
}
export interface DataAzurermKubernetesClusterNetworkProfile {
}
export declare function dataAzurermKubernetesClusterNetworkProfileToTerraform(struct?: DataAzurermKubernetesClusterNetworkProfile): any;
export declare function dataAzurermKubernetesClusterNetworkProfileToHclTerraform(struct?: DataAzurermKubernetesClusterNetworkProfile): any;
export declare class DataAzurermKubernetesClusterNetworkProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterNetworkProfile | undefined;
    set internalValue(value: DataAzurermKubernetesClusterNetworkProfile | undefined);
    get dnsServiceIp(): string;
    get dockerBridgeCidr(): string;
    get loadBalancerSku(): string;
    get networkPlugin(): string;
    get networkPolicy(): string;
    get podCidr(): string;
    get serviceCidr(): string;
}
export declare class DataAzurermKubernetesClusterNetworkProfileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterNetworkProfileOutputReference;
}
export interface DataAzurermKubernetesClusterOmsAgentOmsAgentIdentity {
}
export declare function dataAzurermKubernetesClusterOmsAgentOmsAgentIdentityToTerraform(struct?: DataAzurermKubernetesClusterOmsAgentOmsAgentIdentity): any;
export declare function dataAzurermKubernetesClusterOmsAgentOmsAgentIdentityToHclTerraform(struct?: DataAzurermKubernetesClusterOmsAgentOmsAgentIdentity): any;
export declare class DataAzurermKubernetesClusterOmsAgentOmsAgentIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterOmsAgentOmsAgentIdentity | undefined;
    set internalValue(value: DataAzurermKubernetesClusterOmsAgentOmsAgentIdentity | undefined);
    get clientId(): string;
    get objectId(): string;
    get userAssignedIdentityId(): string;
}
export declare class DataAzurermKubernetesClusterOmsAgentOmsAgentIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterOmsAgentOmsAgentIdentityOutputReference;
}
export interface DataAzurermKubernetesClusterOmsAgent {
}
export declare function dataAzurermKubernetesClusterOmsAgentToTerraform(struct?: DataAzurermKubernetesClusterOmsAgent): any;
export declare function dataAzurermKubernetesClusterOmsAgentToHclTerraform(struct?: DataAzurermKubernetesClusterOmsAgent): any;
export declare class DataAzurermKubernetesClusterOmsAgentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterOmsAgent | undefined;
    set internalValue(value: DataAzurermKubernetesClusterOmsAgent | undefined);
    get logAnalyticsWorkspaceId(): string;
    get msiAuthForMonitoringEnabled(): cdktf.IResolvable;
    private _omsAgentIdentity;
    get omsAgentIdentity(): DataAzurermKubernetesClusterOmsAgentOmsAgentIdentityList;
}
export declare class DataAzurermKubernetesClusterOmsAgentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterOmsAgentOutputReference;
}
export interface DataAzurermKubernetesClusterServiceMeshProfileCertificateAuthority {
}
export declare function dataAzurermKubernetesClusterServiceMeshProfileCertificateAuthorityToTerraform(struct?: DataAzurermKubernetesClusterServiceMeshProfileCertificateAuthority): any;
export declare function dataAzurermKubernetesClusterServiceMeshProfileCertificateAuthorityToHclTerraform(struct?: DataAzurermKubernetesClusterServiceMeshProfileCertificateAuthority): any;
export declare class DataAzurermKubernetesClusterServiceMeshProfileCertificateAuthorityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterServiceMeshProfileCertificateAuthority | undefined;
    set internalValue(value: DataAzurermKubernetesClusterServiceMeshProfileCertificateAuthority | undefined);
    get certChainObjectName(): string;
    get certObjectName(): string;
    get keyObjectName(): string;
    get keyVaultId(): string;
    get rootCertObjectName(): string;
}
export declare class DataAzurermKubernetesClusterServiceMeshProfileCertificateAuthorityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterServiceMeshProfileCertificateAuthorityOutputReference;
}
export interface DataAzurermKubernetesClusterServiceMeshProfile {
}
export declare function dataAzurermKubernetesClusterServiceMeshProfileToTerraform(struct?: DataAzurermKubernetesClusterServiceMeshProfile): any;
export declare function dataAzurermKubernetesClusterServiceMeshProfileToHclTerraform(struct?: DataAzurermKubernetesClusterServiceMeshProfile): any;
export declare class DataAzurermKubernetesClusterServiceMeshProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterServiceMeshProfile | undefined;
    set internalValue(value: DataAzurermKubernetesClusterServiceMeshProfile | undefined);
    private _certificateAuthority;
    get certificateAuthority(): DataAzurermKubernetesClusterServiceMeshProfileCertificateAuthorityList;
    get externalIngressGatewayEnabled(): cdktf.IResolvable;
    get internalIngressGatewayEnabled(): cdktf.IResolvable;
    get mode(): string;
    get revisions(): string[];
}
export declare class DataAzurermKubernetesClusterServiceMeshProfileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterServiceMeshProfileOutputReference;
}
export interface DataAzurermKubernetesClusterServicePrincipal {
}
export declare function dataAzurermKubernetesClusterServicePrincipalToTerraform(struct?: DataAzurermKubernetesClusterServicePrincipal): any;
export declare function dataAzurermKubernetesClusterServicePrincipalToHclTerraform(struct?: DataAzurermKubernetesClusterServicePrincipal): any;
export declare class DataAzurermKubernetesClusterServicePrincipalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterServicePrincipal | undefined;
    set internalValue(value: DataAzurermKubernetesClusterServicePrincipal | undefined);
    get clientId(): string;
}
export declare class DataAzurermKubernetesClusterServicePrincipalList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterServicePrincipalOutputReference;
}
export interface DataAzurermKubernetesClusterStorageProfile {
}
export declare function dataAzurermKubernetesClusterStorageProfileToTerraform(struct?: DataAzurermKubernetesClusterStorageProfile): any;
export declare function dataAzurermKubernetesClusterStorageProfileToHclTerraform(struct?: DataAzurermKubernetesClusterStorageProfile): any;
export declare class DataAzurermKubernetesClusterStorageProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterStorageProfile | undefined;
    set internalValue(value: DataAzurermKubernetesClusterStorageProfile | undefined);
    get blobDriverEnabled(): cdktf.IResolvable;
    get diskDriverEnabled(): cdktf.IResolvable;
    get fileDriverEnabled(): cdktf.IResolvable;
    get snapshotControllerEnabled(): cdktf.IResolvable;
}
export declare class DataAzurermKubernetesClusterStorageProfileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterStorageProfileOutputReference;
}
export interface DataAzurermKubernetesClusterWindowsProfile {
}
export declare function dataAzurermKubernetesClusterWindowsProfileToTerraform(struct?: DataAzurermKubernetesClusterWindowsProfile): any;
export declare function dataAzurermKubernetesClusterWindowsProfileToHclTerraform(struct?: DataAzurermKubernetesClusterWindowsProfile): any;
export declare class DataAzurermKubernetesClusterWindowsProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterWindowsProfile | undefined;
    set internalValue(value: DataAzurermKubernetesClusterWindowsProfile | undefined);
    get adminUsername(): string;
}
export declare class DataAzurermKubernetesClusterWindowsProfileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterWindowsProfileOutputReference;
}
export interface DataAzurermKubernetesClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/kubernetes_cluster#read DataAzurermKubernetesCluster#read}
    */
    readonly read?: string;
}
export declare function dataAzurermKubernetesClusterTimeoutsToTerraform(struct?: DataAzurermKubernetesClusterTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermKubernetesClusterTimeoutsToHclTerraform(struct?: DataAzurermKubernetesClusterTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermKubernetesClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermKubernetesClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermKubernetesClusterTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/kubernetes_cluster azurerm_kubernetes_cluster}
*/
export declare class DataAzurermKubernetesCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_kubernetes_cluster";
    /**
    * Generates CDKTF code for importing a DataAzurermKubernetesCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermKubernetesCluster to import
    * @param importFromId The id of the existing DataAzurermKubernetesCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/kubernetes_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermKubernetesCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/kubernetes_cluster azurerm_kubernetes_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermKubernetesClusterConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermKubernetesClusterConfig);
    private _aciConnectorLinux;
    get aciConnectorLinux(): DataAzurermKubernetesClusterAciConnectorLinuxList;
    private _agentPoolProfile;
    get agentPoolProfile(): DataAzurermKubernetesClusterAgentPoolProfileList;
    get apiServerAuthorizedIpRanges(): string[];
    private _azureActiveDirectoryRoleBasedAccessControl;
    get azureActiveDirectoryRoleBasedAccessControl(): DataAzurermKubernetesClusterAzureActiveDirectoryRoleBasedAccessControlList;
    get azurePolicyEnabled(): cdktf.IResolvable;
    get currentKubernetesVersion(): string;
    get diskEncryptionSetId(): string;
    get dnsPrefix(): string;
    get fqdn(): string;
    get httpApplicationRoutingEnabled(): cdktf.IResolvable;
    get httpApplicationRoutingZoneName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermKubernetesClusterIdentityList;
    private _ingressApplicationGateway;
    get ingressApplicationGateway(): DataAzurermKubernetesClusterIngressApplicationGatewayList;
    private _keyManagementService;
    get keyManagementService(): DataAzurermKubernetesClusterKeyManagementServiceList;
    private _keyVaultSecretsProvider;
    get keyVaultSecretsProvider(): DataAzurermKubernetesClusterKeyVaultSecretsProviderList;
    private _kubeAdminConfig;
    get kubeAdminConfig(): DataAzurermKubernetesClusterKubeAdminConfigList;
    get kubeAdminConfigRaw(): string;
    private _kubeConfig;
    get kubeConfig(): DataAzurermKubernetesClusterKubeConfigList;
    get kubeConfigRaw(): string;
    private _kubeletIdentity;
    get kubeletIdentity(): DataAzurermKubernetesClusterKubeletIdentityList;
    get kubernetesVersion(): string;
    private _linuxProfile;
    get linuxProfile(): DataAzurermKubernetesClusterLinuxProfileList;
    get location(): string;
    private _microsoftDefender;
    get microsoftDefender(): DataAzurermKubernetesClusterMicrosoftDefenderList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkProfile;
    get networkProfile(): DataAzurermKubernetesClusterNetworkProfileList;
    get nodeResourceGroup(): string;
    get nodeResourceGroupId(): string;
    get oidcIssuerEnabled(): cdktf.IResolvable;
    get oidcIssuerUrl(): string;
    private _omsAgent;
    get omsAgent(): DataAzurermKubernetesClusterOmsAgentList;
    get openServiceMeshEnabled(): cdktf.IResolvable;
    get privateClusterEnabled(): cdktf.IResolvable;
    get privateFqdn(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get roleBasedAccessControlEnabled(): cdktf.IResolvable;
    private _serviceMeshProfile;
    get serviceMeshProfile(): DataAzurermKubernetesClusterServiceMeshProfileList;
    private _servicePrincipal;
    get servicePrincipal(): DataAzurermKubernetesClusterServicePrincipalList;
    private _storageProfile;
    get storageProfile(): DataAzurermKubernetesClusterStorageProfileList;
    private _tags;
    get tags(): cdktf.StringMap;
    private _windowsProfile;
    get windowsProfile(): DataAzurermKubernetesClusterWindowsProfileList;
    private _timeouts;
    get timeouts(): DataAzurermKubernetesClusterTimeoutsOutputReference;
    putTimeouts(value: DataAzurermKubernetesClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermKubernetesClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
