/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMarketplaceAgreementConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/marketplace_agreement#id DataAzurermMarketplaceAgreement#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/marketplace_agreement#offer DataAzurermMarketplaceAgreement#offer}
    */
    readonly offer: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/marketplace_agreement#plan DataAzurermMarketplaceAgreement#plan}
    */
    readonly plan: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/marketplace_agreement#publisher DataAzurermMarketplaceAgreement#publisher}
    */
    readonly publisher: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/marketplace_agreement#timeouts DataAzurermMarketplaceAgreement#timeouts}
    */
    readonly timeouts?: DataAzurermMarketplaceAgreementTimeouts;
}
export interface DataAzurermMarketplaceAgreementTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/marketplace_agreement#read DataAzurermMarketplaceAgreement#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMarketplaceAgreementTimeoutsToTerraform(struct?: DataAzurermMarketplaceAgreementTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermMarketplaceAgreementTimeoutsToHclTerraform(struct?: DataAzurermMarketplaceAgreementTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMarketplaceAgreementTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermMarketplaceAgreementTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermMarketplaceAgreementTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/marketplace_agreement azurerm_marketplace_agreement}
*/
export declare class DataAzurermMarketplaceAgreement extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_marketplace_agreement";
    /**
    * Generates CDKTF code for importing a DataAzurermMarketplaceAgreement resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermMarketplaceAgreement to import
    * @param importFromId The id of the existing DataAzurermMarketplaceAgreement that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/marketplace_agreement#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermMarketplaceAgreement to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/marketplace_agreement azurerm_marketplace_agreement} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMarketplaceAgreementConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMarketplaceAgreementConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get licenseTextLink(): string;
    private _offer?;
    get offer(): string;
    set offer(value: string);
    get offerInput(): string | undefined;
    private _plan?;
    get plan(): string;
    set plan(value: string);
    get planInput(): string | undefined;
    get privacyPolicyLink(): string;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    get publisherInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermMarketplaceAgreementTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMarketplaceAgreementTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermMarketplaceAgreementTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
