/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMobileNetworkDataNetworkConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/mobile_network_data_network#id DataAzurermMobileNetworkDataNetwork#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/mobile_network_data_network#mobile_network_id DataAzurermMobileNetworkDataNetwork#mobile_network_id}
    */
    readonly mobileNetworkId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/mobile_network_data_network#name DataAzurermMobileNetworkDataNetwork#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/mobile_network_data_network#timeouts DataAzurermMobileNetworkDataNetwork#timeouts}
    */
    readonly timeouts?: DataAzurermMobileNetworkDataNetworkTimeouts;
}
export interface DataAzurermMobileNetworkDataNetworkTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/mobile_network_data_network#read DataAzurermMobileNetworkDataNetwork#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMobileNetworkDataNetworkTimeoutsToTerraform(struct?: DataAzurermMobileNetworkDataNetworkTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermMobileNetworkDataNetworkTimeoutsToHclTerraform(struct?: DataAzurermMobileNetworkDataNetworkTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMobileNetworkDataNetworkTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermMobileNetworkDataNetworkTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermMobileNetworkDataNetworkTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/mobile_network_data_network azurerm_mobile_network_data_network}
*/
export declare class DataAzurermMobileNetworkDataNetwork extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_mobile_network_data_network";
    /**
    * Generates CDKTF code for importing a DataAzurermMobileNetworkDataNetwork resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermMobileNetworkDataNetwork to import
    * @param importFromId The id of the existing DataAzurermMobileNetworkDataNetwork that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/mobile_network_data_network#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermMobileNetworkDataNetwork to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/mobile_network_data_network azurerm_mobile_network_data_network} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMobileNetworkDataNetworkConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMobileNetworkDataNetworkConfig);
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _mobileNetworkId?;
    get mobileNetworkId(): string;
    set mobileNetworkId(value: string);
    get mobileNetworkIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermMobileNetworkDataNetworkTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMobileNetworkDataNetworkTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermMobileNetworkDataNetworkTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
