/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermOracleCloudVmClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/oracle_cloud_vm_cluster#id DataAzurermOracleCloudVmCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/oracle_cloud_vm_cluster#name DataAzurermOracleCloudVmCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/oracle_cloud_vm_cluster#resource_group_name DataAzurermOracleCloudVmCluster#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/oracle_cloud_vm_cluster#timeouts DataAzurermOracleCloudVmCluster#timeouts}
    */
    readonly timeouts?: DataAzurermOracleCloudVmClusterTimeouts;
}
export interface DataAzurermOracleCloudVmClusterDataCollectionOptions {
}
export declare function dataAzurermOracleCloudVmClusterDataCollectionOptionsToTerraform(struct?: DataAzurermOracleCloudVmClusterDataCollectionOptions): any;
export declare function dataAzurermOracleCloudVmClusterDataCollectionOptionsToHclTerraform(struct?: DataAzurermOracleCloudVmClusterDataCollectionOptions): any;
export declare class DataAzurermOracleCloudVmClusterDataCollectionOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermOracleCloudVmClusterDataCollectionOptions | undefined;
    set internalValue(value: DataAzurermOracleCloudVmClusterDataCollectionOptions | undefined);
    get diagnosticsEventsEnabled(): cdktf.IResolvable;
    get healthMonitoringEnabled(): cdktf.IResolvable;
    get incidentLogsEnabled(): cdktf.IResolvable;
}
export declare class DataAzurermOracleCloudVmClusterDataCollectionOptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermOracleCloudVmClusterDataCollectionOptionsOutputReference;
}
export interface DataAzurermOracleCloudVmClusterIormConfigCacheDbPlans {
}
export declare function dataAzurermOracleCloudVmClusterIormConfigCacheDbPlansToTerraform(struct?: DataAzurermOracleCloudVmClusterIormConfigCacheDbPlans): any;
export declare function dataAzurermOracleCloudVmClusterIormConfigCacheDbPlansToHclTerraform(struct?: DataAzurermOracleCloudVmClusterIormConfigCacheDbPlans): any;
export declare class DataAzurermOracleCloudVmClusterIormConfigCacheDbPlansOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermOracleCloudVmClusterIormConfigCacheDbPlans | undefined;
    set internalValue(value: DataAzurermOracleCloudVmClusterIormConfigCacheDbPlans | undefined);
    get dbName(): string;
    get flashCacheLimit(): string;
    get share(): number;
}
export declare class DataAzurermOracleCloudVmClusterIormConfigCacheDbPlansList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermOracleCloudVmClusterIormConfigCacheDbPlansOutputReference;
}
export interface DataAzurermOracleCloudVmClusterIormConfigCache {
}
export declare function dataAzurermOracleCloudVmClusterIormConfigCacheToTerraform(struct?: DataAzurermOracleCloudVmClusterIormConfigCache): any;
export declare function dataAzurermOracleCloudVmClusterIormConfigCacheToHclTerraform(struct?: DataAzurermOracleCloudVmClusterIormConfigCache): any;
export declare class DataAzurermOracleCloudVmClusterIormConfigCacheOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermOracleCloudVmClusterIormConfigCache | undefined;
    set internalValue(value: DataAzurermOracleCloudVmClusterIormConfigCache | undefined);
    private _dbPlans;
    get dbPlans(): DataAzurermOracleCloudVmClusterIormConfigCacheDbPlansList;
    get lifecycleDetails(): string;
    get lifecycleState(): string;
    get objective(): string;
}
export declare class DataAzurermOracleCloudVmClusterIormConfigCacheList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermOracleCloudVmClusterIormConfigCacheOutputReference;
}
export interface DataAzurermOracleCloudVmClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/oracle_cloud_vm_cluster#read DataAzurermOracleCloudVmCluster#read}
    */
    readonly read?: string;
}
export declare function dataAzurermOracleCloudVmClusterTimeoutsToTerraform(struct?: DataAzurermOracleCloudVmClusterTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermOracleCloudVmClusterTimeoutsToHclTerraform(struct?: DataAzurermOracleCloudVmClusterTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermOracleCloudVmClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermOracleCloudVmClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermOracleCloudVmClusterTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/oracle_cloud_vm_cluster azurerm_oracle_cloud_vm_cluster}
*/
export declare class DataAzurermOracleCloudVmCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_oracle_cloud_vm_cluster";
    /**
    * Generates CDKTF code for importing a DataAzurermOracleCloudVmCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermOracleCloudVmCluster to import
    * @param importFromId The id of the existing DataAzurermOracleCloudVmCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/oracle_cloud_vm_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermOracleCloudVmCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/oracle_cloud_vm_cluster azurerm_oracle_cloud_vm_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermOracleCloudVmClusterConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermOracleCloudVmClusterConfig);
    get backupSubnetCidr(): string;
    get cloudExadataInfrastructureId(): string;
    get clusterName(): string;
    get compartmentId(): string;
    get computeNodes(): string[];
    get cpuCoreCount(): number;
    private _dataCollectionOptions;
    get dataCollectionOptions(): DataAzurermOracleCloudVmClusterDataCollectionOptionsList;
    get dataStoragePercentage(): number;
    get dataStorageSizeInTbs(): number;
    get dbNodeStorageSizeInGbs(): number;
    get dbServers(): string[];
    get diskRedundancy(): string;
    get displayName(): string;
    get domain(): string;
    get giVersion(): string;
    get hostname(): string;
    get hostnameActual(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _iormConfigCache;
    get iormConfigCache(): DataAzurermOracleCloudVmClusterIormConfigCacheList;
    get lastUpdateHistoryEntryId(): string;
    get licenseModel(): string;
    get lifecycleDetails(): string;
    get lifecycleState(): string;
    get listenerPort(): number;
    get localBackupEnabled(): cdktf.IResolvable;
    get location(): string;
    get memorySizeInGbs(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get nodeCount(): number;
    get nsgUrl(): string;
    get ociUrl(): string;
    get ocid(): string;
    get ocpuCount(): number;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get scanDnsName(): string;
    get scanDnsRecordId(): string;
    get scanIpIds(): string[];
    get scanListenerPortTcp(): number;
    get scanListenerPortTcpSsl(): number;
    get shape(): string;
    get sparseDiskgroupEnabled(): cdktf.IResolvable;
    get sshPublicKeys(): string[];
    get storageSizeInGbs(): number;
    get subnetId(): string;
    get subnetOcid(): string;
    get systemVersion(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get timeCreated(): string;
    get timeZone(): string;
    get vipOds(): string[];
    get virtualNetworkId(): string;
    get zoneId(): string;
    private _timeouts;
    get timeouts(): DataAzurermOracleCloudVmClusterTimeoutsOutputReference;
    putTimeouts(value: DataAzurermOracleCloudVmClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermOracleCloudVmClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
