/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermPrivateDnsResolverForwardingRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/private_dns_resolver_forwarding_rule#dns_forwarding_ruleset_id DataAzurermPrivateDnsResolverForwardingRule#dns_forwarding_ruleset_id}
    */
    readonly dnsForwardingRulesetId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/private_dns_resolver_forwarding_rule#id DataAzurermPrivateDnsResolverForwardingRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/private_dns_resolver_forwarding_rule#name DataAzurermPrivateDnsResolverForwardingRule#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/private_dns_resolver_forwarding_rule#timeouts DataAzurermPrivateDnsResolverForwardingRule#timeouts}
    */
    readonly timeouts?: DataAzurermPrivateDnsResolverForwardingRuleTimeouts;
}
export interface DataAzurermPrivateDnsResolverForwardingRuleTargetDnsServers {
}
export declare function dataAzurermPrivateDnsResolverForwardingRuleTargetDnsServersToTerraform(struct?: DataAzurermPrivateDnsResolverForwardingRuleTargetDnsServers): any;
export declare function dataAzurermPrivateDnsResolverForwardingRuleTargetDnsServersToHclTerraform(struct?: DataAzurermPrivateDnsResolverForwardingRuleTargetDnsServers): any;
export declare class DataAzurermPrivateDnsResolverForwardingRuleTargetDnsServersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermPrivateDnsResolverForwardingRuleTargetDnsServers | undefined;
    set internalValue(value: DataAzurermPrivateDnsResolverForwardingRuleTargetDnsServers | undefined);
    get ipAddress(): string;
    get port(): number;
}
export declare class DataAzurermPrivateDnsResolverForwardingRuleTargetDnsServersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermPrivateDnsResolverForwardingRuleTargetDnsServersOutputReference;
}
export interface DataAzurermPrivateDnsResolverForwardingRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/private_dns_resolver_forwarding_rule#read DataAzurermPrivateDnsResolverForwardingRule#read}
    */
    readonly read?: string;
}
export declare function dataAzurermPrivateDnsResolverForwardingRuleTimeoutsToTerraform(struct?: DataAzurermPrivateDnsResolverForwardingRuleTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermPrivateDnsResolverForwardingRuleTimeoutsToHclTerraform(struct?: DataAzurermPrivateDnsResolverForwardingRuleTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermPrivateDnsResolverForwardingRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermPrivateDnsResolverForwardingRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermPrivateDnsResolverForwardingRuleTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/private_dns_resolver_forwarding_rule azurerm_private_dns_resolver_forwarding_rule}
*/
export declare class DataAzurermPrivateDnsResolverForwardingRule extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_private_dns_resolver_forwarding_rule";
    /**
    * Generates CDKTF code for importing a DataAzurermPrivateDnsResolverForwardingRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermPrivateDnsResolverForwardingRule to import
    * @param importFromId The id of the existing DataAzurermPrivateDnsResolverForwardingRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/private_dns_resolver_forwarding_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermPrivateDnsResolverForwardingRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/private_dns_resolver_forwarding_rule azurerm_private_dns_resolver_forwarding_rule} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermPrivateDnsResolverForwardingRuleConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermPrivateDnsResolverForwardingRuleConfig);
    private _dnsForwardingRulesetId?;
    get dnsForwardingRulesetId(): string;
    set dnsForwardingRulesetId(value: string);
    get dnsForwardingRulesetIdInput(): string | undefined;
    get domainName(): string;
    get enabled(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): cdktf.StringMap;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _targetDnsServers;
    get targetDnsServers(): DataAzurermPrivateDnsResolverForwardingRuleTargetDnsServersList;
    private _timeouts;
    get timeouts(): DataAzurermPrivateDnsResolverForwardingRuleTimeoutsOutputReference;
    putTimeouts(value: DataAzurermPrivateDnsResolverForwardingRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermPrivateDnsResolverForwardingRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
