/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSharedImageConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/shared_image#gallery_name DataAzurermSharedImage#gallery_name}
    */
    readonly galleryName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/shared_image#id DataAzurermSharedImage#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/shared_image#name DataAzurermSharedImage#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/shared_image#resource_group_name DataAzurermSharedImage#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/shared_image#timeouts DataAzurermSharedImage#timeouts}
    */
    readonly timeouts?: DataAzurermSharedImageTimeouts;
}
export interface DataAzurermSharedImageIdentifier {
}
export declare function dataAzurermSharedImageIdentifierToTerraform(struct?: DataAzurermSharedImageIdentifier): any;
export declare function dataAzurermSharedImageIdentifierToHclTerraform(struct?: DataAzurermSharedImageIdentifier): any;
export declare class DataAzurermSharedImageIdentifierOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSharedImageIdentifier | undefined;
    set internalValue(value: DataAzurermSharedImageIdentifier | undefined);
    get offer(): string;
    get publisher(): string;
    get sku(): string;
}
export declare class DataAzurermSharedImageIdentifierList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSharedImageIdentifierOutputReference;
}
export interface DataAzurermSharedImagePurchasePlan {
}
export declare function dataAzurermSharedImagePurchasePlanToTerraform(struct?: DataAzurermSharedImagePurchasePlan): any;
export declare function dataAzurermSharedImagePurchasePlanToHclTerraform(struct?: DataAzurermSharedImagePurchasePlan): any;
export declare class DataAzurermSharedImagePurchasePlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSharedImagePurchasePlan | undefined;
    set internalValue(value: DataAzurermSharedImagePurchasePlan | undefined);
    get name(): string;
    get product(): string;
    get publisher(): string;
}
export declare class DataAzurermSharedImagePurchasePlanList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSharedImagePurchasePlanOutputReference;
}
export interface DataAzurermSharedImageTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/shared_image#read DataAzurermSharedImage#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSharedImageTimeoutsToTerraform(struct?: DataAzurermSharedImageTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermSharedImageTimeoutsToHclTerraform(struct?: DataAzurermSharedImageTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSharedImageTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermSharedImageTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermSharedImageTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/shared_image azurerm_shared_image}
*/
export declare class DataAzurermSharedImage extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_shared_image";
    /**
    * Generates CDKTF code for importing a DataAzurermSharedImage resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermSharedImage to import
    * @param importFromId The id of the existing DataAzurermSharedImage that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/shared_image#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermSharedImage to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/shared_image azurerm_shared_image} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSharedImageConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSharedImageConfig);
    get acceleratedNetworkSupportEnabled(): cdktf.IResolvable;
    get architecture(): string;
    get confidentialVmEnabled(): cdktf.IResolvable;
    get confidentialVmSupported(): cdktf.IResolvable;
    get description(): string;
    get eula(): string;
    private _galleryName?;
    get galleryName(): string;
    set galleryName(value: string);
    get galleryNameInput(): string | undefined;
    get hibernationEnabled(): cdktf.IResolvable;
    get hyperVGeneration(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identifier;
    get identifier(): DataAzurermSharedImageIdentifierList;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get osType(): string;
    get privacyStatementUri(): string;
    private _purchasePlan;
    get purchasePlan(): DataAzurermSharedImagePurchasePlanList;
    get releaseNoteUri(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get specialized(): cdktf.IResolvable;
    private _tags;
    get tags(): cdktf.StringMap;
    get trustedLaunchEnabled(): cdktf.IResolvable;
    get trustedLaunchSupported(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermSharedImageTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSharedImageTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermSharedImageTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
