/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSignalrServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/signalr_service#id DataAzurermSignalrService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/signalr_service#name DataAzurermSignalrService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/signalr_service#resource_group_name DataAzurermSignalrService#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/signalr_service#timeouts DataAzurermSignalrService#timeouts}
    */
    readonly timeouts?: DataAzurermSignalrServiceTimeouts;
}
export interface DataAzurermSignalrServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/signalr_service#read DataAzurermSignalrService#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSignalrServiceTimeoutsToTerraform(struct?: DataAzurermSignalrServiceTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermSignalrServiceTimeoutsToHclTerraform(struct?: DataAzurermSignalrServiceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSignalrServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermSignalrServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermSignalrServiceTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/signalr_service azurerm_signalr_service}
*/
export declare class DataAzurermSignalrService extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_signalr_service";
    /**
    * Generates CDKTF code for importing a DataAzurermSignalrService resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermSignalrService to import
    * @param importFromId The id of the existing DataAzurermSignalrService that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/signalr_service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermSignalrService to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/signalr_service azurerm_signalr_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSignalrServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSignalrServiceConfig);
    get aadAuthEnabled(): cdktf.IResolvable;
    get hostname(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get ipAddress(): string;
    get localAuthEnabled(): cdktf.IResolvable;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get primaryAccessKey(): string;
    get primaryConnectionString(): string;
    get publicNetworkAccessEnabled(): cdktf.IResolvable;
    get publicPort(): number;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryAccessKey(): string;
    get secondaryConnectionString(): string;
    get serverPort(): number;
    get serverlessConnectionTimeoutInSeconds(): number;
    private _tags;
    get tags(): cdktf.StringMap;
    get tlsClientCertEnabled(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermSignalrServiceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSignalrServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermSignalrServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
