/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermStorageManagementPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/storage_management_policy#id DataAzurermStorageManagementPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/storage_management_policy#storage_account_id DataAzurermStorageManagementPolicy#storage_account_id}
    */
    readonly storageAccountId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/storage_management_policy#timeouts DataAzurermStorageManagementPolicy#timeouts}
    */
    readonly timeouts?: DataAzurermStorageManagementPolicyTimeouts;
}
export interface DataAzurermStorageManagementPolicyRuleActionsBaseBlob {
}
export declare function dataAzurermStorageManagementPolicyRuleActionsBaseBlobToTerraform(struct?: DataAzurermStorageManagementPolicyRuleActionsBaseBlob): any;
export declare function dataAzurermStorageManagementPolicyRuleActionsBaseBlobToHclTerraform(struct?: DataAzurermStorageManagementPolicyRuleActionsBaseBlob): any;
export declare class DataAzurermStorageManagementPolicyRuleActionsBaseBlobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermStorageManagementPolicyRuleActionsBaseBlob | undefined;
    set internalValue(value: DataAzurermStorageManagementPolicyRuleActionsBaseBlob | undefined);
    get autoTierToHotFromCoolEnabled(): cdktf.IResolvable;
    get deleteAfterDaysSinceCreationGreaterThan(): number;
    get deleteAfterDaysSinceLastAccessTimeGreaterThan(): number;
    get deleteAfterDaysSinceModificationGreaterThan(): number;
    get tierToArchiveAfterDaysSinceCreationGreaterThan(): number;
    get tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan(): number;
    get tierToArchiveAfterDaysSinceLastTierChangeGreaterThan(): number;
    get tierToArchiveAfterDaysSinceModificationGreaterThan(): number;
    get tierToColdAfterDaysSinceCreationGreaterThan(): number;
    get tierToColdAfterDaysSinceLastAccessTimeGreaterThan(): number;
    get tierToColdAfterDaysSinceModificationGreaterThan(): number;
    get tierToCoolAfterDaysSinceCreationGreaterThan(): number;
    get tierToCoolAfterDaysSinceLastAccessTimeGreaterThan(): number;
    get tierToCoolAfterDaysSinceModificationGreaterThan(): number;
}
export declare class DataAzurermStorageManagementPolicyRuleActionsBaseBlobList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermStorageManagementPolicyRuleActionsBaseBlobOutputReference;
}
export interface DataAzurermStorageManagementPolicyRuleActionsSnapshot {
}
export declare function dataAzurermStorageManagementPolicyRuleActionsSnapshotToTerraform(struct?: DataAzurermStorageManagementPolicyRuleActionsSnapshot): any;
export declare function dataAzurermStorageManagementPolicyRuleActionsSnapshotToHclTerraform(struct?: DataAzurermStorageManagementPolicyRuleActionsSnapshot): any;
export declare class DataAzurermStorageManagementPolicyRuleActionsSnapshotOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermStorageManagementPolicyRuleActionsSnapshot | undefined;
    set internalValue(value: DataAzurermStorageManagementPolicyRuleActionsSnapshot | undefined);
    get changeTierToArchiveAfterDaysSinceCreation(): number;
    get changeTierToCoolAfterDaysSinceCreation(): number;
    get deleteAfterDaysSinceCreationGreaterThan(): number;
    get tierToArchiveAfterDaysSinceLastTierChangeGreaterThan(): number;
    get tierToColdAfterDaysSinceCreationGreaterThan(): number;
}
export declare class DataAzurermStorageManagementPolicyRuleActionsSnapshotList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermStorageManagementPolicyRuleActionsSnapshotOutputReference;
}
export interface DataAzurermStorageManagementPolicyRuleActionsVersion {
}
export declare function dataAzurermStorageManagementPolicyRuleActionsVersionToTerraform(struct?: DataAzurermStorageManagementPolicyRuleActionsVersion): any;
export declare function dataAzurermStorageManagementPolicyRuleActionsVersionToHclTerraform(struct?: DataAzurermStorageManagementPolicyRuleActionsVersion): any;
export declare class DataAzurermStorageManagementPolicyRuleActionsVersionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermStorageManagementPolicyRuleActionsVersion | undefined;
    set internalValue(value: DataAzurermStorageManagementPolicyRuleActionsVersion | undefined);
    get changeTierToArchiveAfterDaysSinceCreation(): number;
    get changeTierToCoolAfterDaysSinceCreation(): number;
    get deleteAfterDaysSinceCreation(): number;
    get tierToArchiveAfterDaysSinceLastTierChangeGreaterThan(): number;
    get tierToColdAfterDaysSinceCreationGreaterThan(): number;
}
export declare class DataAzurermStorageManagementPolicyRuleActionsVersionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermStorageManagementPolicyRuleActionsVersionOutputReference;
}
export interface DataAzurermStorageManagementPolicyRuleActions {
}
export declare function dataAzurermStorageManagementPolicyRuleActionsToTerraform(struct?: DataAzurermStorageManagementPolicyRuleActions): any;
export declare function dataAzurermStorageManagementPolicyRuleActionsToHclTerraform(struct?: DataAzurermStorageManagementPolicyRuleActions): any;
export declare class DataAzurermStorageManagementPolicyRuleActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermStorageManagementPolicyRuleActions | undefined;
    set internalValue(value: DataAzurermStorageManagementPolicyRuleActions | undefined);
    private _baseBlob;
    get baseBlob(): DataAzurermStorageManagementPolicyRuleActionsBaseBlobList;
    private _snapshot;
    get snapshot(): DataAzurermStorageManagementPolicyRuleActionsSnapshotList;
    private _version;
    get version(): DataAzurermStorageManagementPolicyRuleActionsVersionList;
}
export declare class DataAzurermStorageManagementPolicyRuleActionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermStorageManagementPolicyRuleActionsOutputReference;
}
export interface DataAzurermStorageManagementPolicyRuleFiltersMatchBlobIndexTag {
}
export declare function dataAzurermStorageManagementPolicyRuleFiltersMatchBlobIndexTagToTerraform(struct?: DataAzurermStorageManagementPolicyRuleFiltersMatchBlobIndexTag): any;
export declare function dataAzurermStorageManagementPolicyRuleFiltersMatchBlobIndexTagToHclTerraform(struct?: DataAzurermStorageManagementPolicyRuleFiltersMatchBlobIndexTag): any;
export declare class DataAzurermStorageManagementPolicyRuleFiltersMatchBlobIndexTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermStorageManagementPolicyRuleFiltersMatchBlobIndexTag | undefined;
    set internalValue(value: DataAzurermStorageManagementPolicyRuleFiltersMatchBlobIndexTag | undefined);
    get name(): string;
    get operation(): string;
    get value(): string;
}
export declare class DataAzurermStorageManagementPolicyRuleFiltersMatchBlobIndexTagList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermStorageManagementPolicyRuleFiltersMatchBlobIndexTagOutputReference;
}
export interface DataAzurermStorageManagementPolicyRuleFilters {
}
export declare function dataAzurermStorageManagementPolicyRuleFiltersToTerraform(struct?: DataAzurermStorageManagementPolicyRuleFilters): any;
export declare function dataAzurermStorageManagementPolicyRuleFiltersToHclTerraform(struct?: DataAzurermStorageManagementPolicyRuleFilters): any;
export declare class DataAzurermStorageManagementPolicyRuleFiltersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermStorageManagementPolicyRuleFilters | undefined;
    set internalValue(value: DataAzurermStorageManagementPolicyRuleFilters | undefined);
    get blobTypes(): string[];
    private _matchBlobIndexTag;
    get matchBlobIndexTag(): DataAzurermStorageManagementPolicyRuleFiltersMatchBlobIndexTagList;
    get prefixMatch(): string[];
}
export declare class DataAzurermStorageManagementPolicyRuleFiltersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermStorageManagementPolicyRuleFiltersOutputReference;
}
export interface DataAzurermStorageManagementPolicyRule {
}
export declare function dataAzurermStorageManagementPolicyRuleToTerraform(struct?: DataAzurermStorageManagementPolicyRule): any;
export declare function dataAzurermStorageManagementPolicyRuleToHclTerraform(struct?: DataAzurermStorageManagementPolicyRule): any;
export declare class DataAzurermStorageManagementPolicyRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermStorageManagementPolicyRule | undefined;
    set internalValue(value: DataAzurermStorageManagementPolicyRule | undefined);
    private _actions;
    get actions(): DataAzurermStorageManagementPolicyRuleActionsList;
    get enabled(): cdktf.IResolvable;
    private _filters;
    get filters(): DataAzurermStorageManagementPolicyRuleFiltersList;
    get name(): string;
}
export declare class DataAzurermStorageManagementPolicyRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermStorageManagementPolicyRuleOutputReference;
}
export interface DataAzurermStorageManagementPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/storage_management_policy#read DataAzurermStorageManagementPolicy#read}
    */
    readonly read?: string;
}
export declare function dataAzurermStorageManagementPolicyTimeoutsToTerraform(struct?: DataAzurermStorageManagementPolicyTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermStorageManagementPolicyTimeoutsToHclTerraform(struct?: DataAzurermStorageManagementPolicyTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermStorageManagementPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermStorageManagementPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermStorageManagementPolicyTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/storage_management_policy azurerm_storage_management_policy}
*/
export declare class DataAzurermStorageManagementPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_storage_management_policy";
    /**
    * Generates CDKTF code for importing a DataAzurermStorageManagementPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermStorageManagementPolicy to import
    * @param importFromId The id of the existing DataAzurermStorageManagementPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/storage_management_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermStorageManagementPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/data-sources/storage_management_policy azurerm_storage_management_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermStorageManagementPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermStorageManagementPolicyConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _rule;
    get rule(): DataAzurermStorageManagementPolicyRuleList;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermStorageManagementPolicyTimeoutsOutputReference;
    putTimeouts(value: DataAzurermStorageManagementPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermStorageManagementPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
