/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataFactoryCredentialServicePrincipalConfig extends cdktf.TerraformMetaArguments {
    /**
    * (Optional) List of string annotations.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/data_factory_credential_service_principal#annotations DataFactoryCredentialServicePrincipal#annotations}
    */
    readonly annotations?: string[];
    /**
    * The resource ID of the parent Data Factory
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/data_factory_credential_service_principal#data_factory_id DataFactoryCredentialServicePrincipal#data_factory_id}
    */
    readonly dataFactoryId: string;
    /**
    * (Optional) Short text description
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/data_factory_credential_service_principal#description DataFactoryCredentialServicePrincipal#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/data_factory_credential_service_principal#id DataFactoryCredentialServicePrincipal#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The desired name of the credential resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/data_factory_credential_service_principal#name DataFactoryCredentialServicePrincipal#name}
    */
    readonly name: string;
    /**
    * The Client ID of the Service Principal
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/data_factory_credential_service_principal#service_principal_id DataFactoryCredentialServicePrincipal#service_principal_id}
    */
    readonly servicePrincipalId: string;
    /**
    * The Tenant ID of the Service Principal
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/data_factory_credential_service_principal#tenant_id DataFactoryCredentialServicePrincipal#tenant_id}
    */
    readonly tenantId: string;
    /**
    * service_principal_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/data_factory_credential_service_principal#service_principal_key DataFactoryCredentialServicePrincipal#service_principal_key}
    */
    readonly servicePrincipalKey?: DataFactoryCredentialServicePrincipalServicePrincipalKey;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/data_factory_credential_service_principal#timeouts DataFactoryCredentialServicePrincipal#timeouts}
    */
    readonly timeouts?: DataFactoryCredentialServicePrincipalTimeouts;
}
export interface DataFactoryCredentialServicePrincipalServicePrincipalKey {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/data_factory_credential_service_principal#linked_service_name DataFactoryCredentialServicePrincipal#linked_service_name}
    */
    readonly linkedServiceName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/data_factory_credential_service_principal#secret_name DataFactoryCredentialServicePrincipal#secret_name}
    */
    readonly secretName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/data_factory_credential_service_principal#secret_version DataFactoryCredentialServicePrincipal#secret_version}
    */
    readonly secretVersion?: string;
}
export declare function dataFactoryCredentialServicePrincipalServicePrincipalKeyToTerraform(struct?: DataFactoryCredentialServicePrincipalServicePrincipalKeyOutputReference | DataFactoryCredentialServicePrincipalServicePrincipalKey): any;
export declare function dataFactoryCredentialServicePrincipalServicePrincipalKeyToHclTerraform(struct?: DataFactoryCredentialServicePrincipalServicePrincipalKeyOutputReference | DataFactoryCredentialServicePrincipalServicePrincipalKey): any;
export declare class DataFactoryCredentialServicePrincipalServicePrincipalKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryCredentialServicePrincipalServicePrincipalKey | undefined;
    set internalValue(value: DataFactoryCredentialServicePrincipalServicePrincipalKey | undefined);
    private _linkedServiceName?;
    get linkedServiceName(): string;
    set linkedServiceName(value: string);
    get linkedServiceNameInput(): string | undefined;
    private _secretName?;
    get secretName(): string;
    set secretName(value: string);
    get secretNameInput(): string | undefined;
    private _secretVersion?;
    get secretVersion(): string;
    set secretVersion(value: string);
    resetSecretVersion(): void;
    get secretVersionInput(): string | undefined;
}
export interface DataFactoryCredentialServicePrincipalTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/data_factory_credential_service_principal#create DataFactoryCredentialServicePrincipal#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/data_factory_credential_service_principal#delete DataFactoryCredentialServicePrincipal#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/data_factory_credential_service_principal#read DataFactoryCredentialServicePrincipal#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/data_factory_credential_service_principal#update DataFactoryCredentialServicePrincipal#update}
    */
    readonly update?: string;
}
export declare function dataFactoryCredentialServicePrincipalTimeoutsToTerraform(struct?: DataFactoryCredentialServicePrincipalTimeouts | cdktf.IResolvable): any;
export declare function dataFactoryCredentialServicePrincipalTimeoutsToHclTerraform(struct?: DataFactoryCredentialServicePrincipalTimeouts | cdktf.IResolvable): any;
export declare class DataFactoryCredentialServicePrincipalTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryCredentialServicePrincipalTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataFactoryCredentialServicePrincipalTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/data_factory_credential_service_principal azurerm_data_factory_credential_service_principal}
*/
export declare class DataFactoryCredentialServicePrincipal extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_data_factory_credential_service_principal";
    /**
    * Generates CDKTF code for importing a DataFactoryCredentialServicePrincipal resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataFactoryCredentialServicePrincipal to import
    * @param importFromId The id of the existing DataFactoryCredentialServicePrincipal that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/data_factory_credential_service_principal#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataFactoryCredentialServicePrincipal to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/data_factory_credential_service_principal azurerm_data_factory_credential_service_principal} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataFactoryCredentialServicePrincipalConfig
    */
    constructor(scope: Construct, id: string, config: DataFactoryCredentialServicePrincipalConfig);
    private _annotations?;
    get annotations(): string[];
    set annotations(value: string[]);
    resetAnnotations(): void;
    get annotationsInput(): string[] | undefined;
    private _dataFactoryId?;
    get dataFactoryId(): string;
    set dataFactoryId(value: string);
    get dataFactoryIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _servicePrincipalId?;
    get servicePrincipalId(): string;
    set servicePrincipalId(value: string);
    get servicePrincipalIdInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    get tenantIdInput(): string | undefined;
    private _servicePrincipalKey;
    get servicePrincipalKey(): DataFactoryCredentialServicePrincipalServicePrincipalKeyOutputReference;
    putServicePrincipalKey(value: DataFactoryCredentialServicePrincipalServicePrincipalKey): void;
    resetServicePrincipalKey(): void;
    get servicePrincipalKeyInput(): DataFactoryCredentialServicePrincipalServicePrincipalKey | undefined;
    private _timeouts;
    get timeouts(): DataFactoryCredentialServicePrincipalTimeoutsOutputReference;
    putTimeouts(value: DataFactoryCredentialServicePrincipalTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataFactoryCredentialServicePrincipalTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
