/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EventhubAuthorizationRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_authorization_rule#eventhub_name EventhubAuthorizationRule#eventhub_name}
    */
    readonly eventhubName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_authorization_rule#id EventhubAuthorizationRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_authorization_rule#listen EventhubAuthorizationRule#listen}
    */
    readonly listen?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_authorization_rule#manage EventhubAuthorizationRule#manage}
    */
    readonly manage?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_authorization_rule#name EventhubAuthorizationRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_authorization_rule#namespace_name EventhubAuthorizationRule#namespace_name}
    */
    readonly namespaceName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_authorization_rule#resource_group_name EventhubAuthorizationRule#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_authorization_rule#send EventhubAuthorizationRule#send}
    */
    readonly send?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_authorization_rule#timeouts EventhubAuthorizationRule#timeouts}
    */
    readonly timeouts?: EventhubAuthorizationRuleTimeouts;
}
export interface EventhubAuthorizationRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_authorization_rule#create EventhubAuthorizationRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_authorization_rule#delete EventhubAuthorizationRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_authorization_rule#read EventhubAuthorizationRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_authorization_rule#update EventhubAuthorizationRule#update}
    */
    readonly update?: string;
}
export declare function eventhubAuthorizationRuleTimeoutsToTerraform(struct?: EventhubAuthorizationRuleTimeouts | cdktf.IResolvable): any;
export declare function eventhubAuthorizationRuleTimeoutsToHclTerraform(struct?: EventhubAuthorizationRuleTimeouts | cdktf.IResolvable): any;
export declare class EventhubAuthorizationRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EventhubAuthorizationRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: EventhubAuthorizationRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_authorization_rule azurerm_eventhub_authorization_rule}
*/
export declare class EventhubAuthorizationRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_eventhub_authorization_rule";
    /**
    * Generates CDKTF code for importing a EventhubAuthorizationRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the EventhubAuthorizationRule to import
    * @param importFromId The id of the existing EventhubAuthorizationRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_authorization_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the EventhubAuthorizationRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_authorization_rule azurerm_eventhub_authorization_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EventhubAuthorizationRuleConfig
    */
    constructor(scope: Construct, id: string, config: EventhubAuthorizationRuleConfig);
    private _eventhubName?;
    get eventhubName(): string;
    set eventhubName(value: string);
    get eventhubNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _listen?;
    get listen(): boolean | cdktf.IResolvable;
    set listen(value: boolean | cdktf.IResolvable);
    resetListen(): void;
    get listenInput(): boolean | cdktf.IResolvable | undefined;
    private _manage?;
    get manage(): boolean | cdktf.IResolvable;
    set manage(value: boolean | cdktf.IResolvable);
    resetManage(): void;
    get manageInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespaceName?;
    get namespaceName(): string;
    set namespaceName(value: string);
    get namespaceNameInput(): string | undefined;
    get primaryConnectionString(): string;
    get primaryConnectionStringAlias(): string;
    get primaryKey(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryConnectionString(): string;
    get secondaryConnectionStringAlias(): string;
    get secondaryKey(): string;
    private _send?;
    get send(): boolean | cdktf.IResolvable;
    set send(value: boolean | cdktf.IResolvable);
    resetSend(): void;
    get sendInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    get timeouts(): EventhubAuthorizationRuleTimeoutsOutputReference;
    putTimeouts(value: EventhubAuthorizationRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | EventhubAuthorizationRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
