/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EventhubNamespaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#auto_inflate_enabled EventhubNamespace#auto_inflate_enabled}
    */
    readonly autoInflateEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#capacity EventhubNamespace#capacity}
    */
    readonly capacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#dedicated_cluster_id EventhubNamespace#dedicated_cluster_id}
    */
    readonly dedicatedClusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#id EventhubNamespace#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#local_authentication_enabled EventhubNamespace#local_authentication_enabled}
    */
    readonly localAuthenticationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#location EventhubNamespace#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#maximum_throughput_units EventhubNamespace#maximum_throughput_units}
    */
    readonly maximumThroughputUnits?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#minimum_tls_version EventhubNamespace#minimum_tls_version}
    */
    readonly minimumTlsVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#name EventhubNamespace#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#network_rulesets EventhubNamespace#network_rulesets}
    */
    readonly networkRulesets?: EventhubNamespaceNetworkRulesets[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#public_network_access_enabled EventhubNamespace#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#resource_group_name EventhubNamespace#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#sku EventhubNamespace#sku}
    */
    readonly sku: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#tags EventhubNamespace#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#identity EventhubNamespace#identity}
    */
    readonly identity?: EventhubNamespaceIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#timeouts EventhubNamespace#timeouts}
    */
    readonly timeouts?: EventhubNamespaceTimeouts;
}
export interface EventhubNamespaceNetworkRulesetsIpRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#action EventhubNamespace#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#ip_mask EventhubNamespace#ip_mask}
    */
    readonly ipMask?: string;
}
export declare function eventhubNamespaceNetworkRulesetsIpRuleToTerraform(struct?: EventhubNamespaceNetworkRulesetsIpRule | cdktf.IResolvable): any;
export declare function eventhubNamespaceNetworkRulesetsIpRuleToHclTerraform(struct?: EventhubNamespaceNetworkRulesetsIpRule | cdktf.IResolvable): any;
export declare class EventhubNamespaceNetworkRulesetsIpRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): EventhubNamespaceNetworkRulesetsIpRule | cdktf.IResolvable | undefined;
    set internalValue(value: EventhubNamespaceNetworkRulesetsIpRule | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    resetAction(): void;
    get actionInput(): string | undefined;
    private _ipMask?;
    get ipMask(): string;
    set ipMask(value: string);
    resetIpMask(): void;
    get ipMaskInput(): string | undefined;
}
export declare class EventhubNamespaceNetworkRulesetsIpRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: EventhubNamespaceNetworkRulesetsIpRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): EventhubNamespaceNetworkRulesetsIpRuleOutputReference;
}
export interface EventhubNamespaceNetworkRulesetsVirtualNetworkRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#ignore_missing_virtual_network_service_endpoint EventhubNamespace#ignore_missing_virtual_network_service_endpoint}
    */
    readonly ignoreMissingVirtualNetworkServiceEndpoint?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#subnet_id EventhubNamespace#subnet_id}
    */
    readonly subnetId?: string;
}
export declare function eventhubNamespaceNetworkRulesetsVirtualNetworkRuleToTerraform(struct?: EventhubNamespaceNetworkRulesetsVirtualNetworkRule | cdktf.IResolvable): any;
export declare function eventhubNamespaceNetworkRulesetsVirtualNetworkRuleToHclTerraform(struct?: EventhubNamespaceNetworkRulesetsVirtualNetworkRule | cdktf.IResolvable): any;
export declare class EventhubNamespaceNetworkRulesetsVirtualNetworkRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): EventhubNamespaceNetworkRulesetsVirtualNetworkRule | cdktf.IResolvable | undefined;
    set internalValue(value: EventhubNamespaceNetworkRulesetsVirtualNetworkRule | cdktf.IResolvable | undefined);
    private _ignoreMissingVirtualNetworkServiceEndpoint?;
    get ignoreMissingVirtualNetworkServiceEndpoint(): boolean | cdktf.IResolvable;
    set ignoreMissingVirtualNetworkServiceEndpoint(value: boolean | cdktf.IResolvable);
    resetIgnoreMissingVirtualNetworkServiceEndpoint(): void;
    get ignoreMissingVirtualNetworkServiceEndpointInput(): boolean | cdktf.IResolvable | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
}
export declare class EventhubNamespaceNetworkRulesetsVirtualNetworkRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: EventhubNamespaceNetworkRulesetsVirtualNetworkRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): EventhubNamespaceNetworkRulesetsVirtualNetworkRuleOutputReference;
}
export interface EventhubNamespaceNetworkRulesets {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#default_action EventhubNamespace#default_action}
    */
    readonly defaultAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#ip_rule EventhubNamespace#ip_rule}
    */
    readonly ipRule?: EventhubNamespaceNetworkRulesetsIpRule[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#public_network_access_enabled EventhubNamespace#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#trusted_service_access_enabled EventhubNamespace#trusted_service_access_enabled}
    */
    readonly trustedServiceAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#virtual_network_rule EventhubNamespace#virtual_network_rule}
    */
    readonly virtualNetworkRule?: EventhubNamespaceNetworkRulesetsVirtualNetworkRule[] | cdktf.IResolvable;
}
export declare function eventhubNamespaceNetworkRulesetsToTerraform(struct?: EventhubNamespaceNetworkRulesets | cdktf.IResolvable): any;
export declare function eventhubNamespaceNetworkRulesetsToHclTerraform(struct?: EventhubNamespaceNetworkRulesets | cdktf.IResolvable): any;
export declare class EventhubNamespaceNetworkRulesetsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): EventhubNamespaceNetworkRulesets | cdktf.IResolvable | undefined;
    set internalValue(value: EventhubNamespaceNetworkRulesets | cdktf.IResolvable | undefined);
    private _defaultAction?;
    get defaultAction(): string;
    set defaultAction(value: string);
    resetDefaultAction(): void;
    get defaultActionInput(): string | undefined;
    private _ipRule;
    get ipRule(): EventhubNamespaceNetworkRulesetsIpRuleList;
    putIpRule(value: EventhubNamespaceNetworkRulesetsIpRule[] | cdktf.IResolvable): void;
    resetIpRule(): void;
    get ipRuleInput(): cdktf.IResolvable | EventhubNamespaceNetworkRulesetsIpRule[] | undefined;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _trustedServiceAccessEnabled?;
    get trustedServiceAccessEnabled(): boolean | cdktf.IResolvable;
    set trustedServiceAccessEnabled(value: boolean | cdktf.IResolvable);
    resetTrustedServiceAccessEnabled(): void;
    get trustedServiceAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _virtualNetworkRule;
    get virtualNetworkRule(): EventhubNamespaceNetworkRulesetsVirtualNetworkRuleList;
    putVirtualNetworkRule(value: EventhubNamespaceNetworkRulesetsVirtualNetworkRule[] | cdktf.IResolvable): void;
    resetVirtualNetworkRule(): void;
    get virtualNetworkRuleInput(): cdktf.IResolvable | EventhubNamespaceNetworkRulesetsVirtualNetworkRule[] | undefined;
}
export declare class EventhubNamespaceNetworkRulesetsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: EventhubNamespaceNetworkRulesets[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): EventhubNamespaceNetworkRulesetsOutputReference;
}
export interface EventhubNamespaceIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#identity_ids EventhubNamespace#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#type EventhubNamespace#type}
    */
    readonly type: string;
}
export declare function eventhubNamespaceIdentityToTerraform(struct?: EventhubNamespaceIdentityOutputReference | EventhubNamespaceIdentity): any;
export declare function eventhubNamespaceIdentityToHclTerraform(struct?: EventhubNamespaceIdentityOutputReference | EventhubNamespaceIdentity): any;
export declare class EventhubNamespaceIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EventhubNamespaceIdentity | undefined;
    set internalValue(value: EventhubNamespaceIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface EventhubNamespaceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#create EventhubNamespace#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#delete EventhubNamespace#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#read EventhubNamespace#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#update EventhubNamespace#update}
    */
    readonly update?: string;
}
export declare function eventhubNamespaceTimeoutsToTerraform(struct?: EventhubNamespaceTimeouts | cdktf.IResolvable): any;
export declare function eventhubNamespaceTimeoutsToHclTerraform(struct?: EventhubNamespaceTimeouts | cdktf.IResolvable): any;
export declare class EventhubNamespaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EventhubNamespaceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: EventhubNamespaceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace azurerm_eventhub_namespace}
*/
export declare class EventhubNamespace extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_eventhub_namespace";
    /**
    * Generates CDKTF code for importing a EventhubNamespace resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the EventhubNamespace to import
    * @param importFromId The id of the existing EventhubNamespace that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the EventhubNamespace to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/eventhub_namespace azurerm_eventhub_namespace} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EventhubNamespaceConfig
    */
    constructor(scope: Construct, id: string, config: EventhubNamespaceConfig);
    private _autoInflateEnabled?;
    get autoInflateEnabled(): boolean | cdktf.IResolvable;
    set autoInflateEnabled(value: boolean | cdktf.IResolvable);
    resetAutoInflateEnabled(): void;
    get autoInflateEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _capacity?;
    get capacity(): number;
    set capacity(value: number);
    resetCapacity(): void;
    get capacityInput(): number | undefined;
    private _dedicatedClusterId?;
    get dedicatedClusterId(): string;
    set dedicatedClusterId(value: string);
    resetDedicatedClusterId(): void;
    get dedicatedClusterIdInput(): string | undefined;
    get defaultPrimaryConnectionString(): string;
    get defaultPrimaryConnectionStringAlias(): string;
    get defaultPrimaryKey(): string;
    get defaultSecondaryConnectionString(): string;
    get defaultSecondaryConnectionStringAlias(): string;
    get defaultSecondaryKey(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _localAuthenticationEnabled?;
    get localAuthenticationEnabled(): boolean | cdktf.IResolvable;
    set localAuthenticationEnabled(value: boolean | cdktf.IResolvable);
    resetLocalAuthenticationEnabled(): void;
    get localAuthenticationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _maximumThroughputUnits?;
    get maximumThroughputUnits(): number;
    set maximumThroughputUnits(value: number);
    resetMaximumThroughputUnits(): void;
    get maximumThroughputUnitsInput(): number | undefined;
    private _minimumTlsVersion?;
    get minimumTlsVersion(): string;
    set minimumTlsVersion(value: string);
    resetMinimumTlsVersion(): void;
    get minimumTlsVersionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkRulesets;
    get networkRulesets(): EventhubNamespaceNetworkRulesetsList;
    putNetworkRulesets(value: EventhubNamespaceNetworkRulesets[] | cdktf.IResolvable): void;
    resetNetworkRulesets(): void;
    get networkRulesetsInput(): cdktf.IResolvable | EventhubNamespaceNetworkRulesets[] | undefined;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    get skuInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _identity;
    get identity(): EventhubNamespaceIdentityOutputReference;
    putIdentity(value: EventhubNamespaceIdentity): void;
    resetIdentity(): void;
    get identityInput(): EventhubNamespaceIdentity | undefined;
    private _timeouts;
    get timeouts(): EventhubNamespaceTimeoutsOutputReference;
    putTimeouts(value: EventhubNamespaceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | EventhubNamespaceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
