/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ExpressRoutePortConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#bandwidth_in_gbps ExpressRoutePort#bandwidth_in_gbps}
    */
    readonly bandwidthInGbps: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#billing_type ExpressRoutePort#billing_type}
    */
    readonly billingType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#encapsulation ExpressRoutePort#encapsulation}
    */
    readonly encapsulation: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#id ExpressRoutePort#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#location ExpressRoutePort#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#name ExpressRoutePort#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#peering_location ExpressRoutePort#peering_location}
    */
    readonly peeringLocation: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#resource_group_name ExpressRoutePort#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#tags ExpressRoutePort#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#identity ExpressRoutePort#identity}
    */
    readonly identity?: ExpressRoutePortIdentity;
    /**
    * link1 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#link1 ExpressRoutePort#link1}
    */
    readonly link1?: ExpressRoutePortLink1;
    /**
    * link2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#link2 ExpressRoutePort#link2}
    */
    readonly link2?: ExpressRoutePortLink2;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#timeouts ExpressRoutePort#timeouts}
    */
    readonly timeouts?: ExpressRoutePortTimeouts;
}
export interface ExpressRoutePortIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#identity_ids ExpressRoutePort#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#type ExpressRoutePort#type}
    */
    readonly type: string;
}
export declare function expressRoutePortIdentityToTerraform(struct?: ExpressRoutePortIdentityOutputReference | ExpressRoutePortIdentity): any;
export declare function expressRoutePortIdentityToHclTerraform(struct?: ExpressRoutePortIdentityOutputReference | ExpressRoutePortIdentity): any;
export declare class ExpressRoutePortIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ExpressRoutePortIdentity | undefined;
    set internalValue(value: ExpressRoutePortIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ExpressRoutePortLink1 {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#admin_enabled ExpressRoutePort#admin_enabled}
    */
    readonly adminEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#macsec_cak_keyvault_secret_id ExpressRoutePort#macsec_cak_keyvault_secret_id}
    */
    readonly macsecCakKeyvaultSecretId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#macsec_cipher ExpressRoutePort#macsec_cipher}
    */
    readonly macsecCipher?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#macsec_ckn_keyvault_secret_id ExpressRoutePort#macsec_ckn_keyvault_secret_id}
    */
    readonly macsecCknKeyvaultSecretId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#macsec_sci_enabled ExpressRoutePort#macsec_sci_enabled}
    */
    readonly macsecSciEnabled?: boolean | cdktf.IResolvable;
}
export declare function expressRoutePortLink1ToTerraform(struct?: ExpressRoutePortLink1OutputReference | ExpressRoutePortLink1): any;
export declare function expressRoutePortLink1ToHclTerraform(struct?: ExpressRoutePortLink1OutputReference | ExpressRoutePortLink1): any;
export declare class ExpressRoutePortLink1OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ExpressRoutePortLink1 | undefined;
    set internalValue(value: ExpressRoutePortLink1 | undefined);
    private _adminEnabled?;
    get adminEnabled(): boolean | cdktf.IResolvable;
    set adminEnabled(value: boolean | cdktf.IResolvable);
    resetAdminEnabled(): void;
    get adminEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get connectorType(): string;
    get id(): string;
    get interfaceName(): string;
    private _macsecCakKeyvaultSecretId?;
    get macsecCakKeyvaultSecretId(): string;
    set macsecCakKeyvaultSecretId(value: string);
    resetMacsecCakKeyvaultSecretId(): void;
    get macsecCakKeyvaultSecretIdInput(): string | undefined;
    private _macsecCipher?;
    get macsecCipher(): string;
    set macsecCipher(value: string);
    resetMacsecCipher(): void;
    get macsecCipherInput(): string | undefined;
    private _macsecCknKeyvaultSecretId?;
    get macsecCknKeyvaultSecretId(): string;
    set macsecCknKeyvaultSecretId(value: string);
    resetMacsecCknKeyvaultSecretId(): void;
    get macsecCknKeyvaultSecretIdInput(): string | undefined;
    private _macsecSciEnabled?;
    get macsecSciEnabled(): boolean | cdktf.IResolvable;
    set macsecSciEnabled(value: boolean | cdktf.IResolvable);
    resetMacsecSciEnabled(): void;
    get macsecSciEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get patchPanelId(): string;
    get rackId(): string;
    get routerName(): string;
}
export interface ExpressRoutePortLink2 {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#admin_enabled ExpressRoutePort#admin_enabled}
    */
    readonly adminEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#macsec_cak_keyvault_secret_id ExpressRoutePort#macsec_cak_keyvault_secret_id}
    */
    readonly macsecCakKeyvaultSecretId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#macsec_cipher ExpressRoutePort#macsec_cipher}
    */
    readonly macsecCipher?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#macsec_ckn_keyvault_secret_id ExpressRoutePort#macsec_ckn_keyvault_secret_id}
    */
    readonly macsecCknKeyvaultSecretId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#macsec_sci_enabled ExpressRoutePort#macsec_sci_enabled}
    */
    readonly macsecSciEnabled?: boolean | cdktf.IResolvable;
}
export declare function expressRoutePortLink2ToTerraform(struct?: ExpressRoutePortLink2OutputReference | ExpressRoutePortLink2): any;
export declare function expressRoutePortLink2ToHclTerraform(struct?: ExpressRoutePortLink2OutputReference | ExpressRoutePortLink2): any;
export declare class ExpressRoutePortLink2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ExpressRoutePortLink2 | undefined;
    set internalValue(value: ExpressRoutePortLink2 | undefined);
    private _adminEnabled?;
    get adminEnabled(): boolean | cdktf.IResolvable;
    set adminEnabled(value: boolean | cdktf.IResolvable);
    resetAdminEnabled(): void;
    get adminEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get connectorType(): string;
    get id(): string;
    get interfaceName(): string;
    private _macsecCakKeyvaultSecretId?;
    get macsecCakKeyvaultSecretId(): string;
    set macsecCakKeyvaultSecretId(value: string);
    resetMacsecCakKeyvaultSecretId(): void;
    get macsecCakKeyvaultSecretIdInput(): string | undefined;
    private _macsecCipher?;
    get macsecCipher(): string;
    set macsecCipher(value: string);
    resetMacsecCipher(): void;
    get macsecCipherInput(): string | undefined;
    private _macsecCknKeyvaultSecretId?;
    get macsecCknKeyvaultSecretId(): string;
    set macsecCknKeyvaultSecretId(value: string);
    resetMacsecCknKeyvaultSecretId(): void;
    get macsecCknKeyvaultSecretIdInput(): string | undefined;
    private _macsecSciEnabled?;
    get macsecSciEnabled(): boolean | cdktf.IResolvable;
    set macsecSciEnabled(value: boolean | cdktf.IResolvable);
    resetMacsecSciEnabled(): void;
    get macsecSciEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get patchPanelId(): string;
    get rackId(): string;
    get routerName(): string;
}
export interface ExpressRoutePortTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#create ExpressRoutePort#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#delete ExpressRoutePort#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#read ExpressRoutePort#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#update ExpressRoutePort#update}
    */
    readonly update?: string;
}
export declare function expressRoutePortTimeoutsToTerraform(struct?: ExpressRoutePortTimeouts | cdktf.IResolvable): any;
export declare function expressRoutePortTimeoutsToHclTerraform(struct?: ExpressRoutePortTimeouts | cdktf.IResolvable): any;
export declare class ExpressRoutePortTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ExpressRoutePortTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ExpressRoutePortTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port azurerm_express_route_port}
*/
export declare class ExpressRoutePort extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_express_route_port";
    /**
    * Generates CDKTF code for importing a ExpressRoutePort resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ExpressRoutePort to import
    * @param importFromId The id of the existing ExpressRoutePort that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ExpressRoutePort to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/express_route_port azurerm_express_route_port} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ExpressRoutePortConfig
    */
    constructor(scope: Construct, id: string, config: ExpressRoutePortConfig);
    private _bandwidthInGbps?;
    get bandwidthInGbps(): number;
    set bandwidthInGbps(value: number);
    get bandwidthInGbpsInput(): number | undefined;
    private _billingType?;
    get billingType(): string;
    set billingType(value: string);
    resetBillingType(): void;
    get billingTypeInput(): string | undefined;
    private _encapsulation?;
    get encapsulation(): string;
    set encapsulation(value: string);
    get encapsulationInput(): string | undefined;
    get ethertype(): string;
    get guid(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get mtu(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _peeringLocation?;
    get peeringLocation(): string;
    set peeringLocation(value: string);
    get peeringLocationInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _identity;
    get identity(): ExpressRoutePortIdentityOutputReference;
    putIdentity(value: ExpressRoutePortIdentity): void;
    resetIdentity(): void;
    get identityInput(): ExpressRoutePortIdentity | undefined;
    private _link1;
    get link1(): ExpressRoutePortLink1OutputReference;
    putLink1(value: ExpressRoutePortLink1): void;
    resetLink1(): void;
    get link1Input(): ExpressRoutePortLink1 | undefined;
    private _link2;
    get link2(): ExpressRoutePortLink2OutputReference;
    putLink2(value: ExpressRoutePortLink2): void;
    resetLink2(): void;
    get link2Input(): ExpressRoutePortLink2 | undefined;
    private _timeouts;
    get timeouts(): ExpressRoutePortTimeoutsOutputReference;
    putTimeouts(value: ExpressRoutePortTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ExpressRoutePortTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
