/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ExtendedCustomLocationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/extended_custom_location#cluster_extension_ids ExtendedCustomLocation#cluster_extension_ids}
    */
    readonly clusterExtensionIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/extended_custom_location#display_name ExtendedCustomLocation#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/extended_custom_location#host_resource_id ExtendedCustomLocation#host_resource_id}
    */
    readonly hostResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/extended_custom_location#host_type ExtendedCustomLocation#host_type}
    */
    readonly hostType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/extended_custom_location#id ExtendedCustomLocation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/extended_custom_location#location ExtendedCustomLocation#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/extended_custom_location#name ExtendedCustomLocation#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/extended_custom_location#namespace ExtendedCustomLocation#namespace}
    */
    readonly namespace: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/extended_custom_location#resource_group_name ExtendedCustomLocation#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * authentication block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/extended_custom_location#authentication ExtendedCustomLocation#authentication}
    */
    readonly authentication?: ExtendedCustomLocationAuthentication;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/extended_custom_location#timeouts ExtendedCustomLocation#timeouts}
    */
    readonly timeouts?: ExtendedCustomLocationTimeouts;
}
export interface ExtendedCustomLocationAuthentication {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/extended_custom_location#type ExtendedCustomLocation#type}
    */
    readonly type?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/extended_custom_location#value ExtendedCustomLocation#value}
    */
    readonly value: string;
}
export declare function extendedCustomLocationAuthenticationToTerraform(struct?: ExtendedCustomLocationAuthenticationOutputReference | ExtendedCustomLocationAuthentication): any;
export declare function extendedCustomLocationAuthenticationToHclTerraform(struct?: ExtendedCustomLocationAuthenticationOutputReference | ExtendedCustomLocationAuthentication): any;
export declare class ExtendedCustomLocationAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ExtendedCustomLocationAuthentication | undefined;
    set internalValue(value: ExtendedCustomLocationAuthentication | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export interface ExtendedCustomLocationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/extended_custom_location#create ExtendedCustomLocation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/extended_custom_location#delete ExtendedCustomLocation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/extended_custom_location#read ExtendedCustomLocation#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/extended_custom_location#update ExtendedCustomLocation#update}
    */
    readonly update?: string;
}
export declare function extendedCustomLocationTimeoutsToTerraform(struct?: ExtendedCustomLocationTimeouts | cdktf.IResolvable): any;
export declare function extendedCustomLocationTimeoutsToHclTerraform(struct?: ExtendedCustomLocationTimeouts | cdktf.IResolvable): any;
export declare class ExtendedCustomLocationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ExtendedCustomLocationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ExtendedCustomLocationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/extended_custom_location azurerm_extended_custom_location}
*/
export declare class ExtendedCustomLocation extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_extended_custom_location";
    /**
    * Generates CDKTF code for importing a ExtendedCustomLocation resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ExtendedCustomLocation to import
    * @param importFromId The id of the existing ExtendedCustomLocation that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/extended_custom_location#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ExtendedCustomLocation to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/extended_custom_location azurerm_extended_custom_location} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ExtendedCustomLocationConfig
    */
    constructor(scope: Construct, id: string, config: ExtendedCustomLocationConfig);
    private _clusterExtensionIds?;
    get clusterExtensionIds(): string[];
    set clusterExtensionIds(value: string[]);
    get clusterExtensionIdsInput(): string[] | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _hostResourceId?;
    get hostResourceId(): string;
    set hostResourceId(value: string);
    get hostResourceIdInput(): string | undefined;
    private _hostType?;
    get hostType(): string;
    set hostType(value: string);
    resetHostType(): void;
    get hostTypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _authentication;
    get authentication(): ExtendedCustomLocationAuthenticationOutputReference;
    putAuthentication(value: ExtendedCustomLocationAuthentication): void;
    resetAuthentication(): void;
    get authenticationInput(): ExtendedCustomLocationAuthentication | undefined;
    private _timeouts;
    get timeouts(): ExtendedCustomLocationTimeoutsOutputReference;
    putTimeouts(value: ExtendedCustomLocationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ExtendedCustomLocationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
