/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FirewallNatRuleCollectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/firewall_nat_rule_collection#action FirewallNatRuleCollection#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/firewall_nat_rule_collection#azure_firewall_name FirewallNatRuleCollection#azure_firewall_name}
    */
    readonly azureFirewallName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/firewall_nat_rule_collection#id FirewallNatRuleCollection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/firewall_nat_rule_collection#name FirewallNatRuleCollection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/firewall_nat_rule_collection#priority FirewallNatRuleCollection#priority}
    */
    readonly priority: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/firewall_nat_rule_collection#resource_group_name FirewallNatRuleCollection#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/firewall_nat_rule_collection#rule FirewallNatRuleCollection#rule}
    */
    readonly rule: FirewallNatRuleCollectionRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/firewall_nat_rule_collection#timeouts FirewallNatRuleCollection#timeouts}
    */
    readonly timeouts?: FirewallNatRuleCollectionTimeouts;
}
export interface FirewallNatRuleCollectionRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/firewall_nat_rule_collection#description FirewallNatRuleCollection#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/firewall_nat_rule_collection#destination_addresses FirewallNatRuleCollection#destination_addresses}
    */
    readonly destinationAddresses: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/firewall_nat_rule_collection#destination_ports FirewallNatRuleCollection#destination_ports}
    */
    readonly destinationPorts: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/firewall_nat_rule_collection#name FirewallNatRuleCollection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/firewall_nat_rule_collection#protocols FirewallNatRuleCollection#protocols}
    */
    readonly protocols: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/firewall_nat_rule_collection#source_addresses FirewallNatRuleCollection#source_addresses}
    */
    readonly sourceAddresses?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/firewall_nat_rule_collection#source_ip_groups FirewallNatRuleCollection#source_ip_groups}
    */
    readonly sourceIpGroups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/firewall_nat_rule_collection#translated_address FirewallNatRuleCollection#translated_address}
    */
    readonly translatedAddress: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/firewall_nat_rule_collection#translated_port FirewallNatRuleCollection#translated_port}
    */
    readonly translatedPort: string;
}
export declare function firewallNatRuleCollectionRuleToTerraform(struct?: FirewallNatRuleCollectionRule | cdktf.IResolvable): any;
export declare function firewallNatRuleCollectionRuleToHclTerraform(struct?: FirewallNatRuleCollectionRule | cdktf.IResolvable): any;
export declare class FirewallNatRuleCollectionRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FirewallNatRuleCollectionRule | cdktf.IResolvable | undefined;
    set internalValue(value: FirewallNatRuleCollectionRule | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _destinationAddresses?;
    get destinationAddresses(): string[];
    set destinationAddresses(value: string[]);
    get destinationAddressesInput(): string[] | undefined;
    private _destinationPorts?;
    get destinationPorts(): string[];
    set destinationPorts(value: string[]);
    get destinationPortsInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _protocols?;
    get protocols(): string[];
    set protocols(value: string[]);
    get protocolsInput(): string[] | undefined;
    private _sourceAddresses?;
    get sourceAddresses(): string[];
    set sourceAddresses(value: string[]);
    resetSourceAddresses(): void;
    get sourceAddressesInput(): string[] | undefined;
    private _sourceIpGroups?;
    get sourceIpGroups(): string[];
    set sourceIpGroups(value: string[]);
    resetSourceIpGroups(): void;
    get sourceIpGroupsInput(): string[] | undefined;
    private _translatedAddress?;
    get translatedAddress(): string;
    set translatedAddress(value: string);
    get translatedAddressInput(): string | undefined;
    private _translatedPort?;
    get translatedPort(): string;
    set translatedPort(value: string);
    get translatedPortInput(): string | undefined;
}
export declare class FirewallNatRuleCollectionRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FirewallNatRuleCollectionRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FirewallNatRuleCollectionRuleOutputReference;
}
export interface FirewallNatRuleCollectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/firewall_nat_rule_collection#create FirewallNatRuleCollection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/firewall_nat_rule_collection#delete FirewallNatRuleCollection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/firewall_nat_rule_collection#read FirewallNatRuleCollection#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/firewall_nat_rule_collection#update FirewallNatRuleCollection#update}
    */
    readonly update?: string;
}
export declare function firewallNatRuleCollectionTimeoutsToTerraform(struct?: FirewallNatRuleCollectionTimeouts | cdktf.IResolvable): any;
export declare function firewallNatRuleCollectionTimeoutsToHclTerraform(struct?: FirewallNatRuleCollectionTimeouts | cdktf.IResolvable): any;
export declare class FirewallNatRuleCollectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FirewallNatRuleCollectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: FirewallNatRuleCollectionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/firewall_nat_rule_collection azurerm_firewall_nat_rule_collection}
*/
export declare class FirewallNatRuleCollection extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_firewall_nat_rule_collection";
    /**
    * Generates CDKTF code for importing a FirewallNatRuleCollection resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the FirewallNatRuleCollection to import
    * @param importFromId The id of the existing FirewallNatRuleCollection that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/firewall_nat_rule_collection#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the FirewallNatRuleCollection to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/firewall_nat_rule_collection azurerm_firewall_nat_rule_collection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FirewallNatRuleCollectionConfig
    */
    constructor(scope: Construct, id: string, config: FirewallNatRuleCollectionConfig);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _azureFirewallName?;
    get azureFirewallName(): string;
    set azureFirewallName(value: string);
    get azureFirewallNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _rule;
    get rule(): FirewallNatRuleCollectionRuleList;
    putRule(value: FirewallNatRuleCollectionRule[] | cdktf.IResolvable): void;
    get ruleInput(): cdktf.IResolvable | FirewallNatRuleCollectionRule[] | undefined;
    private _timeouts;
    get timeouts(): FirewallNatRuleCollectionTimeoutsOutputReference;
    putTimeouts(value: FirewallNatRuleCollectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | FirewallNatRuleCollectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
