/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HdinsightSparkClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#cluster_version HdinsightSparkCluster#cluster_version}
    */
    readonly clusterVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#encryption_in_transit_enabled HdinsightSparkCluster#encryption_in_transit_enabled}
    */
    readonly encryptionInTransitEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#id HdinsightSparkCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#location HdinsightSparkCluster#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#name HdinsightSparkCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#resource_group_name HdinsightSparkCluster#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#tags HdinsightSparkCluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#tier HdinsightSparkCluster#tier}
    */
    readonly tier: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#tls_min_version HdinsightSparkCluster#tls_min_version}
    */
    readonly tlsMinVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#zones HdinsightSparkCluster#zones}
    */
    readonly zones?: string[];
    /**
    * component_version block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#component_version HdinsightSparkCluster#component_version}
    */
    readonly componentVersion: HdinsightSparkClusterComponentVersion;
    /**
    * compute_isolation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#compute_isolation HdinsightSparkCluster#compute_isolation}
    */
    readonly computeIsolation?: HdinsightSparkClusterComputeIsolation;
    /**
    * disk_encryption block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#disk_encryption HdinsightSparkCluster#disk_encryption}
    */
    readonly diskEncryption?: HdinsightSparkClusterDiskEncryption[] | cdktf.IResolvable;
    /**
    * extension block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#extension HdinsightSparkCluster#extension}
    */
    readonly extension?: HdinsightSparkClusterExtension;
    /**
    * gateway block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#gateway HdinsightSparkCluster#gateway}
    */
    readonly gateway: HdinsightSparkClusterGateway;
    /**
    * metastores block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#metastores HdinsightSparkCluster#metastores}
    */
    readonly metastores?: HdinsightSparkClusterMetastores;
    /**
    * monitor block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#monitor HdinsightSparkCluster#monitor}
    */
    readonly monitor?: HdinsightSparkClusterMonitor;
    /**
    * network block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#network HdinsightSparkCluster#network}
    */
    readonly network?: HdinsightSparkClusterNetwork;
    /**
    * private_link_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#private_link_configuration HdinsightSparkCluster#private_link_configuration}
    */
    readonly privateLinkConfiguration?: HdinsightSparkClusterPrivateLinkConfiguration;
    /**
    * roles block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#roles HdinsightSparkCluster#roles}
    */
    readonly roles: HdinsightSparkClusterRoles;
    /**
    * security_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#security_profile HdinsightSparkCluster#security_profile}
    */
    readonly securityProfile?: HdinsightSparkClusterSecurityProfile;
    /**
    * storage_account block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#storage_account HdinsightSparkCluster#storage_account}
    */
    readonly storageAccount?: HdinsightSparkClusterStorageAccount[] | cdktf.IResolvable;
    /**
    * storage_account_gen2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#storage_account_gen2 HdinsightSparkCluster#storage_account_gen2}
    */
    readonly storageAccountGen2?: HdinsightSparkClusterStorageAccountGen2;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#timeouts HdinsightSparkCluster#timeouts}
    */
    readonly timeouts?: HdinsightSparkClusterTimeouts;
}
export interface HdinsightSparkClusterComponentVersion {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#spark HdinsightSparkCluster#spark}
    */
    readonly spark: string;
}
export declare function hdinsightSparkClusterComponentVersionToTerraform(struct?: HdinsightSparkClusterComponentVersionOutputReference | HdinsightSparkClusterComponentVersion): any;
export declare function hdinsightSparkClusterComponentVersionToHclTerraform(struct?: HdinsightSparkClusterComponentVersionOutputReference | HdinsightSparkClusterComponentVersion): any;
export declare class HdinsightSparkClusterComponentVersionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightSparkClusterComponentVersion | undefined;
    set internalValue(value: HdinsightSparkClusterComponentVersion | undefined);
    private _spark?;
    get spark(): string;
    set spark(value: string);
    get sparkInput(): string | undefined;
}
export interface HdinsightSparkClusterComputeIsolation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#compute_isolation_enabled HdinsightSparkCluster#compute_isolation_enabled}
    */
    readonly computeIsolationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#host_sku HdinsightSparkCluster#host_sku}
    */
    readonly hostSku?: string;
}
export declare function hdinsightSparkClusterComputeIsolationToTerraform(struct?: HdinsightSparkClusterComputeIsolationOutputReference | HdinsightSparkClusterComputeIsolation): any;
export declare function hdinsightSparkClusterComputeIsolationToHclTerraform(struct?: HdinsightSparkClusterComputeIsolationOutputReference | HdinsightSparkClusterComputeIsolation): any;
export declare class HdinsightSparkClusterComputeIsolationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightSparkClusterComputeIsolation | undefined;
    set internalValue(value: HdinsightSparkClusterComputeIsolation | undefined);
    private _computeIsolationEnabled?;
    get computeIsolationEnabled(): boolean | cdktf.IResolvable;
    set computeIsolationEnabled(value: boolean | cdktf.IResolvable);
    resetComputeIsolationEnabled(): void;
    get computeIsolationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _hostSku?;
    get hostSku(): string;
    set hostSku(value: string);
    resetHostSku(): void;
    get hostSkuInput(): string | undefined;
}
export interface HdinsightSparkClusterDiskEncryption {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#encryption_algorithm HdinsightSparkCluster#encryption_algorithm}
    */
    readonly encryptionAlgorithm?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#encryption_at_host_enabled HdinsightSparkCluster#encryption_at_host_enabled}
    */
    readonly encryptionAtHostEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#key_vault_key_id HdinsightSparkCluster#key_vault_key_id}
    */
    readonly keyVaultKeyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#key_vault_managed_identity_id HdinsightSparkCluster#key_vault_managed_identity_id}
    */
    readonly keyVaultManagedIdentityId?: string;
}
export declare function hdinsightSparkClusterDiskEncryptionToTerraform(struct?: HdinsightSparkClusterDiskEncryption | cdktf.IResolvable): any;
export declare function hdinsightSparkClusterDiskEncryptionToHclTerraform(struct?: HdinsightSparkClusterDiskEncryption | cdktf.IResolvable): any;
export declare class HdinsightSparkClusterDiskEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HdinsightSparkClusterDiskEncryption | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightSparkClusterDiskEncryption | cdktf.IResolvable | undefined);
    private _encryptionAlgorithm?;
    get encryptionAlgorithm(): string;
    set encryptionAlgorithm(value: string);
    resetEncryptionAlgorithm(): void;
    get encryptionAlgorithmInput(): string | undefined;
    private _encryptionAtHostEnabled?;
    get encryptionAtHostEnabled(): boolean | cdktf.IResolvable;
    set encryptionAtHostEnabled(value: boolean | cdktf.IResolvable);
    resetEncryptionAtHostEnabled(): void;
    get encryptionAtHostEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _keyVaultKeyId?;
    get keyVaultKeyId(): string;
    set keyVaultKeyId(value: string);
    resetKeyVaultKeyId(): void;
    get keyVaultKeyIdInput(): string | undefined;
    private _keyVaultManagedIdentityId?;
    get keyVaultManagedIdentityId(): string;
    set keyVaultManagedIdentityId(value: string);
    resetKeyVaultManagedIdentityId(): void;
    get keyVaultManagedIdentityIdInput(): string | undefined;
}
export declare class HdinsightSparkClusterDiskEncryptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HdinsightSparkClusterDiskEncryption[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HdinsightSparkClusterDiskEncryptionOutputReference;
}
export interface HdinsightSparkClusterExtension {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#log_analytics_workspace_id HdinsightSparkCluster#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#primary_key HdinsightSparkCluster#primary_key}
    */
    readonly primaryKey: string;
}
export declare function hdinsightSparkClusterExtensionToTerraform(struct?: HdinsightSparkClusterExtensionOutputReference | HdinsightSparkClusterExtension): any;
export declare function hdinsightSparkClusterExtensionToHclTerraform(struct?: HdinsightSparkClusterExtensionOutputReference | HdinsightSparkClusterExtension): any;
export declare class HdinsightSparkClusterExtensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightSparkClusterExtension | undefined;
    set internalValue(value: HdinsightSparkClusterExtension | undefined);
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _primaryKey?;
    get primaryKey(): string;
    set primaryKey(value: string);
    get primaryKeyInput(): string | undefined;
}
export interface HdinsightSparkClusterGateway {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#password HdinsightSparkCluster#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#username HdinsightSparkCluster#username}
    */
    readonly username: string;
}
export declare function hdinsightSparkClusterGatewayToTerraform(struct?: HdinsightSparkClusterGatewayOutputReference | HdinsightSparkClusterGateway): any;
export declare function hdinsightSparkClusterGatewayToHclTerraform(struct?: HdinsightSparkClusterGatewayOutputReference | HdinsightSparkClusterGateway): any;
export declare class HdinsightSparkClusterGatewayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightSparkClusterGateway | undefined;
    set internalValue(value: HdinsightSparkClusterGateway | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface HdinsightSparkClusterMetastoresAmbari {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#database_name HdinsightSparkCluster#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#password HdinsightSparkCluster#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#server HdinsightSparkCluster#server}
    */
    readonly server: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#username HdinsightSparkCluster#username}
    */
    readonly username: string;
}
export declare function hdinsightSparkClusterMetastoresAmbariToTerraform(struct?: HdinsightSparkClusterMetastoresAmbariOutputReference | HdinsightSparkClusterMetastoresAmbari): any;
export declare function hdinsightSparkClusterMetastoresAmbariToHclTerraform(struct?: HdinsightSparkClusterMetastoresAmbariOutputReference | HdinsightSparkClusterMetastoresAmbari): any;
export declare class HdinsightSparkClusterMetastoresAmbariOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightSparkClusterMetastoresAmbari | undefined;
    set internalValue(value: HdinsightSparkClusterMetastoresAmbari | undefined);
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface HdinsightSparkClusterMetastoresHive {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#database_name HdinsightSparkCluster#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#password HdinsightSparkCluster#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#server HdinsightSparkCluster#server}
    */
    readonly server: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#username HdinsightSparkCluster#username}
    */
    readonly username: string;
}
export declare function hdinsightSparkClusterMetastoresHiveToTerraform(struct?: HdinsightSparkClusterMetastoresHiveOutputReference | HdinsightSparkClusterMetastoresHive): any;
export declare function hdinsightSparkClusterMetastoresHiveToHclTerraform(struct?: HdinsightSparkClusterMetastoresHiveOutputReference | HdinsightSparkClusterMetastoresHive): any;
export declare class HdinsightSparkClusterMetastoresHiveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightSparkClusterMetastoresHive | undefined;
    set internalValue(value: HdinsightSparkClusterMetastoresHive | undefined);
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface HdinsightSparkClusterMetastoresOozie {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#database_name HdinsightSparkCluster#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#password HdinsightSparkCluster#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#server HdinsightSparkCluster#server}
    */
    readonly server: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#username HdinsightSparkCluster#username}
    */
    readonly username: string;
}
export declare function hdinsightSparkClusterMetastoresOozieToTerraform(struct?: HdinsightSparkClusterMetastoresOozieOutputReference | HdinsightSparkClusterMetastoresOozie): any;
export declare function hdinsightSparkClusterMetastoresOozieToHclTerraform(struct?: HdinsightSparkClusterMetastoresOozieOutputReference | HdinsightSparkClusterMetastoresOozie): any;
export declare class HdinsightSparkClusterMetastoresOozieOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightSparkClusterMetastoresOozie | undefined;
    set internalValue(value: HdinsightSparkClusterMetastoresOozie | undefined);
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface HdinsightSparkClusterMetastores {
    /**
    * ambari block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#ambari HdinsightSparkCluster#ambari}
    */
    readonly ambari?: HdinsightSparkClusterMetastoresAmbari;
    /**
    * hive block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#hive HdinsightSparkCluster#hive}
    */
    readonly hive?: HdinsightSparkClusterMetastoresHive;
    /**
    * oozie block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#oozie HdinsightSparkCluster#oozie}
    */
    readonly oozie?: HdinsightSparkClusterMetastoresOozie;
}
export declare function hdinsightSparkClusterMetastoresToTerraform(struct?: HdinsightSparkClusterMetastoresOutputReference | HdinsightSparkClusterMetastores): any;
export declare function hdinsightSparkClusterMetastoresToHclTerraform(struct?: HdinsightSparkClusterMetastoresOutputReference | HdinsightSparkClusterMetastores): any;
export declare class HdinsightSparkClusterMetastoresOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightSparkClusterMetastores | undefined;
    set internalValue(value: HdinsightSparkClusterMetastores | undefined);
    private _ambari;
    get ambari(): HdinsightSparkClusterMetastoresAmbariOutputReference;
    putAmbari(value: HdinsightSparkClusterMetastoresAmbari): void;
    resetAmbari(): void;
    get ambariInput(): HdinsightSparkClusterMetastoresAmbari | undefined;
    private _hive;
    get hive(): HdinsightSparkClusterMetastoresHiveOutputReference;
    putHive(value: HdinsightSparkClusterMetastoresHive): void;
    resetHive(): void;
    get hiveInput(): HdinsightSparkClusterMetastoresHive | undefined;
    private _oozie;
    get oozie(): HdinsightSparkClusterMetastoresOozieOutputReference;
    putOozie(value: HdinsightSparkClusterMetastoresOozie): void;
    resetOozie(): void;
    get oozieInput(): HdinsightSparkClusterMetastoresOozie | undefined;
}
export interface HdinsightSparkClusterMonitor {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#log_analytics_workspace_id HdinsightSparkCluster#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#primary_key HdinsightSparkCluster#primary_key}
    */
    readonly primaryKey: string;
}
export declare function hdinsightSparkClusterMonitorToTerraform(struct?: HdinsightSparkClusterMonitorOutputReference | HdinsightSparkClusterMonitor): any;
export declare function hdinsightSparkClusterMonitorToHclTerraform(struct?: HdinsightSparkClusterMonitorOutputReference | HdinsightSparkClusterMonitor): any;
export declare class HdinsightSparkClusterMonitorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightSparkClusterMonitor | undefined;
    set internalValue(value: HdinsightSparkClusterMonitor | undefined);
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _primaryKey?;
    get primaryKey(): string;
    set primaryKey(value: string);
    get primaryKeyInput(): string | undefined;
}
export interface HdinsightSparkClusterNetwork {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#connection_direction HdinsightSparkCluster#connection_direction}
    */
    readonly connectionDirection?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#private_link_enabled HdinsightSparkCluster#private_link_enabled}
    */
    readonly privateLinkEnabled?: boolean | cdktf.IResolvable;
}
export declare function hdinsightSparkClusterNetworkToTerraform(struct?: HdinsightSparkClusterNetworkOutputReference | HdinsightSparkClusterNetwork): any;
export declare function hdinsightSparkClusterNetworkToHclTerraform(struct?: HdinsightSparkClusterNetworkOutputReference | HdinsightSparkClusterNetwork): any;
export declare class HdinsightSparkClusterNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightSparkClusterNetwork | undefined;
    set internalValue(value: HdinsightSparkClusterNetwork | undefined);
    private _connectionDirection?;
    get connectionDirection(): string;
    set connectionDirection(value: string);
    resetConnectionDirection(): void;
    get connectionDirectionInput(): string | undefined;
    private _privateLinkEnabled?;
    get privateLinkEnabled(): boolean | cdktf.IResolvable;
    set privateLinkEnabled(value: boolean | cdktf.IResolvable);
    resetPrivateLinkEnabled(): void;
    get privateLinkEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface HdinsightSparkClusterPrivateLinkConfigurationIpConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#name HdinsightSparkCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#primary HdinsightSparkCluster#primary}
    */
    readonly primary?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#private_ip_address HdinsightSparkCluster#private_ip_address}
    */
    readonly privateIpAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#private_ip_allocation_method HdinsightSparkCluster#private_ip_allocation_method}
    */
    readonly privateIpAllocationMethod?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#subnet_id HdinsightSparkCluster#subnet_id}
    */
    readonly subnetId?: string;
}
export declare function hdinsightSparkClusterPrivateLinkConfigurationIpConfigurationToTerraform(struct?: HdinsightSparkClusterPrivateLinkConfigurationIpConfigurationOutputReference | HdinsightSparkClusterPrivateLinkConfigurationIpConfiguration): any;
export declare function hdinsightSparkClusterPrivateLinkConfigurationIpConfigurationToHclTerraform(struct?: HdinsightSparkClusterPrivateLinkConfigurationIpConfigurationOutputReference | HdinsightSparkClusterPrivateLinkConfigurationIpConfiguration): any;
export declare class HdinsightSparkClusterPrivateLinkConfigurationIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightSparkClusterPrivateLinkConfigurationIpConfiguration | undefined;
    set internalValue(value: HdinsightSparkClusterPrivateLinkConfigurationIpConfiguration | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _primary?;
    get primary(): boolean | cdktf.IResolvable;
    set primary(value: boolean | cdktf.IResolvable);
    resetPrimary(): void;
    get primaryInput(): boolean | cdktf.IResolvable | undefined;
    private _privateIpAddress?;
    get privateIpAddress(): string;
    set privateIpAddress(value: string);
    resetPrivateIpAddress(): void;
    get privateIpAddressInput(): string | undefined;
    private _privateIpAllocationMethod?;
    get privateIpAllocationMethod(): string;
    set privateIpAllocationMethod(value: string);
    resetPrivateIpAllocationMethod(): void;
    get privateIpAllocationMethodInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
}
export interface HdinsightSparkClusterPrivateLinkConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#group_id HdinsightSparkCluster#group_id}
    */
    readonly groupId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#name HdinsightSparkCluster#name}
    */
    readonly name: string;
    /**
    * ip_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#ip_configuration HdinsightSparkCluster#ip_configuration}
    */
    readonly ipConfiguration: HdinsightSparkClusterPrivateLinkConfigurationIpConfiguration;
}
export declare function hdinsightSparkClusterPrivateLinkConfigurationToTerraform(struct?: HdinsightSparkClusterPrivateLinkConfigurationOutputReference | HdinsightSparkClusterPrivateLinkConfiguration): any;
export declare function hdinsightSparkClusterPrivateLinkConfigurationToHclTerraform(struct?: HdinsightSparkClusterPrivateLinkConfigurationOutputReference | HdinsightSparkClusterPrivateLinkConfiguration): any;
export declare class HdinsightSparkClusterPrivateLinkConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightSparkClusterPrivateLinkConfiguration | undefined;
    set internalValue(value: HdinsightSparkClusterPrivateLinkConfiguration | undefined);
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    get groupIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _ipConfiguration;
    get ipConfiguration(): HdinsightSparkClusterPrivateLinkConfigurationIpConfigurationOutputReference;
    putIpConfiguration(value: HdinsightSparkClusterPrivateLinkConfigurationIpConfiguration): void;
    get ipConfigurationInput(): HdinsightSparkClusterPrivateLinkConfigurationIpConfiguration | undefined;
}
export interface HdinsightSparkClusterRolesHeadNodeScriptActions {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#name HdinsightSparkCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#parameters HdinsightSparkCluster#parameters}
    */
    readonly parameters?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#uri HdinsightSparkCluster#uri}
    */
    readonly uri: string;
}
export declare function hdinsightSparkClusterRolesHeadNodeScriptActionsToTerraform(struct?: HdinsightSparkClusterRolesHeadNodeScriptActions | cdktf.IResolvable): any;
export declare function hdinsightSparkClusterRolesHeadNodeScriptActionsToHclTerraform(struct?: HdinsightSparkClusterRolesHeadNodeScriptActions | cdktf.IResolvable): any;
export declare class HdinsightSparkClusterRolesHeadNodeScriptActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HdinsightSparkClusterRolesHeadNodeScriptActions | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightSparkClusterRolesHeadNodeScriptActions | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): string;
    set parameters(value: string);
    resetParameters(): void;
    get parametersInput(): string | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export declare class HdinsightSparkClusterRolesHeadNodeScriptActionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HdinsightSparkClusterRolesHeadNodeScriptActions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HdinsightSparkClusterRolesHeadNodeScriptActionsOutputReference;
}
export interface HdinsightSparkClusterRolesHeadNode {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#password HdinsightSparkCluster#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#ssh_keys HdinsightSparkCluster#ssh_keys}
    */
    readonly sshKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#subnet_id HdinsightSparkCluster#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#username HdinsightSparkCluster#username}
    */
    readonly username: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#virtual_network_id HdinsightSparkCluster#virtual_network_id}
    */
    readonly virtualNetworkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#vm_size HdinsightSparkCluster#vm_size}
    */
    readonly vmSize: string;
    /**
    * script_actions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#script_actions HdinsightSparkCluster#script_actions}
    */
    readonly scriptActions?: HdinsightSparkClusterRolesHeadNodeScriptActions[] | cdktf.IResolvable;
}
export declare function hdinsightSparkClusterRolesHeadNodeToTerraform(struct?: HdinsightSparkClusterRolesHeadNodeOutputReference | HdinsightSparkClusterRolesHeadNode): any;
export declare function hdinsightSparkClusterRolesHeadNodeToHclTerraform(struct?: HdinsightSparkClusterRolesHeadNodeOutputReference | HdinsightSparkClusterRolesHeadNode): any;
export declare class HdinsightSparkClusterRolesHeadNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightSparkClusterRolesHeadNode | undefined;
    set internalValue(value: HdinsightSparkClusterRolesHeadNode | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _sshKeys?;
    get sshKeys(): string[];
    set sshKeys(value: string[]);
    resetSshKeys(): void;
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    resetVirtualNetworkId(): void;
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    get vmSizeInput(): string | undefined;
    private _scriptActions;
    get scriptActions(): HdinsightSparkClusterRolesHeadNodeScriptActionsList;
    putScriptActions(value: HdinsightSparkClusterRolesHeadNodeScriptActions[] | cdktf.IResolvable): void;
    resetScriptActions(): void;
    get scriptActionsInput(): cdktf.IResolvable | HdinsightSparkClusterRolesHeadNodeScriptActions[] | undefined;
}
export interface HdinsightSparkClusterRolesWorkerNodeAutoscaleCapacity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#max_instance_count HdinsightSparkCluster#max_instance_count}
    */
    readonly maxInstanceCount: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#min_instance_count HdinsightSparkCluster#min_instance_count}
    */
    readonly minInstanceCount: number;
}
export declare function hdinsightSparkClusterRolesWorkerNodeAutoscaleCapacityToTerraform(struct?: HdinsightSparkClusterRolesWorkerNodeAutoscaleCapacityOutputReference | HdinsightSparkClusterRolesWorkerNodeAutoscaleCapacity): any;
export declare function hdinsightSparkClusterRolesWorkerNodeAutoscaleCapacityToHclTerraform(struct?: HdinsightSparkClusterRolesWorkerNodeAutoscaleCapacityOutputReference | HdinsightSparkClusterRolesWorkerNodeAutoscaleCapacity): any;
export declare class HdinsightSparkClusterRolesWorkerNodeAutoscaleCapacityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightSparkClusterRolesWorkerNodeAutoscaleCapacity | undefined;
    set internalValue(value: HdinsightSparkClusterRolesWorkerNodeAutoscaleCapacity | undefined);
    private _maxInstanceCount?;
    get maxInstanceCount(): number;
    set maxInstanceCount(value: number);
    get maxInstanceCountInput(): number | undefined;
    private _minInstanceCount?;
    get minInstanceCount(): number;
    set minInstanceCount(value: number);
    get minInstanceCountInput(): number | undefined;
}
export interface HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceSchedule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#days HdinsightSparkCluster#days}
    */
    readonly days: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#target_instance_count HdinsightSparkCluster#target_instance_count}
    */
    readonly targetInstanceCount: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#time HdinsightSparkCluster#time}
    */
    readonly time: string;
}
export declare function hdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceScheduleToTerraform(struct?: HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceSchedule | cdktf.IResolvable): any;
export declare function hdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceScheduleToHclTerraform(struct?: HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceSchedule | cdktf.IResolvable): any;
export declare class HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceSchedule | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceSchedule | cdktf.IResolvable | undefined);
    private _days?;
    get days(): string[];
    set days(value: string[]);
    get daysInput(): string[] | undefined;
    private _targetInstanceCount?;
    get targetInstanceCount(): number;
    set targetInstanceCount(value: number);
    get targetInstanceCountInput(): number | undefined;
    private _time?;
    get time(): string;
    set time(value: string);
    get timeInput(): string | undefined;
}
export declare class HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceSchedule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceScheduleOutputReference;
}
export interface HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrence {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#timezone HdinsightSparkCluster#timezone}
    */
    readonly timezone: string;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#schedule HdinsightSparkCluster#schedule}
    */
    readonly schedule: HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceSchedule[] | cdktf.IResolvable;
}
export declare function hdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceToTerraform(struct?: HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceOutputReference | HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrence): any;
export declare function hdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceToHclTerraform(struct?: HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceOutputReference | HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrence): any;
export declare class HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrence | undefined;
    set internalValue(value: HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrence | undefined);
    private _timezone?;
    get timezone(): string;
    set timezone(value: string);
    get timezoneInput(): string | undefined;
    private _schedule;
    get schedule(): HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceScheduleList;
    putSchedule(value: HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceSchedule[] | cdktf.IResolvable): void;
    get scheduleInput(): cdktf.IResolvable | HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceSchedule[] | undefined;
}
export interface HdinsightSparkClusterRolesWorkerNodeAutoscale {
    /**
    * capacity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#capacity HdinsightSparkCluster#capacity}
    */
    readonly capacity?: HdinsightSparkClusterRolesWorkerNodeAutoscaleCapacity;
    /**
    * recurrence block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#recurrence HdinsightSparkCluster#recurrence}
    */
    readonly recurrence?: HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrence;
}
export declare function hdinsightSparkClusterRolesWorkerNodeAutoscaleToTerraform(struct?: HdinsightSparkClusterRolesWorkerNodeAutoscaleOutputReference | HdinsightSparkClusterRolesWorkerNodeAutoscale): any;
export declare function hdinsightSparkClusterRolesWorkerNodeAutoscaleToHclTerraform(struct?: HdinsightSparkClusterRolesWorkerNodeAutoscaleOutputReference | HdinsightSparkClusterRolesWorkerNodeAutoscale): any;
export declare class HdinsightSparkClusterRolesWorkerNodeAutoscaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightSparkClusterRolesWorkerNodeAutoscale | undefined;
    set internalValue(value: HdinsightSparkClusterRolesWorkerNodeAutoscale | undefined);
    private _capacity;
    get capacity(): HdinsightSparkClusterRolesWorkerNodeAutoscaleCapacityOutputReference;
    putCapacity(value: HdinsightSparkClusterRolesWorkerNodeAutoscaleCapacity): void;
    resetCapacity(): void;
    get capacityInput(): HdinsightSparkClusterRolesWorkerNodeAutoscaleCapacity | undefined;
    private _recurrence;
    get recurrence(): HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceOutputReference;
    putRecurrence(value: HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrence): void;
    resetRecurrence(): void;
    get recurrenceInput(): HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrence | undefined;
}
export interface HdinsightSparkClusterRolesWorkerNodeScriptActions {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#name HdinsightSparkCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#parameters HdinsightSparkCluster#parameters}
    */
    readonly parameters?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#uri HdinsightSparkCluster#uri}
    */
    readonly uri: string;
}
export declare function hdinsightSparkClusterRolesWorkerNodeScriptActionsToTerraform(struct?: HdinsightSparkClusterRolesWorkerNodeScriptActions | cdktf.IResolvable): any;
export declare function hdinsightSparkClusterRolesWorkerNodeScriptActionsToHclTerraform(struct?: HdinsightSparkClusterRolesWorkerNodeScriptActions | cdktf.IResolvable): any;
export declare class HdinsightSparkClusterRolesWorkerNodeScriptActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HdinsightSparkClusterRolesWorkerNodeScriptActions | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightSparkClusterRolesWorkerNodeScriptActions | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): string;
    set parameters(value: string);
    resetParameters(): void;
    get parametersInput(): string | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export declare class HdinsightSparkClusterRolesWorkerNodeScriptActionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HdinsightSparkClusterRolesWorkerNodeScriptActions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HdinsightSparkClusterRolesWorkerNodeScriptActionsOutputReference;
}
export interface HdinsightSparkClusterRolesWorkerNode {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#password HdinsightSparkCluster#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#ssh_keys HdinsightSparkCluster#ssh_keys}
    */
    readonly sshKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#subnet_id HdinsightSparkCluster#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#target_instance_count HdinsightSparkCluster#target_instance_count}
    */
    readonly targetInstanceCount: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#username HdinsightSparkCluster#username}
    */
    readonly username: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#virtual_network_id HdinsightSparkCluster#virtual_network_id}
    */
    readonly virtualNetworkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#vm_size HdinsightSparkCluster#vm_size}
    */
    readonly vmSize: string;
    /**
    * autoscale block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#autoscale HdinsightSparkCluster#autoscale}
    */
    readonly autoscale?: HdinsightSparkClusterRolesWorkerNodeAutoscale;
    /**
    * script_actions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#script_actions HdinsightSparkCluster#script_actions}
    */
    readonly scriptActions?: HdinsightSparkClusterRolesWorkerNodeScriptActions[] | cdktf.IResolvable;
}
export declare function hdinsightSparkClusterRolesWorkerNodeToTerraform(struct?: HdinsightSparkClusterRolesWorkerNodeOutputReference | HdinsightSparkClusterRolesWorkerNode): any;
export declare function hdinsightSparkClusterRolesWorkerNodeToHclTerraform(struct?: HdinsightSparkClusterRolesWorkerNodeOutputReference | HdinsightSparkClusterRolesWorkerNode): any;
export declare class HdinsightSparkClusterRolesWorkerNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightSparkClusterRolesWorkerNode | undefined;
    set internalValue(value: HdinsightSparkClusterRolesWorkerNode | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _sshKeys?;
    get sshKeys(): string[];
    set sshKeys(value: string[]);
    resetSshKeys(): void;
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _targetInstanceCount?;
    get targetInstanceCount(): number;
    set targetInstanceCount(value: number);
    get targetInstanceCountInput(): number | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    resetVirtualNetworkId(): void;
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    get vmSizeInput(): string | undefined;
    private _autoscale;
    get autoscale(): HdinsightSparkClusterRolesWorkerNodeAutoscaleOutputReference;
    putAutoscale(value: HdinsightSparkClusterRolesWorkerNodeAutoscale): void;
    resetAutoscale(): void;
    get autoscaleInput(): HdinsightSparkClusterRolesWorkerNodeAutoscale | undefined;
    private _scriptActions;
    get scriptActions(): HdinsightSparkClusterRolesWorkerNodeScriptActionsList;
    putScriptActions(value: HdinsightSparkClusterRolesWorkerNodeScriptActions[] | cdktf.IResolvable): void;
    resetScriptActions(): void;
    get scriptActionsInput(): cdktf.IResolvable | HdinsightSparkClusterRolesWorkerNodeScriptActions[] | undefined;
}
export interface HdinsightSparkClusterRolesZookeeperNodeScriptActions {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#name HdinsightSparkCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#parameters HdinsightSparkCluster#parameters}
    */
    readonly parameters?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#uri HdinsightSparkCluster#uri}
    */
    readonly uri: string;
}
export declare function hdinsightSparkClusterRolesZookeeperNodeScriptActionsToTerraform(struct?: HdinsightSparkClusterRolesZookeeperNodeScriptActions | cdktf.IResolvable): any;
export declare function hdinsightSparkClusterRolesZookeeperNodeScriptActionsToHclTerraform(struct?: HdinsightSparkClusterRolesZookeeperNodeScriptActions | cdktf.IResolvable): any;
export declare class HdinsightSparkClusterRolesZookeeperNodeScriptActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HdinsightSparkClusterRolesZookeeperNodeScriptActions | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightSparkClusterRolesZookeeperNodeScriptActions | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): string;
    set parameters(value: string);
    resetParameters(): void;
    get parametersInput(): string | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export declare class HdinsightSparkClusterRolesZookeeperNodeScriptActionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HdinsightSparkClusterRolesZookeeperNodeScriptActions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HdinsightSparkClusterRolesZookeeperNodeScriptActionsOutputReference;
}
export interface HdinsightSparkClusterRolesZookeeperNode {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#password HdinsightSparkCluster#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#ssh_keys HdinsightSparkCluster#ssh_keys}
    */
    readonly sshKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#subnet_id HdinsightSparkCluster#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#username HdinsightSparkCluster#username}
    */
    readonly username: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#virtual_network_id HdinsightSparkCluster#virtual_network_id}
    */
    readonly virtualNetworkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#vm_size HdinsightSparkCluster#vm_size}
    */
    readonly vmSize: string;
    /**
    * script_actions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#script_actions HdinsightSparkCluster#script_actions}
    */
    readonly scriptActions?: HdinsightSparkClusterRolesZookeeperNodeScriptActions[] | cdktf.IResolvable;
}
export declare function hdinsightSparkClusterRolesZookeeperNodeToTerraform(struct?: HdinsightSparkClusterRolesZookeeperNodeOutputReference | HdinsightSparkClusterRolesZookeeperNode): any;
export declare function hdinsightSparkClusterRolesZookeeperNodeToHclTerraform(struct?: HdinsightSparkClusterRolesZookeeperNodeOutputReference | HdinsightSparkClusterRolesZookeeperNode): any;
export declare class HdinsightSparkClusterRolesZookeeperNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightSparkClusterRolesZookeeperNode | undefined;
    set internalValue(value: HdinsightSparkClusterRolesZookeeperNode | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _sshKeys?;
    get sshKeys(): string[];
    set sshKeys(value: string[]);
    resetSshKeys(): void;
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    resetVirtualNetworkId(): void;
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    get vmSizeInput(): string | undefined;
    private _scriptActions;
    get scriptActions(): HdinsightSparkClusterRolesZookeeperNodeScriptActionsList;
    putScriptActions(value: HdinsightSparkClusterRolesZookeeperNodeScriptActions[] | cdktf.IResolvable): void;
    resetScriptActions(): void;
    get scriptActionsInput(): cdktf.IResolvable | HdinsightSparkClusterRolesZookeeperNodeScriptActions[] | undefined;
}
export interface HdinsightSparkClusterRoles {
    /**
    * head_node block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#head_node HdinsightSparkCluster#head_node}
    */
    readonly headNode: HdinsightSparkClusterRolesHeadNode;
    /**
    * worker_node block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#worker_node HdinsightSparkCluster#worker_node}
    */
    readonly workerNode: HdinsightSparkClusterRolesWorkerNode;
    /**
    * zookeeper_node block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#zookeeper_node HdinsightSparkCluster#zookeeper_node}
    */
    readonly zookeeperNode: HdinsightSparkClusterRolesZookeeperNode;
}
export declare function hdinsightSparkClusterRolesToTerraform(struct?: HdinsightSparkClusterRolesOutputReference | HdinsightSparkClusterRoles): any;
export declare function hdinsightSparkClusterRolesToHclTerraform(struct?: HdinsightSparkClusterRolesOutputReference | HdinsightSparkClusterRoles): any;
export declare class HdinsightSparkClusterRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightSparkClusterRoles | undefined;
    set internalValue(value: HdinsightSparkClusterRoles | undefined);
    private _headNode;
    get headNode(): HdinsightSparkClusterRolesHeadNodeOutputReference;
    putHeadNode(value: HdinsightSparkClusterRolesHeadNode): void;
    get headNodeInput(): HdinsightSparkClusterRolesHeadNode | undefined;
    private _workerNode;
    get workerNode(): HdinsightSparkClusterRolesWorkerNodeOutputReference;
    putWorkerNode(value: HdinsightSparkClusterRolesWorkerNode): void;
    get workerNodeInput(): HdinsightSparkClusterRolesWorkerNode | undefined;
    private _zookeeperNode;
    get zookeeperNode(): HdinsightSparkClusterRolesZookeeperNodeOutputReference;
    putZookeeperNode(value: HdinsightSparkClusterRolesZookeeperNode): void;
    get zookeeperNodeInput(): HdinsightSparkClusterRolesZookeeperNode | undefined;
}
export interface HdinsightSparkClusterSecurityProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#aadds_resource_id HdinsightSparkCluster#aadds_resource_id}
    */
    readonly aaddsResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#cluster_users_group_dns HdinsightSparkCluster#cluster_users_group_dns}
    */
    readonly clusterUsersGroupDns?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#domain_name HdinsightSparkCluster#domain_name}
    */
    readonly domainName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#domain_user_password HdinsightSparkCluster#domain_user_password}
    */
    readonly domainUserPassword: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#domain_username HdinsightSparkCluster#domain_username}
    */
    readonly domainUsername: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#ldaps_urls HdinsightSparkCluster#ldaps_urls}
    */
    readonly ldapsUrls: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#msi_resource_id HdinsightSparkCluster#msi_resource_id}
    */
    readonly msiResourceId: string;
}
export declare function hdinsightSparkClusterSecurityProfileToTerraform(struct?: HdinsightSparkClusterSecurityProfileOutputReference | HdinsightSparkClusterSecurityProfile): any;
export declare function hdinsightSparkClusterSecurityProfileToHclTerraform(struct?: HdinsightSparkClusterSecurityProfileOutputReference | HdinsightSparkClusterSecurityProfile): any;
export declare class HdinsightSparkClusterSecurityProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightSparkClusterSecurityProfile | undefined;
    set internalValue(value: HdinsightSparkClusterSecurityProfile | undefined);
    private _aaddsResourceId?;
    get aaddsResourceId(): string;
    set aaddsResourceId(value: string);
    get aaddsResourceIdInput(): string | undefined;
    private _clusterUsersGroupDns?;
    get clusterUsersGroupDns(): string[];
    set clusterUsersGroupDns(value: string[]);
    resetClusterUsersGroupDns(): void;
    get clusterUsersGroupDnsInput(): string[] | undefined;
    private _domainName?;
    get domainName(): string;
    set domainName(value: string);
    get domainNameInput(): string | undefined;
    private _domainUserPassword?;
    get domainUserPassword(): string;
    set domainUserPassword(value: string);
    get domainUserPasswordInput(): string | undefined;
    private _domainUsername?;
    get domainUsername(): string;
    set domainUsername(value: string);
    get domainUsernameInput(): string | undefined;
    private _ldapsUrls?;
    get ldapsUrls(): string[];
    set ldapsUrls(value: string[]);
    get ldapsUrlsInput(): string[] | undefined;
    private _msiResourceId?;
    get msiResourceId(): string;
    set msiResourceId(value: string);
    get msiResourceIdInput(): string | undefined;
}
export interface HdinsightSparkClusterStorageAccount {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#is_default HdinsightSparkCluster#is_default}
    */
    readonly isDefault: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#storage_account_key HdinsightSparkCluster#storage_account_key}
    */
    readonly storageAccountKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#storage_container_id HdinsightSparkCluster#storage_container_id}
    */
    readonly storageContainerId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#storage_resource_id HdinsightSparkCluster#storage_resource_id}
    */
    readonly storageResourceId?: string;
}
export declare function hdinsightSparkClusterStorageAccountToTerraform(struct?: HdinsightSparkClusterStorageAccount | cdktf.IResolvable): any;
export declare function hdinsightSparkClusterStorageAccountToHclTerraform(struct?: HdinsightSparkClusterStorageAccount | cdktf.IResolvable): any;
export declare class HdinsightSparkClusterStorageAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HdinsightSparkClusterStorageAccount | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightSparkClusterStorageAccount | cdktf.IResolvable | undefined);
    private _isDefault?;
    get isDefault(): boolean | cdktf.IResolvable;
    set isDefault(value: boolean | cdktf.IResolvable);
    get isDefaultInput(): boolean | cdktf.IResolvable | undefined;
    private _storageAccountKey?;
    get storageAccountKey(): string;
    set storageAccountKey(value: string);
    get storageAccountKeyInput(): string | undefined;
    private _storageContainerId?;
    get storageContainerId(): string;
    set storageContainerId(value: string);
    get storageContainerIdInput(): string | undefined;
    private _storageResourceId?;
    get storageResourceId(): string;
    set storageResourceId(value: string);
    resetStorageResourceId(): void;
    get storageResourceIdInput(): string | undefined;
}
export declare class HdinsightSparkClusterStorageAccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HdinsightSparkClusterStorageAccount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HdinsightSparkClusterStorageAccountOutputReference;
}
export interface HdinsightSparkClusterStorageAccountGen2 {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#filesystem_id HdinsightSparkCluster#filesystem_id}
    */
    readonly filesystemId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#is_default HdinsightSparkCluster#is_default}
    */
    readonly isDefault: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#managed_identity_resource_id HdinsightSparkCluster#managed_identity_resource_id}
    */
    readonly managedIdentityResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#storage_resource_id HdinsightSparkCluster#storage_resource_id}
    */
    readonly storageResourceId: string;
}
export declare function hdinsightSparkClusterStorageAccountGen2ToTerraform(struct?: HdinsightSparkClusterStorageAccountGen2OutputReference | HdinsightSparkClusterStorageAccountGen2): any;
export declare function hdinsightSparkClusterStorageAccountGen2ToHclTerraform(struct?: HdinsightSparkClusterStorageAccountGen2OutputReference | HdinsightSparkClusterStorageAccountGen2): any;
export declare class HdinsightSparkClusterStorageAccountGen2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightSparkClusterStorageAccountGen2 | undefined;
    set internalValue(value: HdinsightSparkClusterStorageAccountGen2 | undefined);
    private _filesystemId?;
    get filesystemId(): string;
    set filesystemId(value: string);
    get filesystemIdInput(): string | undefined;
    private _isDefault?;
    get isDefault(): boolean | cdktf.IResolvable;
    set isDefault(value: boolean | cdktf.IResolvable);
    get isDefaultInput(): boolean | cdktf.IResolvable | undefined;
    private _managedIdentityResourceId?;
    get managedIdentityResourceId(): string;
    set managedIdentityResourceId(value: string);
    get managedIdentityResourceIdInput(): string | undefined;
    private _storageResourceId?;
    get storageResourceId(): string;
    set storageResourceId(value: string);
    get storageResourceIdInput(): string | undefined;
}
export interface HdinsightSparkClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#create HdinsightSparkCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#delete HdinsightSparkCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#read HdinsightSparkCluster#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#update HdinsightSparkCluster#update}
    */
    readonly update?: string;
}
export declare function hdinsightSparkClusterTimeoutsToTerraform(struct?: HdinsightSparkClusterTimeouts | cdktf.IResolvable): any;
export declare function hdinsightSparkClusterTimeoutsToHclTerraform(struct?: HdinsightSparkClusterTimeouts | cdktf.IResolvable): any;
export declare class HdinsightSparkClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightSparkClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightSparkClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster azurerm_hdinsight_spark_cluster}
*/
export declare class HdinsightSparkCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_hdinsight_spark_cluster";
    /**
    * Generates CDKTF code for importing a HdinsightSparkCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the HdinsightSparkCluster to import
    * @param importFromId The id of the existing HdinsightSparkCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the HdinsightSparkCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/hdinsight_spark_cluster azurerm_hdinsight_spark_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HdinsightSparkClusterConfig
    */
    constructor(scope: Construct, id: string, config: HdinsightSparkClusterConfig);
    private _clusterVersion?;
    get clusterVersion(): string;
    set clusterVersion(value: string);
    get clusterVersionInput(): string | undefined;
    private _encryptionInTransitEnabled?;
    get encryptionInTransitEnabled(): boolean | cdktf.IResolvable;
    set encryptionInTransitEnabled(value: boolean | cdktf.IResolvable);
    resetEncryptionInTransitEnabled(): void;
    get encryptionInTransitEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get httpsEndpoint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sshEndpoint(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    get tierInput(): string | undefined;
    private _tlsMinVersion?;
    get tlsMinVersion(): string;
    set tlsMinVersion(value: string);
    resetTlsMinVersion(): void;
    get tlsMinVersionInput(): string | undefined;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
    private _componentVersion;
    get componentVersion(): HdinsightSparkClusterComponentVersionOutputReference;
    putComponentVersion(value: HdinsightSparkClusterComponentVersion): void;
    get componentVersionInput(): HdinsightSparkClusterComponentVersion | undefined;
    private _computeIsolation;
    get computeIsolation(): HdinsightSparkClusterComputeIsolationOutputReference;
    putComputeIsolation(value: HdinsightSparkClusterComputeIsolation): void;
    resetComputeIsolation(): void;
    get computeIsolationInput(): HdinsightSparkClusterComputeIsolation | undefined;
    private _diskEncryption;
    get diskEncryption(): HdinsightSparkClusterDiskEncryptionList;
    putDiskEncryption(value: HdinsightSparkClusterDiskEncryption[] | cdktf.IResolvable): void;
    resetDiskEncryption(): void;
    get diskEncryptionInput(): cdktf.IResolvable | HdinsightSparkClusterDiskEncryption[] | undefined;
    private _extension;
    get extension(): HdinsightSparkClusterExtensionOutputReference;
    putExtension(value: HdinsightSparkClusterExtension): void;
    resetExtension(): void;
    get extensionInput(): HdinsightSparkClusterExtension | undefined;
    private _gateway;
    get gateway(): HdinsightSparkClusterGatewayOutputReference;
    putGateway(value: HdinsightSparkClusterGateway): void;
    get gatewayInput(): HdinsightSparkClusterGateway | undefined;
    private _metastores;
    get metastores(): HdinsightSparkClusterMetastoresOutputReference;
    putMetastores(value: HdinsightSparkClusterMetastores): void;
    resetMetastores(): void;
    get metastoresInput(): HdinsightSparkClusterMetastores | undefined;
    private _monitor;
    get monitor(): HdinsightSparkClusterMonitorOutputReference;
    putMonitor(value: HdinsightSparkClusterMonitor): void;
    resetMonitor(): void;
    get monitorInput(): HdinsightSparkClusterMonitor | undefined;
    private _network;
    get network(): HdinsightSparkClusterNetworkOutputReference;
    putNetwork(value: HdinsightSparkClusterNetwork): void;
    resetNetwork(): void;
    get networkInput(): HdinsightSparkClusterNetwork | undefined;
    private _privateLinkConfiguration;
    get privateLinkConfiguration(): HdinsightSparkClusterPrivateLinkConfigurationOutputReference;
    putPrivateLinkConfiguration(value: HdinsightSparkClusterPrivateLinkConfiguration): void;
    resetPrivateLinkConfiguration(): void;
    get privateLinkConfigurationInput(): HdinsightSparkClusterPrivateLinkConfiguration | undefined;
    private _roles;
    get roles(): HdinsightSparkClusterRolesOutputReference;
    putRoles(value: HdinsightSparkClusterRoles): void;
    get rolesInput(): HdinsightSparkClusterRoles | undefined;
    private _securityProfile;
    get securityProfile(): HdinsightSparkClusterSecurityProfileOutputReference;
    putSecurityProfile(value: HdinsightSparkClusterSecurityProfile): void;
    resetSecurityProfile(): void;
    get securityProfileInput(): HdinsightSparkClusterSecurityProfile | undefined;
    private _storageAccount;
    get storageAccount(): HdinsightSparkClusterStorageAccountList;
    putStorageAccount(value: HdinsightSparkClusterStorageAccount[] | cdktf.IResolvable): void;
    resetStorageAccount(): void;
    get storageAccountInput(): cdktf.IResolvable | HdinsightSparkClusterStorageAccount[] | undefined;
    private _storageAccountGen2;
    get storageAccountGen2(): HdinsightSparkClusterStorageAccountGen2OutputReference;
    putStorageAccountGen2(value: HdinsightSparkClusterStorageAccountGen2): void;
    resetStorageAccountGen2(): void;
    get storageAccountGen2Input(): HdinsightSparkClusterStorageAccountGen2 | undefined;
    private _timeouts;
    get timeouts(): HdinsightSparkClusterTimeoutsOutputReference;
    putTimeouts(value: HdinsightSparkClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | HdinsightSparkClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
