/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IothubEnrichmentAConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/iothub_enrichment#endpoint_names IothubEnrichmentA#endpoint_names}
    */
    readonly endpointNames: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/iothub_enrichment#id IothubEnrichmentA#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/iothub_enrichment#iothub_name IothubEnrichmentA#iothub_name}
    */
    readonly iothubName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/iothub_enrichment#key IothubEnrichmentA#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/iothub_enrichment#resource_group_name IothubEnrichmentA#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/iothub_enrichment#value IothubEnrichmentA#value}
    */
    readonly value: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/iothub_enrichment#timeouts IothubEnrichmentA#timeouts}
    */
    readonly timeouts?: IothubEnrichmentTimeouts;
}
export interface IothubEnrichmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/iothub_enrichment#create IothubEnrichmentA#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/iothub_enrichment#delete IothubEnrichmentA#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/iothub_enrichment#read IothubEnrichmentA#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/iothub_enrichment#update IothubEnrichmentA#update}
    */
    readonly update?: string;
}
export declare function iothubEnrichmentTimeoutsToTerraform(struct?: IothubEnrichmentTimeouts | cdktf.IResolvable): any;
export declare function iothubEnrichmentTimeoutsToHclTerraform(struct?: IothubEnrichmentTimeouts | cdktf.IResolvable): any;
export declare class IothubEnrichmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IothubEnrichmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: IothubEnrichmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/iothub_enrichment azurerm_iothub_enrichment}
*/
export declare class IothubEnrichmentA extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_iothub_enrichment";
    /**
    * Generates CDKTF code for importing a IothubEnrichmentA resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the IothubEnrichmentA to import
    * @param importFromId The id of the existing IothubEnrichmentA that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/iothub_enrichment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the IothubEnrichmentA to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/iothub_enrichment azurerm_iothub_enrichment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IothubEnrichmentAConfig
    */
    constructor(scope: Construct, id: string, config: IothubEnrichmentAConfig);
    private _endpointNames?;
    get endpointNames(): string[];
    set endpointNames(value: string[]);
    get endpointNamesInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _iothubName?;
    get iothubName(): string;
    set iothubName(value: string);
    get iothubNameInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
    private _timeouts;
    get timeouts(): IothubEnrichmentTimeoutsOutputReference;
    putTimeouts(value: IothubEnrichmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | IothubEnrichmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
